/**********************************************************************
 *                                                                    *
 *       (c) Copyright 2003                                           *
 *       All rights reserved                                          *
 *       Programs written by Jianghui Liu (NJIT)                      *
 *                                                                    *
 *       Permission to use, copy, modify, and distribute this         *
 *       software and its documentation for any purpose and without   *
 *       fee is hereby granted, provided that this copyright          *
 *       notice appears in all copies.   Programmer(s) makes no       *
 *       representations about the suitability of this                *
 *       software for any purpose.  It is provided "as is" without    *
 *       express or implied warranty.                                 *
 *                                                                    *
 **********************************************************************/
package RNA;
import java.io.*;
import java.util.*;

//--------------------------------------------------------------------------------
// This class needs a property file to specify the code table for sequence bases.
//--------------------------------------------------------------------------------
public class Matcher
{
    /*public static void main(String args[])
    {
        String codeTableFile = "codeTable.properties";
        String scoreMatrixFile = "score.matrix.binary";
        Matcher m = new Matcher(codeTableFile, scoreMatrixFile);

        System.out.println("WW : WW " + m.baseMatch("WW", "WW"));
    }*/

    private Hashtable codeTable;
    private Hashtable scoreMatrix;
    private StringBuffer matrices;

    private double maxPairScore = Double.NEGATIVE_INFINITY;
    private double minPairScore = Double.MAX_VALUE;
    private double maxSingleScore = Double.NEGATIVE_INFINITY;
    private double minSingleScore = Double.MAX_VALUE;

    public Matcher(String codeTableFile)
    {
        codeTable = new Hashtable();
        setupCodeTable(codeTableFile);

        maxPairScore = 2;
        minPairScore = 0;
        maxSingleScore = 1;
        minSingleScore = 0;
    }

    public Matcher(String codeTableFile, String scoreMatrixFile)
    {
        codeTable = new Hashtable();
        scoreMatrix = new Hashtable();

        setupCodeTable(codeTableFile);
        setupScoreMatrix(scoreMatrixFile);
    }

    public double getMaxSingle()
    {
        return maxSingleScore;
    }

    public double getMaxPair()
    {
        return maxPairScore;
    }

    //---------------------------------------------------------------------------------
    // This function tries to align ribonucleotide to ribonucleotide, or
    // ribonucleotide-pair to ribonucleotide-pair.
    // 
    // Currently, if score matrix is provided the score is fetched from the matrix,
    // otherwise if two single ribonucleotides are equal, we set score as '1';
    // if two ribonucleotide-pairs are matched, we set score as '2'; for the rest, the
    // score will be set to '0'. In fact, we don't match single with pair.
    //---------------------------------------------------------------------------------
    public double baseMatch(String base1, String base2)
    {
        int length = base1.length();
        double score = 0;

        if ( length == base2.length()) {  // only the equal length cases processed !
            if( scoreMatrix != null && scoreMatrix.containsKey(base1+base2)) {
                score = ((Double)scoreMatrix.get(base1+base2)).doubleValue();
            } else if(base1.equals(base2)){
                if( length == 1)
                    score = maxSingleScore;
                else if( length == 2)
                    score = maxPairScore;
            } else if (length == 2){     // loook up in the code table
                String codeword1a = (String)codeTable.get(base1.substring(0, 1));
                String codeword1b = (String)codeTable.get(base1.substring(1, 2));

                String codeword2a = (String)codeTable.get(base2.substring(0, 1));
                String codeword2b = (String)codeTable.get(base2.substring(1, 2));

                if( codeword1a != null && codeword1b != null &&
                    codeword2a != null && codeword2b != null) {
                    score = getCompatibleScore(codeword1a, codeword1b, codeword2a, codeword2b);
                } else {
                    score = minPairScore;
                    System.out.println("Never happen !: " + base1 + " vs. " + base2);
                    System.exit(0);
                }
            } else if( length == 1) {    // look up in the code table
                String codeword1 = (String)codeTable.get(base1.substring(0, 1));
                String codeword2 = (String)codeTable.get(base2.substring(0, 1));

                if( codeword1 != null && codeword2 != null) {
                    score = getCompatibleScore(codeword1, codeword2);
                } else {
                    if ( codeword1 == null )
                        System.out.println("Illegal Code: " + base1 + " !!");
                    else
                        System.out.println("Illegal Code: " + base2 + " !!");

                    System.exit(0);
                }
            }
        }

        return score;
    }
///#########################################################NEW FOR CONSTRAINED ALIGNMENT###########################################
    //---------------------------------------------------------------------------------
    // This function tries to align ribonucleotide to ribonucleotide, or
    // ribonucleotide-pair to ribonucleotide-pair.
    // 
    // Currently, if score matrix is provided the score is fetched from the matrix,
    // otherwise if two single ribonucleotides are equal, we set score as '1';
    // if two ribonucleotide-pairs are matched, we set score as '2'; for the rest, the
    // score will be set to '0'. In fact, we don't match single with pair.
    //---------------------------------------------------------------------------------
    public double baseMatch2(int flag,String base1, String base2, int m1, int m2, String mconserved,double f, double[] factors_for_conserved)
    {
        int length = base1.length();
        double score = 0;
//#################################################################################
	double factor=0;
	if(flag ==1){
		f = 0;	
	//if(m1<=(mconserved.length()-1)&&(m1!=-1)){
	//	if(mconserved.substring(m1,m1+1).equals("*")){
	//		factor = f;	
	//	}
		if(m1!=-1)
		f = factors_for_conserved[m1];	
	//}
	//if((m2!=-1) && (m2<=(mconserved.length()-1))){
	//	if(mconserved.substring(m2,m2+1).equals("*")){
	//		factor = factor + f;
	//	}
		if(m2!=-1)	
		f += factors_for_conserved[m2];
		factor = 1 + f;
	}
//	}
//	if(factor ==0){
//		factor = 1;
//	}	
//	factor = 1 + f;
//	if(factor!=1) 
//		System.out.println("m1=" + m1 + " m2=" +m2+" factor= "+factor);
//	}
	else{ 	//##################No factors file provided so either binary conservation or no conservation#########################
		if(f==0){
			f =1;
		}
		f = 2.0 - f;
		if(mconserved!=null){
			if(m1<=(mconserved.length()-1)&&(m1!=-1)){
				if(mconserved.substring(m1,m1+1).equals("*")){
					factor = f;
				}
			}
			if((m2!= -1)&&(m2<=(mconserved.length()-1))){
				if(mconserved.substring(m2,m2+1).equals("*")){
					factor = factor +f;
				}
			}
		}
		if(factor == 0){
			factor = 1;
		}
	}
//#################################################################################
        if ( length == base2.length()) {  // only the equal length cases processed !
            if( scoreMatrix != null && scoreMatrix.containsKey(base1+base2)) {
                score = ((Double)scoreMatrix.get(base1+base2)).doubleValue()*factor;    //###################change
            } else if(base1.equals(base2)){
                if( length == 1)
                    score = maxSingleScore * factor;  //############change#########
                else if( length == 2)
                    score = maxPairScore * factor;          //##########change#############
            } else if (length == 2){     // loook up in the code table
                String codeword1a = (String)codeTable.get(base1.substring(0, 1));
                String codeword1b = (String)codeTable.get(base1.substring(1, 2));

                String codeword2a = (String)codeTable.get(base2.substring(0, 1));
                String codeword2b = (String)codeTable.get(base2.substring(1, 2));

                if( codeword1a != null && codeword1b != null &&
                    codeword2a != null && codeword2b != null) {
                    score = getCompatibleScore(codeword1a, codeword1b, codeword2a, codeword2b) * factor;   ///########change
                } else {
                    score = minPairScore * factor;   //############factor####################
                    System.out.println("Never happen !: " + base1 + " vs. " + base2);
                    System.exit(0);
                }
            } else if( length == 1) {    // look up in the code table
                String codeword1 = (String)codeTable.get(base1.substring(0, 1));
                String codeword2 = (String)codeTable.get(base2.substring(0, 1));

                if( codeword1 != null && codeword2 != null) {
                    score = getCompatibleScore(codeword1, codeword2) * factor;   //##############change###########
                } else {
                    if ( codeword1 == null )
                        System.out.println("Illegal Code: " + base1 + " !!");
                    else
                        System.out.println("Illegal Code: " + base2 + " !!");

                    System.exit(0);
                }
            }
        }
	//System.out.println("Factor = " + factor);
        return score;
    }
////##################################################################################################################################



    //---------------------------------------------------------
    // This version will be used by LOCAL matching algorithm
    //---------------------------------------------------------
    public double baseMatch(String base1, String base2, boolean ungap)
    {
        double score;
        score = baseMatch(base1, base2);

        if( ungap==true && score<=0)
            score = Double.NEGATIVE_INFINITY;

        return score;
    }

    public String getScoreMatrices()
    {
        return new String(matrices);
    }

    //---------------------------------------------------
    // base code translation table is established here:
    // the table is provide by file: 'codeTableFile'
    //---------------------------------------------------
    private void setupCodeTable(String codeTableFile)
    {
        Properties prop = null;
        try{
            prop = new Properties();
            InputStream in = new FileInputStream(codeTableFile);
            prop.load(in);
            in.close();
        } catch( IOException e) {
            e.printStackTrace();
        }

        Enumeration keys = prop.propertyNames();
        while( keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            StringBuffer codebuffer = new StringBuffer("");

            String words = prop.getProperty(key);
            StringTokenizer t = new StringTokenizer(words, "|");
            while( t.hasMoreTokens())
                codebuffer.append(t.nextToken());

            codeTable.put(key, new String(codebuffer));
        }
    }

    //-----------------------------------------------------
    // score matrix is established here:
    // the matrix is provided by file: 'scoreMatrixFile'
    //-----------------------------------------------------
    private void setupScoreMatrix(String scoreMatrixFile)
    {
        matrices = new StringBuffer();

        BufferedReader in = null;
        ArrayList items = new ArrayList();

        try{
            in = new BufferedReader(new FileReader(scoreMatrixFile));

            // Read in score matrix for single stranded regions 
            String aLine = null;
            while( (aLine=in.readLine()) != null && (aLine.length()==0 || aLine.charAt(0) != '>'));

            if( aLine == null)
                return;
            else {
                aLine = in.readLine();
                matrices.append(aLine + "\n");

                StringTokenizer token = new StringTokenizer(aLine);
                while( token.hasMoreElements())
                    items.add(token.nextToken());
            }

            int n = items.size();      // the number of rows
            for(int i=0; i<n; i++) {   // fetch matrix one row by one row
                aLine = in.readLine();
                matrices.append(aLine + "\n");

                StringTokenizer token = new StringTokenizer(aLine);
                token.nextToken();

                for(int j=0; j<n; j++) {
                    String key = new String((String)items.get(i) + (String)items.get(j));
                    double score = Double.parseDouble(token.nextToken());

                    if( score > maxSingleScore)
                        maxSingleScore = score;
                    if( score < minSingleScore)
                        minSingleScore = score;

                    scoreMatrix.put(key, new Double(score));
                }
            }

            matrices.append("\n\n");

            // Read in score matrix for double stranded regions
            items.clear();
            while( (aLine=in.readLine())!=null && (aLine.length()==0 || aLine.charAt(0) != '>'));
            if( aLine == null) {
                scoreMatrix.clear();
                return;
            } else {
                aLine = in.readLine();
                matrices.append(aLine + "\n");
                StringTokenizer token = new StringTokenizer(aLine);
                while( token.hasMoreElements())
                    items.add(token.nextToken());
            }

            n = items.size();  // the number of rows in the matrix
            for(int i=0; i<n; i++) {
                aLine = in.readLine();
                matrices.append(aLine + "\n");
                StringTokenizer t = new StringTokenizer(aLine);
                t.nextToken();

                for(int j=0; j<n; j++) {
                    String key = new String((String)items.get(i) + (String)items.get(j));
                    double score = Double.parseDouble(t.nextToken());
                    if( score > maxPairScore)
                        maxPairScore = score;
                    if( score < minPairScore)
                        minPairScore = score;

                    scoreMatrix.put(key, new Double(score));
                }
            }
            in.close();
        } catch(IOException e) {
            e.printStackTrace();
            System.exit(0);
        }
    }

    //---------------------------------------------------------------
    // Score of aligning two base pair components: a1-a2 <-> b1-b2
    //---------------------------------------------------------------
    private double getCompatibleScore(String a1, String a2, String b1, String b2)
    {
        double score = Double.NEGATIVE_INFINITY;

        for(int i=0; i<a1.length(); i++)
        for(int j=0; j<a2.length(); j++) {
            for(int k=0; k<b1.length(); k++)
            for(int l=0; l<b2.length(); l++) {
                String key1 = a1.substring(i, i+1) + a2.substring(j, j+1);
                String key2 = b1.substring(k, k+1) + b2.substring(l, l+1);

                double s;
                if( scoreMatrix != null && scoreMatrix.containsKey(key1+key2)){
                    s = ((Double)scoreMatrix.get(key1+key2)).doubleValue();
                } else{
                    if( key1.equals(key2))
                        s = maxPairScore;
                    else
                        s = minPairScore;
                }

                if( s > score)
                    score = s;

                if( score == maxPairScore)
                   return score;
            }
        }
        return score;
    }

    //--------------------------------------------------
    // score of aligning two single bases
    //--------------------------------------------------
    private double getCompatibleScore(String a, String b)
    {
        double score = Double.NEGATIVE_INFINITY;

        for(int i=0; i<a.length(); i++) {
            for(int k=0; k<b.length(); k++) {
                String newstring = a.substring(i, i+1) + b.substring(k, k+1);
                if( scoreMatrix != null && scoreMatrix.containsKey(newstring)) {
                    double s = ((Double)scoreMatrix.get(newstring)).doubleValue();
                    if( s > score )
                        score = s;
                } else {
                    if( a.substring(i, i+1).equals(b.substring(k, k+1)))
                        score = maxSingleScore;
                    else
                        score = minSingleScore;
                }
            }
        }
        return score;
    }

    //--------------------------------------------------
    //              !!!! OBSOLETE !!!!!
    // check the code table to see whether there exist
    // identical codewords shared by both 'a' and 'b'.
    //--------------------------------------------------
    private boolean compatible(String a, String b)
    {
        for(int i=0; i<a.length(); i++)
        for(int j=0; j<b.length(); j++) {
            if( a.charAt(i) == b.charAt(j))
                return true;
        }

        return false;
    }
}
