/**********************************************************************
 *                                                                    *
 *       (c) Copyright 2003                                           *
 *       All rights reserved                                          *
 *       Programs written by Jianghui Liu (NJIT)                      *
 *                                                                    *
 *       Permission to use, copy, modify, and distribute this         *
 *       software and its documentation for any purpose and without   *
 *       fee is hereby granted, provided that this copyright          *
 *       notice appears in all copies.   Programmer(s) makes no       *
 *       representations about the suitability of this                *
 *       software for any purpose.  It is provided "as is" without    *
 *       express or implied warranty.                                 *
 *                                                                    *
 **********************************************************************/
package RNA;
 import java.util.Arrays;
 import java.util.Vector;
 import java.text.*;

 public class TextHistogram
 {
     private double[] values = null;

     public TextHistogram(int[] dataset)
     {
         values = new double[dataset.length];
         for(int i=0; i<values.length; i++)
         {
             values[i] = dataset[i];
         }

         Arrays.sort(values);
     }

     public TextHistogram(double[] dataset)
     {
         values = new double[dataset.length];
         for(int i=0; i<values.length; i++)
         {
             values[i] = dataset[i];
         }

         Arrays.sort(values);
     }

     public double getTopPercentValue(int percent)
     {
         int threshold = (int)(values.length * percent / 100);
         return (double)values[values.length - threshold];
     }

     public double getPValue(double score)
     {
         if( score > values[values.length-1] )
             return 0;
         if( score < values[0] )
             return 1;

         int index = Arrays.binarySearch(values, score);
         if( index >= 0)
         {
             while( index > 0 && values[index-1] >= score )
                 index --;
         }
         else {
             index = -(index+1);
         }

         return (double)(values.length - index) / values.length;
     }

     public String display()
     {
         return display((int)(values[values.length-1] - values[0]));
     }

     public String display(int nbins)
     {
         if( nbins > (int)(values[values.length-1] - values[0]))
             nbins = (int)(values[values.length-1] - values[0]);
         if( nbins <= 1)
             nbins = 10;

         NumberFormat nf = NumberFormat.getInstance();
         nf.setMaximumFractionDigits(2);

         int[] scores = new int[nbins];
         double max = values[values.length-1];
         double min = values[0];

         System.out.println("Maximum value is : " + nf.format(max));
         System.out.println("Minimam value is: " + nf.format(min));

         int xScale = (int)Math.floor((max - values[0])/nbins);
         if( xScale == 0)
             xScale = 1;

         int curPointer = values.length - 1;
         int binCount;
         for(binCount=1; binCount<nbins; binCount++)
         {
             while( curPointer >= 0 && values[curPointer] > max - binCount*xScale)
             {
                 scores[nbins - binCount]++;
                 curPointer--;
             }

             if( curPointer < 0)
                 break;
         }

         if( curPointer >= 0 )
         {
             scores[0] = curPointer + 1;
         }

         // format the text histogram
         StringBuffer[] lines = new StringBuffer[nbins];
         for(int i=0; i<lines.length; i++)
             lines[i] = new StringBuffer();

         int prefixLength = 20;
         for(int i=0; i<nbins; i++)
         {
             if( i == 0)
             {
                 lines[i].append("< " + (Math.ceil((max - (nbins-1)*xScale) * 100)/100) + " ");

                 int length = lines[i].length();
                 for(int j=0; j<(prefixLength-length); j++)
                 {
                     lines[i].append(" ");
                 }
                 lines[i].append("|");
             }
             else if( i == (nbins-1))
             {
                 lines[i].append(">" + nf.format(max - xScale) + " ");

                 int length = lines[i].length();
                 for(int j=0; j<(prefixLength-length); j++)
                 {
                     lines[i].append(" ");
                 }
                 lines[i].append("|");
             }
             else
             {
                 lines[i].append((Math.ceil((max - xScale * (nbins - i))*100)/100) +
                                 "<-->" + (Math.ceil((max - xScale * (nbins - i - 1))*100)/100) );

                 int length = lines[i].length();
                 for(int j=0; j<(prefixLength-length); j++)
                 {
                     lines[i].append(" ");
                 }
                 lines[i].append("|");
             }
         }

         double MaxScore = Statistic.getMax(scores);
         //int MinScore = Statistic.getMin(scores);
         int yScale = (int)Math.floor(MaxScore/50);
         if( yScale == 0)
             yScale = 1;

         String titleLine = new String("  score distribution:   one '=' equals " + yScale + "\n\n");
         for(int i=0; i<nbins; i++)
         {
             int ticks = (int)Math.round(scores[i]/yScale);
             for(int j=0; j<ticks; j++)
             {
                 lines[i].append("=");
             }

             if( ticks == 0 && scores[i] > 0)
             {
                 lines[i].append("o");
             }

             if( scores[i] > 0)
             {
                 lines[i].append("   " + "[" + scores[i] + "]");
             }

             lines[i].append("\n");
         }

         StringBuffer result = new StringBuffer();
         result.append("Max: " + nf.format(max) + "    Min: " + nf.format(min) + "\n");
         result.append(titleLine);
         for(int i=0; i<nbins; i++)
         {
             result.append(lines[i]);
         }

         return result.toString();
     }
 }
