/*************************************************************************
 *                                                                       *
 *       (c) Copyright 2003                                              *
 *       All rights reserved                                             *
 *       Programs written by Jianghui Liu (NJIT)                         *
 *                                                                       *
 *       Permission to use, copy, modify, and distribute this software   *
 *       and its documentation for any purpose and without fee is her-   *
 *       eby granted, provided that this copyright notice appears in     *
 *       all copies.   Programmer(s) makes no representations about      *
 *       the suitability of this software for any purpose.  It is pro-   *
 *       vided "as is" without express or implied warranty.              *
 *                                                                       *
 *       08/06/2003                                                      *
 *************************************************************************/
package RNA;
import java.io.*;
import java.util.*;
import java.text.NumberFormat;


//-------------------------------------------------------
// This class implements the database searching strategy
//-------------------------------------------------------
public class RNAmatcher
{
    public RNA query;
    public int no_strs;
    public String conserved_region;
    public RNAmatcher(String queryFile)
    {
        try {
            BufferedReader in = new BufferedReader(new FileReader(queryFile));
            query = RNAReader.getRNA(in);
            in.close();
        } catch(IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public RNAmatcher(String queryFile,String factor_file)
    {
        try {
            BufferedReader in = new BufferedReader(new FileReader(queryFile));
            query = RNAReader.getRNA(in, factor_file);
            in.close();
        } catch(IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
    public RNAmatcher( RNA a)
    {
	   query = a;
    }

    public RNAmatcher(){
    
    }

///###############################Search for CSFS (NEW)#########################################################################

    public void searchDBRawforcsfs(String DBFile, int ntop, String Score_matrices, double Penalty, 
                            String outputFile, boolean global,double [][][] scoresforcsfs,int [] auxmat)
    {
        String doll = new String("-\\|/");
	int test1=0;

        RNAReader in = new RNAReader(DBFile);
        int count = 0;
        RNA data = in.getNextRNA();
//        System.out.println("\n");
        while( data != null)
        {
            count ++;
            int dummy = count % 4;
//            System.out.print("\rDetermine the database size. Wait ... " + doll.substring(dummy, dummy+1));

            data = in.getNextRNA();
        }
  //      System.out.println("\n" + count + " RNA structures are stored in the Database.\n");
	no_strs = count;	
        double[] ScoreArray = new double[count];

        StringBuffer[] results = new StringBuffer[2*ntop];
        String[]  headers  = new String[2*ntop];
        RNA[]     topRNAs  = new RNA[2*ntop];
        double[] topScores = new double[2*ntop];

        // set up code translation table and score matrix
        String scoreMatrixFile = Score_matrices;
        String codeTableFile = "codeTable.properties";
        Matcher m = new Matcher(codeTableFile, scoreMatrixFile);

        int[] queryMap = new int[query.seqLength()];
        in = new RNAReader(DBFile);
        count = 0;
        //################change for csfs#####################
	data = in.getNextRNAforcsfs();
	//##########################################
    //    System.out.println("\n");
        
       // System.out.print("Searching against database. Wait ... ");
	while( data != null)
	
        {
	    count++;
            if((data.seq_no!=query.seq_no)&&(data.seq_no>query.seq_no)){
	    	int[] dataMap = new int[data.seqLength()];
          
	    	for(int j=0; j<dataMap.length; j++){
                	dataMap[j] = -1;
            	}
	
	        for(int i=0; i<queryMap.length; i++){
        	        queryMap[i] = -1;
	    	}

/////////////////////////////////////either local or global decided here////////////////////////////////////////////////////////////
            	if( global == true ){
		   ScoreArray[count - 1] = RNA.match2D(query, data, queryMap, dataMap, m);
	    	}
            	else 
                   ScoreArray[count - 1] = RNA.localMatch2D(query, data, queryMap, dataMap, m, Penalty);
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
             }
//############Change for csfs###############################################	   
	    
	     auxmat[count-1] = data.seq_no*10 + data.str_no;
	     data = in.getNextRNAforcsfs();
//################################################################
			
	     
       }

	int l1,m1,n1,n2;
	l1= query.seq_no;
	m1= query.str_no;
	for (n1=0;n1<count;n1++){
		scoresforcsfs[l1][m1][n1] = ScoreArray[n1];
	}	
    
        //System.out.println("\nSending output to file: " + outputFile + ", wait ...");

        /*try {
                PrintWriter out  = null;
                out= new PrintWriter(new BufferedWriter(new FileWriter(outputFile)));
		System.out.println("file opened");
        	out.println("dsjhdjshdsj");
		for(int i=0; i<ScoreArray.length; i++){
        		out.println(ScoreArray[i]+"\n");
		}
	        out.println("#=== Query ===#\n ");
                out.println(query.dispRNA());
        } catch(IOException e) {
                e.printStackTrace();
        }*/
	
/*        for(int i=0; i<ScoreArray.length; i++){
        	System.out.println(ScoreArray[i]+"\n");
	}
*/
}
//#################################################################################################################################


    //-------------------------------
    // Raw Score based DB searching
    //-------------------------------
    public void searchDBRaw(String DBFile, int ntop, String Score_matrices, double Penalty, 
                            String outputFile, boolean global)
    {
        String doll = new String("-\\|/");
	int test1=0;
///////////////////////////////////////
	int A0=0,C0=0,G0=0,U0=0,A1=0,C1=0,G1=0,U1=0;
//////////////////////////////////////

        RNAReader in = new RNAReader(DBFile);
        int count = 0;
        RNA data = in.getNextRNA();
        System.out.println("\n");
        while( data != null)
        {
            count ++;
            int dummy = count % 4;
            System.out.print("\rDetermine the database size. Wait ... " + doll.substring(dummy, dummy+1));

            data = in.getNextRNA();
        }
        System.out.println("\n" + count + " RNA structures are stored in the Database.\n");

        double[] ScoreArray = new double[count];

        StringBuffer[] results = new StringBuffer[2*ntop];
        String[]  headers  = new String[2*ntop];
        RNA[]     topRNAs  = new RNA[2*ntop];
        double[] topScores = new double[2*ntop];
        for(int i=0; i<topScores.length; i++)
            topScores[i] = Double.NEGATIVE_INFINITY;

        // set up code translation table and score matrix
        String scoreMatrixFile = Score_matrices;
        String codeTableFile = "codeTable.properties";
        Matcher m = new Matcher(codeTableFile, scoreMatrixFile);

        int[] queryMap = new int[query.seqLength()];
       //////////////print the length of the query sequence = size of the queryMap structure////////////////////

	System.out.print("\n\n The length of the query seq is : "+ query.seqLength());
///////////////////////////////////////////////////////////////////////////////////////////////////////////////
        in = new RNAReader(DBFile);
        count = 0;
        data = in.getNextRNA();
        System.out.println("\n");
        
        System.out.print("Searching against database. Wait ... ");
	while( data != null)
	
        {
            count ++;
	    test1++;	
            int dummy = count % 4;
          //  System.out.print("Searching against database. Wait ... " + doll.substring(dummy, dummy+1));
////////////
	   // System.out.print("point 1 :" + test1);   //used for testing	
//////////////
            int[] dataMap = new int[data.seqLength()];
           for(int j=0; j<dataMap.length; j++){
                dataMap[j] = -1;
	//	if (data.getBase(j).equals("A"))
	//		A0++;

	  //  	if (data.getBase(j).equals("C"))
	//		C0++;

	  //  	if (data.getBase(j).equals("G"))
	//		G0++;

	  //  	if (data.getBase(j).equals("U"))
	//		U0++;
            }
	
            for(int i=0; i<queryMap.length; i++){
                queryMap[i] = -1;
	    
	  //  	if (query.getBase(i).equals("A"))
	//		A1++;

	  //  	if (query.getBase(i).equals("C"))
	//		C1++;

	  //  	if (query.getBase(i).equals("G"))
	//		G1++;

	  //  	if (query.getBase(i).equals("U"))
	//		U1++;
	    }
/////////////////////////////////////either local or global decided here////////////////////////////////////////////////////////////
            if( global == true )
                ScoreArray[count - 1] = RNA.match2D(query, data, queryMap, dataMap, m);
            else 
                ScoreArray[count - 1] = RNA.localMatch2D(query, data, queryMap, dataMap, m, Penalty);
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//////////////print out query map & data map//////////////////////////////////////////////////////////////////////////

//	    System.out.print("\n\nQuery Map: length is "+ queryMap.length+ "\n");
//            System.out.print("\nA,C,G,U Content in Query sequence :- \n");
//	    System.out.print("A = " + A1 + "\nC = "+C1+"\nG = "+G1+"\nU = "+U1);
	
		
	   /* for (int i=0;i<queryMap.length;i++){
	     if(queryMap[i]!=-1)	
		System.out.print(","+i+"="+queryMap[i]);
   	    }*/

	
//	    System.out.print("\n\nData Map: length is "+ dataMap.length+"\n");

//            System.out.print("\nA,C,G,U Content in Database sequence :-\n"); 
//	    System.out.print("A = " + A0 + "\nC = "+C0+"\nG = "+G0+"\nU = "+U0);
	   /* for (int i=0;i<dataMap.length;i++){
	    	if(dataMap[i]!=-1)
		System.out.print(","+i+"=" + dataMap[i]);
   	    }*/

	
/////////////////////////////////////////////////////////////////////////////////////////

            //System.out.print("point 2:" + test1);  //used for testing
/////////////
            int slot = getSlot(topScores, ScoreArray[count-1]);
            if( slot != -1) {
                boolean found = false;
                for(int k=0; k<2*ntop; k++) {
                    if( k != slot && topRNAs[k] != null && topRNAs[k].getName().equals(data.getName()) ) {
                        if( ScoreArray[count-1] > topScores[k]) {
                            slot = k;
                            break;
                        } else {
                            found = true;
                            break;
                        }
                    }
                }
	/////////////////////	
               // System.out.print("point 3:" + test1 + found);  //was used for testing
////////////////////////////////
                if( found == false) {
                    topScores[slot] = ScoreArray[count-1];
                    topRNAs[slot] = data;
//////////////////////////////////////
                   // System.out.print("point 3.1:" + test1);    //was used for testing
       ////////////////////////////////////////             
		    
		    results[slot] = new StringBuffer(RNA.alignMatch(query, queryMap, data, dataMap, m));

/////////////////////////////////////////////////////////////////////////////////////////////
                   // System.out.print("point 3.2:" + test1);      //was used for testing
///////////////////////////////////////////////////////////////////////

                    int[] region1 = HomoUtil.getAlignedRegion(query, queryMap);

/////////////////////////////////////////////////////////////////////
                   // System.out.print("point 3.3:" + test1);       //was used for testing
 /////////////////////////////////////////////////////////////////////                   


		    int[] region2 = HomoUtil.getAlignedRegion(data, dataMap);
                    headers[slot] = fixedWidth( ((region1[0]+1) + "-" + (region1[1]+1)), 7) + "  " +
                                  fixedWidth( data.getName(), 22) + " "
                                  + fixedWidth( ((region2[0]+1) + "-" + (region2[1]+1)), 7) + " "
                                  + fixedWidth(data.getAnnotate(), 50);
                }
            }
//////////////////////////////

           // System.out.print("\npoint 4:" + test1);    //was used for testing
  /////////////////////////////////          
	   data = in.getNextRNA();
//data=null;
////////////////////////////////////////////
	     
            //System.out.print("\npoint 5:" + test1);   //was used for testing
////////////////////////////////////
      }
/////////////////////////////////
	
           // System.out.println("point 6:" + test1);     //was used for testing
/////////////////////////////
        System.out.println("\nSending output to file: " + outputFile + ", wait ...");

        try {
            PrintWriter out  = null;
            out= new PrintWriter(new BufferedWriter(new FileWriter(outputFile)));
		
        /*for(int i=0; i<topScores.length; i++){
        	out.println(topScores[i]+"\n");
	}*/
	    out.println("#=== Query ===#\n ");
            out.println(query.dispRNA());

            out.println("#=== Hits ===#\n");
	    out.println("Rank Score Query-offset DB Str/seq            Offset            Annotation\n");
            out.println("__________________________________________________________________________\n");
	    // format the rank list of RNAs
            StringBuffer detail = new StringBuffer();
            NumberFormat nf = NumberFormat.getInstance();
            nf.setMaximumFractionDigits(2);

            double threshold = Double.NEGATIVE_INFINITY;
            double score, Prescore = 0;
            int rank = 1;
            int i = 0;
            do {
                int slot = getTopRank(topScores);
                score = topScores[slot];
                if( topScores[slot] <= Double.NEGATIVE_INFINITY)
                    break;

                if( score == Prescore ) {
                    String strRank = new String("" + rank);
                    out.print("" + fixedWidth(strRank, 4) + "  " + fixedWidth(nf.format(score), 6) + "  "
                              + headers[slot] + "\n");
                } else {
                    rank = i+1;
                    String strRank = new String("" + rank);
                    out.print("" + fixedWidth(strRank, 4) + "  " + fixedWidth(nf.format(score), 6) + "  "
                              + headers[slot] + "\n");
                }

                detail.append("===============================================================\n");
                detail.append("\nRank: " + rank + "  Score: " + nf.format(score)); 
                detail.append(results[slot]);

                Prescore = score;
                i ++;
                if( i == ntop)
                    threshold = score;

                topScores[slot] = Double.NEGATIVE_INFINITY;
            } while ( score >= threshold);

            out.println("\n" + detail);

            TextHistogram hisA = new TextHistogram(ScoreArray);
            out.println("\n The score distribution is: \n");
            out.println(hisA.display(80));

            out.println("\n\n The score matrices used are : \n");
            out.println(m.getScoreMatrices());
            out.println("\nGap penalty is set as: " + Penalty);
            out.close();

            System.out.println("database searching has finished successfully!");
            System.out.println("The detailed result can be found in file: " + outputFile);
        } catch(IOException e) {
            e.printStackTrace();
        }

    }
    // ---------------------------------------------------------------------------------
    //  Two-Distibution DB Searching:
    //  Database searching: return the top 'ntop' structures. The scoring matrices and
    //  atom gap penalty are provided as arguments.
    // ---------------------------------------------------------------------------------
    /*public RNA[] getTopN(String DBFile, int ntop, String Score_matrices, double Penalty)
    {
        double[]  RawScores = null;
        int[]     AlignLens = null;
        double[]  IdenPercent = null;
        double[]  FinalScores = null;

        System.out.println("\nDetermine the database volume. Wait ...");

        // -----------------------------------------------------
        // First scan of database to get the size information
        // -----------------------------------------------------
        RNAReader in = new RNAReader(DBFile);
        int count = 0;
        RNA data = in.getNextRNA();
        while( data != null)
        {
            count ++;
            data = in.getNextRNA();
        }
        System.out.println( count + " RNA structures found in the Database.\n");
        int nStruct = count;

        RawScores = new double[nStruct];    // array of raw scores;
        AlignLens = new int[nStruct];       // array of alignment length;
        IdenPercent = new double[nStruct];  // array of structural identical percentagies;
        FinalScores = new double[nStruct];  // array of normalized scores;

        // set up code translation table and score matrix
        String scoreMatrixFile = Score_matrices;
        String codeTableFile = "codeTable.properties";
        Matcher m = new Matcher(codeTableFile, scoreMatrixFile);
        int[] queryMap = new int[query.seqLength()];

        // -------------------------------------------------------
        // Second Scan of the database to get the distributions
        // -------------------------------------------------------
        System.out.println("Determine raw-score and aligned-length distributions. Wait ...");
        in = new RNAReader(DBFile);
        count = 0;
        data = in.getNextRNA();
        while( data != null)
        {
            count ++;
            int[] dataMap = new int[data.seqLength()];
            for(int j=0; j<dataMap.length; j++)
                dataMap[j] = -1;
            for(int i=0; i<queryMap.length; i++)
                queryMap[i] = -1;

            RawScores[count - 1] = RNA.localMatch2D(query, data, queryMap, dataMap, m, Penalty);

            int[] region = HomoUtil.getAlignedRegion(query, queryMap);
            int start = region[0];
            int end   = region[1];
            int alignedLen = end - start + 1;
            AlignLens[count - 1] = alignedLen;

            int IdLen = 0;
            for(int i=start; i<=end; i++)
            {
                if( queryMap[i] != -1)
                    IdLen ++;
            }

            IdenPercent[count - 1] = (100.0 * IdLen) / alignedLen;

            data = in.getNextRNA();
        }

        // Two IMPORTANT distributions are set up !!
        TextHistogram scoreDist = new TextHistogram(RawScores);
        TextHistogram lengthDist = new TextHistogram(AlignLens);

        // The final scores are calculated !
        double factor = Math.log(10) * Math.log(10);
        for(int i=0; i<FinalScores.length; i++)
        {
            double p1 = scoreDist.getPValue(RawScores[i]);
            double p2 = lengthDist.getPValue(AlignLens[i]);
            FinalScores[i] = -1 * Math.log(p1 * p2) * IdenPercent[i] / factor;
        }

        // --------------------------
        // Get the top 'ntop' scores
        // --------------------------
        double[] topScores = new double[ntop];
        for(int i=0; i<topScores.length; i++)
        {
            topScores[i] = Double.NEGATIVE_INFINITY;
        }
        for(int i=0; i<FinalScores.length; i++)
        {
            int slot = getSlot(topScores, FinalScores[i]);
            if( slot != -1)
                topScores[slot] = FinalScores[i];
        }
        Arrays.sort(topScores);        // Ascending order !!

        System.out.println("\nFinal score interval: " + topScores[0] + 
                           " -- " + topScores[ntop-1]);

        // -------------------------------------------------------
        // Third Scan of the database to get the FINAL result 
        // -------------------------------------------------------
        System.out.println("Heavesting the final candidates ...");

        RNA[] topRNAs = new RNA[ntop];
        in = new RNAReader(DBFile);
        count = 0;
        data  = in.getNextRNA();
        int index = 0;
        while( data != null && index < ntop)
        {
            count ++;
            if( FinalScores[count-1] >= topScores[0] )
            {
                topRNAs[index] = data;
                index ++;
            }
            data = in.getNextRNA();
        }

        return topRNAs;
    }*/

    public static void main(String[] args) throws IOException
    {   
///##################################New Variables####################################################
	String sequence = " ";
        String RNAname  = " ";
        String remark   = " ";
        String structLine  = " ";

	RNA querycsfs = new RNA(RNAname,sequence,structLine,remark);	

        double[][][] scoresforcsfs = new double[100][100][200];///##############NEW###############################
        int [] auxmat = new int [1000]; 
	int max_seq_no=0;
        int max_str_no=0;
///#####################################################################################

        if( args.length == 0 || args[0].equalsIgnoreCase("-h") || args[0].equalsIgnoreCase("-help"))
        {
            System.out.println("Usage: ");
            System.out.println("   java RNAmatcher -d <Database> -q <Query> [-b] -m <query type>");
            System.out.println("   [-s <Score_matrix>] [-n <top>] [-o <Output>] [-g <Gap penalty>] ");
            System.out.println("Default Settings: ");
            System.out.println("   -d <Database> (Default): null");
            System.out.println("   -q <Query> (Default): null");
            System.out.println("   -m <query type> (Default): 0");
            System.out.println("   -s <Score_matrix> (Default): scoreMat.structure");
            System.out.println("   -n <top> (Default): 100");
            System.out.println("   -o <Output> (Default): junk.out");
            System.out.println("   -g <Gap penalty> (Default): -6 for '-m 0'; -3 for '-m 1'");
            System.exit(0);
        }
//######################################################
	String choice = "dsearch";	
	String cons_file = null;
	String conserved_region = null;
	String factor_file = null;
	RNAmatcher searcher = null;	
//#####################################################
        String Data_file = null;
        String Query_file = null;
        String Score_matrices = "scoreMat.structure";
        String Output_file = "junk.out";
        boolean RawMethod = true;
        double Penalty = -6;
        boolean global = false;
        int nTop = 100;

        boolean setPenalty = false;
        boolean motifMod = false;
        for(int i=0; i<args.length; i++)
        {   
//###########################################################################################
            if( args[i].equals("-c"))
	    {
	    	choice = "csfs";
//##########################################################################################		
	    } else if( args[i].equals("-d"))
            {
                Data_file = new String(args[i+1]);
                i++;
            } else if( args[i].equals("-q")) {
                Query_file = args[i+1];
                i++;
            } else if( args[i].equals("-s")) {
                Score_matrices = args[i+1];
                i++;
            } else if( args[i].equals("-b")) {
                global = true;
            } else if( args[i].equals("-o")) {
                Output_file = args[i+1];
                i++;
            } else if( args[i].equals("-g")) {
                setPenalty = true;
                Penalty = Double.parseDouble(args[i+1]);
                i++;
            } else if( args[i].equals("-m")) {
                int a = Integer.parseInt(args[i+1]);
                i ++;
                if( a == 1) {
                    motifMod = true;
                    if( setPenalty == false)
                        Penalty = -3;
                } else { motifMod = false; }
            } else if( args[i].equals("-n")) {
                nTop = Integer.parseInt(args[i+1]);
                i ++;
//#############################################NEW###############################################
            } else if(args[i].equals("-r")){
	    	cons_file = args[i+1];
	//	System.out.println("Cons file:" + cons_file);	
		i++;
	    } else if(args[i].equals("-f")){
		   factor_file = args[i+1];
 		   i++;
//###############################################################################################
	    } else {
                System.out.println("Illegal parameter " + args[i]);
                System.exit(0);
            }
        }


	if(!(choice.equals("csfs"))){   //for Regular Database Search
       		 if( Data_file == null || Query_file == null)
        	 {
            		System.out.println("ERROR! Database file or Query file NOT set properly!");
            		System.out.println("Try '-h' for help");
            		System.exit(0);
        	 }

        	System.out.println("\n\n#========== Your Settings ==========#");
       	 	System.out.println("Data File: " + Data_file);
       	 	System.out.println("Query file: " + Query_file);
      		System.out.println("Score matrices File: " + Score_matrices);
      		System.out.println("Gap Penalty: " + Penalty);
       		if( motifMod == true)
            		System.out.println("Runing Mode:  Motif Pattern");
        	else
            		System.out.println("Runing Mode:  Structure Comparison");

        	System.out.println("Output File: " + Output_file + "\n");
		if(factor_file != null){
        		searcher = new RNAmatcher(Query_file,factor_file);
		}
		else{
	
        		searcher = new RNAmatcher(Query_file);
		}
        	Date startpoint = new Date();

        	if( motifMod == true)
        	{
            		searcher.searchMotif2File(Data_file, nTop, Output_file, Score_matrices, Penalty);
        	}
        	else
       		{
            		System.out.println("#========== The Query Structure is: ==========#");
        	    	System.out.println(searcher.query.dispRNA());
	
            		if( RawMethod == true)
                		searcher.searchDBRaw(Data_file, nTop, Score_matrices, Penalty, Output_file, global);
            		else  // this 'else' never get excuted !!
                		searcher.searchDBDist(Data_file, nTop, Score_matrices, Penalty, Output_file);
        	}
           
        	Date endpoint = new Date();
        	System.out.println("\nCPU time by database search is: " + (endpoint.getTime() - startpoint.getTime())
                            + "  millisecond\n");
	}else {//###########################for csfs#################################
		System.out.println("Finding Common Structure for the RNA sequences");
		
       		 if( Data_file == null)
        	 {
            		System.out.println("ERROR! Database file!");
            		System.out.println("Try '-h' for help");
            		System.exit(0);
        	 }
		
        //#####################################Read the conserved region from the file######################
		
		BufferedReader cin = null;
		cin = new BufferedReader(new FileReader(cons_file));
		String cline = "";
		try{
		   if((cin == null) || (cin.ready() == false))
			System.out.println("Conserved Region file did not open!");
		}catch(Exception e){
		   e.printStackTrace();
		}

		try{
		   while(cline.length() == 0){
			if ((cline = cin.readLine()) == null){
				cin.close();
			}
		   }
		   conserved_region = cline;
		   System.out.println("The conserved region for csfs is :" + conserved_region);			
		}catch(IOException e){
		   e.printStackTrace();
		}
	//##################################################################################################	
	
        	RNAReader qin = new RNAReader(Data_file);    //#########NEW###########
		
		System.out.println("\n\n#========== Your Settings ==========#");
       	 	System.out.println("Operation : Finding Common RNA Structure");
		System.out.println("Data File: " + Data_file);
      		System.out.println("Score matrices File: " + Score_matrices);
      		System.out.println("Gap Penalty: " + Penalty);
        	System.out.println("Output File: " + Output_file + "\n");

        	Date startpoint = new Date();
		int count=0;
		querycsfs = qin.getNextRNAforcsfs();
		querycsfs.conserved = conserved_region;
		//System.out.println("quer conserved: "+querycsfs.conserved);
		while(querycsfs!=null){	
        	
			searcher = new RNAmatcher(querycsfs);
		//	System.out.println("#========== The Query Structure is: ==========#");
        	//	System.out.println(searcher.query.dispRNA());
			global = true;
                	searcher.searchDBRawforcsfs(Data_file, nTop, Score_matrices, Penalty, Output_file, global,scoresforcsfs,auxmat);
			count = searcher.no_strs;

	 	 	max_seq_no = querycsfs.seq_no;
			max_str_no = querycsfs.str_no;
			querycsfs = qin.getNextRNAforcsfs();
			if(querycsfs!=null){
				querycsfs.conserved = conserved_region;
			//	System.out.println("quer conserved: "+querycsfs.conserved);
			}
		}
	
		int l1=0,m1=0,n1=0,index=0;

		RNAmatcher getcsfs = new RNAmatcher();
		for(l1=1;l1<=max_seq_no;l1++){
		  for(m1=1;m1<=10;m1++){
		     for(n1=0;n1<count;n1++){
 			if(scoresforcsfs[l1][m1][n1]!=0){
				index = getcsfs.find_auxmat_index(l1*10+m1,count,auxmat);
				scoresforcsfs[auxmat[n1]/10][auxmat[n1]%10][index] = scoresforcsfs[l1][m1][n1];
			}	 		    	
		     }
		  }
		}
/*
		for(l1=1;l1<=max_seq_no;l1++){
			System.out.println("\nqseq_no\tqstr_no\tdstr_no\tScore");	
			for(m1=1;m1<=10;m1++){
				for(n1=0;n1<count;n1++){
					if(scoresforcsfs[l1][m1][n1]!=0){
						System.out.println(l1+"\t"+m1+"\t"+(n1+1)+"\t"+scoresforcsfs[l1][m1][n1]);
					}
				}
		
			}
		}
*/
/*		for(l1=0;l1<count;l1++){
			System.out.println((l1+1)+"=>"+auxmat[l1]);
		}
*/
		getcsfs.selectstr(scoresforcsfs,auxmat,count,max_seq_no, 10);
        	Date endpoint = new Date();
        	System.out.println("\nCPU time for csfs part 1 is: " + (endpoint.getTime() - startpoint.getTime())
                            + "  millisecond\n");
	}
}
//#########NEW for CSFS###################################################################################
//This function scans the score matrix obtained for csfs & selects the best structures####################

public void selectstr(double [][][] scoresforcsfs, int [] auxmat, int count, int max_seq_no, int max_str_no) throws IOException
{
	double max = -1;
  	int l1,m1,n1,store_n1=-1,store_n2=-1;
	int seq_no1=-1,seq_no2=-1,str_no1=-1,str_no2=-1;
	int [] indicator = new int[count];
  	int [] res_str = new int[max_seq_no+1];
	
 	String eg;
	boolean check = true;
	
//	BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
      while(check){	
//	eg = br.readLine();
	check = false;
	max =0;
	for(l1 = 0; l1<count;l1++){
	    if (indicator[l1] != -1){
	    	check = true;
	        break;
	    }		
	}
	if(check == false){
		System.out.println("Complete!!!!");
		break;
	}
		
	for (l1 = 1; l1<=max_seq_no; l1++){
		for(m1 = 1; m1<= max_str_no; m1++){
			for(n1=0; n1<=count; n1++){
				if(scoresforcsfs[l1][m1][n1]>max){
					max = scoresforcsfs[l1][m1][n1];
					seq_no1 = l1;
					str_no1 = m1;
					seq_no2 = auxmat[n1]/10;
					str_no2 = auxmat[n1]%10;
					store_n1=n1;
				}
						
			}
		}
	}
        for (l1=0;l1<=count;l1++){
		if(auxmat[l1]==seq_no1*10+str_no1){
			store_n2 = l1;
		}	
	}
	
	if(indicator[store_n2] != -1){        		
//	   System.out.println("seq_no1:"+seq_no1+" str_no1:"+str_no1);
	   indicator[store_n2] = -1;
	   res_str[seq_no1] = str_no1; 	
	}
	if(indicator[store_n1] !=-1){
//	   System.out.println("seq_no2:"+seq_no2+" str_no2:"+str_no2);
	   indicator[store_n1] = -1;
	   res_str[seq_no2] = str_no2;
	}
//	System.out.println("Max Score:"+max);	
	

//Making the rows 0 for all the other structures of the selected sequences	
	for (l1 = 1; l1<=max_seq_no; l1++){
		for(m1 = 1; m1<= max_str_no; m1++){
			if(((l1==seq_no1)&&(m1!=str_no1))||((l1 == seq_no2)&&(m1 != str_no2))){
				for(n1=0; n1<=count; n1++){
					scoresforcsfs[l1][m1][n1] = 0;									
				}
			}
		}
	}

//Making the columns 0 for all other structures of the selected sequences	
	for(n1 = 0; n1<= count; n1++){
		if (((auxmat[n1]/10 == seq_no1)&&(auxmat[n1]%10 != str_no1))||( (auxmat[n1]/10 == seq_no2) && (auxmat[n1]%10 != str_no2))){
			for(l1 = 1; l1<=max_seq_no; l1++){
				for(m1 =1; m1<=max_str_no; m1++){
					scoresforcsfs[l1][m1][n1] = 0;	
				}
			}
			indicator[n1] = -1;		
		} 	
	}

//Update the score matrix
int index = 0;
double new_val=0;
	for(l1 = 1; l1<=max_seq_no; l1++){
 	  if((l1!=seq_no1)&&(l1!=seq_no2)){
	    for(m1 = 1; m1<=max_str_no; m1++){
		  if((scoresforcsfs[l1][m1][store_n1]!=0)&&(scoresforcsfs[l1][m1][store_n2])!=0){
		  new_val = (scoresforcsfs[l1][m1][store_n1] + scoresforcsfs[l1][m1][store_n2])/2;
		  scoresforcsfs[l1][m1][store_n1] = new_val;
		  scoresforcsfs[l1][m1][store_n2] = new_val;	
		  index = find_auxmat_index(l1*10+m1, count, auxmat);
		  if(index!=-1){
			scoresforcsfs[auxmat[store_n1]/10][auxmat[store_n1]%10][index] = new_val;
		  	scoresforcsfs[auxmat[store_n2]/10][auxmat[store_n2]%10][index] = new_val;
		  }
		  }
       	    }	
	  }
	}
	scoresforcsfs[auxmat[store_n1]/10][auxmat[store_n1]%10][store_n2] = 0;
	scoresforcsfs[auxmat[store_n2]/10][auxmat[store_n2]%10][store_n1] = 0;
/*	
	for(l1=1;l1<=max_seq_no;l1++){
		System.out.println("\nqseq_no\tqstr_no\tdstr_no\tScore");	
		for(m1=1;m1<=max_str_no;m1++){
			for(n1=0;n1<count;n1++){
				if(scoresforcsfs[l1][m1][n1]!=0){
					System.out.println(l1+"\t"+m1+"\t"+(n1+1)+"\t"+scoresforcsfs[l1][m1][n1]);
				}
			}
	
		}
	}
*/
   }
   System.out.println("The selected structures:");
   for(int l3 = 1; l3<=max_seq_no; l3++){
	System.out.println("Seq No.:" + l3 + "Str No.:"+ res_str[l3]);
   }
   
   store_strs(res_str); 
 
}   

//####################NEW for CSFS######################################################################
//Store the selected structures in file
public void store_strs(int [] res_str){	
  
  BufferedReader in = null;
  FileWriter out = null;
  String inputfile = "./seqdata.db.struct";
  String strfile = "./csfsout1.str";
  
  try{
	in = new BufferedReader(new FileReader(inputfile));

  	out = new FileWriter(strfile);
  }catch(Exception e){
	e.printStackTrace();
  }

  String sequence = null;
  String structLine  = null;
  int seq_no,str_no;
  String [] header = new String[5];
  String line = new String("");
 
  try{
	while((line = in.readLine()) != null){
	
	//    if((line = in.readLine()) == null){
	  //  	in.close();
  	//	return;
         //   }		
	
            // get RNA name and remark
          if(line.charAt(0) == '>'){ 
	     header = line.substring(1).split("[\\s+]", 4); ///#####################change to 4 from 3 & line.substring from line

            // get RNA sequence
            sequence = in.readLine();
            //Get RNA folding 
	    structLine = in.readLine();

       	    seq_no = Integer.parseInt(header[0]);
	    str_no = Integer.parseInt(header[1]);	
	    if(res_str[seq_no] == str_no){
 		out.write(">"+header[2]+" "+header[3]);	 		
		out.write("\n");
		out.write(sequence);
		out.write("\n");
		out.write(structLine);
		out.write("\n");
	
	    }
           }
	}
	out.close();
  } catch (IOException e){
  	e.printStackTrace();
  }
	
}

//#####################################################################################################

//#######################################################################################################
public int find_auxmat_index(int value, int count, int [] auxmat){
	int n;
	for(n=0; n<=count; n++){
	   if (auxmat[n] == value) return n; 
	}
	return -1;

}

//#########################NEW to read the query RNA structure for CSFS###NOT USED ##############################################
    //---------------------------------------------------------
    // This is read in an RNA in parenthesis nested format as:
    //   >NM_000032:1-52 Homo sapiens aminolevulinate
    //   CACCTGTCATTCGTTCGTCCTCAGTGCAGGGCAACAGGACTTTAGGTTCAAG
    //   .(((((...((((((.(((((......)))))))).)))...))))).....
    //---------------------------------------------------------
    private static RNA getQuery(BufferedReader in)
    {
        String sequence = null;
        String RNAname  = null;
        String remark   = null;
        String structLine  = null;
	int seq_no,str_no;
	String [] header = new String[5];
        String line = null;
        try {
            while( ((line = in.readLine()) != null) &&
                    (line.length() == 0 || line.charAt(0) != '>'));

    	    if( line == null)
                return null;

            // get RNA name and remark
            header = line.substring(1).split("[\\s+]", 4); ///#####################change to 4 from 3 & line.substring from line
            //System.out.println("segments: " + header.length);
            if( header.length > 0){
                RNAname = header[2];
	    }
            else
                RNAname = "Unknown RNA";

            if( header.length > 1){
                remark = header[header.length-1];
                //System.out.println("annotate: " + remark);
            } else
                remark = "";

            // get RNA sequence
            sequence = in.readLine();
            structLine = in.readLine();

        } catch(IOException e) {
            e.printStackTrace();
	}
	
	seq_no = Integer.parseInt(header[0]);
	str_no = Integer.parseInt(header[1]);	
	return new RNA(RNAname.substring(0,RNAname.length()), sequence.toUpperCase(), structLine, remark,seq_no,str_no);
}

///##############################################################################################################

    //------------------------------------------------------------------------------------------------------------
    // This will search the dabase using Motif-mode: which will treat the query structure globally while
    // cope with subject structure locally.
    //-----------------------------------------------------------------------------------------------------------
    private void searchMotif2File(String DBFile, int ntop, String outputFile, String Score_matrices, double Penalty)
    {
        double[]  ScoreArray = null;

        // set up code translation table and score matrix
        String scoreMatrixFile = Score_matrices;

        String codeTableFile = "codeTable.properties";
        Matcher m = new Matcher(codeTableFile, scoreMatrixFile);

        StringBuffer[] results = new StringBuffer[2*ntop];
        RNA[] topRNAs = new RNA[2*ntop];
        String[] headers = new String[2*ntop];
        double[] topScores = new double[2*ntop];
        for(int i=0; i<topScores.length; i++)
            topScores[i] = Double.NEGATIVE_INFINITY;

        RNAReader in = new RNAReader(DBFile);

        PrintWriter out  = null;
        System.out.println("#==== The Query Motif ====#\n");
        System.out.println(query.dispRNA());
        int[] motifMap = new int[query.seqLength()];

        System.out.println("Searching the database");
        System.out.println("Determine the volume of the Database ...");

        int count = 0;
        try {
            out= new PrintWriter(new BufferedWriter(new FileWriter(outputFile)));

            out.println("#==== The Query Motif ====# ");
            out.println(query.dispRNA());

            // find out the number of RNAs in the Database
            RNA data = in.getNextRNA();
            while( data != null)
            {
                count ++;
                data = in.getNextRNA();
            }
            System.out.println( "\n" + count + " RNA structures are stored in the Database.\n");
            ScoreArray = new double[count];

            // start calculation
            in = new RNAReader(DBFile);
            count = 0;
            data = in.getNextRNA();
            while( data != null)
            {
                count ++;

                int[] dataMap = new int[data.seqLength()];
                for(int j=0; j<dataMap.length; j++)
                    dataMap[j] = -1;

                for(int i=0; i<motifMap.length; i++)
                    motifMap[i] = -1;

                ScoreArray[count - 1] = RNA.motifMatch2D(query, data, motifMap, dataMap, m, Penalty);

                int slot = getSlot(topScores, ScoreArray[count-1]);
                if( slot != -1)
                {
                    boolean found = false;
                    for(int i=0; i<topRNAs.length; i++)
                    {
                        if( topRNAs[i] != null && topRNAs[i].getName().equals(data.getName()) )
                        {
                            found = true;
                            break;
                        }
                    }
                    if( found == false )
                    {
                        topScores[slot] = ScoreArray[count-1];
                        topRNAs[slot] = data;
                        results[slot] = new StringBuffer(RNA.alignMatch(query, motifMap, data, dataMap, m));
                        int[] region1 = HomoUtil.getAlignedRegion(query, motifMap);
                        int[] region2 = HomoUtil.getAlignedRegion(data, dataMap);
                        headers[slot] = fixedWidth( ((region1[0]+1) + "-" + (region1[1]+1)), 7) + "  " +
                                         fixedWidth( data.getName(), 22) + " " + 
                                         fixedWidth( ((region2[0]+1) + "-" + (region2[1]+1)), 7) + " " +
                                         fixedWidth(data.getAnnotate(), 50);
                    }
                }

                if( count % 200 == 0)
                {
                    System.out.print("\r");
                    System.out.print("  Searched " + count + " RNAs, wait ......");
                }

                data = in.getNextRNA();
            }

            System.out.println("Sending output to file: " + outputFile + " wait ...");

            //out.println("Database Scanned: " +  DBFile + ";  Total Number of RNA structures: " + count );
            //out.println("===============================================================");
            out.println("#==== Hits ====#\n");

            // format the rank list of RNAs
            StringBuffer detail = new StringBuffer();
            NumberFormat nf = NumberFormat.getInstance();
            nf.setMaximumFractionDigits(2);
            int rank = 1;
            double prevScore = Double.NEGATIVE_INFINITY;
            double threshold = Double.NEGATIVE_INFINITY;
            int i = 0;
            double score;
            do{
                int slot = getTopRank(topScores);
                score = topScores[slot];
                if( score <= Double.NEGATIVE_INFINITY)
                    break;

                if( score == prevScore)
                {
                    String strRank = new String("" + rank);
                    out.print("" + fixedWidth(strRank,4) + " " + fixedWidth(nf.format(score),6) +
                              " " + headers[slot] + "\n");
                }
                else
                {
                    rank = i + 1;
                    String strRank = new String("" + rank);
                    out.print("" + fixedWidth(strRank,4) + " " + fixedWidth(nf.format(score),6) +
                              " " + headers[slot] + "\n");
                }

                detail.append("===============================================================\n");
                detail.append("\nRank: " + rank + "  Score: " + nf.format(score) );
                detail.append(results[slot]);

                topScores[slot] = Double.NEGATIVE_INFINITY;
                prevScore = score;
                i ++;

                if( i == ntop)
                    threshold = prevScore;
            } while( score >= threshold );

            out.println("\n\n Detailed Results for the top list: ");
            out.println(detail);

            TextHistogram his = new TextHistogram(ScoreArray);
            out.println("\n The score distribution is: \n");
            out.println(his.display(80));

            out.println("\n\n The score matrices used are : \n");
            out.println(m.getScoreMatrices());
            out.println("\nGap penalty is set as: " + Penalty);
            out.close();

            System.out.println("Motif searching has finished successfully!");
            System.out.println("The detailed result can be found in file: " + outputFile);
        }
        catch(IOException e)
        {
            e.printStackTrace();
        }

    }

    //----------------------------------------------------------------
    // Two-Distribution Approach to Rank the hists:
    // The same function as getTopN, except that this one will format 
    // the verbose output to a dump file
    //----------------------------------------------------------------
    private void searchDBDist(String DBFile, int ntop, String Score_matrices, 
                           double Penalty, String outputFile)
    {
        double[]  RawScores  = null;
        int[]     AlignLens  = null;
        double[]  IdenPercent= null;
        double[]  FinalScores= null;

        System.out.println("Determine the database size, wait ...");

        // -----------------------------------------------------
        // First scan of database to get the size information
        // -----------------------------------------------------
        RNAReader in = new RNAReader(DBFile);
        int count = 0;
        RNA data = in.getNextRNA();
        while( data != null)
        {
            count ++;
            data = in.getNextRNA();
        }
        System.out.println( count + " RNA structures found in the Database.\n");
        int nStruct = count;

        RawScores = new double[count];
        AlignLens = new int[count];
        IdenPercent = new double[count];
        FinalScores = new double[count];

        // set up code translation table and score matrix
        String scoreMatrixFile = Score_matrices;
        String codeTableFile = "codeTable.properties";
        Matcher m = new Matcher(codeTableFile, scoreMatrixFile);
        int[] queryMap = new int[query.seqLength()];

        // -------------------------------------------------------
        // Second Scan of the database to get the distributions
        // -------------------------------------------------------
        System.out.println("\nDetermine raw-score and aligned-length distributions. Wait ...");
        in = new RNAReader(DBFile);
        count = 0;
        data  = in.getNextRNA();
        while( data != null)
        {
            count ++;

            int[] dataMap = new int[data.seqLength()];
            for(int j=0; j<dataMap.length; j++)
                dataMap[j] = -1;
            for(int i=0; i<queryMap.length; i++)
                queryMap[i] = -1;

            RawScores[count - 1] = RNA.localMatch2D(query, data, queryMap, dataMap, m, Penalty);

            int[] region = HomoUtil.getAlignedRegion(query, queryMap);
            int start = region[0];
            int end   = region[1];
            int alignedLen = end - start + 1;
            AlignLens[count - 1] = alignedLen;

            int IdLen = 0;
            for(int i=start; i<=end; i++)
            {
                //if( queryMap[i] != -1 && query.getBase(i).equals(data.getBase(queryMap[i]-1)) )
                if( queryMap[i] != -1)
                    IdLen ++;
            }
            IdenPercent[count - 1] = 100.0 * IdLen / alignedLen;

            if( count % 200 == 0)
            {
                System.out.print("\r");
                System.out.print("  Processed " + count + " RNAs, be patient ......");
            }
            data = in.getNextRNA();
        }

        // Two IMPORTANT distributions are set up !!
        TextHistogram scoreDist = new TextHistogram(RawScores);
        TextHistogram lengthDist = new TextHistogram(AlignLens);

        // The final scores are calculated !
        double factor = Math.log(10) * Math.log(10);
        for(int i=0; i<FinalScores.length; i++)
        {
            double p1 = scoreDist.getPValue(RawScores[i]);
            double p2 = lengthDist.getPValue(AlignLens[i]);
            FinalScores[i] = -1 * Math.log(p1 * p2) 
                             * IdenPercent[i] / factor;
        }

        // --------------------------------------------
        // Get the top 'ntop' scores
        // --------------------------------------------
        double[] topScores = new double[ntop];
        for(int i=0; i<topScores.length; i++)
        {
            topScores[i] = Double.NEGATIVE_INFINITY;
        }
        for(int i=0; i<FinalScores.length; i++)
        {
            int slot = getSlot(topScores, FinalScores[i]);
            if( slot != -1)
                topScores[slot] = FinalScores[i];
        }
        Arrays.sort(topScores);        // Ascending order !!

        System.out.println("\nFinal score interval: " + topScores[0] + " -- " + topScores[ntop-1]);

        // -------------------------------------------------------
        // Third Scan of the database to get the FINAL result 
        // -------------------------------------------------------
        System.out.println("Heavesting the final candidates and preparing the output ...");

        StringBuffer[] alignments = new StringBuffer[2*ntop];  // detailed strucuture alignment;
        RNA[] topRNAs = new RNA[2*ntop];                       // the final selected candidates;
        double[] candScores = new double[2*ntop];              // the final set of scores;
        String[] headers = new String[2*ntop];
        for(int i=0; i<2*ntop; i++)
            candScores[i] = Double.NEGATIVE_INFINITY;

        in = new RNAReader(DBFile);
        count = 0;
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(2);
        data = in.getNextRNA();
        int index = 0;
        while( data != null && index < 2*ntop)
        {
            count ++;
            boolean found = false;
            for(int k=0; k<index; k++)
            {
                if( topRNAs[k].getName().equals(data.getName()) )
                {
                    found = true;
                    break;
                }
            }
            if( found == true)
            {
                data = in.getNextRNA();
                continue;
            }

            if( FinalScores[count-1] >= topScores[0] )
            {
                int[] dataMap = new int[data.seqLength()];
                for(int j=0; j<dataMap.length; j++)
                    dataMap[j] = -1;
                for(int i=0; i<queryMap.length; i++)
                    queryMap[i] = -1;

                RNA.localMatch2D(query, data, queryMap, dataMap, m, Penalty);
                alignments[index] = new StringBuffer(RNA.alignMatch(query, queryMap, data, dataMap, m));
                candScores[index] = FinalScores[count-1];
                topRNAs[index] = data;

                int[] region1 = HomoUtil.getAlignedRegion(query, queryMap);
                int[] region2 = HomoUtil.getAlignedRegion(data, dataMap);
                headers[index] = fixedWidth( ((region1[0]+1) + "-" + (region1[1]+1)), 7) + "  " +
                                  fixedWidth( data.getName(), 22) + " "
                                  + fixedWidth( ((region2[0]+1) + "-" + (region2[1]+1)), 7) + " "  
                                  + fixedWidth(data.getAnnotate(), 50);
                index ++;
            }
            data = in.getNextRNA();
        }
 
        StringBuffer briefs = new StringBuffer();
        StringBuffer details= new StringBuffer();

        double threshold = Double.NEGATIVE_INFINITY;
        double score, Prescore = 0;
        int rank = 1;
        int i = 0;
        do {
            int slot = getMax(candScores);
            score = candScores[slot];
            if( score <= Double.NEGATIVE_INFINITY )
                break;

            if( score == Prescore )
            {
                String strRank = new String("" + rank);
                briefs.append("" + fixedWidth(strRank, 4) + "  " + fixedWidth(nf.format(score), 8) + "  " 
                          + headers[slot] + "\n");
            }
            else
            {
                rank = i+1;
                String strRank = new String("" + rank);
                briefs.append("" + fixedWidth(strRank, 4) + "  " + fixedWidth(nf.format(score), 8) + "  " 
                          + headers[slot] + "\n");
            }

            details.append("===============================================================\n");
            details.append("\nRank: " + rank + "  Score: " + nf.format(score) );
            details.append(alignments[slot]);

            Prescore = score;
            i++;
            if( i == ntop)
                threshold = Prescore;

            candScores[slot] = Double.NEGATIVE_INFINITY;   // reset the score !
        } while( score >= threshold);

        System.out.println("Dumping the output to " + outputFile + " ...");

        try {
            PrintWriter out  = null;
            out= new PrintWriter(new BufferedWriter(new FileWriter(outputFile)));

            out.println("#=== Query ===#\n ");
            out.println(query.dispRNA());

            out.println("#=== Hits ===#\n");
            out.println(briefs);

            out.println("\n\n Detailed Results for the top list: ");
            out.println(details);
       
            TextHistogram his = new TextHistogram(FinalScores);
            out.println("\n The score distribution is: \n");
            out.println(his.display());

            out.println("\n\n The score matrices used are : \n");
            out.println(m.getScoreMatrices());
            out.println("\nGap penalty is set as: " + Penalty);
            out.close();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    // ---------------------------------------------------
    // Given a SET, find the minimum item which is smaller
    // than the given the item.
    // ---------------------------------------------------
    private int getSlot(double[] scores, double oneScore)
    {
        double min = scores[0];
        int slot = 0;
        for(int i=1; i<scores.length; i++)
        {
            if( scores[i] < min)
            {
                min = scores[i];
                slot = i;
            }
        }

        if( scores[slot] < oneScore)
            return slot;
        else
            return -1;
    }

    // ----------------------------------------
    //  find the maximum item from a SET 
    // ----------------------------------------
    private int getMax(double[] scores)
    {
        double max = scores[0];
        int slot = 0;
        for(int i=1; i<scores.length; i++)
        {
            if( scores[i] > max)
            {
                max = scores[i];
                slot = i;
            }
        }
        return slot;
    }

    private String fixedWidth(String str, int width)
    {
        StringBuffer ret = new StringBuffer();
        int length = str.length();
        if( length > width)
            length = width;
        ret.append(str.substring(0, length));

        for(int i=0; i<width-length; i++)
            ret.append(" ");
        return ret.toString();
    }

    //--------------------------------------
    // From a set, select the largest item
    //--------------------------------------
    private int getTopRank(double[] scores)
    {
        double max = scores[0];
        int slot = 0;
        for(int i=1; i<scores.length; i++)
        {
            if( scores[i] > max)
            {
                max = scores[i];
                slot = i;
            }
        }
                                                                                                                             
        return slot;
    }
}

