// --*- C++ -*------x---------------------------------------------------------
// $Id: Letter3D.cc,v 1.3 2005/09/02 18:22:50 bindewae Exp $
//
// Class:           Letter3D
// 
// Base class:      -
//
// Derived classes: - 
//
// Author:          Eckart Bindewald
//
// Project name:    -
//
// Date:            $Date: 2005/09/02 18:22:50 $
//
// Description:     - 
// -----------------x-------------------x-------------------x-----------------

#include <Letter3D.h>

// ---------------------------------------------------------------------------
//                                   Letter3D
// -----------------x-------------------x-------------------x-----------------

/* CONSTRUCTORS */

/* default constructor */
Letter3D::Letter3D() : letter(' ') 
{
}

/* copy constructor */
Letter3D::Letter3D(const Letter3D& other)
{
  copy(other);
}

/* destructor */
Letter3D::~Letter3D() { }

/* OPERATORS */

/** Assigment operator. */
Letter3D& 
Letter3D::operator = (const Letter3D& orig)
{
  if ((&orig) != this) {
    copy(orig);
  }
  return *this;
}

ostream& 
operator << (ostream& os, const Letter3D& rval)
{
  os << rval.letter << endl << rval.matrix << rval.lines;
  return os;
}

istream& 
operator >> (istream& is, Letter3D& rval)
{
  is >> rval.letter;
  // cout << "read letter: " << rval.letter << endl;
  is >> rval.matrix;
  // cout << "Read matrix: " << rval.matrix << endl;
  is >> rval.lines;
  // cout << "Lines : " << rval.lines << endl;
  ERROR_IF(!is, "Error reading Letter3D element!", exception);
  return is;
}

/* PREDICATES */

/** returns coordinates of non-zero matrix elements */
Vec<Letter3D::point_type>
Letter3D::getPoints() const
{
  Vec<point_type> points;
  for (Vec<Vec<matrix_type> >::size_type row = 0; row < matrix.size(); ++row) {
    for (Vec<matrix_type>::size_type col = 0; col < matrix[row].size(); ++col) {
      if (matrix[row][col] != 0) {
	points.push_back(indexToPoint(static_cast<int>(col), 
				      static_cast<int>(row)));
      }
    }
  }
  return points;
}

/** Is current state valid? */
bool
Letter3D::isValid() const
{
  return (matrix.size() > 0);
}

/* MODIFIERS */

/* copy method */
void 
Letter3D::copy(const Letter3D& other)
{
  letter = other.letter;
  matrix = other.matrix;
  lines = other.lines;  
}
