#include <pdbtools.h>
#include <StringTools.h>

/** read HETATM records of PDB file */
Vec<Vec<Vector3D> >
readPdbVectors(istream& is, bool readHydrogens,
	       bool readATOMMode,
	       bool readHETATMMode,
	       bool quitTERMode)
{
  const unsigned int precision = 3;
  bool validFlag = true;
  vector<string> words;
  Vec<Vec<Vector3D> > result;
  int currentResidueId = -999;
  while(validFlag && is) {
    string line = getLine(is);
    //    cout << "line: " << linectr++ << " " << line << endl;
    if ( (line.size() > 20) && (line.substr(17,3).find("HOH") == 0) ) {
      // cout << "readPdbHetero: Ignoring water molecule!" << endl;
      continue; // skip water molecule
    }
    // ignore hydrogens if asked too
    if ( (!readHydrogens) && (line[13] =='H') ) {
      continue;
    }
    //    cout << "getting tokens... " << endl;
    words = getTokens(line);
    //    cout << words.size() << " tokens found!" << endl;
    if (words.size() >= 8) {
      if ((line.size() > 45) && ((readHETATMMode && (words[0].find("HETATM") == 0)) 
				 || (readATOMMode && (words[0].find("ATOM") == 0) ) ) ) {
	double x = stod(line.substr(30, 5+precision));
	double y = stod(line.substr(35+precision, 5+precision));
	double z = stod(line.substr(40+(2*precision), 5+precision));
	int residueId = stoi(line.substr(22, 4));
	Vector3D v(x,y,z);
	if (residueId != currentResidueId) {
	  currentResidueId = residueId;
	  result.push_back(Vec<Vector3D>()); // start new residue
	}
	result[result.size()-1].push_back(v);
      }      
    }
    else if (words.size() > 0) {
      if ((words[0].find("END") == 0)
	  || (words[0].find("ENDMDL") == 0)
	  || (quitTERMode && (words[0].find("TER") == 0)) // overread chain breaks
	  || (words[0].find("MASTER") == 0) ) {
	validFlag = false;
      }
	  
    }
    
  }
  return result;
}
