#ifndef __ALIGNMENT_COLUMN__
#define __ALIGNMENT_COLUMN__

#include <string>
#include <Vec.h>
#include <CharacterAlphabet.h>

using namespace std;

class AlignmentColumn {

 public:

  AlignmentColumn() { }
  
  AlignmentColumn(const string& _s, const CharacterAlphabet& _alphabet) 
    : alphabet(_alphabet), s(_s) {
    charCount = Vec<unsigned int>(alphabet.size(), (s.size()+1));
    gapCount = s.size() +1;
  }

  AlignmentColumn(const AlignmentColumn& other) { copy(other); }

  virtual ~AlignmentColumn() { }
  
  /** returns n'th character (or gap) of column */
  char getChar(unsigned int n) const { return s[n]; }

  /** returns count of n'th character in alphabet */
  unsigned int getCount(unsigned int i) const { 
    if (charCount[i] > s.size()) {
      charCount[i] = countChar(s, alphabet.getChar(i));
    }
    return charCount[i]; 
  }
  
  /** returns number of gap characters */
  unsigned int getGapCount() const { 
    if (gapCount > s.size()) {
      updateGapCount();
    }
    return gapCount; 
  }

  /** returns number of non-gap characters */
  unsigned int getNonGapCount() const { 
    return (s.size()-getGapCount()); 
  }

  unsigned int size() const { return s.size(); }

 private:

  void update() const {
    if (charCount.size() != alphabet.size()) {
      charCount = Vec<unsigned int>(alphabet.size());
    }
    for (unsigned int i = 0; i < alphabet.size(); ++i) {
      charCount[i] = countChar(s, alphabet.getChar(i));
    }
    updateGapCount();
  }

  /** updates count of i'th character (i: index in alphabet) */
  void updateCount(unsigned int i) const  {
    charCount[i] = countChar(s, alphabet.getChar(i));
  }

  void updateGapCount() const {
    gapCount = 0;
    for (unsigned int i = 0; i < s.size(); ++i) {
      if (alphabet.isGap(s[i])) {
	++gapCount;
      }
    }
  }

  void copy(const AlignmentColumn& other) {
    alphabet = other.alphabet;
    s = other.s;
  }

  unsigned int countChar(const string& s, char c) const {
    unsigned int count = 0;
    for (unsigned int i = 0; i < s.size(); ++i) {
      if (s[i] == c) {
	++count;
      }
    }
    return count;
  }

  CharacterAlphabet alphabet;

  string s;
  
  mutable Vec<unsigned int> charCount;

  mutable unsigned int gapCount;

};


#endif
