// --*- C++ -*------x---------------------------------------------------------
// $Id: Letter3D.h,v 1.3 2005/09/12 18:57:44 bindewae Exp $
//
// Class:           Letter3D
// 
// Base class:      -
//
// Derived classes: - 
//
// Author:          Eckart Bindewald
//
// Project name:    -
//
// Date:            08/2005
//
// Description:     3D representation of letter, used by JVXMatrixWriter, VRMLMatrixWriter
// 
// Reviewed by:     -
// -----------------x-------------------x-------------------x-----------------

#ifndef __LETTER3D_H__
#define __LETTER3D_H__

// Includes

#include <iostream>
#include <Vec.h>
#include <debug.h>
#include <utility> 

using namespace std;

/** 3D representation of letter
    @review - */
class Letter3D {
public:
  /* TYPES */

  typedef Vec<unsigned int> line_type;

  typedef int matrix_type;

  typedef pair<double, double> point_type;

  typedef Vec<matrix_type>::size_type size_type;

  enum { FACE_XZ = 0, FACE_YZ = 1, FACE_XY180 = 2, FACE_XY90 = 3 };

  /* CONSTRUCTORS */

  Letter3D();

  Letter3D(const Letter3D& orig);

  virtual ~Letter3D();

  /* OPERATORS */

  /** Assigment operator. */
  Letter3D& operator = (const Letter3D& orig);

  friend ostream& operator << (ostream& os, const Letter3D& rval);
  friend istream& operator >> (istream& is, Letter3D& rval);

  /* PREDICATES */

  /** returns letter */
  virtual char getLetter() const { return letter; }

  /** returns coordinates of non-zero matrix elements. Corresponds to indices used by lines. */
  virtual Vec<point_type> getPoints() const;

  /** returns letter */
  virtual const Vec<Vec<matrix_type> >& getMatrix() const { return matrix; }

  /** returns defined lines */
  virtual const Vec<line_type>& getLines() const { return lines; }

  /** return number of columns */
  virtual size_type getNumberColumns() const { 
    PRECOND(isValid(), exception);
    return matrix[0].size(); 
  }

  /** returns number of rows */
  virtual size_type getNumberRows() const { return matrix.size(); }

  /** Is current state valid? */
  virtual bool isValid() const;

  /* MODIFIERS */

protected:
  /* OPERATORS  */
  /* PREDICATES */
  point_type indexToPoint(int col, int row) const { 
    point_type p;
    p.first = col;
    p.second = matrix.size() - static_cast<double>(row) - 1.0;
    return p;
  }

  /* MODIFIERS  */
  void copy(const Letter3D& other);

private:
  /* OPERATORS  */
  /* PREDICATES */
  /* MODIFIERS  */

private:
  /* PRIVATE ATTRIBUTES */

  char letter;
  // matrices, usually 8x8 matrix in Commodore 64 Style
  Vec<Vec<matrix_type> > matrix;
  // defines set of lines
  Vec<line_type> lines; 

};

#endif /* __ACLASS_H__ */

