// --*- C++ -*------x---------------------------------------------------------
// $Id: Vec.h,v 1.2 2005/01/30 17:29:16 bindewae Exp $
//
// Class:           Vec
// 
// Base class:      vector
//
// Derived classes: - 
//
// Description:     "vector" class, 
//                   can easily be extended for example for range-checking 
// 
// -----------------x-------------------x-------------------x-----------------

#ifndef __VEC_H__
#define __VEC_H__

// Includes

#include <vector>

#include <debug.h>

using namespace std;

template<class T>
class Vec: public vector<T> {
public:
  typedef typename vector<T>::size_type size_type;

public:
  Vec(): vector<T>() { }
  Vec(const vector<T>& orig) : vector<T>(orig) { }
  Vec(size_type n): vector<T>(n) { }
  Vec(size_type n, const T& val): vector<T>(n, val) { }

};

/** Writes a Vec to a stream.
  The data format is very simple: the first element is the length of
  the vector followed by a space-seperated list of elements. */
template <class T>
inline
istream& 
operator >> (istream& is, Vec<T>& v)
{
  PRECOND(is, exception);
  typename Vec<T>::size_type size;
  v.clear(); // first remove all existing elements EB 02/2001
  is >> size;
  ERROR_IF(!is, "Vec: Number of elements expected as first item!",
	   exception);
  // maximum number of input elements:
  ERROR_IF(size > 200000, "Vec: Too large number of input elements!",
	   exception);
  for (typename Vec<T>::size_type i = 0; i < size; i++)
    {
      T element;
      is >> element;
      ERROR_IF(!is, "Vec: Error reading element!", exception);
      v.push_back(element);
    }

  POSTCOND(is, exception);
  return is;

}

/** Writes a Vec to a stream.

  The data format is very simple: the first element is the length of
  the vector followed by a space-seperated list of elements. */
template <class T>
inline
ostream& 
operator << (ostream& os, const Vec<T>& v)
{
  PRECOND(os, exception);
  os << v.size() << "   ";
  for (unsigned int i = 0; i < v.size(); ++i) {
    os << v[i] << " ";
  }
  os << endl;
  POSTCOND(os, exception);
  return os;
}

/**
 comparison. return true, if == is true for all elements 
*/
template <class T>
inline
bool
operator == (const Vec<T>& lval, const Vec<T>& rval)
{
  if (lval.size() != rval.size()) {
    return false;
  }
  for (unsigned int i = 0; i < lval.size(); ++i) {
    if (!(lval[i] == rval[i])) {
      return false;
    }
  }
  return true;
}

#endif /* __A_CLASS_H__ */

