// --*- C++ -*------x---------------------------------------------------------
// $Id: ClassifierBase.h,v 1.1.1.1 2006/07/03 14:43:20 bindewae Exp $
//
// Class:           ClassifierBase
// 
// Base class:      -
//
// Derived classes: KnnNet, KnnNet2
//
// Author:          Eckart Bindewald
//
// Description:     base class interface for all classifiers
// 
// Reviewed by:     -
// -----------------x-------------------x-------------------x-----------------

#ifndef __CLASSIFIER_BASE_H__
#define __CLASSIFIER_BASE_H__

// Includes

#include <iostream>
#include <Vec.h>
#include <debug.h>

/** Implements network of k-nearest neigbor classifiers.
    @author Eckart Bindewald
    @see    Modern Applied Statistics with S / Ripley B
    @review */
class ClassifierBase {
public:

  virtual ~ClassifierBase() { }

  /* PREDICATES */

  /** Is current state valid? */
  virtual bool isValid() const {
    return false;
  }

  /** central prediction method. Returns probability of each class according to 
      vote of classes of k nearest neighbors */
  virtual Vec<double> predictClassProb(const Vec<double>& v) const {
    ERROR("predictClassProb not yet implemented!");
    return Vec<double>();
  }

  /** central prediction method. Returns probability of each class according to 
      vote of classes of k nearest neighbors */
  virtual Vec<double> predictClassProb(const Vec<double>& v, unsigned int knownClass) const {
    ERROR("predictClassProb not yet implemented!");
    return Vec<double>();
  }

  /** central prediction method. Returns probability of each class according to 
      vote of classes of k nearest neighbors */
  virtual Vec<double> predictClassProbTrain(const Vec<double>& v, unsigned int knownClass,
					    ostream& os) const {
    ERROR("predictClassProb not yet implemented!");
    return Vec<double>();
  }

  virtual Vec<double> getLastPrediction() const { 
    ERROR("getLastPrediction not implemented!");
    return Vec<double>(); }

  /* MODIFIERS */
  
  virtual void clear() {
  }

protected:
  /* OPERATORS  */
  /* PREDICATES */
  /* MODIFIERS  */
  virtual void copy(const ClassifierBase& other) { }

private:
  /* OPERATORS  */
  /* PREDICATES */
  /* MODIFIERS  */

private:
  /* PRIVATE ATTRIBUTES */

};

#endif /* __ACLASS_H__ */

