#ifndef __HISTOGRAM_SPECIAL1_FUNCTOR__
#define __HISTOGRAM_SPECIAL1_FUNCTOR__

#include <HistogramStandardFunctor.h>

class HistogramLogSpecial1Functor : public HistogramStandardFunctor {

 public:

  HistogramLogSpecial1Functor() : min(0.0), step(1.0) { }
  
  HistogramLogSpecial1Functor(double _min, double _step) : min(_min), step(_step)
    { }

  /** nonlinear mapping of sequence similarity to histogram bins. Sequence similarity is on scale from 0 to 10 instead of 0 to 1 or 0 to 100 */
  virtual int operator() (double x) const {
    if (x >= 10.0) {
      return 0;
    }
    int result = static_cast<int>(5.0 + 2.0 * log(10.0 - x));
    if ((x < 10) && (result < 0)) {
      result = 0;
    }
    return result;
  }

 private:

  double min;
  double step;

};

#endif
