// --*- C++ -*------x---------------------------------------------------------
// $Id:
//
// Class:           IntervallInt
// 
// Base class:      -
//
// Derived classes: - 
//
// Author:          Eckart Bindewald
//
// Description:     Implements concepts of intervall.
//                  Upper and lower bounds are integers.
// 
// Reviewed by:     -
// -----------------x-------------------x-------------------x-----------------

#ifndef __INTERVALL_INT_H__
#define __INTERVALL_INT_H__

// Includes

#include <iostream>

#include <debug.h>
#include <vectornumerics.h>

using namespace std;

/** Intervall class, stores upper and lower limits (both are inclusive)
    @author Eckart Bindewald
    @see    -
    @review - */
class IntervallInt {
public:

  typedef int index_type;
  typedef Vec<int> container_type;

  IntervallInt() : lower(0), upper(0) { }

  IntervallInt(int _lower, int _upper) : lower(_lower), 
					 upper(_upper) { }

  IntervallInt(const IntervallInt& orig) { copy(orig); }

  virtual ~IntervallInt() { }

  /* OPERATORS */

  /** Assigment operator. */
  IntervallInt& operator = (const IntervallInt& orig) {
    if (&orig != this) {
      copy(orig);
    }
    return *this;
  } 

  friend ostream& operator << (ostream& os, const IntervallInt& rval);

  /*
  friend ostream& operator << (ostream& os, const Edge& rval);

  friend istream& operator >> (istream& is, Edge& rval);
  */

  /* PREDICATES */

  /** returns all containing indices. Careful, this array can be large. */
  container_type getIndices() const {
    container_type indices(getLength());
    for (container_type::size_type i = 0; i < indices.size(); ++i) {
      indices[i] = i + lower;
    }
    return indices;
  }

  index_type getLength() const { return getUpper() - getLower() + 1; }

  index_type getLower() const { return lower; }

  index_type getUpper() const { return upper; }

  double getMiddle() const { return 0.5 * (getLower() + getUpper()); }

  /** returns true if intervalls are overlapping */
  bool isOverlapping(const IntervallInt& other) const {
    if ((getUpper() < other.getLower())
	|| (other.getUpper() < getLower())) {
      return false;
    }
    return true;
  }

  /** precondition: must be overlapping in the first place! */
  void consolidate(const IntervallInt& other) {
    PRECOND(isOverlapping(other));
    if (other.getLower() < lower) {
      lower = other.getLower();
    }
    if (other.getUpper() > upper) {
      upper = other.getUpper();
    }
  }

  /* MODIFIERS */

  void setLower(index_type n) { lower = n; }

  void setUpper(index_type m) { upper = m; }

protected:
  /* OPERATORS  */

  /* PREDICATES */

  /* MODIFIERS  */

  void copy(const IntervallInt& other) { 
    lower = other.lower;
    upper = other.upper;
  }

private:

  /* OPERATORS  */

  /* PREDICATES */

  /* MODIFIERS  */

private:

  /* PRIVATE ATTRIBUTES */

  index_type lower;
  
  index_type upper;

};


inline
bool operator < (const IntervallInt& intervallA, 
		 const IntervallInt& intervallB)
{
  // return (intervallA.getMiddle() < intervallB.getMiddle());
  return (intervallA.getLower() < intervallB.getLower());
}

inline
bool operator == (const IntervallInt& intervallA, 
		 const IntervallInt& intervallB)
{
  return (intervallA.getLower() == intervallB.getLower())
    && (intervallA.getUpper() == intervallB.getUpper());
}

inline
ostream& operator << (ostream& os, const IntervallInt& rval)
{
  os << rval.getLower() << " - " << rval.getUpper() << endl;
  return os;
}


/* TODO !
inline
IntervallInt intersection(const IntervallInt& intervallA, 
			  const IntervallInt& intervallB)
{
  IntervallInt result(intervallA.getLower(), intervallA.getLower());
  if (!intervallIsOverlapping(intervallB)) {
    return result; // return empty intervall
  }
  // todo
}
*/

#endif /* __INTERVALL_INT_H__ */

