#ifndef __MATRIX_TOOLS_H__
#define __MATRIX_TOOLS_H__

#include <iostream>
#include <Vec.h>
#include <debug.h>

using namespace std;

class MatrixTools {

 public:

  typedef unsigned int size_type;
  typedef double matrix_element_type;
  typedef Vec<Vec<matrix_element_type> > matrix_type;
  typedef Vec<matrix_element_type> matrix_row_type;

  /** reads matrix in format that is also used by program "R" */
  static matrix_type readPlainMatrix(istream& is) {
    matrix_type result;
    while (is) {
      string line = getLine(is);
      Vec<string> words = getTokens(line);
      if (words.size() > 0) {
	matrix_row_type row(words.size());
	for (unsigned int i = 0; i < words.size(); ++i) {
	  row[i] = stod(words[i]);
	}
	result.push_back(row);
      }
    }
    return result;
  }

  static size_type countThresholdElements(const matrix_type& matrix, matrix_element_type thresh) {
    size_type counter = 0;
    for (size_type i = 0; i < matrix.size(); ++i) {
      for (size_type j = 0; j < matrix[0].size(); ++j) {
	if (matrix[i][j] >= thresh) {
	  ++counter;
	}
      }
    }
    return counter;
  }

  static size_type countThresholdElements(const matrix_type& matrix, matrix_element_type thresh,
					  size_type row) {
    size_type counter = 0;
    for (size_type i = 0; i < matrix[row].size(); ++i) {
      if (matrix[row][i] >= thresh) {
	++counter;
      }
    }
    return counter;
  }

};

#endif
