// --*- C++ -*------x---------------------------------------------------------
// $Id: RankedSolution5.cc,v 1.1.1.1 2006/07/03 14:43:20 bindewae Exp $
//
// Class:           RankedSolution5
// 
// Base class:      -
//
// Derived classes: - 
//
// Author:          Eckart Bindewald
//
// Project name:    -
//
// Date:            $Date: 2006/07/03 14:43:20 $
//
// Description:     Implements a ranked docking solutions
// -----------------x-------------------x-------------------x-----------------

#include <RankedSolution5.h>

// ---------------------------------------------------------------------------
//                                   RankedSolution5
// -----------------x-------------------x-------------------x-----------------

/* CONSTRUCTORS */
template<class T, class S>
RankedSolution5::RankedSolution5() : first(0.0)
{
}

templaet
RankedSolution5::RankedSolution5(const RankedSolution5& other) 
{
  copy(other);
}


/* OPERATORS */

/** Assigment operator. */
RankedSolution5& 
RankedSolution5::operator = (const RankedSolution5& orig)
{
  if (&orig != this) {
    copy(orig);
  }
  return *this;
}

/** comparison operator. */
bool
operator < (const RankedSolution5& lval,
	    const RankedSolution5& rval)
{
  return lval.first < rval.first;
}

/** comparison operator. */
<template 
bool
operator < (double lval,
	    const RankedSolution5& rval)
{
  return lval < rval.first;
}

/** comparison operator. */
<template class T, class S>
bool
operator < (const RankedSolution5<T,S>& lval,
	    double rval)
{
  return lval.first < rval;
}

/* PREDICATES */



/* MODIFIERS */


template<class T>
void
RankedSolution5::copy(const RankedSolution5<T>& other)
{
  first = other.first;
  second = other.second;
}

