#ifndef __MULTI_VAL_ARRAY_TEST__
#define __MULTI_VAL_ARRAY_TEST__

#include <MultiValArray.h>
#include <MultiValArrayTools.h>

class MultiValArrayTest {

 public:

  typedef MultiValArray::size_type size_type;

  static void testAll() {
    testInit();
    testGetSet2D();
    testGetSet3D();
  }

  static void testInit() {
    Vec<size_type> dimensions(2);
    dimensions[0] = 3;
    dimensions[1] = 4;
    MultiValArray array(dimensions);
  }


  static void testGetSet2D() {
    string methodName = "testGetSet2D";
    cout << "Starting " << methodName << endl;
    Vec<size_type> dimensions(2);
    dimensions[0] = 3;
    dimensions[1] = 4;
    MultiValArray array(dimensions);
    cout << "Initialized " << dimensions << " array with multipliers " << array.getMultipliers() << endl;
    MultiValArray::index_array indices(2);
    double count = 0.0;
    MultiValArrayTools::write2D(cout, array);
    cout << endl;
    for (size_type i = 0; i < dimensions[0]; ++i) {
      for (size_type j = 0; j < dimensions[1]; ++j) {
        indices[0] = i;
        indices[1] = j;
	++count;
	cout << i << " " << j << " " << count << " " << array.get(indices) << " " ;
	ASSERT(array.get(indices) == 0.0);
	array.set(indices, count);
	cout << " " << array.get(indices) << endl;
	ASSERT(array.get(indices) == count);
      }

    }
    cout << endl;
    MultiValArrayTools::write2D(cout, array);
    cout << "Finished " << methodName << endl;
  }

  static void testGetSet3D() {
    string methodName = "testGetSet3D";
    cout << "Starting " << methodName << endl;
    Vec<size_type> dimensions(3);
    dimensions[0] = 3;
    dimensions[1] = 4;
    dimensions[2] = 5;
    MultiValArray array(dimensions);
    MultiValArray::index_array indices(3);
    double count = 0.0;
    MultiValArrayTools::write3D(cout, array);
    for (size_type i = 0; i < dimensions[0]; ++i) {
      for (size_type j = 0; j < dimensions[1]; ++j) {
	for (size_type k = 0; k < dimensions[2]; ++k) {
	  indices[0] = i;
	  indices[1] = j;
	  indices[2] = k;
	  ++count;
	  cout << i << " " << j << " " << count << " " << array.get(indices) << " " ;
	  ASSERT(array.get(indices) == 0.0);
	  array.set(indices, count);
	  cout << " " << array.get(indices) << endl;
	  ASSERT(array.get(indices) == count);
	}
      }
    }
    MultiValArrayTools::write3D(cout, array);
    cout << "Finished " << methodName << endl;
  }




};

#endif
