#include <math.h>
#include <Random.h>

Random* Random::msInstance = 0;


/** from numerical recipes 
    return normally distributed random number */
double
Random::getExponential() {
  double x = getRandf();
  if (x <= 0.0) {
    x = 1.0; // wrap around
  }
  return -log(x);
}

/** from numerical recipes 
    return normally distributed random number */
double
Random::getGaussian() 
{
  double fac,rsq,v1,v2;
  if  (iset == 0) {
    do {
      v1=2.0*getRandf()-1.0;
      v2=2.0*getRandf()-1.0;
      rsq=v1*v1+v2*v2;
    } while (rsq >= 1.0 || rsq == 0.0);
    fac=sqrt(-2.0*log(rsq)/rsq);
    gset=v1*fac;
    iset=1;
    return v2*fac;
  } 
  iset=0;
  return gset;
}
