#include <iostream>
#include <Timer.h>

int 
Timer::seconds() const
{
  if (stopTime != 0) {
    return stopTime-startTime;
  } 
  else {
    time_t now = time(0);
    return now-startTime;
  }
}

int 
Timer::minutes() const
{
  if (stopTime != 0) {
    return (stopTime-startTime)/60;
  } 
  else {
    time_t now = time(0);
    return (now-startTime)/60;
  }
}

int 
Timer::hours() const
{
  if (stopTime != 0) {
      return (stopTime-startTime)/3600;
  } 
  else {
    time_t now = time(0);
    return (now-startTime)/3600;
  }
}

ostream& 
operator << (ostream& os, const Timer& time) 
{
  time_t delta = time.stopTime - time.startTime;
  int hours   = delta / 3600;
  int minutes = (delta-hours*3600) / 60;
  int seconds = (delta-hours*3600-minutes*60);
  return os << hours << ":" << minutes << ":" << seconds
	    << " total seconds: " << delta;
}

bool 
operator == (const Timer& left, const Timer& right)
{
  return ( (left.startTime == right.startTime)
	  &&(left.stopTime == right.stopTime) );
}


