# Converts nucleoitde to complement : A->U (or T in dna mode), G->C etc. 
# strict: "error"|"self"|or replacement char like "X", or "N" or "-" or "."
nucleotide.complement <- function(c, dna=FALSE, strict="error") {
	stopifnot(nchar(c) == 1)
	result <- ""
	if (is.gap(c)) {
		result <- c
	} else {
	c1 <- toupper(c)
	result <- c1
	if (c1 == "A") {
		if (dna) {
			result <- "T"
		} else {
			result <- "U"
		}
	} else if (c1 == "C") {
		result <- "G"
	} else if (c1 == "G") {
		result <- "C"
	} else if (c1 == "T") {
		result = "A"
	} else if (c1 == "U") {
		result = "A"
	} else if (strict == "error") {
		stop("Could not find letter:", c, "\n")
	} else if (strict != "self") {
		result <- strict # typical example: "-", ".", "N", "X"
	}
	}
	stopifnot(nchar(result) == 1)
	result
}

test.nucleotide.complement <- function() {
  checkEquals(nucleotide.complement("A", dna=FALSE), "U")
  checkEquals(nucleotide.complement("C", dna=FALSE), "G")
  checkEquals(nucleotide.complement("G", dna=FALSE), "C")
  checkEquals(nucleotide.complement("U", dna=FALSE), "A")
  checkEquals(nucleotide.complement("u", dna=FALSE), "A")
  checkEquals(nucleotide.complement("N", dna=FALSE, strict="self"), "N")
  checkEquals(nucleotide.complement("N", dna=TRUE, strict="self"), "N")
  checkEquals(nucleotide.complement("a", dna=TRUE), "T")
  checkEquals(nucleotide.complement("C", dna=TRUE), "G")
  checkEquals(nucleotide.complement("G", dna=TRUE), "C")
  checkEquals(nucleotide.complement("T", dna=TRUE), "A")
}
