readMultiFASTA.old <- function(file, sep="", verbose=TRUE, firstBlock=NULL, lastBlock=NULL, origIds=FALSE) {
  stop("Deprecated method readMultiFASTA.old called.\n")
  lines <- readLines(file)
  if (verbose) {
   cat("Read", length(lines), "lines.\n")
  }
  result <- list()
  seps <- c() # stores all indices of lines that act as seperator lines
  for (i in 1:length(lines)) {
   if (lines[i] == sep) {
    seps[length(seps) + 1] <- i
   } 
  }
  if ( (length(seps) == 0) || (seps[length(seps)] != length(lines) ) ) {
   seps[length(seps) + 1] <- length(lines) + 1 # EOF is another separator
  }
  if (verbose) {
   cat("Found", length(seps) , "separators.\n") 
  }
#  print(seps) 
  tfile <- tempfile()
  startBlock = 1
  if (!is.null(firstBlock)) {
   startBlock = firstBlock
  }
  stopBlock = length(seps)
  if (!is.null(lastBlock)) {
   stopBlock = lastBlock
  }
  for (i in startBlock:stopBlock) {
   firstLine = 1
   if (i > 1) {
    firstLine = seps[i-1] + 1 # one line after last seperator
   }
   lastLine <- seps[i] - 1
   stopifnot(firstLine >= 1)
   stopifnot(firstLine <= lastLine)
   stopifnot(lastLine <= length(lines))
#   cat("Using ", i, "first and last line:", firstLine, lastLine, "\n")
#   stopifnot(lastLine - firstLine <= 50)
   appMode = FALSE
   for (j in firstLine:lastLine) {
     cat(lines[j], "\n", sep="", file=tfile, append=appMode)
     appMode = TRUE
   }
   if (origIds) {
    result[[i]] <- readFASTA(tfile, strip.descs=TRUE)
   } else {
    result[[length(result) + 1]] <- readFASTA(tfile, strip.descs=TRUE)
   }
   if(verbose) {
    cat("Read alignment", i, "with", length( result[[length(result)]] ), "sequences.\n") 
   }
  }
  file.remove(tfile)
  result
}

readMultiFASTABlockfromConnection <- function(con, sep="", delim=">", verbose=0) {
 methodName <- "readMultiFASTABlockfromConnection"
 if (verbose > 0) {
  cat("Starting", methodName, "\n")
 }
 result <- list()
 while (TRUE) {
   line <- readLines(con, ok=TRUE, n=1)
   if (length(line) == 0) {
     break
   }
   if (line == sep) {
    break
   }
#   cat("Read line:\n")
#   print(line)
   if (substr(line, 1,1) == delim) {
     block <- list()
     block$desc <- substr(line,2, nchar(line))
     result[[length(result) + 1]] <- block
   } else {
      line <- gsub("\\s", "", line) # remove white space from line
      result[[length(result)]]$seq <- paste(result[[length(result)]]$seq, line, sep="")
   }
 }
 if (verbose > 0) {
  cat("Finished", methodName, "\n")
 }
 result  
}

test.readLines <- function(filename) {
 stopifnot(file.exists(filename))
 con <- file(filename, "r", blocking=FALSE)
 while (TRUE) {
   line <- readLines(con, ok=TRUE, n=1)
   if (length(line) == 0) {
     break
   }
   cat("Reading line:\n")
   print(line)
 }
 close(con)
}

# less memory intensive implementation of readMultiFASTA
readMultiFASTAConnection <- function(filename, sep="", firstBlock=1, lastBlock=NULL, origIds=FALSE, verbose=0) {
  methodName <- "readMultiFASTAConnection"
  if (verbose > 0) {
   cat("Starting", methodName, "\n")
  }   
  con <- file(filename, "r") # open connection
  linesSkip <- 0
  if (verbose > 0) {
   cat("Started skipping...\n")
  }
  if (is.null(firstBlock)) {
     firstBlock = 1
  }
  stopifnot(length(firstBlock) == 1)
  if (firstBlock > 1) {
   sepCount <- 0
   while(TRUE) {
     line <- readLines(con, n=1)
     if (length(line) == 0) {
      # end of file reached, should not happen!
       stop(paste("Premature end of file reached in", methodName, "\n"))
     }
     linesSkip <- linesSkip + 1
     if (line == sep) {
       sepCount <- sepCount + 1
       if ((sepCount + 1) == firstBlock) {
          break # found beginning!
       }
     }
   }
  }

  if (verbose > 0) {
   cat("Skipped", linesSkip, "lines.\n")
  }

  lines <- c() # readLines(file)

  result <- list()
  nBlocks <- NULL
  if ((!is.null(firstBlock)) && (!is.null(lastBlock))) {
   nBlocks <- lastBlock - firstBlock + 1
  }
  while (TRUE) {
   if (verbose > 2) {
    cat("Launching readMultiFASTABlockfromConnection\n")
   }
   block <- readMultiFASTABlockfromConnection(con, sep="", verbose=(verbose-1))
   if (verbose > 2) {
    cat("Finished readMultiFASTABlockfromConnection\n")
   }
   if (is.list(block) && (length(block) > 0)) {
     if (is.null(lastBlock) ) {
      result[[length(result) + 1]] <- block
     } else if (length(result) < nBlocks) {
      result[[length(result) + 1]] <- block
     } else {
      break
     }
   } else {
    break
   }
  }

  close(con)

  if (verbose > 0) {
   cat("Finished", methodName, "\n")
  }   
  result
}


test.readMultiFASTA <- function(file=system.file("data/dm3_A27_ds2_exons_top3.fasta",package="rnafolding"), firstBlock=NULL, lastBlock=NULL) {
 stopifnot(file.exists(file))
 m <- readMultiFASTA(file=file, firstBlock=firstBlock,lastBlock=lastBlock)
 cat("Read", length(m) , "alignments.\n")
 m
}

test.readMultiFASTA.2 <- function(file=system.file("data/tRNA_ecoli_anticodon.fa", package="rnafolding"), firstBlock=NULL, lastBlock=NULL) {
 stopifnot(file.exists(file))
 m <- readMultiFASTA(file=file, firstBlock=firstBlock,lastBlock=lastBlock)
 cat("Read", length(m) , "alignments.\n")
 m
}

test.readMultiFASTAConnection <- function(file=system.file("data/dm3_A27_ds2_exons_top3.fasta",package="rnafolding"), firstBlock=1, lastBlock=3, verbose=3) {
 stopifnot(file.exists(file))
 m <- readMultiFASTAConnection(file=file, firstBlock=firstBlock,lastBlock=lastBlock, verbose=verbose)
 cat("Read", length(m) , "alignments.\n")
 checkEquals(length(m), (lastBlock-firstBlock + 1))
 m
}

test.readMultiFASTAConnection.2 <- function(file=system.file("data/tRNA_ecoli_anticodon.fa", package="rnafolding"), firstBlock=1, lastBlock=1, verbose=3) {
 stopifnot(file.exists(file))
 m <- readMultiFASTAConnection(file=file, firstBlock=firstBlock,lastBlock=lastBlock, verbose=verbose)
 cat("Read", length(m) , "alignments.\n")
 checkEquals(length(m), (lastBlock-firstBlock + 1))
 m
}


# less memory intensive implementation of readMultiFASTA
readMultiFASTA <- function(filename, sep="", firstBlock=1, lastBlock=NULL, origIds=FALSE, verbose=0) {
 readMultiFASTAConnection(filename=filename, sep=sep, firstBlock=firstBlock, lastBlock=lastBlock)
}
