# reads in a matrix (typically generated by KNetFold) and generates PDF 
# Eckart Bindewald 2006

# parse command line:
args <- commandArgs()
numArgs <- length(args)
# last element is length
len <- as.integer(args[numArgs])
prVals <- pretty(1:len)
prVals <- prVals[2:length(prVals)] # remove first element
prVals <- c(1, prVals) # add one
prPos <- (prVals-1)/(len-1) # length is mapped to one, start counting from one instead of zero
dm <- as.matrix(read.table("mx3.dat"))
# postscript(file="mx3.ps")
# image(dm, axes=T, breaks=c(0.0, 0.05, 0.5, 1.0), col=gray(c(1.0, 0.7, 0.0))
pdf(file="mx3.pdf")
par(pty="s") # square region
# image(dm, axes=F, breaks=c(0.0, 0.05, 0.5, 1.0), col=gray(c(1.0, 0.7, 0.0)))
image(dm, axes=F, breaks=c(0.0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0), col=gray(c(1.0, 0.8, 0.7, 0.6, 0.5, 0.4, 0.3, 0.2, 0.1, 0.0)))
# axis(2, at = c(0, 1), labels = c("1", len))
title("Predicted contact matrix (KNetFold v1.4.4)", font.main=4);
axis(1, at = prPos, labels = prVals)
axis(2, at = prPos, labels = prVals)
# axis(3, at = prPos, labels = prVals)
axis(4, at = prPos, labels = prVals)
