/*
 * Decompiled with CFR 0.152.
 */
package SecondaryStructureDesign;

import SecondaryStructureDesign.ColorGradientMixer;
import SecondaryStructureDesign.SequenceEditorWizard;
import commandtools.CommandApplication;
import generaltools.Randomizer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Random;
import javax.swing.AbstractListModel;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.Scrollable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import rnasecondary.ImprovedSecondaryStructureParser;
import rnasecondary.Interaction;
import rnasecondary.InteractionSet;
import rnasecondary.MutableSecondaryStructure;
import rnasecondary.RnaInteractionType;
import rnasecondary.SecondaryStructureScriptFormatWriter;
import rnasecondary.SimpleInteraction;
import rnasecondary.SimpleInteractionSet;
import sequence.DnaTools;
import sequence.DuplicateNameException;
import sequence.MutableSequence;
import sequence.Residue;
import sequence.Sequence;
import sequence.SimpleMutableSequence;
import sequence.UnevenAlignment;
import sequence.UnknownSymbolException;

public class SecondaryStructureEditorPanel
extends JPanel {
    public static final String NEWLINE = System.getProperty("line.separator");
    private boolean sameSequence = false;
    private MutableSecondaryStructure structure;
    private Sequence sequence1;
    private Sequence sequence2;
    private ColorGradientMixer mixer;
    private InteractionSet modifiedInteractions = new SimpleInteractionSet();
    private InteractionSet existingInteractions;
    private InteractionSet conflictingInteractions = new SimpleInteractionSet();
    private boolean interactionsModified = false;
    private final HashMap<Integer, Color> sequenceColorMap = new HashMap();
    private JList sequenceSelector1;
    private JList sequenceSelector2;
    private JScrollPane scrollPane;
    private StemCreationDisplay display = null;
    private JButton closeButton;
    private JButton commitButton;
    private JButton clearButton;
    private JButton clearAllButton;
    private JButton newSequenceButton;
    private JButton editSequenceButton;
    private JButton importButton;
    private JButton exportButton;
    private JComboBox sequenceEditorSelector = null;
    private JPanel pane;
    private Window w;
    private UnevenAlignment sequences;
    private CommandApplication application;

    public SecondaryStructureEditorPanel(MutableSecondaryStructure structure, Window w, CommandApplication application) {
        this.application = application;
        this.structure = structure;
        this.w = w;
        this.sequences = structure.getSequences();
        this.existingInteractions = structure.getInteractions();
        this.createAndShowGUI();
    }

    public SecondaryStructureEditorPanel(MutableSecondaryStructure structure, Window w) {
        this(structure, w, null);
    }

    public MutableSecondaryStructure getSecondaryStructure() {
        return this.structure;
    }

    private void createAndShowGUI() {
        System.out.println("Creating GUI");
        this.setLayout(new BorderLayout());
        this.importButton = new JButton("Import");
        this.importButton.setToolTipText("Import an existing secondary structure for modification");
        this.importButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File selectedFile;
                JFileChooser chooser = new JFileChooser();
                chooser.setApproveButtonText("Import");
                chooser.setFileSelectionMode(2);
                File wd = new File("./");
                chooser.setCurrentDirectory(wd);
                int returnVal = chooser.showOpenDialog(SecondaryStructureEditorPanel.this);
                if (returnVal == 0 && (selectedFile = chooser.getSelectedFile()).isFile()) {
                    ImprovedSecondaryStructureParser parser = new ImprovedSecondaryStructureParser();
                    MutableSecondaryStructure ss = null;
                    try {
                        ss = parser.parse(selectedFile.getAbsolutePath());
                    }
                    catch (IOException ioe) {
                        System.out.println("IOException encountered in " + selectedFile.getAbsolutePath() + " : " + ioe.getMessage());
                    }
                    catch (ParseException pe) {
                        System.out.println("Parsing exception encountered in " + selectedFile.getAbsolutePath() + " : " + pe.getMessage());
                    }
                    if (ss != null) {
                        int i;
                        System.out.println("Successfully parsed input");
                        InteractionSet in = ss.getInteractions();
                        UnevenAlignment aln = ss.getSequences();
                        for (i = 0; i < aln.getSequenceCount(); ++i) {
                            try {
                                SecondaryStructureEditorPanel.this.structure.addSequence(aln.getSequence(i));
                                continue;
                            }
                            catch (DuplicateNameException ex) {
                                int j = 0;
                                while (j < in.size()) {
                                    Interaction interaction = in.get(j);
                                    if (interaction.getSequence1().equals(aln.getSequence(i)) || interaction.getSequence2().equals(aln.getSequence(i))) {
                                        in.remove(interaction);
                                        continue;
                                    }
                                    ++j;
                                }
                            }
                        }
                        for (i = SecondaryStructureEditorPanel.this.sequences.getSequenceCount() - 1; i > SecondaryStructureEditorPanel.this.sequences.getSequenceCount() - aln.getSequenceCount() - 1; --i) {
                            SecondaryStructureEditorPanel.this.sequenceColorMap.put(i, SecondaryStructureEditorPanel.this.mixer.nextColor());
                        }
                        for (i = 0; i < in.size(); ++i) {
                            SecondaryStructureEditorPanel.this.structure.addInteraction(in.get(i));
                        }
                        SecondaryStructureEditorPanel.this.sequenceSelector1.setModel(new SequenceListModel());
                        SecondaryStructureEditorPanel.this.sequenceSelector2.setModel(new SequenceListModel());
                        SecondaryStructureEditorPanel.this.scrollPane.getViewport().revalidate();
                        SecondaryStructureEditorPanel.this.repaint();
                    }
                }
            }
        });
        this.exportButton = new JButton("Export");
        this.exportButton.setToolTipText("Export secondary structure");
        this.exportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = new JFileChooser();
                chooser.setApproveButtonText("Save");
                chooser.setFileSelectionMode(2);
                String cwdName = "./";
                File cwd = new File(cwdName);
                chooser.setCurrentDirectory(cwd);
                int returnVal = chooser.showSaveDialog(SecondaryStructureEditorPanel.this);
                if (returnVal == 0) {
                    String fileName = chooser.getCurrentDirectory() + "/" + chooser.getSelectedFile().getName();
                    FileOutputStream fis = null;
                    try {
                        fis = new FileOutputStream(fileName);
                        PrintWriter pwtr = new PrintWriter(fis);
                        SecondaryStructureScriptFormatWriter writer = new SecondaryStructureScriptFormatWriter();
                        pwtr.println(writer.writeString(SecondaryStructureEditorPanel.this.structure));
                        pwtr.close();
                    }
                    catch (IOException exc) {
                        JOptionPane.showMessageDialog(null, "Could not open file: " + exc.getMessage());
                    }
                }
            }
        });
        this.sequenceSelector1 = new JList(new SequenceListModel());
        this.sequenceSelector2 = new JList(new SequenceListModel());
        this.sequenceSelector1.setSelectionMode(0);
        this.sequenceSelector2.setSelectionMode(0);
        Dimension listDimension = new Dimension(150, 200);
        this.sequenceSelector1.setPreferredSize(listDimension);
        this.sequenceSelector2.setPreferredSize(listDimension);
        JPanel selectorPanel = new JPanel();
        selectorPanel.setLayout(new BoxLayout(selectorPanel, 1));
        JPanel importExport = new JPanel();
        importExport.setLayout(new BoxLayout(importExport, 0));
        importExport.add(this.importButton);
        importExport.add(Box.createHorizontalStrut(15));
        importExport.add(this.exportButton);
        importExport.setMaximumSize(new Dimension(importExport.getMaximumSize().width, importExport.getPreferredSize().height));
        selectorPanel.add(importExport);
        selectorPanel.add(Box.createVerticalStrut(10));
        selectorPanel.add(new JLabel("Sequence 1"));
        selectorPanel.add(new JScrollPane(this.sequenceSelector1));
        selectorPanel.add(Box.createVerticalStrut(15));
        selectorPanel.add(new JLabel("Sequence 2"));
        selectorPanel.add(new JScrollPane(this.sequenceSelector2));
        selectorPanel.setPreferredSize(new Dimension(200, 450));
        JPanel controlPanel = new JPanel();
        controlPanel.setLayout(new BoxLayout(controlPanel, 0));
        this.commitButton = new JButton("Commit");
        this.commitButton.setToolTipText("Commit new interactions");
        this.commitButton.setEnabled(false);
        this.commitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SecondaryStructureEditorPanel.this.saveInteractions();
            }
        });
        this.clearButton = new JButton("Clear");
        this.clearButton.setToolTipText("Clear new interactions");
        this.clearButton.setEnabled(false);
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SecondaryStructureEditorPanel.this.discardModifiedInteractions()) {
                    SecondaryStructureEditorPanel.this.updateInteractions();
                    SecondaryStructureEditorPanel.this.display.repaint();
                }
            }
        });
        this.clearAllButton = new JButton("Clear All");
        this.clearAllButton.setToolTipText("Clear all interactions");
        this.clearAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SecondaryStructureEditorPanel.this.existingInteractions.clear();
                SecondaryStructureEditorPanel.this.modifiedInteractions.clear();
                SecondaryStructureEditorPanel.this.conflictingInteractions.clear();
                SecondaryStructureEditorPanel.this.display.repaint();
            }
        });
        this.closeButton = new JButton("Close");
        this.closeButton.setToolTipText("Close wizard");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SecondaryStructureEditorPanel.this.discardModifiedInteractions()) {
                    SecondaryStructureEditorPanel.this.structure.setSequences(SecondaryStructureEditorPanel.this.sequences);
                    SecondaryStructureEditorPanel.this.structure.setInteractions(SecondaryStructureEditorPanel.this.existingInteractions);
                    System.out.println("Disposing window");
                    SecondaryStructureEditorPanel.this.w.setVisible(false);
                    SecondaryStructureEditorPanel.this.w.dispose();
                }
            }
        });
        controlPanel.add(this.commitButton);
        controlPanel.add(Box.createHorizontalStrut(15));
        controlPanel.add(this.clearButton);
        controlPanel.add(Box.createHorizontalStrut(15));
        controlPanel.add(this.clearAllButton);
        controlPanel.add(Box.createHorizontalGlue());
        controlPanel.add(this.closeButton);
        controlPanel.setMaximumSize(new Dimension(controlPanel.getMaximumSize().width, controlPanel.getPreferredSize().height));
        JPanel sequenceEditorPanel = new JPanel();
        sequenceEditorPanel.setLayout(new BoxLayout(sequenceEditorPanel, 0));
        this.newSequenceButton = new JButton("Add Sequence");
        this.newSequenceButton.setToolTipText("Create a new sequence");
        this.newSequenceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SecondaryStructureEditorPanel.this.isInteractionsModified()) {
                    int result = JOptionPane.showConfirmDialog(SecondaryStructureEditorPanel.this.display, "Interactions have been modified. Inorder to edit sequence, changes must be saved. Save changes?");
                    if (result != 0) {
                        return;
                    }
                    SecondaryStructureEditorPanel.this.saveInteractions();
                }
                boolean valid = false;
                Frame f = null;
                final JDialog dlg = new JDialog(f, "Create new Sequence", true);
                final JTextField sizeField = new JTextField(5);
                final JRadioButton rnaStrand = new JRadioButton("RNA Sequence");
                JRadioButton dnaStrand = new JRadioButton("DNA Sequence");
                final JTextField nameField = new JTextField(10);
                JPanel main = new JPanel();
                main.setLayout(new BoxLayout(main, 1));
                JLabel nameLabel = new JLabel("Enter Sequence Name");
                JPanel panel = new JPanel();
                panel.add(nameLabel);
                panel.add(Box.createHorizontalStrut(1));
                panel.add(nameField);
                main.add(panel);
                JLabel seqSizeLabel = new JLabel("Enter Sequence Size");
                panel = new JPanel();
                panel.setLayout(new BoxLayout(panel, 0));
                panel.add(seqSizeLabel);
                panel.add(Box.createHorizontalStrut(10));
                panel.add(sizeField);
                main.add(panel);
                final ButtonGroup group = new ButtonGroup();
                group.add(rnaStrand);
                group.add(dnaStrand);
                group.setSelected(rnaStrand.getModel(), true);
                main.add(Box.createVerticalStrut(15));
                main.add(rnaStrand);
                main.add(dnaStrand);
                main.add(Box.createVerticalStrut(15));
                JButton doneButton = new JButton("Done");
                doneButton.addActionListener(new ActionListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void actionPerformed(ActionEvent e) {
                        String size = sizeField.getText();
                        String name = nameField.getText();
                        boolean rna = group.isSelected(rnaStrand.getModel());
                        int s = 0;
                        try {
                            s = Integer.parseInt(size);
                            if (s < 1) {
                                throw new NumberFormatException();
                            }
                            String sequence = "";
                            for (int i = 0; i < s; ++i) {
                                sequence = sequence + "N";
                            }
                            SimpleMutableSequence seq = new SimpleMutableSequence(sequence, name, rna ? DnaTools.AMBIGUOUS_RNA_ALPHABET : DnaTools.AMBIGUOUS_DNA_ALPHABET);
                            SecondaryStructureEditorPanel.this.sequences.addSequence(seq);
                            SecondaryStructureEditorPanel.this.sequenceColorMap.put(SecondaryStructureEditorPanel.this.sequences.getSequenceCount() - 1, SecondaryStructureEditorPanel.this.mixer.nextColor());
                            SequenceEditorWizard wizard = new SequenceEditorWizard(seq);
                            wizard.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    if (e.getID() == 1) {
                                        System.out.println("Window closing");
                                        System.out.println("model size: " + SecondaryStructureEditorPanel.this.sequenceSelector1.getModel().getSize());
                                        SecondaryStructureEditorPanel.this.sequenceSelector1.setModel(new SequenceListModel());
                                        SecondaryStructureEditorPanel.this.sequenceSelector2.setModel(new SequenceListModel());
                                        SecondaryStructureEditorPanel.this.sequenceEditorSelector.setModel(new SequenceSelectorComboBoxModel());
                                        SecondaryStructureEditorPanel.this.scrollPane.getViewport().revalidate();
                                        SecondaryStructureEditorPanel.this.scrollPane.revalidate();
                                        SecondaryStructureEditorPanel.this.repaint();
                                    }
                                }
                            });
                            System.out.println("getting ready to launch the sequence editor wizard");
                            wizard.launchWizard(null, SecondaryStructureEditorPanel.this);
                        }
                        catch (NumberFormatException e1) {
                            JOptionPane.showMessageDialog(SecondaryStructureEditorPanel.this, "Invalid sequence size");
                        }
                        catch (UnknownSymbolException e2) {
                            JOptionPane.showMessageDialog(SecondaryStructureEditorPanel.this, "Unknown symbol exception");
                        }
                        catch (DuplicateNameException e3) {
                            JOptionPane.showMessageDialog(SecondaryStructureEditorPanel.this, "Sequence already exists with that name");
                        }
                        catch (Exception e4) {
                            e4.printStackTrace();
                        }
                        finally {
                            dlg.setVisible(false);
                            dlg.dispose();
                        }
                    }
                });
                main.add(doneButton);
                dlg.setLayout(new BorderLayout());
                dlg.add(main);
                dlg.setDefaultCloseOperation(2);
                dlg.pack();
                dlg.setVisible(true);
            }
        });
        sequenceEditorPanel.add(this.newSequenceButton);
        sequenceEditorPanel.add(Box.createHorizontalStrut(15));
        this.sequenceEditorSelector = new JComboBox(new SequenceSelectorComboBoxModel());
        this.sequenceEditorSelector.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (SecondaryStructureEditorPanel.this.sequenceEditorSelector.getSelectedIndex() > -1 && SecondaryStructureEditorPanel.this.sequences.getSequence(SecondaryStructureEditorPanel.this.sequenceEditorSelector.getSelectedIndex()) instanceof MutableSequence) {
                    SecondaryStructureEditorPanel.this.editSequenceButton.setEnabled(true);
                } else {
                    SecondaryStructureEditorPanel.this.editSequenceButton.setEnabled(false);
                }
            }
        });
        this.editSequenceButton = new JButton("Edit Sequence");
        this.editSequenceButton.setToolTipText("Edit an existing sequence");
        this.editSequenceButton.setEnabled(false);
        this.editSequenceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SecondaryStructureEditorPanel.this.isInteractionsModified()) {
                    int result = JOptionPane.showConfirmDialog(SecondaryStructureEditorPanel.this.display, "Interactions have been modified. Inorder to edit sequence, changes must be saved. Save changes?");
                    if (result != 0) {
                        return;
                    }
                    SecondaryStructureEditorPanel.this.saveInteractions();
                }
                int selectedIndex = SecondaryStructureEditorPanel.this.sequenceEditorSelector.getSelectedIndex();
                System.out.println("Selected index is: " + selectedIndex);
                if (selectedIndex > -1) {
                    MutableSequence seq = (MutableSequence)SecondaryStructureEditorPanel.this.sequences.getSequence(SecondaryStructureEditorPanel.this.sequenceEditorSelector.getSelectedIndex());
                    SequenceEditorWizard sequenceEditor = new SequenceEditorWizard(seq, SecondaryStructureEditorPanel.this.existingInteractions);
                    sequenceEditor.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (e.getID() == 1) {
                                SecondaryStructureEditorPanel.this.scrollPane.getViewport().revalidate();
                                SecondaryStructureEditorPanel.this.scrollPane.revalidate();
                                SecondaryStructureEditorPanel.this.repaint();
                            }
                        }
                    });
                    sequenceEditor.launchWizard(null, SecondaryStructureEditorPanel.this);
                } else {
                    JOptionPane.showMessageDialog(SecondaryStructureEditorPanel.this, "Must select a sequence to edit");
                }
            }
        });
        sequenceEditorPanel.add(this.sequenceEditorSelector);
        sequenceEditorPanel.add(this.editSequenceButton);
        sequenceEditorPanel.setMaximumSize(new Dimension(sequenceEditorPanel.getMaximumSize().width, sequenceEditorPanel.getPreferredSize().height));
        this.display = new StemCreationDisplay();
        this.sequenceSelector1.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (SecondaryStructureEditorPanel.this.sequenceSelector1.getSelectedValue() != null && !SecondaryStructureEditorPanel.this.sequenceSelector1.getSelectedValue().equals(SecondaryStructureEditorPanel.this.sequence1) && SecondaryStructureEditorPanel.this.discardModifiedInteractions()) {
                    for (int i = 0; i < SecondaryStructureEditorPanel.this.sequences.getSequenceCount(); ++i) {
                        if (SecondaryStructureEditorPanel.this.sequenceSelector1.getSelectedValue().equals(SecondaryStructureEditorPanel.this.sequences.getSequence(i).getName())) {
                            SecondaryStructureEditorPanel.this.setSequence1(SecondaryStructureEditorPanel.this.sequences.getSequence(i));
                            break;
                        }
                        SecondaryStructureEditorPanel.this.sequenceSelector1.setSelectedValue(SecondaryStructureEditorPanel.this.sequence1, true);
                    }
                }
            }
        });
        this.sequenceSelector2.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (SecondaryStructureEditorPanel.this.sequenceSelector2.getSelectedValue() != null && !SecondaryStructureEditorPanel.this.sequenceSelector2.getSelectedValue().equals(SecondaryStructureEditorPanel.this.sequence2) && SecondaryStructureEditorPanel.this.discardModifiedInteractions()) {
                    for (int i = 0; i < SecondaryStructureEditorPanel.this.sequences.getSequenceCount(); ++i) {
                        if (SecondaryStructureEditorPanel.this.sequenceSelector2.getSelectedValue().equals(SecondaryStructureEditorPanel.this.sequences.getSequence(i).getName())) {
                            SecondaryStructureEditorPanel.this.setSequence2(SecondaryStructureEditorPanel.this.sequences.getSequence(i));
                            break;
                        }
                        SecondaryStructureEditorPanel.this.sequenceSelector2.setSelectedValue(SecondaryStructureEditorPanel.this.sequence2, true);
                    }
                }
            }
        });
        this.scrollPane = new JScrollPane(this.display);
        this.scrollPane.getViewport().setBackground(Color.white);
        this.scrollPane.setPreferredSize(new Dimension(500, 450));
        this.pane = new JPanel();
        this.pane.setLayout(new BoxLayout(this.pane, 1));
        this.pane.add(sequenceEditorPanel);
        this.pane.add(this.scrollPane);
        this.pane.add(controlPanel);
        JSplitPane splitPane = new JSplitPane(1, selectorPanel, this.pane);
        this.add(splitPane);
    }

    private void saveInteractions() {
        if (this.isInteractionsModified()) {
            int i;
            for (i = 0; i < this.conflictingInteractions.size(); ++i) {
                InteractionSet conflicts = this.getConflictingInteractions(this.existingInteractions, this.conflictingInteractions.get(i));
                for (int j = 0; j < conflicts.size(); ++j) {
                    this.existingInteractions.remove(conflicts.get(j));
                }
            }
            for (i = 0; i < this.modifiedInteractions.size(); ++i) {
                this.existingInteractions.add(this.modifiedInteractions.get(i));
            }
            this.updateInteractions();
            this.display.repaint();
        }
    }

    private InteractionSet getValidInteractions(InteractionSet set, InteractionSet conflicts) {
        int i;
        SimpleInteractionSet s = new SimpleInteractionSet();
        for (i = 0; i < set.size(); ++i) {
            s.add(set.get(i));
        }
        System.out.println(NEWLINE + "Getting Valid Interactions");
        System.out.println("Existing size: " + set.size());
        System.out.println("Conflict size: " + conflicts.size());
        for (i = 0; i < conflicts.size(); ++i) {
            InteractionSet c = this.getConflictingInteractions(s, conflicts.get(i));
            for (int j = 0; j < c.size(); ++j) {
                s.remove(c.get(j));
            }
        }
        System.out.println("Valid size: " + s.size());
        return s;
    }

    public boolean validateInteraction(InteractionSet s, Interaction i) {
        return this.getConflictingInteractions(s, i).size() == 0;
    }

    public InteractionSet getConflictingInteractions(InteractionSet s, Interaction i) {
        SimpleInteractionSet set = new SimpleInteractionSet();
        Residue nr1 = i.getResidue1();
        Residue nr2 = i.getResidue2();
        for (int j = 0; j < s.size(); ++j) {
            Interaction in = s.get(j);
            Residue er1 = in.getResidue1();
            Residue er2 = in.getResidue2();
            if (er1.isSameSequence(nr1) && er1.getPos() == nr1.getPos()) {
                set.add(in);
                continue;
            }
            if (er1.isSameSequence(nr2) && er1.getPos() == nr2.getPos()) {
                set.add(in);
                continue;
            }
            if (er2.isSameSequence(nr1) && er2.getPos() == nr1.getPos()) {
                set.add(in);
                continue;
            }
            if (!er2.isSameSequence(nr2) || er2.getPos() != nr2.getPos()) continue;
            set.add(in);
        }
        return set;
    }

    public void removeConflictingInteractions(InteractionSet s, Interaction i) {
        Residue nr1 = i.getResidue1();
        Residue nr2 = i.getResidue2();
        for (int j = 0; j < s.size(); ++j) {
            Interaction in = s.get(j);
            Residue er1 = in.getResidue1();
            Residue er2 = in.getResidue2();
            if (er1.isSameSequence(nr1) && er1.getPos() == nr1.getPos()) {
                s.remove(in);
                continue;
            }
            if (er1.isSameSequence(nr2) && er1.getPos() == nr2.getPos()) {
                s.remove(in);
                continue;
            }
            if (er2.isSameSequence(nr1) && er2.getPos() == nr1.getPos()) {
                s.remove(in);
                continue;
            }
            if (!er2.isSameSequence(nr2) || er2.getPos() != nr2.getPos()) continue;
            s.remove(in);
        }
    }

    public void setSequence1(Sequence sequence1) {
        this.sequence1 = sequence1;
        this.handleSequenceChange();
    }

    private void handleSequenceChange() {
        this.display.clearSelection();
        this.checkSequencesEqual();
        this.updateInteractions();
        this.display.updateDimensions();
        this.pane.revalidate();
        this.scrollPane.revalidate();
        this.scrollPane.getViewport().revalidate();
        this.scrollPane.repaint();
    }

    public void setInteractionsModified(boolean b) {
        this.interactionsModified = b;
        if (b) {
            this.commitButton.setEnabled(true);
            this.clearButton.setEnabled(true);
        } else {
            this.commitButton.setEnabled(false);
            this.clearButton.setEnabled(false);
        }
    }

    public boolean isInteractionsModified() {
        return this.interactionsModified;
    }

    public void setSequence2(Sequence sequence2) {
        this.sequence2 = sequence2;
        this.handleSequenceChange();
    }

    public Sequence getSequence1() {
        return this.sequence1;
    }

    public Sequence getSequence2() {
        return this.sequence2;
    }

    private boolean checkSequencesEqual() {
        if (this.sequence1 != null && this.sequence2 != null) {
            if (this.sequence1.equals(this.sequence2)) {
                this.sameSequence = true;
                return true;
            }
            this.sameSequence = false;
            return false;
        }
        return false;
    }

    private void updateInteractions() {
        this.modifiedInteractions.clear();
        this.conflictingInteractions.clear();
        this.setInteractionsModified(false);
    }

    private boolean discardModifiedInteractions() {
        if (this.isInteractionsModified()) {
            int result = JOptionPane.showConfirmDialog(this.display, "Interactions have been modified. Discard changes?");
            return result == 0;
        }
        return true;
    }

    private class SequenceListModel
    extends AbstractListModel {
        private SequenceListModel() {
        }

        @Override
        public int getSize() {
            return SecondaryStructureEditorPanel.this.sequences.getSequenceCount();
        }

        @Override
        public Object getElementAt(int index) {
            return SecondaryStructureEditorPanel.this.sequences.getSequence(index).getName();
        }
    }

    private class StemCreationDisplay
    extends JPanel
    implements Scrollable {
        private final Dimension PANEL_DIMENSION = new Dimension(500, 500);
        private final Dimension CHARACTER_BOUND = new Dimension(12, 16);
        private final Point SEQ1_POINT = new Point(20, 50);
        private final Point SEQ2_POINT = new Point(20, 300);
        private final Point SEQEQUAL_POINT = new Point(20, 300);
        private final int INTER_SEQUENCE_SPACE = 50;
        private final int BORDER_SPACE = 20;
        private Sequence selectedSequence = null;
        private int selectedPosition = -1;

        public void clearSelection() {
            this.selectedSequence = null;
            this.selectedPosition = -1;
        }

        private Sequence getClickedSequence(Point p) {
            if (SecondaryStructureEditorPanel.this.sameSequence) {
                Rectangle sequenceBound = new Rectangle(this.SEQEQUAL_POINT, new Dimension(this.CHARACTER_BOUND.width * SecondaryStructureEditorPanel.this.sequence1.size(), this.CHARACTER_BOUND.height));
                if (sequenceBound.contains(p)) {
                    return SecondaryStructureEditorPanel.this.sequence1;
                }
                return null;
            }
            Rectangle sequence1Bound = new Rectangle(this.SEQ1_POINT, new Dimension(this.CHARACTER_BOUND.width * SecondaryStructureEditorPanel.this.sequence1.size(), this.CHARACTER_BOUND.height));
            Rectangle sequence2Bound = new Rectangle(this.SEQ2_POINT, new Dimension(this.CHARACTER_BOUND.width * SecondaryStructureEditorPanel.this.sequence2.size(), this.CHARACTER_BOUND.height));
            System.out.println(sequence1Bound);
            System.out.println(sequence2Bound);
            System.out.println(p);
            if (sequence1Bound.contains(p)) {
                return SecondaryStructureEditorPanel.this.sequence1;
            }
            if (sequence2Bound.contains(p)) {
                return SecondaryStructureEditorPanel.this.sequence2;
            }
            return null;
        }

        private int getClickedPosition(Point p) {
            Sequence s = this.getClickedSequence(p);
            if (s != null) {
                if (SecondaryStructureEditorPanel.this.sameSequence) {
                    return (p.x - this.SEQEQUAL_POINT.x) / this.CHARACTER_BOUND.width;
                }
                if (s.equals(SecondaryStructureEditorPanel.this.sequence1)) {
                    return (p.x - this.SEQ1_POINT.x) / this.CHARACTER_BOUND.width;
                }
                return (p.x - this.SEQ2_POINT.x) / this.CHARACTER_BOUND.width;
            }
            return -1;
        }

        public StemCreationDisplay() {
            Random r = Randomizer.getInstance();
            System.out.println("Creating stem creation display");
            SecondaryStructureEditorPanel.this.mixer = new ColorGradientMixer(new Color(r.nextInt(100) + 155, r.nextInt(100) + 155, r.nextInt(100) + 155), 40);
            for (int i = 0; i < SecondaryStructureEditorPanel.this.sequences.getSequenceCount(); ++i) {
                SecondaryStructureEditorPanel.this.sequenceColorMap.put(i, SecondaryStructureEditorPanel.this.mixer.nextColor());
            }
            this.setBackground(Color.white);
            this.setPreferredSize(this.PANEL_DIMENSION);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (SecondaryStructureEditorPanel.this.sequence1 != null && SecondaryStructureEditorPanel.this.sequence2 != null) {
                        if (e.getButton() == 1) {
                            Point p = e.getPoint();
                            Sequence s = StemCreationDisplay.this.getClickedSequence(p);
                            int pos = StemCreationDisplay.this.getClickedPosition(p);
                            if (pos == -1 || s == null) {
                                return;
                            }
                            if (StemCreationDisplay.this.selectedSequence == null || StemCreationDisplay.this.selectedPosition == -1) {
                                StemCreationDisplay.this.selectedSequence = s;
                                StemCreationDisplay.this.selectedPosition = pos;
                                System.out.println("Selected sequence " + s.getName() + " at position " + pos);
                            } else {
                                if (SecondaryStructureEditorPanel.this.sameSequence && StemCreationDisplay.this.selectedPosition == pos) {
                                    return;
                                }
                                if (!SecondaryStructureEditorPanel.this.sameSequence && StemCreationDisplay.this.selectedSequence.equals(s)) {
                                    StemCreationDisplay.this.selectedPosition = pos;
                                    System.out.println("Selected sequence " + StemCreationDisplay.this.selectedSequence.getName() + " at position " + pos);
                                } else {
                                    System.out.println("Adding interaction: " + StemCreationDisplay.this.selectedSequence.getName() + ", " + StemCreationDisplay.this.selectedPosition + " to " + s.getName() + ", " + pos);
                                    SimpleInteraction interaction = new SimpleInteraction(StemCreationDisplay.this.selectedSequence.getResidue(StemCreationDisplay.this.selectedPosition), s.getResidue(pos), new RnaInteractionType(1));
                                    InteractionSet conflictingInteractions = SecondaryStructureEditorPanel.this.getConflictingInteractions(SecondaryStructureEditorPanel.this.modifiedInteractions, interaction);
                                    System.out.println("Number of conflicting interactions: " + conflictingInteractions.size());
                                    if (conflictingInteractions.size() > 0) {
                                        for (int i = 0; i < conflictingInteractions.size(); ++i) {
                                            SecondaryStructureEditorPanel.this.modifiedInteractions.remove(conflictingInteractions.get(i));
                                        }
                                    }
                                    if ((conflictingInteractions = SecondaryStructureEditorPanel.this.getConflictingInteractions(SecondaryStructureEditorPanel.this.existingInteractions, interaction)).size() > 0) {
                                        SecondaryStructureEditorPanel.this.conflictingInteractions.add(interaction);
                                    }
                                    SecondaryStructureEditorPanel.this.modifiedInteractions.add(interaction);
                                    StemCreationDisplay.this.selectedSequence = null;
                                    SecondaryStructureEditorPanel.this.setInteractionsModified(true);
                                    StemCreationDisplay.this.selectedPosition = -1;
                                }
                            }
                        }
                    } else {
                        StemCreationDisplay.this.selectedSequence = null;
                        StemCreationDisplay.this.selectedPosition = -1;
                    }
                    StemCreationDisplay.this.repaint();
                }
            });
        }

        private char getSequenceCharacter(Sequence s, int index) {
            return s.sequenceString().charAt(index);
        }

        private void paintSequence(Graphics g, Point p, Sequence s) {
            InteractionSet set = null;
            set = SecondaryStructureEditorPanel.this.conflictingInteractions.size() > 0 ? SecondaryStructureEditorPanel.this.getValidInteractions(SecondaryStructureEditorPanel.this.existingInteractions, SecondaryStructureEditorPanel.this.conflictingInteractions) : SecondaryStructureEditorPanel.this.existingInteractions;
            for (int i = 0; i < set.size(); ++i) {
                Color old;
                Color c;
                Point tp;
                Interaction interaction = set.get(i);
                Residue r1 = interaction.getResidue1();
                Residue r2 = interaction.getResidue2();
                Sequence s1 = interaction.getSequence1();
                Sequence s2 = interaction.getSequence2();
                if (s1.equals(s)) {
                    tp = new Point(p);
                    c = null;
                    c = this.getSequenceColor(s2);
                    tp.translate(this.CHARACTER_BOUND.width * r1.getPos(), 0);
                    old = g.getColor();
                    g.setColor(c);
                    g.fillRect(tp.x, tp.y, this.CHARACTER_BOUND.width, this.CHARACTER_BOUND.height);
                    g.setColor(old);
                }
                if (!s2.equals(s)) continue;
                tp = new Point(p);
                c = null;
                c = this.getSequenceColor(s1);
                tp.translate(this.CHARACTER_BOUND.width * r2.getPos(), 0);
                old = g.getColor();
                g.setColor(c);
                g.fillRect(tp.x, tp.y, this.CHARACTER_BOUND.width, this.CHARACTER_BOUND.height);
                g.setColor(old);
            }
            if (this.selectedSequence != null && this.selectedPosition != -1 && s.equals(this.selectedSequence)) {
                Point tp = new Point(p);
                tp.translate(this.CHARACTER_BOUND.width * this.selectedPosition, 0);
                Color c = g.getColor();
                g.setColor(Color.black);
                g.drawLine(tp.x, tp.y + this.CHARACTER_BOUND.height + 2, tp.x + this.CHARACTER_BOUND.width, tp.y + this.CHARACTER_BOUND.height + 2);
                g.setColor(c);
            }
            Point tp = new Point(p);
            for (int i = 0; i < s.size(); ++i) {
                char[] chars = new char[]{this.getSequenceCharacter(s, i)};
                g.drawChars(chars, 0, 1, tp.x, tp.y + this.CHARACTER_BOUND.height);
                tp.translate(this.CHARACTER_BOUND.width, 0);
            }
        }

        private Color getSequenceColor(Sequence s) {
            for (int i = 0; i < SecondaryStructureEditorPanel.this.sequences.getSequenceCount(); ++i) {
                if (!SecondaryStructureEditorPanel.this.sequences.getSequence(i).equals(s)) continue;
                return (Color)SecondaryStructureEditorPanel.this.sequenceColorMap.get(i);
            }
            return Color.black;
        }

        private void paintInterSequenceInteraction(Graphics g, Point p1, Sequence sequence1, Point p2, Sequence sequence2, Interaction i) {
            Residue r1 = i.getResidue1();
            Residue r2 = i.getResidue2();
            int seq1Position = 0;
            int seq2Position = 0;
            if (r1.isSameSequence(r2)) {
                seq1Position = r1.getPos();
                seq2Position = r2.getPos();
            } else if (i.getSequence1().equals(sequence1)) {
                seq1Position = r1.getPos();
                seq2Position = r2.getPos();
            } else {
                seq1Position = r2.getPos();
                seq2Position = r1.getPos();
            }
            Point tp1 = new Point(p1);
            tp1.translate(this.CHARACTER_BOUND.width * seq1Position + this.CHARACTER_BOUND.width / 2, this.CHARACTER_BOUND.height + 5);
            Point tp2 = new Point(p2);
            tp2.translate(this.CHARACTER_BOUND.width * seq2Position + this.CHARACTER_BOUND.width / 2, -5);
            g.drawLine(tp1.x, tp1.y, tp2.x, tp2.y);
        }

        private void paintIntraSequenceInteraction(Graphics g, Point p, Interaction i, boolean above) {
            int last;
            int first;
            Residue r1 = i.getResidue1();
            Residue r2 = i.getResidue2();
            if (r1.getPos() > r2.getPos()) {
                first = r2.getPos();
                last = r1.getPos();
            } else {
                first = r1.getPos();
                last = r2.getPos();
            }
            int width = (last - first) * this.CHARACTER_BOUND.width;
            int height = (last - first) * this.CHARACTER_BOUND.height / 2;
            Point point = new Point(p);
            if (!above) {
                point.translate(this.CHARACTER_BOUND.width * first + this.CHARACTER_BOUND.width / 2, -1 * height / 2 + this.CHARACTER_BOUND.height + 5);
                g.drawArc(point.x, point.y, width, height, 0, -180);
            } else {
                point.translate(this.CHARACTER_BOUND.width * first + this.CHARACTER_BOUND.width / 2, -5 - height / 2);
                g.drawArc(point.x, point.y, width, height, 0, 180);
            }
        }

        @Override
        public void paintComponent(Graphics g) {
            block8: {
                super.paintComponent(g);
                Font f = g.getFont();
                g.setFont(new Font(f.getName(), 1, 16));
                g.setColor(Color.black);
                if (SecondaryStructureEditorPanel.this.sequence1 == null || SecondaryStructureEditorPanel.this.sequence2 == null) break block8;
                if (SecondaryStructureEditorPanel.this.sameSequence) {
                    this.paintSequence(g, this.SEQEQUAL_POINT, SecondaryStructureEditorPanel.this.sequence1);
                    for (int i = 0; i < SecondaryStructureEditorPanel.this.modifiedInteractions.size(); ++i) {
                        this.paintIntraSequenceInteraction(g, this.SEQEQUAL_POINT, SecondaryStructureEditorPanel.this.modifiedInteractions.get(i), true);
                    }
                    InteractionSet validInteractions = SecondaryStructureEditorPanel.this.getValidInteractions(SecondaryStructureEditorPanel.this.existingInteractions, SecondaryStructureEditorPanel.this.conflictingInteractions);
                    for (int i = 0; i < validInteractions.size(); ++i) {
                        if (!validInteractions.get(i).isIntraSequence() || !validInteractions.get(i).getResidue1().isSameSequence(SecondaryStructureEditorPanel.this.sequence1.getResidue(0))) continue;
                        this.paintIntraSequenceInteraction(g, this.SEQEQUAL_POINT, validInteractions.get(i), false);
                    }
                } else {
                    Interaction in;
                    int i;
                    this.paintSequence(g, this.SEQ1_POINT, SecondaryStructureEditorPanel.this.sequence1);
                    this.paintSequence(g, this.SEQ2_POINT, SecondaryStructureEditorPanel.this.sequence2);
                    for (int i2 = 0; i2 < SecondaryStructureEditorPanel.this.modifiedInteractions.size(); ++i2) {
                        this.paintInterSequenceInteraction(g, this.SEQ1_POINT, SecondaryStructureEditorPanel.this.sequence1, this.SEQ2_POINT, SecondaryStructureEditorPanel.this.sequence2, SecondaryStructureEditorPanel.this.modifiedInteractions.get(i2));
                    }
                    InteractionSet validInteractions = SecondaryStructureEditorPanel.this.getValidInteractions(SecondaryStructureEditorPanel.this.existingInteractions, SecondaryStructureEditorPanel.this.conflictingInteractions);
                    for (i = 0; i < validInteractions.size(); ++i) {
                        Sequence s2;
                        in = validInteractions.get(i);
                        if (in.isIntraSequence()) continue;
                        Sequence s1 = in.getSequence1().equals(SecondaryStructureEditorPanel.this.sequence1) ? in.getSequence1() : in.getSequence2();
                        Sequence sequence = s2 = in.getSequence2().equals(SecondaryStructureEditorPanel.this.sequence2) ? in.getSequence2() : in.getSequence1();
                        if ((!in.getResidue1().isSameSequence(SecondaryStructureEditorPanel.this.sequence1.getResidue(0)) || !in.getResidue2().isSameSequence(SecondaryStructureEditorPanel.this.sequence2.getResidue(0))) && (!in.getResidue1().isSameSequence(SecondaryStructureEditorPanel.this.sequence2.getResidue(0)) || !in.getResidue2().isSameSequence(SecondaryStructureEditorPanel.this.sequence1.getResidue(0)))) continue;
                        this.paintInterSequenceInteraction(g, this.SEQ1_POINT, s1, this.SEQ2_POINT, s2, in);
                    }
                    for (i = 0; i < validInteractions.size(); ++i) {
                        in = validInteractions.get(i);
                        if (!in.isIntraSequence()) continue;
                        if (in.getResidue1().isSameSequence(SecondaryStructureEditorPanel.this.sequence1.getResidue(0))) {
                            this.paintIntraSequenceInteraction(g, this.SEQ1_POINT, in, true);
                            continue;
                        }
                        if (!in.getResidue1().isSameSequence(SecondaryStructureEditorPanel.this.sequence2.getResidue(0))) continue;
                        this.paintIntraSequenceInteraction(g, this.SEQ2_POINT, in, false);
                    }
                }
            }
        }

        public void updateDimensions() {
            if (SecondaryStructureEditorPanel.this.sequence1 != null && SecondaryStructureEditorPanel.this.sequence2 != null) {
                int maxLength = 0;
                if (SecondaryStructureEditorPanel.this.sequence1 != null) {
                    maxLength = SecondaryStructureEditorPanel.this.sequence1.size();
                }
                if (SecondaryStructureEditorPanel.this.sequence2 != null && SecondaryStructureEditorPanel.this.sequence2.size() > maxLength) {
                    maxLength = SecondaryStructureEditorPanel.this.sequence2.size();
                }
                int width = maxLength * this.CHARACTER_BOUND.width + 40;
                int height = 0;
                if (SecondaryStructureEditorPanel.this.sameSequence) {
                    height = 40 + 2 * maxLength * this.CHARACTER_BOUND.height / 2 + this.CHARACTER_BOUND.height;
                    this.SEQEQUAL_POINT.y = 20 + maxLength * this.CHARACTER_BOUND.height / 2;
                } else {
                    height = 90 + 2 * maxLength * this.CHARACTER_BOUND.height / 2 + 2 * this.CHARACTER_BOUND.height;
                    this.SEQ1_POINT.y = 20 + maxLength * this.CHARACTER_BOUND.height / 2;
                    this.SEQ2_POINT.y = this.SEQ1_POINT.y + 50 + this.CHARACTER_BOUND.height;
                    this.SEQ1_POINT.x = (width - SecondaryStructureEditorPanel.this.sequence1.size() * this.CHARACTER_BOUND.width) / 2 + 20;
                    this.SEQ2_POINT.x = (width - SecondaryStructureEditorPanel.this.sequence2.size() * this.CHARACTER_BOUND.width) / 2 + 20;
                }
                this.setPreferredSize(new Dimension(width, height));
                System.out.println("Setting preferred size to : " + this.getPreferredSize());
            } else {
                this.SEQEQUAL_POINT.x = 20;
                this.SEQEQUAL_POINT.y = this.PANEL_DIMENSION.height - this.CHARACTER_BOUND.height;
                this.SEQ1_POINT.x = 20;
                this.SEQ1_POINT.y = 50;
                this.SEQ2_POINT.x = 20;
                this.SEQ2_POINT.y = 300;
                this.setPreferredSize(this.PANEL_DIMENSION);
            }
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            if (orientation == 0) {
                return this.CHARACTER_BOUND.width;
            }
            return this.CHARACTER_BOUND.height;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return false;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return false;
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            return this.getScrollableBlockIncrement(visibleRect, orientation, direction);
        }
    }

    private class SequenceSelectorComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        private Object selectedItem = null;

        private SequenceSelectorComboBoxModel() {
        }

        @Override
        public Object getSelectedItem() {
            return this.selectedItem;
        }

        @Override
        public void setSelectedItem(Object o) {
            this.selectedItem = o;
        }

        @Override
        public Object getElementAt(int index) {
            return SecondaryStructureEditorPanel.this.sequences.getSequence(index).getName();
        }

        @Override
        public int getSize() {
            return SecondaryStructureEditorPanel.this.sequences.getSequenceCount();
        }
    }
}

