/*
 * Decompiled with CFR 0.152.
 */
package commandtools;

import commandtools.AbstractCommand;
import commandtools.Command;
import commandtools.CommandApplication;
import commandtools.CommandExecutionException;
import commandtools.PackageConstants;
import commandtools.StringParameter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public class HistoryCommand
extends AbstractCommand
implements Command {
    public static final String COMMAND_NAME = "history";
    private CommandApplication application;
    private String fileName = null;

    public HistoryCommand(CommandApplication app) {
        super(COMMAND_NAME);
        this.application = app;
    }

    @Override
    public Object cloneDeep() {
        HistoryCommand result = new HistoryCommand(this.application);
        result.application = this.application;
        result.fileName = this.fileName;
        for (int i = 0; i < this.getParameterCount(); ++i) {
            result.addParameter((Command)this.getParameter(i).cloneDeep());
        }
        return result;
    }

    @Override
    public Command execute() throws CommandExecutionException {
        this.executeWithoutUndo();
        return null;
    }

    @Override
    public void executeWithoutUndo() throws CommandExecutionException {
        if (this.fileName == null || this.fileName.length() == 0) {
            System.out.println(((Object)this.application.getCommandHistory()).toString());
        } else {
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(this.fileName);
                PrintStream ps = new PrintStream(fos);
                ps.println(((Object)this.application.getCommandHistory()).toString());
                fos.close();
            }
            catch (IOException ioe) {
                throw new CommandExecutionException("Error writing to file: " + this.fileName + " " + ioe.getMessage());
            }
        }
    }

    @Override
    public String getName() {
        return COMMAND_NAME;
    }

    @Override
    public String toString() {
        StringBuffer result = new StringBuffer(COMMAND_NAME);
        StringParameter filePar = (StringParameter)this.getParameter("file");
        if (filePar != null) {
            this.fileName = filePar.getValue();
        }
        return result.toString();
    }

    @Override
    public String getShortHelpText() {
        return this.helpOutput();
    }

    @Override
    public String getLongHelpText() {
        String helpText = "\"history\" Command Manual" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "NAME" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "SYNOPSIS" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + " [options]" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "DESCRIPTION" + PackageConstants.NEWLINE + "     History command prints history or writes history to a file." + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "OPTIONS" + PackageConstants.NEWLINE;
        helpText = helpText + "     file=FILENAME" + PackageConstants.NEWLINE + "          Write history to FILENAME." + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        return helpText;
    }

    private String helpOutput() {
        return "Correct usage: history [file=FILENAME]";
    }
}

