/*
 * Decompiled with CFR 0.152.
 */
package generaltools;

import generaltools.ConstraintDouble;

public class SimpleConstraintDouble
implements ConstraintDouble {
    double min;
    double max;
    double forceConstant;
    boolean squareMode = true;

    public SimpleConstraintDouble(double min, double max) {
        this.min = min;
        this.max = max;
        this.forceConstant = 1.0;
    }

    public SimpleConstraintDouble(double min, double max, double force) {
        this.min = min;
        this.max = max;
        this.forceConstant = force;
    }

    @Override
    public double getForceConstant() {
        return this.forceConstant;
    }

    @Override
    public double getMin() {
        return this.min;
    }

    @Override
    public double getMax() {
        return this.max;
    }

    @Override
    public double getDiff(double pos) {
        double result = 0.0;
        if (pos > this.max) {
            result = pos - this.max;
        } else if (pos < this.min) {
            result = this.min - pos;
        }
        if (this.squareMode) {
            result *= result;
        }
        assert (result >= 0.0);
        return result;
    }

    public void setSquareMode(boolean b) {
        this.squareMode = b;
    }

    public String toString() {
        return "(Constraint " + this.min + " " + this.max + " " + this.forceConstant + " )";
    }
}

