/*
 * Decompiled with CFR 0.152.
 */
package guitools;

import guitools.CustomDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public class DialogDemo
extends JPanel {
    public static final String NEWLINE = System.getProperty("line.separator");
    JLabel label;
    ImageIcon icon = DialogDemo.createImageIcon("images/middle.gif");
    JFrame frame;
    String simpleDialogDesc = "Some simple message dialogs";
    String iconDesc = "A JOptionPane has its choice of icons";
    String moreDialogDesc = "Some more dialogs";
    CustomDialog customDialog;

    public DialogDemo(JFrame frame) {
        super(new BorderLayout());
        this.frame = frame;
        this.customDialog = new CustomDialog((Frame)frame, "geisel");
        this.customDialog.pack();
        JPanel frequentPanel = this.createSimpleDialogBox();
        JPanel featurePanel = this.createFeatureDialogBox();
        JPanel iconPanel = this.createIconDialogBox();
        this.label = new JLabel("Click the \"Show it!\" button to bring up the selected dialog.", 0);
        Border padding = BorderFactory.createEmptyBorder(20, 20, 5, 20);
        frequentPanel.setBorder(padding);
        featurePanel.setBorder(padding);
        iconPanel.setBorder(padding);
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab("Simple Modal Dialogs", null, frequentPanel, this.simpleDialogDesc);
        tabbedPane.addTab("More Dialogs", null, featurePanel, this.moreDialogDesc);
        tabbedPane.addTab("Dialog Icons", null, iconPanel, this.iconDesc);
        this.add((Component)tabbedPane, "Center");
        this.add((Component)this.label, "Last");
        this.label.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
    }

    void setLabel(String newText) {
        this.label.setText(newText);
    }

    protected static ImageIcon createImageIcon(String path) {
        URL imgURL = DialogDemo.class.getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL);
        }
        System.err.println("Couldn't find file: " + path);
        return null;
    }

    private JPanel createSimpleDialogBox() {
        int numButtons = 4;
        JRadioButton[] radioButtons = new JRadioButton[4];
        final ButtonGroup group = new ButtonGroup();
        JButton showItButton = null;
        String defaultMessageCommand = "default";
        String yesNoCommand = "yesno";
        String yeahNahCommand = "yeahnah";
        String yncCommand = "ync";
        radioButtons[0] = new JRadioButton("OK (in the L&F's words)");
        radioButtons[0].setActionCommand("default");
        radioButtons[1] = new JRadioButton("Yes/No (in the L&F's words)");
        radioButtons[1].setActionCommand("yesno");
        radioButtons[2] = new JRadioButton("Yes/No (in the programmer's words)");
        radioButtons[2].setActionCommand("yeahnah");
        radioButtons[3] = new JRadioButton("Yes/No/Cancel (in the programmer's words)");
        radioButtons[3].setActionCommand("ync");
        for (int i = 0; i < 4; ++i) {
            group.add(radioButtons[i]);
        }
        radioButtons[0].setSelected(true);
        showItButton = new JButton("Show it!");
        showItButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String command = group.getSelection().getActionCommand();
                if (command == "default") {
                    JOptionPane.showMessageDialog(DialogDemo.this.frame, "Eggs aren't supposed to be green.");
                } else if (command == "yesno") {
                    int n = JOptionPane.showConfirmDialog(DialogDemo.this.frame, "Would you like green eggs and ham?", "An Inane Question", 0);
                    if (n == 0) {
                        DialogDemo.this.setLabel("Ewww!");
                    } else if (n == 1) {
                        DialogDemo.this.setLabel("Me neither!");
                    } else {
                        DialogDemo.this.setLabel("Come on -- tell me!");
                    }
                } else if (command == "yeahnah") {
                    Object[] options = new Object[]{"Yes, please", "No way!"};
                    int n = JOptionPane.showOptionDialog(DialogDemo.this.frame, "Would you like green eggs and ham?", "A Silly Question", 0, 3, null, options, options[0]);
                    if (n == 0) {
                        DialogDemo.this.setLabel("You're kidding!");
                    } else if (n == 1) {
                        DialogDemo.this.setLabel("I don't like them, either.");
                    } else {
                        DialogDemo.this.setLabel("Come on -- 'fess up!");
                    }
                } else if (command == "ync") {
                    Object[] options = new Object[]{"Yes, please", "No, thanks", "No eggs, no ham!"};
                    int n = JOptionPane.showOptionDialog(DialogDemo.this.frame, "Would you like some green eggs to go with that ham?", "A Silly Question", 1, 3, null, options, options[2]);
                    if (n == 0) {
                        DialogDemo.this.setLabel("Here you go: green eggs and ham!");
                    } else if (n == 1) {
                        DialogDemo.this.setLabel("OK, just the ham, then.");
                    } else if (n == 2) {
                        DialogDemo.this.setLabel("Well, I'm certainly not going to eat them!");
                    } else {
                        DialogDemo.this.setLabel("Please tell me what you want!");
                    }
                }
            }
        });
        return this.createPane(this.simpleDialogDesc + ":", radioButtons, showItButton);
    }

    private JPanel createPane(String description, JRadioButton[] radioButtons, JButton showButton) {
        int numChoices = radioButtons.length;
        JPanel box = new JPanel();
        JLabel label = new JLabel(description);
        box.setLayout(new BoxLayout(box, 3));
        box.add(label);
        for (int i = 0; i < numChoices; ++i) {
            box.add(radioButtons[i]);
        }
        JPanel pane = new JPanel(new BorderLayout());
        pane.add((Component)box, "First");
        pane.add((Component)showButton, "Last");
        return pane;
    }

    private JPanel create2ColPane(String description, JRadioButton[] radioButtons, JButton showButton) {
        JLabel label = new JLabel(description);
        int numPerColumn = radioButtons.length / 2;
        JPanel grid = new JPanel(new GridLayout(0, 2));
        for (int i = 0; i < numPerColumn; ++i) {
            grid.add(radioButtons[i]);
            grid.add(radioButtons[i + numPerColumn]);
        }
        JPanel box = new JPanel();
        box.setLayout(new BoxLayout(box, 3));
        box.add(label);
        grid.setAlignmentX(0.0f);
        box.add(grid);
        JPanel pane = new JPanel(new BorderLayout());
        pane.add((Component)box, "First");
        pane.add((Component)showButton, "Last");
        return pane;
    }

    private JPanel createIconDialogBox() {
        JButton showItButton = null;
        int numButtons = 6;
        JRadioButton[] radioButtons = new JRadioButton[6];
        final ButtonGroup group = new ButtonGroup();
        String plainCommand = "plain";
        String infoCommand = "info";
        String questionCommand = "question";
        String errorCommand = "error";
        String warningCommand = "warning";
        String customCommand = "custom";
        radioButtons[0] = new JRadioButton("Plain (no icon)");
        radioButtons[0].setActionCommand("plain");
        radioButtons[1] = new JRadioButton("Information icon");
        radioButtons[1].setActionCommand("info");
        radioButtons[2] = new JRadioButton("Question icon");
        radioButtons[2].setActionCommand("question");
        radioButtons[3] = new JRadioButton("Error icon");
        radioButtons[3].setActionCommand("error");
        radioButtons[4] = new JRadioButton("Warning icon");
        radioButtons[4].setActionCommand("warning");
        radioButtons[5] = new JRadioButton("Custom icon");
        radioButtons[5].setActionCommand("custom");
        for (int i = 0; i < 6; ++i) {
            group.add(radioButtons[i]);
        }
        radioButtons[0].setSelected(true);
        showItButton = new JButton("Show it!");
        showItButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String command = group.getSelection().getActionCommand();
                if (command == "plain") {
                    JOptionPane.showMessageDialog(DialogDemo.this.frame, "Eggs aren't supposed to be green.", "A plain message", -1);
                } else if (command == "info") {
                    JOptionPane.showMessageDialog(DialogDemo.this.frame, "Eggs aren't supposed to be green.", "Inane informational dialog", 1);
                } else if (command == "question") {
                    JOptionPane.showMessageDialog(DialogDemo.this.frame, "You shouldn't use a message dialog (like this)" + NEWLINE + "for a question, OK?", "Inane question", 3);
                } else if (command == "error") {
                    JOptionPane.showMessageDialog(DialogDemo.this.frame, "Eggs aren't supposed to be green.", "Inane error", 0);
                } else if (command == "warning") {
                    JOptionPane.showMessageDialog(DialogDemo.this.frame, "Eggs aren't supposed to be green.", "Inane warning", 2);
                } else if (command == "custom") {
                    JOptionPane.showMessageDialog(DialogDemo.this.frame, "Eggs aren't supposed to be green.", "Inane custom dialog", 1, DialogDemo.this.icon);
                }
            }
        });
        return this.create2ColPane(this.iconDesc + ":", radioButtons, showItButton);
    }

    private JPanel createFeatureDialogBox() {
        int numButtons = 5;
        JRadioButton[] radioButtons = new JRadioButton[5];
        final ButtonGroup group = new ButtonGroup();
        JButton showItButton = null;
        String pickOneCommand = "pickone";
        String textEnteredCommand = "textfield";
        String nonAutoCommand = "nonautooption";
        String customOptionCommand = "customoption";
        String nonModalCommand = "nonmodal";
        radioButtons[0] = new JRadioButton("Pick one of several choices");
        radioButtons[0].setActionCommand("pickone");
        radioButtons[1] = new JRadioButton("Enter some text");
        radioButtons[1].setActionCommand("textfield");
        radioButtons[2] = new JRadioButton("Non-auto-closing dialog");
        radioButtons[2].setActionCommand("nonautooption");
        radioButtons[3] = new JRadioButton("Input-validating dialog (with custom message area)");
        radioButtons[3].setActionCommand("customoption");
        radioButtons[4] = new JRadioButton("Non-modal dialog");
        radioButtons[4].setActionCommand("nonmodal");
        for (int i = 0; i < 5; ++i) {
            group.add(radioButtons[i]);
        }
        radioButtons[0].setSelected(true);
        showItButton = new JButton("Show it!");
        showItButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String command = group.getSelection().getActionCommand();
                if (command == "pickone") {
                    Object[] possibilities = new Object[]{"ham", "spam", "yam"};
                    String s = (String)JOptionPane.showInputDialog(DialogDemo.this.frame, "Complete the sentence:" + NEWLINE + "\"Green eggs and...\"", "Customized Dialog", -1, DialogDemo.this.icon, possibilities, "ham");
                    if (s != null && s.length() > 0) {
                        DialogDemo.this.setLabel("Green eggs and... " + s + "!");
                        return;
                    }
                    DialogDemo.this.setLabel("Come on, finish the sentence!");
                } else if (command == "textfield") {
                    String s = (String)JOptionPane.showInputDialog(DialogDemo.this.frame, "Complete the sentence:" + NEWLINE + "\"Green eggs and...\"", "Customized Dialog", -1, DialogDemo.this.icon, null, "ham");
                    if (s != null && s.length() > 0) {
                        DialogDemo.this.setLabel("Green eggs and... " + s + "!");
                        return;
                    }
                    DialogDemo.this.setLabel("Come on, finish the sentence!");
                } else if (command == "nonautooption") {
                    final JOptionPane optionPane = new JOptionPane("The only way to close this dialog is by" + NEWLINE + "pressing one of the following buttons." + NEWLINE + "Do you understand?", 3, 0);
                    JDialog.setDefaultLookAndFeelDecorated(false);
                    final JDialog dialog = new JDialog(DialogDemo.this.frame, "Click a button", true);
                    dialog.setContentPane(optionPane);
                    dialog.setDefaultCloseOperation(0);
                    dialog.addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowClosing(WindowEvent we) {
                            DialogDemo.this.setLabel("Thwarted user attempt to close window.");
                        }
                    });
                    JDialog.setDefaultLookAndFeelDecorated(true);
                    optionPane.addPropertyChangeListener(new PropertyChangeListener(){

                        @Override
                        public void propertyChange(PropertyChangeEvent e) {
                            String prop = e.getPropertyName();
                            if (dialog.isVisible() && e.getSource() == optionPane && "value".equals(prop)) {
                                dialog.setVisible(false);
                            }
                        }
                    });
                    dialog.pack();
                    dialog.setLocationRelativeTo(DialogDemo.this.frame);
                    dialog.setVisible(true);
                    int value = (Integer)optionPane.getValue();
                    if (value == 0) {
                        DialogDemo.this.setLabel("Good.");
                    } else if (value == 1) {
                        DialogDemo.this.setLabel("Try using the window decorations to close the non-auto-closing dialog. You can't!");
                    } else {
                        DialogDemo.this.setLabel("Window unavoidably closed (ESC?).");
                    }
                } else if (command == "customoption") {
                    DialogDemo.this.customDialog.setLocationRelativeTo(DialogDemo.this.frame);
                    DialogDemo.this.customDialog.setVisible(true);
                    String s = DialogDemo.this.customDialog.getValidatedText();
                    if (s != null) {
                        DialogDemo.this.setLabel("Congratulations!  You entered \"" + s + "\".");
                    }
                } else if (command == "nonmodal") {
                    final JDialog dialog = new JDialog((Frame)DialogDemo.this.frame, "A Non-Modal Dialog");
                    JLabel label = new JLabel("<html><p align=center>This is a non-modal dialog.<br>You can have one or more of these up<br>and still use the main window.");
                    label.setHorizontalAlignment(0);
                    Font font = label.getFont();
                    label.setFont(label.getFont().deriveFont(0, 14.0f));
                    JButton closeButton = new JButton("Close");
                    closeButton.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            dialog.setVisible(false);
                            dialog.dispose();
                        }
                    });
                    JPanel closePanel = new JPanel();
                    closePanel.setLayout(new BoxLayout(closePanel, 2));
                    closePanel.add(Box.createHorizontalGlue());
                    closePanel.add(closeButton);
                    closePanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 5));
                    JPanel contentPane = new JPanel(new BorderLayout());
                    contentPane.add((Component)label, "Center");
                    contentPane.add((Component)closePanel, "Last");
                    contentPane.setOpaque(true);
                    dialog.setContentPane(contentPane);
                    dialog.setSize(new Dimension(300, 150));
                    dialog.setLocationRelativeTo(DialogDemo.this.frame);
                    dialog.setVisible(true);
                }
            }
        });
        return this.createPane(this.moreDialogDesc + ":", radioButtons, showItButton);
    }

    private static void createAndShowGUI() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JFrame frame = new JFrame("DialogDemo");
        frame.setDefaultCloseOperation(3);
        DialogDemo newContentPane = new DialogDemo(frame);
        newContentPane.setOpaque(true);
        frame.setContentPane(newContentPane);
        frame.pack();
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DialogDemo.createAndShowGUI();
            }
        });
    }
}

