/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp;

import commandtools.AbstractCommand;
import commandtools.Command;
import commandtools.CommandExecutionException;
import commandtools.StringParameter;
import generaltools.ParsingException;
import java.io.PrintStream;
import rnadesign.designapp.PackageConstants;
import rnadesign.rnacontrol.BridgeItController;
import rnadesign.rnacontrol.Object3DGraphController;
import rnadesign.rnacontrol.Object3DGraphControllerException;

public class BridgeItCommand
extends AbstractCommand {
    public static final String COMMAND_NAME = "bridgeit";
    private Object3DGraphController controller;
    private double angleWeight = 10.0;
    private String origName;
    private boolean combinedMode = false;
    private String newParentName;
    private String origName2;
    private String newParentName2;
    private String filePrefix = "bridge_";
    private String rootName = "root";
    private int solutionId = 10;
    private int helixAlgorithm = 1;
    private PrintStream ps;
    private double collisionDistance = 2.0;
    private double rms = 2.0;
    private int lenMin = 1;
    private int lenMax = 3;

    public BridgeItCommand(PrintStream ps, Object3DGraphController controller) {
        super(COMMAND_NAME);
        assert (controller != null);
        this.ps = ps;
        this.controller = controller;
    }

    @Override
    public Object cloneDeep() {
        BridgeItCommand command = new BridgeItCommand(this.ps, this.controller);
        command.angleWeight = this.angleWeight;
        command.collisionDistance = this.collisionDistance;
        command.combinedMode = this.combinedMode;
        command.origName = this.origName;
        command.newParentName = this.newParentName;
        command.origName2 = this.origName2;
        command.newParentName2 = this.newParentName2;
        command.filePrefix = this.filePrefix;
        command.rootName = this.rootName;
        command.solutionId = this.solutionId;
        command.helixAlgorithm = this.helixAlgorithm;
        command.rms = this.rms;
        command.lenMin = this.lenMin;
        command.lenMax = this.lenMax;
        for (int i = 0; i < this.getParameterCount(); ++i) {
            command.addParameter((Command)this.getParameter(i).cloneDeep());
        }
        return command;
    }

    @Override
    public String getName() {
        return COMMAND_NAME;
    }

    private String helpOutput() {
        return "Correct usage: bridgeit name1 name2 name3 name4 [angle=WEIGHT] [coll=VALUE] [combined=false|true][l=NUMBER] [min=NUMBER][n=NUMBER] [prefix=NAME] [root=NAME] [rms=VALUE]";
    }

    @Override
    public String getShortHelpText() {
        return this.helpOutput();
    }

    @Override
    public String getLongHelpText() {
        String helpText = "\"bridgeit\" Command Manual" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "NAME" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "SYNOPSIS" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + " OBJECTNAME1 OBJECTNAME2 [angle=WEIGHT] [l=NUMBER] [m=NUMBER][n=NUMBER] [prefix=NAME] [root=NAME] [rms=VALUE]" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "DESCRIPTION" + PackageConstants.NEWLINE + "     bridgeit command attempts to find bridging fragments between nucleotides (class Nucleotide3D) or helices (class BranchDescriptor3D)." + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "Options: " + PackageConstants.NEWLINE + "angle=WEIGHT : weight of angle term in superposition. Default: " + this.angleWeight + PackageConstants.NEWLINE + "coll=VALUE   : defines collision (steric clash) distance between atoms" + PackageConstants.NEWLINE + "l=NUMBER     : maximum length (nucleotides) of bridge" + PackageConstants.NEWLINE + "m=NUMBER     : minimum length (nucleotides) of bridge" + PackageConstants.NEWLINE + "prefix=VALUE : prefix of names generated files. Default: " + this.filePrefix + PackageConstants.NEWLINE + "root=VALUE   : tree node to which the generated bridge structure will be added as a child node. Default: " + this.rootName + PackageConstants.NEWLINE + "rms=VALUE    : root mean square deviation of anchor atoms" + PackageConstants.NEWLINE;
        return helpText;
    }

    @Override
    public void executeWithoutUndo() throws CommandExecutionException {
        this.prepareReadout();
        try {
            this.ps.println("Calling controller.bridgeIt with " + this.origName + " " + this.newParentName);
            this.resultProperties = this.controller.bridgeIt(this.origName, this.newParentName, this.rootName, this.filePrefix, this.solutionId, this.rms, this.angleWeight, this.helixAlgorithm, this.lenMin, this.lenMax);
            this.ps.println(this.resultProperties);
        }
        catch (Object3DGraphControllerException e) {
            throw new CommandExecutionException(e.getMessage());
        }
    }

    @Override
    public Command execute() throws CommandExecutionException {
        this.executeWithoutUndo();
        return null;
    }

    private void prepareReadout() throws CommandExecutionException {
        StringParameter rootPar;
        if (this.getParameterCount() < 2) {
            throw new CommandExecutionException(this.helpOutput());
        }
        StringParameter p0 = (StringParameter)this.getParameter(0);
        this.origName = p0.getValue();
        StringParameter p1 = (StringParameter)this.getParameter(1);
        this.newParentName = p1.getValue();
        StringParameter pref = (StringParameter)this.getParameter("prefix");
        if (pref != null) {
            this.filePrefix = pref.getValue();
        }
        if ((rootPar = (StringParameter)this.getParameter("root")) != null) {
            this.rootName = rootPar.getValue();
        }
        try {
            StringParameter angpar;
            StringParameter collpar;
            StringParameter rpar;
            StringParameter npar;
            StringParameter mpar;
            StringParameter lpar;
            StringParameter apar;
            StringParameter p = (StringParameter)this.getParameter("combined");
            if (p != null) {
                this.combinedMode = p.parseBoolean();
            }
            if (this.combinedMode) {
                if (this.getParameterCount() < 4) {
                    throw new CommandExecutionException("There must be at least four parameters in combined bridge mode.");
                }
                StringParameter p2 = (StringParameter)this.getParameter(2);
                this.origName2 = p2.getValue();
                StringParameter p3 = (StringParameter)this.getParameter(3);
                this.newParentName2 = p3.getValue();
                this.combinedMode = true;
            }
            if ((apar = (StringParameter)this.getParameter("a")) != null) {
                this.helixAlgorithm = Integer.parseInt(apar.getValue());
                if (!BridgeItController.validateHelixAlgorithm(this.helixAlgorithm)) {
                    throw new CommandExecutionException("Unknown helix algorithm id: " + this.helixAlgorithm);
                }
            }
            if ((lpar = (StringParameter)this.getParameter("l")) != null) {
                this.lenMax = Integer.parseInt(lpar.getValue());
            }
            if ((mpar = (StringParameter)this.getParameter("m")) != null) {
                this.lenMin = Integer.parseInt(mpar.getValue());
            }
            if ((npar = (StringParameter)this.getParameter("n")) != null) {
                this.solutionId = Integer.parseInt(npar.getValue());
            }
            if ((rpar = (StringParameter)this.getParameter("rms")) != null) {
                this.rms = Double.parseDouble(rpar.getValue());
            }
            if ((collpar = (StringParameter)this.getParameter("coll")) != null) {
                this.collisionDistance = Double.parseDouble(collpar.getValue());
            }
            if ((angpar = (StringParameter)this.getParameter("angle")) != null) {
                this.angleWeight = Double.parseDouble(angpar.getValue());
            }
        }
        catch (NumberFormatException nfe) {
            throw new CommandExecutionException("Could not parse number: " + nfe.getMessage());
        }
        catch (ParsingException nfe) {
            throw new CommandExecutionException("Could not parse: " + nfe.getMessage());
        }
    }
}

