/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp;

import commandtools.AbstractCommand;
import commandtools.Command;
import commandtools.CommandExecutionException;
import commandtools.StringParameter;
import generaltools.ParsingException;
import java.util.Enumeration;
import java.util.Properties;
import rnadesign.designapp.PackageConstants;
import rnadesign.rnacontrol.Object3DGraphController;

public class ControllerCommand
extends AbstractCommand {
    public static final String COMMAND_NAME = "controller";
    private Object3DGraphController controller;
    private Properties properties = new Properties();
    public static final String MIN_LENGTH_STRING = "import-stem-length-min";
    public static final String RENAME_STRAND_STRING = "rename-strands";

    public ControllerCommand(Object3DGraphController controller) {
        super(COMMAND_NAME);
        assert (controller != null);
        this.controller = controller;
    }

    @Override
    public Object cloneDeep() {
        ControllerCommand command = new ControllerCommand(this.controller);
        this.properties = this.properties;
        for (int i = 0; i < this.getParameterCount(); ++i) {
            command.addParameter((Command)this.getParameter(i).cloneDeep());
        }
        return command;
    }

    @Override
    public String getName() {
        return COMMAND_NAME;
    }

    private String helpOutput() {
        return "Direct setting and querying of controller variables and status. Correct usage: controller [import-stem-length-min=value]  [rename-strands=true|false]";
    }

    @Override
    public String getShortHelpText() {
        return this.helpOutput();
    }

    @Override
    public String getLongHelpText() {
        String helpText = "\"controller\" Command Manual" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "NAME" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "SYNOPSIS" + PackageConstants.NEWLINE + "     " + this.helpOutput();
        return helpText;
    }

    @Override
    public void executeWithoutUndo() throws CommandExecutionException {
        this.prepareReadout();
        Enumeration<?> keys = this.properties.propertyNames();
        System.out.println("Using controller directives: " + this.properties);
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            try {
                if (key.equals(MIN_LENGTH_STRING)) {
                    this.controller.setImportStemLengthMin(Integer.parseInt(this.properties.getProperty(key)));
                    continue;
                }
                if (key.equals(RENAME_STRAND_STRING)) {
                    boolean flag = StringParameter.parseBoolean(this.properties.getProperty(key));
                    if (flag) {
                        this.controller.getGraph().setRenameSequenceMode(2);
                        continue;
                    }
                    this.controller.getGraph().setRenameSequenceMode(0);
                    continue;
                }
                throw new CommandExecutionException("Unknown controller directive : " + key);
            }
            catch (NumberFormatException nfe) {
                throw new CommandExecutionException("Could not parse number for : " + key + " : " + this.properties.getProperty(key) + " : " + nfe.getMessage());
            }
            catch (ParsingException pe) {
                throw new CommandExecutionException("Parsing exception in controller command: " + pe.getMessage());
            }
        }
    }

    @Override
    public Command execute() throws CommandExecutionException {
        this.executeWithoutUndo();
        return null;
    }

    private void prepareReadout() throws CommandExecutionException {
        for (int i = 0; i < this.getParameterCount(); ++i) {
            StringParameter parameter = (StringParameter)this.getParameter(i);
            assert (parameter != null);
            String value = parameter.getValue();
            String name = parameter.getName();
            if (name == null || name.length() == 0) {
                throw new CommandExecutionException("Only named parameters excepted in controller command: " + this.getParameter(i));
            }
            this.properties.setProperty(name, value);
        }
    }
}

