/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp;

import commandtools.AbstractCommand;
import commandtools.Command;
import commandtools.CommandExecutionException;
import commandtools.StringParameter;
import java.util.HashSet;
import java.util.Set;
import rnadesign.designapp.PackageConstants;
import rnadesign.rnacontrol.Object3DGraphController;
import rnadesign.rnacontrol.Object3DGraphControllerException;

public class EndingCommand
extends AbstractCommand {
    public static final String COMMAND_NAME = "ending";
    private Object3DGraphController controller;
    private String name;
    private String ending;
    private Set<String> allowedNames;
    private Set<String> forbiddenNames;

    public EndingCommand(Object3DGraphController controller) {
        super(COMMAND_NAME);
        assert (controller != null);
        this.controller = controller;
    }

    @Override
    public Object cloneDeep() {
        EndingCommand command = new EndingCommand(this.controller);
        command.name = this.name;
        command.ending = this.ending;
        command.allowedNames = this.allowedNames;
        command.forbiddenNames = this.forbiddenNames;
        for (int i = 0; i < this.getParameterCount(); ++i) {
            command.addParameter((Command)this.getParameter(i).cloneDeep());
        }
        return command;
    }

    @Override
    public String getName() {
        return COMMAND_NAME;
    }

    private String helpOutput() {
        return "Correct usage: ending [name=NAME] [ending=ENDING] [ allowed=Atom3D,Nucleotide3D | forbidden=RnaStrand]";
    }

    @Override
    public String getShortHelpText() {
        return this.helpOutput();
    }

    @Override
    public String getLongHelpText() {
        String helpText = "\"ending\" Command Manual" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "NAME" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "SYNOPSIS" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + " [options]" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "DESCRIPTION" + PackageConstants.NEWLINE + "     Adds an ending to the name of all objects of a subtree. The options allowed and forbidden can specify the required object classes to which command is applied." + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "OPTIONS" + PackageConstants.NEWLINE;
        helpText = helpText + "     name=value     : specify name of subtree for which ending is to be added." + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "     ending=value   : value of ending to be added" + PackageConstants.NEWLINE;
        helpText = helpText + "     allowed=Classname[,Classname[...]]" + PackageConstants.NEWLINE + "          example: Atom3D,Nucleotide3D" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "     forbidden=Classname[,Classname[...]]" + PackageConstants.NEWLINE + "          example: RnaStrand" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        return helpText;
    }

    @Override
    public void executeWithoutUndo() throws CommandExecutionException {
        this.prepareReadout();
        if (this.name != null) {
            try {
                this.controller.getGraph().addEnding(this.name, this.ending, this.allowedNames, this.forbiddenNames);
            }
            catch (Object3DGraphControllerException gce) {
                throw new CommandExecutionException(gce.getMessage());
            }
        } else {
            throw new CommandExecutionException("No name specified!");
        }
    }

    @Override
    public Command execute() throws CommandExecutionException {
        this.executeWithoutUndo();
        return null;
    }

    private void prepareReadout() throws CommandExecutionException {
        StringParameter forbiddenParameter;
        StringParameter allowedParameter;
        StringParameter endingParameter;
        StringParameter nameParameter = (StringParameter)this.getParameter("name");
        if (nameParameter != null) {
            this.name = nameParameter.getValue();
        }
        if ((endingParameter = (StringParameter)this.getParameter(COMMAND_NAME)) != null) {
            this.ending = endingParameter.getValue();
        }
        if ((allowedParameter = (StringParameter)this.getParameter("allowed")) != null) {
            String[] allowedNamesRaw = allowedParameter.getValue().split(",");
            this.allowedNames = new HashSet<String>();
            for (String s : allowedNamesRaw) {
                this.allowedNames.add(s);
            }
        }
        if ((forbiddenParameter = (StringParameter)this.getParameter("forbidden")) != null) {
            String[] forbiddenNamesRaw;
            for (String s : forbiddenNamesRaw = forbiddenParameter.getValue().split(",")) {
                this.forbiddenNames.add(s);
            }
        }
    }
}

