/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp;

import commandtools.AbstractCommand;
import commandtools.Command;
import commandtools.CommandExecutionException;
import commandtools.StringParameter;
import generaltools.ParsingException;
import java.util.ArrayList;
import java.util.List;
import rnadesign.designapp.PackageConstants;
import rnadesign.rnacontrol.Object3DGraphController;
import rnadesign.rnacontrol.Object3DGraphControllerException;

public class GenerateJunctionDBConstraintCommand
extends AbstractCommand {
    public static final String COMMAND_NAME = "genjunctiondbconstraint";
    private Object3DGraphController controller;
    private List<String> branchNames = new ArrayList<String>();
    private String name = "dbjunction";
    private boolean kissingLoopMode = false;

    public GenerateJunctionDBConstraintCommand(Object3DGraphController controller) {
        super(COMMAND_NAME);
        assert (controller != null);
        this.controller = controller;
    }

    @Override
    public Object cloneDeep() {
        GenerateJunctionDBConstraintCommand command = new GenerateJunctionDBConstraintCommand(this.controller);
        command.branchNames.addAll(this.branchNames);
        command.kissingLoopMode = this.kissingLoopMode;
        command.name = this.name;
        for (int i = 0; i < this.getParameterCount(); ++i) {
            command.addParameter((Command)this.getParameter(i).cloneDeep());
        }
        return command;
    }

    @Override
    public String getName() {
        return COMMAND_NAME;
    }

    private String helpOutput() {
        return "Correct usage: genjunctiondbconstraint name hd=branch1,branch2,[branch3 ...] kl=false|true";
    }

    @Override
    public String getShortHelpText() {
        return this.helpOutput();
    }

    @Override
    public String getLongHelpText() {
        String helpText = "\"genjunctiondbconstraint\" Command Manual" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "NAME" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "SYNOPSIS" + PackageConstants.NEWLINE + "     " + COMMAND_NAME;
        helpText = helpText + "name : name of constraint to be generated" + PackageConstants.NEWLINE;
        helpText = helpText + "hd=branch1,branch2,[branch3 ...]   : specifies helix ends (class BranchDescriptor3D)." + PackageConstants.NEWLINE;
        helpText = helpText + "kl=false|true      : specifies if this is a junction (false) or a kissing-loop (true). Default: false." + PackageConstants.NEWLINE;
        helpText = helpText + "Generates a junction-constraint by specifying helix ends (class BranchDescriptor3D) pointing away from junction" + PackageConstants.NEWLINE;
        helpText = helpText + this.getShortHelpText();
        return helpText;
    }

    @Override
    public void executeWithoutUndo() throws CommandExecutionException {
        this.prepareReadout();
        try {
            this.controller.addJunctionDBConstraintLink(this.name, this.branchNames, this.kissingLoopMode);
        }
        catch (Object3DGraphControllerException e) {
            throw new CommandExecutionException(e.getMessage());
        }
    }

    @Override
    public Command execute() throws CommandExecutionException {
        this.executeWithoutUndo();
        return null;
    }

    private void prepareReadout() throws CommandExecutionException {
        if (this.getParameterCount() < 3) {
            throw new CommandExecutionException("Syntax error in command genjunctiondbconstraint . At least three parameter have to be specified (name, helix1, helix2). See help text.");
        }
        StringParameter p = (StringParameter)this.getParameter(0);
        this.name = p.getValue();
        p = (StringParameter)this.getParameter("kl");
        if (p != null) {
            try {
                this.kissingLoopMode = p.parseBoolean();
            }
            catch (ParsingException pe) {
                throw new CommandExecutionException("Error parsing boolean (true|false) in parameter kl: " + pe.getMessage());
            }
        }
        if ((p = (StringParameter)this.getParameter("hd")) != null) {
            String[] words = p.getValue().split(",");
            if (words.length < 2) {
                throw new CommandExecutionException("At least two helix descriptors have to be specified in opion: hd");
            }
            for (String word : words) {
                this.branchNames.add(word);
            }
        } else {
            throw new CommandExecutionException("Missing mandatory parameter: hd");
        }
    }
}

