/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp;

import commandtools.AbstractCommand;
import commandtools.Command;
import commandtools.CommandExecutionException;
import commandtools.StringParameter;
import generaltools.ParsingException;
import java.util.ArrayList;
import java.util.List;
import rnadesign.designapp.PackageConstants;
import rnadesign.rnacontrol.Object3DGraphController;
import rnadesign.rnacontrol.Object3DGraphControllerException;
import rnadesign.rnamodel.DBElementDescriptor;

public class GrowGraphCommand
extends AbstractCommand {
    public static final String COMMAND_NAME = "growgraph";
    private Object3DGraphController controller;
    private List<DBElementDescriptor> blockList = new ArrayList<DBElementDescriptor>();
    private boolean buildMode = true;
    private String rootName = "root";
    private String nameBase = "g_";
    private int generationCount = 5;
    private int maxBlocks = 3;
    private int maxConnections = 4;
    private int helixVariation = 4;
    private double ringClosureLimit = 15.0;

    public GrowGraphCommand(Object3DGraphController controller) {
        super(COMMAND_NAME);
        assert (controller != null);
        this.controller = controller;
    }

    @Override
    public Object cloneDeep() {
        GrowGraphCommand command = new GrowGraphCommand(this.controller);
        command.buildMode = this.buildMode;
        command.rootName = new String(this.rootName);
        command.nameBase = new String(this.nameBase);
        command.blockList = this.cloneBlockList();
        command.generationCount = this.generationCount;
        command.maxBlocks = this.maxBlocks;
        command.maxConnections = this.maxConnections;
        command.helixVariation = this.helixVariation;
        command.ringClosureLimit = this.ringClosureLimit;
        for (int i = 0; i < this.getParameterCount(); ++i) {
            command.addParameter((Command)this.getParameter(i).cloneDeep());
        }
        return command;
    }

    private List<DBElementDescriptor> cloneBlockList() {
        if (this.blockList == null) {
            return null;
        }
        ArrayList<DBElementDescriptor> result = new ArrayList<DBElementDescriptor>();
        for (int i = 0; i < this.blockList.size(); ++i) {
            result.add(this.blockList.get(i));
        }
        return result;
    }

    @Override
    public String getName() {
        return COMMAND_NAME;
    }

    private String helpOutput() {
        return "Correct usage: growgraph blocks=j|k,order,index[;j|k,order,index] [block-max=number][build=true|false][conn-max=number][pos=x,y,z] [gen=number][name=name][ring-limit=value][root=name][var=number]";
    }

    @Override
    public String getShortHelpText() {
        return this.helpOutput();
    }

    @Override
    public String getLongHelpText() {
        String helpText = "\"growgraph\" Command Manual" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "NAME" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "SYNOPSIS" + PackageConstants.NEWLINE + "     " + this.helpOutput();
        helpText = helpText + "DESCRIPTION" + PackageConstants.NEWLINE + "     This command generates a set of simulated self-assembly structures that are compatible with a supplied graph structure. See also at options for grow command." + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        return helpText;
    }

    @Override
    public void executeWithoutUndo() throws CommandExecutionException {
        this.prepareReadout();
        try {
            this.resultProperties = this.controller.growBuildingBlocksFramework(this.rootName, this.nameBase, this.generationCount, this.blockList, this.maxBlocks, this.maxConnections, this.helixVariation, this.buildMode, this.ringClosureLimit);
            log.info("Result of grow graph command: " + this.resultProperties);
        }
        catch (Object3DGraphControllerException e) {
            throw new CommandExecutionException(e.getMessage());
        }
    }

    @Override
    public Command execute() throws CommandExecutionException {
        this.executeWithoutUndo();
        return null;
    }

    private void prepareReadout() throws CommandExecutionException {
        if (this.getParameterCount() == 0) {
            throw new CommandExecutionException(this.helpOutput());
        }
        try {
            StringParameter ringPdbLimitName;
            StringParameter maxConnectionsName;
            StringParameter varName;
            StringParameter maxBlockName;
            StringParameter genName;
            StringParameter buildName;
            StringParameter pName;
            StringParameter pRoot;
            StringParameter pBlocks = (StringParameter)this.getParameter("blocks");
            if (pBlocks != null) {
                this.readoutBlocks(pBlocks.getValue());
            }
            if ((pRoot = (StringParameter)this.getParameter("root")) != null) {
                this.rootName = pRoot.getValue();
            }
            if ((pName = (StringParameter)this.getParameter("name")) != null) {
                this.nameBase = pName.getValue();
            }
            if ((buildName = (StringParameter)this.getParameter("build")) != null) {
                this.buildMode = buildName.parseBoolean();
            }
            if ((genName = (StringParameter)this.getParameter("gen")) != null) {
                this.generationCount = Integer.parseInt(genName.getValue());
            }
            if ((maxBlockName = (StringParameter)this.getParameter("block-max")) != null) {
                this.maxBlocks = Integer.parseInt(maxBlockName.getValue());
            }
            if ((varName = (StringParameter)this.getParameter("var")) != null) {
                this.helixVariation = Integer.parseInt(varName.getValue());
            }
            if ((maxConnectionsName = (StringParameter)this.getParameter("conn-max")) != null) {
                this.maxConnections = Integer.parseInt(maxConnectionsName.getValue());
            }
            if ((ringPdbLimitName = (StringParameter)this.getParameter("ring-limit")) != null) {
                this.ringClosureLimit = Double.parseDouble(ringPdbLimitName.getValue());
            }
        }
        catch (ParsingException pe) {
            throw new CommandExecutionException("Parsing exception in growgraph command: " + pe.getMessage());
        }
        catch (NumberFormatException nfe) {
            throw new CommandExecutionException("Number format exception while parsing number of base pairs (option bp): " + nfe.getMessage());
        }
    }

    private void readoutBlock(String block, int descriptorId) throws CommandExecutionException {
        if (block == null || block.length() == 0) {
            throw new CommandExecutionException("Error parsing building blocks option. Insufficient block description.");
        }
        String[] words = block.split(",");
        if (words.length != 3) {
            throw new CommandExecutionException("Error parsing building block: 4 elements expected for each block descriptor.");
        }
        int blockType = 0;
        int id = 0;
        int order = 0;
        if (words[0].equals("j")) {
            blockType = 1;
        } else if (words[0].equals("k")) {
            blockType = 2;
        } else {
            throw new CommandExecutionException("Unknown building block type: " + words[0]);
        }
        try {
            order = Integer.parseInt(words[1]);
            id = Integer.parseInt(words[2]) - 1;
        }
        catch (NumberFormatException nfe) {
            throw new CommandExecutionException("Grow command: Error parsing number: " + nfe.getMessage());
        }
        DBElementDescriptor element = new DBElementDescriptor(order, id, blockType, descriptorId);
        this.blockList.add(element);
    }

    private void readoutBlocks(String blocks) throws CommandExecutionException {
        if (blocks == null || blocks.length() == 0) {
            throw new CommandExecutionException("Error parsing building blocks option.");
        }
        String[] words = blocks.split(";");
        for (int i = 0; i < words.length; ++i) {
            this.readoutBlock(words[i], i);
        }
    }
}

