/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp;

import commandtools.AbstractCommand;
import commandtools.BadSyntaxException;
import commandtools.Command;
import commandtools.CommandExecutionException;
import commandtools.StringParameter;
import commandtools.UnknownCommandException;
import java.io.PrintStream;
import rnadesign.designapp.NanoTilerInterpreter;
import rnadesign.designapp.PackageConstants;

public class ManCommand
extends AbstractCommand {
    public static final String COMMAND_NAME = "man";
    private NanoTilerInterpreter interpreter;
    private PrintStream ps;
    private String helpCommand;

    public ManCommand(PrintStream ps, NanoTilerInterpreter interpreter) {
        super(COMMAND_NAME);
        assert (interpreter != null);
        assert (ps != null);
        this.ps = ps;
        this.interpreter = interpreter;
    }

    @Override
    public Object cloneDeep() {
        ManCommand command = new ManCommand(this.ps, this.interpreter);
        for (int i = 0; i < this.getParameterCount(); ++i) {
            command.addParameter((Command)this.getParameter(i).cloneDeep());
        }
        return command;
    }

    @Override
    public String getName() {
        return COMMAND_NAME;
    }

    private String helpOutput() {
        return "Correct usage: man command";
    }

    @Override
    public String getShortHelpText() {
        return this.helpOutput();
    }

    @Override
    public String getLongHelpText() {
        String helpText = "\"man\" Command Manual" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "NAME" + PackageConstants.NEWLINE + "     man" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "SYNOPSIS" + PackageConstants.NEWLINE + "     man COMMAND" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "DESCRIPTION" + PackageConstants.NEWLINE + "     Man command provides detailed text explanation for COMMAND.";
        helpText = helpText + PackageConstants.NEWLINE + "     By default, man prints the available commands.";
        return helpText;
    }

    @Override
    public void executeWithoutUndo() throws CommandExecutionException {
        this.prepareReadout();
        this.ps.println(this.getOutput(this.helpCommand));
    }

    private String getOutput(String helpCommand) {
        Command command = new ManCommand(this.ps, this.interpreter);
        try {
            try {
                command = this.interpreter.interpretLine(helpCommand);
            }
            catch (UnknownCommandException ue) {
                log.severe("Unknown command!: " + ue.getMessage());
                return null;
            }
        }
        catch (BadSyntaxException e) {
            log.severe("Bad syntax! : " + e.getMessage());
            return null;
        }
        return command.getLongHelpText();
    }

    @Override
    public Command execute() throws CommandExecutionException {
        this.executeWithoutUndo();
        return null;
    }

    private void prepareReadout() throws CommandExecutionException {
        if (this.getParameterCount() == 0) {
            throw new CommandExecutionException(this.helpOutput());
        }
        if (this.getParameterCount() != 1) {
            throw new CommandExecutionException(this.helpOutput());
        }
        StringParameter p0 = (StringParameter)this.getParameter(0);
        this.helpCommand = p0.toString();
    }
}

