/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp;

import commandtools.AbstractCommand;
import commandtools.Command;
import commandtools.CommandExecutionException;
import commandtools.StringParameter;
import rnadesign.designapp.PackageConstants;
import rnadesign.rnacontrol.Object3DGraphController;
import tools3d.objects3d.CoordinateSystem3D;

public class OrientCommand
extends AbstractCommand {
    public static final String COMMAND_NAME = "orient";
    private Object3DGraphController controller;
    private String name;
    private String className = "Atom3D";

    public OrientCommand(Object3DGraphController controller) {
        super(COMMAND_NAME);
        assert (controller != null);
        this.controller = controller;
    }

    @Override
    public Object cloneDeep() {
        OrientCommand command = new OrientCommand(this.controller);
        command.name = this.name;
        command.className = this.className;
        for (int i = 0; i < this.getParameterCount(); ++i) {
            command.addParameter((Command)this.getParameter(i).cloneDeep());
        }
        return command;
    }

    @Override
    public String getName() {
        return COMMAND_NAME;
    }

    private String helpOutput() {
        return "Correct usage: orient [name=<OBJECTNAME>] [class=CLASSNAME]" + PackageConstants.NEWLINE + " with typical CLASSNAME values of Atom3D, RnaStrand3D and object names of root.A or 1.1.5";
    }

    @Override
    public String getShortHelpText() {
        return this.helpOutput();
    }

    @Override
    public String getLongHelpText() {
        String helpText = "\"orient\" Command Manual" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "NAME" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "SYNOPSIS" + PackageConstants.NEWLINE + "     " + this.helpOutput();
        helpText = helpText + "DESCRIPTION" + PackageConstants.NEWLINE + "     Normalized orientation along principal axis of moments of intertia tensor." + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "OPTIONS" + PackageConstants.NEWLINE;
        helpText = helpText + "     name=OBJECT" + PackageConstants.NEWLINE + "          Only print the sub-tree from node with this name." + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "     class=OBJECT" + PackageConstants.NEWLINE + "          Atom3D, Nucleotide3D. Show only this type." + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        return helpText;
    }

    @Override
    public void executeWithoutUndo() throws CommandExecutionException {
        this.prepareReadout();
        CoordinateSystem3D cs = this.controller.getGraph().applyNormalizedOrientation(this.name, this.className);
        System.out.println("Applied coordinate system transformation: " + cs);
    }

    @Override
    public Command execute() throws CommandExecutionException {
        this.executeWithoutUndo();
        return null;
    }

    private void prepareReadout() throws CommandExecutionException {
        StringParameter classNameParameter;
        StringParameter nameParameter = (StringParameter)this.getParameter("name");
        if (nameParameter != null) {
            this.name = nameParameter.getValue();
        }
        if ((classNameParameter = (StringParameter)this.getParameter("class")) != null) {
            this.className = classNameParameter.getValue();
        }
    }
}

