/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp;

import commandtools.AbstractCommand;
import commandtools.Command;
import commandtools.CommandExecutionException;
import commandtools.StringParameter;
import rnadesign.designapp.PackageConstants;
import rnadesign.rnacontrol.Object3DGraphController;
import rnadesign.rnacontrol.Object3DGraphControllerException;

public class RenameCommand
extends AbstractCommand {
    public static final String COMMAND_NAME = "rename";
    private Object3DGraphController controller;
    private String originalName;
    private String newName;

    public RenameCommand(Object3DGraphController controller) {
        super(COMMAND_NAME);
        assert (controller != null);
        this.controller = controller;
    }

    @Override
    public Object cloneDeep() {
        RenameCommand command = new RenameCommand(this.controller);
        command.originalName = this.originalName;
        command.newName = this.newName;
        for (int i = 0; i < this.getParameterCount(); ++i) {
            command.addParameter((Command)this.getParameter(i).cloneDeep());
        }
        return command;
    }

    @Override
    public String getName() {
        return COMMAND_NAME;
    }

    private String helpOutput() {
        return "Correct usage: rename originalName newName " + PackageConstants.NEWLINE + "or rename selected: " + COMMAND_NAME + " newName";
    }

    @Override
    public String getShortHelpText() {
        return this.helpOutput();
    }

    @Override
    public String getLongHelpText() {
        String helpText = "\"rename\" Command Manual" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "NAME" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "SYNOPSIS" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + " ORIGINALNAME NEWNAME" + PackageConstants.NEWLINE + "     or rename selected: " + COMMAND_NAME + " NEWNAME" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "DESCRIPTION" + PackageConstants.NEWLINE + "     Rename command allows user to rename an object." + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        return helpText;
    }

    @Override
    public void executeWithoutUndo() throws CommandExecutionException {
        this.prepareReadout();
        if (this.originalName != null) {
            try {
                String oldSelection = null;
                try {
                    oldSelection = this.controller.getGraph().getSelectionRoot().getName();
                }
                catch (NullPointerException e) {
                    log.info("Nothing selected");
                }
                this.controller.getGraph().selectByFullName(this.originalName);
                this.controller.getGraph().rename(this.newName);
                if (oldSelection != null) {
                    this.controller.getGraph().selectByFullName(oldSelection);
                }
                this.controller.getGraph().deselectAll();
            }
            catch (Object3DGraphControllerException ce) {
                throw new CommandExecutionException(ce.getMessage());
            }
        } else if (this.newName != null) {
            try {
                this.controller.getGraph().rename(this.newName);
            }
            catch (Object3DGraphControllerException ce) {
                throw new CommandExecutionException(ce.getMessage());
            }
        } else {
            throw new CommandExecutionException("No name specified!");
        }
    }

    @Override
    public Command execute() throws CommandExecutionException {
        this.executeWithoutUndo();
        return null;
    }

    private void prepareReadout() throws CommandExecutionException {
        if (this.getParameterCount() == 1) {
            StringParameter p0 = (StringParameter)this.getParameter(0);
            this.newName = p0.getValue();
        } else if (this.getParameterCount() == 2) {
            StringParameter p0 = (StringParameter)this.getParameter(0);
            this.originalName = p0.getValue();
            StringParameter p1 = (StringParameter)this.getParameter(1);
            this.newName = p1.getValue();
        } else {
            throw new CommandExecutionException(this.helpOutput());
        }
    }
}

