/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp;

import commandtools.AbstractCommand;
import commandtools.Command;
import commandtools.CommandExecutionException;
import commandtools.StringParameter;
import generaltools.ParsingException;
import rnadesign.designapp.PackageConstants;
import rnadesign.rnacontrol.Object3DGraphController;

public class ResiduePropertyCommand
extends AbstractCommand {
    public static final String COMMAND_NAME = "resproperty";
    private Object3DGraphController controller;
    private String residueNames;
    private String value;

    public ResiduePropertyCommand(Object3DGraphController controller) {
        super(COMMAND_NAME);
        assert (controller != null);
        this.controller = controller;
    }

    @Override
    public Object cloneDeep() {
        ResiduePropertyCommand command = new ResiduePropertyCommand(this.controller);
        command.residueNames = this.residueNames;
        command.value = this.value;
        for (int i = 0; i < this.getParameterCount(); ++i) {
            command.addParameter((Command)this.getParameter(i).cloneDeep());
        }
        return command;
    }

    @Override
    public String getName() {
        return COMMAND_NAME;
    }

    private String helpOutput() {
        return "Correct usage: resproperty residueNames residuenames status";
    }

    @Override
    public String getShortHelpText() {
        return this.helpOutput();
    }

    @Override
    public String getLongHelpText() {
        String helpText = "\"resproperty\" Command Manual" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "NAME" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "SYNOPSIS" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + " residuenames status" + PackageConstants.NEWLINE + "     or rename selected: " + COMMAND_NAME + " NEWNAME" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "DESCRIPTION" + PackageConstants.NEWLINE + "     Changes status of residues. Example: resproperty A:3-5;B:9,11-15 adhoc . Instead of adhoc, also fragment or optimized can be used." + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        return helpText;
    }

    @Override
    public void executeWithoutUndo() throws CommandExecutionException {
        this.prepareReadout();
        if (this.residueNames != null) {
            try {
                this.controller.getSequences().setResiduesProperty(this.residueNames, "sequence_status", this.value);
            }
            catch (ParsingException pe) {
                throw new CommandExecutionException(pe.getMessage());
            }
        }
    }

    @Override
    public Command execute() throws CommandExecutionException {
        this.executeWithoutUndo();
        return null;
    }

    private void prepareReadout() throws CommandExecutionException {
        if (this.getParameterCount() == 1) {
            StringParameter p0 = (StringParameter)this.getParameter(0);
            this.value = p0.getValue();
        } else if (this.getParameterCount() == 2) {
            StringParameter p0 = (StringParameter)this.getParameter(0);
            this.residueNames = p0.getValue();
            StringParameter p1 = (StringParameter)this.getParameter(1);
            this.value = p1.getValue();
        } else {
            throw new CommandExecutionException(this.helpOutput());
        }
    }
}

