/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp;

import commandtools.AbstractCommand;
import commandtools.Command;
import commandtools.CommandExecutionException;
import commandtools.StringParameter;
import java.io.PrintStream;
import java.util.Properties;
import rnadesign.designapp.PackageConstants;
import rnadesign.rnacontrol.Object3DGraphController;
import rnadesign.rnamodel.BranchDescriptor3D;
import rnadesign.rnamodel.SimpleStrandJunctionDB;
import tools3d.objects3d.Object3D;

public class ScoreFitCommand
extends AbstractCommand {
    public static final String COMMAND_NAME = "scorefit";
    private PrintStream ps;
    private Object3DGraphController controller;
    private String bScaff1Name;
    private String bScaff2Name;
    private String bLoop1Name;
    private String bLoop2Name;
    private int n1 = 0;
    private int n2 = 0;
    private double angleWeight = 1.0;

    public ScoreFitCommand(PrintStream ps, Object3DGraphController controller) {
        super(COMMAND_NAME);
        assert (controller != null);
        this.controller = controller;
        this.ps = ps;
    }

    @Override
    public Object cloneDeep() {
        ScoreFitCommand command = new ScoreFitCommand(this.ps, this.controller);
        command.name = this.name;
        command.bScaff1Name = this.bScaff1Name;
        command.bScaff2Name = this.bScaff2Name;
        command.bLoop1Name = this.bLoop1Name;
        command.bLoop2Name = this.bLoop2Name;
        command.n1 = this.n1;
        command.n2 = this.n2;
        for (int i = 0; i < this.getParameterCount(); ++i) {
            command.addParameter((Command)this.getParameter(i).cloneDeep());
        }
        return command;
    }

    @Override
    public String getName() {
        return COMMAND_NAME;
    }

    private String helpOutput() {
        return "Correct usage: scorefit (j|k) branchdescriporScaffoldName1 branchdescriptorScaffoldName2 branchdescriptorLoopName1 branchdescriptorLoopName2 [n1=val][n2=val]";
    }

    @Override
    public String getShortHelpText() {
        return this.helpOutput();
    }

    @Override
    public String getLongHelpText() {
        String helpText = "\"scorefit\" Command Manual" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "NAME" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "SYNOPSIS" + PackageConstants.NEWLINE + "     " + this.helpOutput() + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "DESCRIPTION" + PackageConstants.NEWLINE + "     Returns score of 2-way junctions in gap." + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        return helpText;
    }

    private void printEntry(PrintStream ps, Properties result) {
        ps.println("" + result);
    }

    @Override
    public void executeWithoutUndo() throws CommandExecutionException {
        this.prepareReadout();
        Object3D obj1 = this.controller.getGraph().findByFullName(this.bScaff1Name);
        Object3D obj2 = this.controller.getGraph().findByFullName(this.bScaff2Name);
        Object3D obj3 = this.controller.getGraph().findByFullName(this.bLoop1Name);
        Object3D obj4 = this.controller.getGraph().findByFullName(this.bLoop2Name);
        if (obj1 == null) {
            throw new CommandExecutionException("Could not find object 1 : " + this.bScaff1Name);
        }
        if (obj2 == null) {
            throw new CommandExecutionException("Could not find object 2 : " + this.bScaff2Name);
        }
        if (obj3 == null) {
            throw new CommandExecutionException("Could not find object 3 : " + this.bLoop1Name);
        }
        if (obj4 == null) {
            throw new CommandExecutionException("Could not find object 4 : " + this.bLoop2Name);
        }
        if (!(obj1 instanceof BranchDescriptor3D)) {
            throw new CommandExecutionException("Object 1 is not of type BranchDescriptor3D : " + this.bScaff1Name);
        }
        if (!(obj2 instanceof BranchDescriptor3D)) {
            throw new CommandExecutionException("Object 2 is not of type BranchDescriptor3D : " + this.bScaff2Name);
        }
        if (!(obj3 instanceof BranchDescriptor3D)) {
            throw new CommandExecutionException("Object 3 is not of type BranchDescriptor3D : " + this.bLoop1Name);
        }
        if (!(obj4 instanceof BranchDescriptor3D)) {
            throw new CommandExecutionException("Object 4 is not of type BranchDescriptor3D : " + this.bLoop2Name);
        }
        BranchDescriptor3D b1 = (BranchDescriptor3D)obj1;
        BranchDescriptor3D b2 = (BranchDescriptor3D)obj2;
        BranchDescriptor3D b3 = (BranchDescriptor3D)obj3;
        BranchDescriptor3D b4 = (BranchDescriptor3D)obj4;
        this.resultProperties = SimpleStrandJunctionDB.scoreJunctionLoopFit(b1, b2, b3, b4, this.n1, this.n2, this.angleWeight);
        this.ps.println(this.resultProperties);
    }

    @Override
    public Command execute() throws CommandExecutionException {
        this.executeWithoutUndo();
        return null;
    }

    private void prepareReadout() throws CommandExecutionException {
        if (this.getParameterCount() < 4) {
            throw new CommandExecutionException(this.helpOutput());
        }
        this.bScaff1Name = ((StringParameter)this.getParameter(0)).getValue();
        this.bScaff2Name = ((StringParameter)this.getParameter(1)).getValue();
        this.bLoop1Name = ((StringParameter)this.getParameter(2)).getValue();
        this.bLoop2Name = ((StringParameter)this.getParameter(3)).getValue();
        try {
            this.n1 = this.parse("n1", this.n1);
            this.n2 = this.parse("n2", this.n2);
        }
        catch (NumberFormatException nfe) {
            throw new CommandExecutionException(nfe.getMessage());
        }
    }
}

