/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp;

import commandtools.AbstractCommand;
import commandtools.Command;
import commandtools.CommandExecutionException;
import commandtools.StringParameter;
import rnadesign.designapp.PackageConstants;
import rnadesign.rnacontrol.Object3DGraphController;
import rnadesign.rnacontrol.Object3DGraphControllerException;
import tools3d.Vector3D;
import tools3d.objects3d.Object3DTools;

public class SynthCommand
extends AbstractCommand {
    public static final String COMMAND_NAME = "synth";
    private double x = 0.0;
    private double y = 0.0;
    private double z = 0.0;
    private String className;
    private String name;
    private String parentName;
    private double scalex = 1.0;
    private double scaley = 1.0;
    private double scalez = 1.0;
    private Object3DGraphController controller;

    public SynthCommand(Object3DGraphController controller) {
        super(COMMAND_NAME);
        assert (controller != null);
        this.controller = controller;
    }

    @Override
    public Object cloneDeep() {
        SynthCommand command = new SynthCommand(this.controller);
        command.x = this.x;
        command.y = this.y;
        command.z = this.z;
        command.className = this.className;
        command.name = this.name;
        command.parentName = this.parentName;
        command.scalex = this.scalex;
        command.scaley = this.scaley;
        command.scalez = this.scalez;
        for (int i = 0; i < this.getParameterCount(); ++i) {
            command.addParameter((Command)this.getParameter(i).cloneDeep());
        }
        return command;
    }

    private String helpOutput() {
        return "Correct usage: synth classname|simple name parentfullname x y z [scalex=val][scaley=val][scalez=val]";
    }

    @Override
    public String getShortHelpText() {
        return this.helpOutput();
    }

    @Override
    public String getLongHelpText() {
        String helpText = "\"synth\" Command Manual" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "NAME" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "SYNOPSIS" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + " classname|simple name parentfullname x y z [scalex=val] [scaley=val] [scalez=val]" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "DESCRIPTION" + PackageConstants.NEWLINE + "     Synth command synthesizes an object of specified type at a specified location." + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        return helpText;
    }

    @Override
    public void executeWithoutUndo() throws CommandExecutionException {
        assert (this.controller != null);
        this.prepareReadout();
        try {
            this.controller.getGraph().synthesizeObject(this.className, new Vector3D(this.scalex * this.x, this.scaley * this.y, this.scalez * this.z), this.name, this.parentName);
        }
        catch (Object3DGraphControllerException ce) {
            throw new CommandExecutionException("Error in synth command: " + ce.getMessage());
        }
    }

    @Override
    public Command execute() throws CommandExecutionException {
        this.executeWithoutUndo();
        return null;
    }

    private void prepareReadout() throws CommandExecutionException {
        if (this.getParameterCount() < 6) {
            throw new CommandExecutionException(this.helpOutput());
        }
        StringParameter p0 = (StringParameter)this.getParameter(0);
        StringParameter p1 = (StringParameter)this.getParameter(1);
        StringParameter p2 = (StringParameter)this.getParameter(2);
        StringParameter p3 = (StringParameter)this.getParameter(3);
        StringParameter p4 = (StringParameter)this.getParameter(4);
        StringParameter p5 = (StringParameter)this.getParameter(5);
        this.className = p0.getValue();
        this.name = p1.getValue();
        if (!Object3DTools.isAllowedName(this.name)) {
            throw new CommandExecutionException("Illegal object name: " + this.name);
        }
        this.parentName = p2.getValue();
        try {
            this.x = Double.parseDouble(p3.getValue());
            this.y = Double.parseDouble(p4.getValue());
            this.z = Double.parseDouble(p5.getValue());
            StringParameter scaleXPar = (StringParameter)this.getParameter("scalex");
            StringParameter scaleYPar = (StringParameter)this.getParameter("scaley");
            StringParameter scaleZPar = (StringParameter)this.getParameter("scalez");
            if (scaleXPar != null) {
                this.scalex = Double.parseDouble(scaleXPar.getValue());
            }
            if (scaleYPar != null) {
                this.scaley = Double.parseDouble(scaleYPar.getValue());
            }
            if (scaleZPar != null) {
                this.scalez = Double.parseDouble(scaleZPar.getValue());
            }
        }
        catch (NumberFormatException nfe) {
            throw new CommandExecutionException("Bad number syntax in command rotate : " + nfe.getMessage());
        }
    }
}

