/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp;

import commandtools.AbstractCommand;
import commandtools.Command;
import commandtools.CommandExecutionException;
import commandtools.StringParameter;
import controltools.ModelChangeEvent;
import generaltools.ParsingException;
import java.io.PrintStream;
import java.util.Properties;
import java.util.logging.Logger;
import rnadesign.designapp.PackageConstants;
import rnadesign.rnacontrol.Object3DGraphController;
import rnadesign.rnacontrol.Object3DGraphControllerException;
import rnadesign.rnamodel.RnaConstants;

public class TraceRnaGraphCommand
extends AbstractCommand {
    private static Logger log = Logger.getLogger("NanoTiler_debug");
    public static final String COMMAND_NAME = "tracernagraph";
    private double kt = 10.0;
    private int helixLengthMax = 1000;
    private String name = "traced";
    private int numSteps = 100000;
    private double errorScoreLimit = 5.0;
    private Object3DGraphController controller;
    private PrintStream ps;
    private double offset = RnaConstants.JUNCTION_OFFSET;
    private double distMax = 7.0;
    private double distMin = 3.0;
    private boolean generateBridges = false;
    private String rootName = "root";
    private int verboseLevel = 1;
    private boolean modify = false;

    public TraceRnaGraphCommand(Object3DGraphController controller, PrintStream ps) {
        super(COMMAND_NAME);
        assert (controller != null);
        this.controller = controller;
        this.ps = ps;
    }

    @Override
    public Object cloneDeep() {
        TraceRnaGraphCommand command = new TraceRnaGraphCommand(this.controller, this.ps);
        command.kt = this.kt;
        command.helixLengthMax = this.helixLengthMax;
        command.name = this.name;
        command.numSteps = this.numSteps;
        command.errorScoreLimit = this.errorScoreLimit;
        command.offset = this.offset;
        command.distMax = this.distMax;
        command.distMin = this.distMin;
        command.rootName = this.rootName;
        command.verboseLevel = this.verboseLevel;
        return command;
    }

    @Override
    public void executeWithoutUndo() throws CommandExecutionException {
        assert (this.controller != null);
        this.prepareReadout();
        this.ps.println("Starting to optimize helices!");
        Object stemFitParameters = null;
        Properties properties = new Properties();
        try {
            properties = this.modify ? this.controller.traceAndModifyRnaGraph(this.rootName, this.numSteps, this.kt, this.errorScoreLimit, this.offset, this.distMax, this.distMin, this.name, this.verboseLevel) : this.controller.traceRnaGraph(this.rootName, this.numSteps, this.kt, this.errorScoreLimit, this.offset, this.distMax, this.distMin, this.name, this.verboseLevel, this.generateBridges, this.helixLengthMax);
        }
        catch (Object3DGraphControllerException gce) {
            throw new CommandExecutionException(gce.getMessage());
        }
        this.controller.refresh(new ModelChangeEvent((Object)this.controller, 4));
        this.ps.println("Helix optimization finished! Result:");
        this.ps.println(properties.toString());
        this.resultProperties = properties;
    }

    @Override
    public Command execute() throws CommandExecutionException {
        this.executeWithoutUndo();
        return null;
    }

    private void prepareReadout() throws CommandExecutionException {
        try {
            Command modParameter;
            Command nameParameter;
            Command rootParameter;
            Command bpmaxParameter;
            Command maxParameter;
            Command offsetParameter;
            Command errorLimitParameter;
            Command verboseParameter;
            Command stepsParameter;
            Command bridgeParameter;
            Command ktParameter = this.getParameter("kt");
            if (ktParameter != null) {
                this.kt = Double.parseDouble(((StringParameter)ktParameter).getValue());
            }
            if ((bridgeParameter = this.getParameter("bridge")) != null) {
                this.generateBridges = ((StringParameter)bridgeParameter).parseBoolean();
            }
            if ((stepsParameter = this.getParameter("steps")) != null) {
                this.numSteps = Integer.parseInt(((StringParameter)stepsParameter).getValue());
            }
            if ((verboseParameter = this.getParameter("verbose")) != null) {
                this.verboseLevel = Integer.parseInt(((StringParameter)verboseParameter).getValue());
            }
            if ((errorLimitParameter = this.getParameter("error")) != null) {
                this.errorScoreLimit = Double.parseDouble(((StringParameter)errorLimitParameter).getValue());
            }
            if ((offsetParameter = this.getParameter("offset")) != null) {
                this.offset = Double.parseDouble(((StringParameter)offsetParameter).getValue());
            }
            if ((maxParameter = this.getParameter("max")) != null) {
                this.distMax = Double.parseDouble(((StringParameter)maxParameter).getValue());
            }
            if ((bpmaxParameter = this.getParameter("bpmax")) != null) {
                this.helixLengthMax = Integer.parseInt(((StringParameter)bpmaxParameter).getValue());
            }
            if ((rootParameter = this.getParameter("root")) != null) {
                this.rootName = ((StringParameter)rootParameter).getValue();
            }
            if ((nameParameter = this.getParameter("name")) != null) {
                this.name = ((StringParameter)nameParameter).getValue();
            }
            if ((modParameter = this.getParameter("mod")) != null) {
                this.modify = ((StringParameter)modParameter).parseBoolean();
            }
        }
        catch (NumberFormatException nfe) {
            throw new CommandExecutionException("Bad number format detected: " + nfe.getMessage());
        }
        catch (ParsingException pe) {
            throw new CommandExecutionException("Parsing error encountered: " + pe.getMessage());
        }
    }

    @Override
    public String getShortHelpText() {
        return this.helpOutput();
    }

    @Override
    public String getLongHelpText() {
        String helpText = "\"tracernagraph\" Command Manual" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "NAME" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "SYNOPSIS" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + " [options]" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "DESCRIPTION" + PackageConstants.NEWLINE + "     Generate RNA helices that trace a 3D graph." + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "OPTIONS" + PackageConstants.NEWLINE;
        helpText = helpText + "     bpmax=1..N   : maximum number of base pairs per helix." + PackageConstants.NEWLINE;
        helpText = helpText + "     error=DOUBLE" + PackageConstants.NEWLINE + "          Set the error limit parameter." + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "     bridge=false|true : generate single-stranded connections between generated RNA helices." + PackageConstants.NEWLINE;
        helpText = helpText + "     root=STRING  : use graph at subtree with this name" + PackageConstants.NEWLINE;
        helpText = helpText + "     max=VALUE  : maximum allowed distance between helical residues of strands that are to be connected." + PackageConstants.NEWLINE;
        helpText = helpText + "     name=STRING  : base name for generated RNA structure" + PackageConstants.NEWLINE;
        helpText = helpText + "     offset=VALUE  : Length of ends not traced with helices" + PackageConstants.NEWLINE;
        return helpText;
    }

    private String helpOutput() {
        return "Correct usage: tracernagraph root=NAME [bridge=false|true][error=value] [steps=<value>] [offset=<value>] [max=<value>] [mod=false|true]";
    }
}

