/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp.rnagui;

import commandtools.CommandApplication;
import commandtools.CommandException;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.AbstractListModel;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import rnadesign.designapp.rnagui.GeneralWizard;
import rnadesign.rnacontrol.Object3DGraphController;
import rnadesign.rnamodel.BranchDescriptor3D;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.Object3DAction;
import tools3d.objects3d.Object3DActionVisitor;
import tools3d.objects3d.Object3DTools;

public class AddHelixWizard
implements GeneralWizard {
    public static final String FRAME_TITLE = "Add Helix";
    private static final Dimension TABLE_DIM = new Dimension(200, 200);
    private CommandApplication application;
    private ArrayList<BranchDescriptor3D> junctions;
    private JList branchSelector1;
    private JList branchSelector2;
    private JDialog frame;
    private boolean finished;
    private JButton add;
    private Object3DGraphController graphController;
    private int selectedIndex1 = -1;
    private int selectedIndex2 = -1;
    private JTextField bpmin;
    private JTextField bpmax;
    private ArrayList<ActionListener> actionListeners = new ArrayList();

    public AddHelixWizard(CommandApplication application) {
        this.application = application;
    }

    @Override
    public void addActionListener(ActionListener listener) {
        this.actionListeners.add(listener);
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public void launchWizard(Object3DGraphController graphController, Component parentFrame) {
        this.graphController = graphController;
        this.frame = new JDialog(parentFrame instanceof Frame ? (Frame)parentFrame : null, FRAME_TITLE, true);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                AddHelixWizard.this.finished = true;
            }
        });
        this.junctions = new ArrayList();
        Object3DActionVisitor visitor = new Object3DActionVisitor(graphController.getGraph().getGraph(), new Object3DAction(){

            @Override
            public void act(Object3D obj) {
                if (obj instanceof BranchDescriptor3D) {
                    AddHelixWizard.this.junctions.add((BranchDescriptor3D)obj);
                }
            }
        });
        visitor.nextToEnd();
        if (this.junctions.size() <= 1) {
            JOptionPane.showMessageDialog(null, "No branch descriptors available to add helices to.");
            return;
        }
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        JLabel label = new JLabel("<html><h2>Select first branch");
        label.setAlignmentX(0.0f);
        panel.add(label);
        this.branchSelector1 = new JList(new JunctionListModel());
        this.branchSelector1.addListSelectionListener(new AddListener());
        JScrollPane pane = new JScrollPane(this.branchSelector1);
        pane.setPreferredSize(TABLE_DIM);
        panel.add(pane);
        label = new JLabel("<html><h2>Select second branch");
        label.setAlignmentX(0.0f);
        panel.add(label);
        this.branchSelector2 = new JList(new JunctionListModel());
        this.branchSelector2.addListSelectionListener(new AddListener());
        pane = new JScrollPane(this.branchSelector2);
        pane.setPreferredSize(TABLE_DIM);
        panel.add(pane);
        panel.add(Box.createVerticalStrut(15));
        JPanel bottomPanel = new JPanel();
        JButton close = new JButton("Close");
        close.addActionListener(new CloseWindowListener());
        bottomPanel.add(close);
        this.add = new JButton("Add");
        this.add.addActionListener(new AddListener());
        this.add.setEnabled(false);
        bottomPanel.add(this.add);
        panel.add(bottomPanel);
        this.frame.add(panel);
        this.frame.pack();
        this.frame.setVisible(true);
    }

    private class JunctionListModel
    extends AbstractListModel {
        private JunctionListModel() {
        }

        @Override
        public int getSize() {
            return AddHelixWizard.this.junctions.size();
        }

        @Override
        public Object getElementAt(int index) {
            return Object3DTools.getFullName((Object3D)AddHelixWizard.this.junctions.get(index));
        }
    }

    private class AddListener
    implements ActionListener,
    ListSelectionListener {
        private AddListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (AddHelixWizard.this.branchSelector1.getSelectedIndex() != -1 && AddHelixWizard.this.branchSelector2.getSelectedIndex() != -1) {
                AddHelixWizard.this.add.setEnabled(true);
            } else {
                AddHelixWizard.this.add.setEnabled(false);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (AddHelixWizard.this.branchSelector1.getSelectedIndex() == AddHelixWizard.this.branchSelector2.getSelectedIndex()) {
                JOptionPane.showMessageDialog(AddHelixWizard.this.frame, "Pleas select two different junctions");
                return;
            }
            BranchDescriptor3D branch1 = (BranchDescriptor3D)AddHelixWizard.this.junctions.get(AddHelixWizard.this.branchSelector1.getSelectedIndex());
            BranchDescriptor3D branch2 = (BranchDescriptor3D)AddHelixWizard.this.junctions.get(AddHelixWizard.this.branchSelector2.getSelectedIndex());
            String branch1Name = Object3DTools.getFullName(branch1);
            String branch2Name = Object3DTools.getFullName(branch2);
            try {
                AddHelixWizard.this.application.runScriptLine("genhelix " + branch1Name + " " + branch2Name);
            }
            catch (CommandException ex) {
                JOptionPane.showMessageDialog(AddHelixWizard.this.frame, ex.getMessage());
                return;
            }
            AddHelixWizard.this.frame.setVisible(false);
            AddHelixWizard.this.frame.dispose();
        }
    }

    private class CloseWindowListener
    implements ActionListener {
        private CloseWindowListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AddHelixWizard.this.frame.setVisible(false);
            AddHelixWizard.this.frame.dispose();
        }
    }
}

