/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp.rnagui;

import commandtools.CommandApplication;
import commandtools.CommandEvent;
import commandtools.CommandHistoryChangeListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class CommandHistoryDisplay
extends JPanel
implements CommandHistoryChangeListener {
    private List<ActionListener> actionListeners = new ArrayList<ActionListener>();
    private final Dimension dimensions = new Dimension(259, 88);
    private CommandApplication app;
    private Logger log = Logger.getLogger("NanoTiler_debug");
    private JList list;
    private JScrollPane scrollPane;
    public static final int LINES_MAX = 5;

    public CommandHistoryDisplay(CommandApplication application) {
        this.app = application;
        this.app.addCommandHistoryChangeListener(this);
        this.addComponents();
    }

    private void addComponents() {
        this.setPreferredSize(this.dimensions);
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createLineBorder(Color.black));
        this.add((Component)new JLabel("Command history"), "North");
        this.list = new JList(new Vector());
        this.scrollPane = new JScrollPane(this.list);
        this.scrollPane.setPreferredSize(this.dimensions);
        this.add((Component)this.scrollPane, "Center");
    }

    public void addActionListener(ActionListener listener) {
        this.actionListeners.add(listener);
    }

    @Override
    public void commandHistoryChanged(CommandEvent event) {
        Vector<String> history = this.app.getCommandHistory().toStringVector();
        this.list.setListData(history);
        this.setPreferredSize(this.dimensions);
        this.scrollPane.setPreferredSize(this.dimensions);
        final int end = this.scrollPane.getVerticalScrollBar().getMaximum();
        Runnable scrollToEnd = new Runnable(){

            @Override
            public void run() {
                try {
                    CommandHistoryDisplay.this.scrollPane.getVerticalScrollBar().setValue(end);
                }
                catch (Exception e) {
                    CommandHistoryDisplay.this.log.warning(e.getMessage());
                }
            }
        };
        SwingUtilities.invokeLater(scrollToEnd);
    }
}

