/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp.rnagui;

import commandtools.CommandApplication;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import rnadesign.designapp.NanoTilerInterpreter;
import rnadesign.designapp.rnagui.GeneralWizard;
import rnadesign.rnacontrol.Object3DGraphController;

public class EnvWizard
implements GeneralWizard {
    private static final int COL_SIZE = 15;
    private boolean finished = false;
    public static Logger log = Logger.getLogger("NanoTiler_debug");
    private JFrame frame = null;
    private JList resultsField;
    private JButton button;
    private Properties properties;
    private CommandApplication application;
    private NanoTilerInterpreter interpreter;
    private List<ActionListener> actionListeners = new ArrayList<ActionListener>();
    private Object3DGraphController graphController;
    private String[] variables;
    private PrintStream ps;
    public static final String FRAME_TITLE = "Environment Variables";

    public EnvWizard(CommandApplication application) {
        assert (application != null);
        this.application = application;
        this.interpreter = (NanoTilerInterpreter)application.getInterpreter();
        this.properties = this.interpreter.getVariables();
    }

    @Override
    public void addActionListener(ActionListener listener) {
        this.actionListeners.add(listener);
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    private void formatVariables() {
        Enumeration<?> names = this.properties.propertyNames();
        int countElements = 0;
        while (names.hasMoreElements()) {
            names.nextElement();
            ++countElements;
        }
        names = this.properties.propertyNames();
        this.variables = new String[countElements];
        for (int i = 0; i < this.variables.length; ++i) {
            String name = (String)names.nextElement();
            this.variables[i] = name + " = " + this.properties.getProperty(name);
        }
    }

    @Override
    public void launchWizard(Object3DGraphController graphController, Component parentFrame) {
        if (graphController == null) {
            log.info("GraphController received by launchWizard is null!");
        }
        this.graphController = graphController;
        this.frame = new JFrame(FRAME_TITLE);
        this.formatVariables();
        this.addComponents(this.frame);
        this.frame.pack();
        this.frame.setVisible(true);
    }

    public void addComponents(JFrame _frame) {
        Container f = _frame.getContentPane();
        f.setLayout(new BorderLayout());
        JPanel centerPanel = new JPanel();
        centerPanel.setPreferredSize(new Dimension(500, 200));
        centerPanel.setLayout(new BoxLayout(centerPanel, 1));
        this.resultsField = new JList<String>(this.variables);
        JScrollPane scroll = new JScrollPane(this.resultsField);
        scroll.setHorizontalScrollBarPolicy(30);
        scroll.setVerticalScrollBarPolicy(20);
        centerPanel.add(scroll);
        JPanel buttonPanel = new JPanel();
        this.button = new JButton("Done");
        this.button.addActionListener(new DoneListener());
        buttonPanel.add(this.button);
        f.add((Component)buttonPanel, "South");
        f.add((Component)centerPanel, "Center");
    }

    private class DoneListener
    implements ActionListener {
        private DoneListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            EnvWizard.this.frame.setVisible(false);
            EnvWizard.this.frame = null;
            EnvWizard.this.finished = true;
        }
    }
}

