/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp.rnagui;

import controltools.ModelChangeEvent;
import controltools.ModelChangeListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import rnadesign.designapp.rnagui.AtomColorModel;
import rnadesign.designapp.rnagui.GeneralGeometryPainter;
import rnadesign.designapp.rnagui.GeometryPainter;
import rnadesign.designapp.rnagui.GeometryPainterFactory;
import rnadesign.designapp.rnagui.GraphPanel;
import rnadesign.designapp.rnagui.NanoTilerGeometryPainterFactory;
import rnadesign.designapp.rnagui.NucleotideColorModel;
import rnadesign.designapp.rnagui.Object3DPainter;
import rnadesign.designapp.rnagui.PointPainter;
import rnadesign.designapp.rnagui.RainbowColorModel;
import rnadesign.designapp.rnagui.RnaGuiParameters;
import rnadesign.designapp.rnagui.RnaStrandColorModel;
import rnadesign.designapp.rnagui.SimplePainter;
import rnadesign.rnacontrol.CameraController;
import rnadesign.rnacontrol.Object3DGraphController;
import tools3d.GeometryColorModel;
import tools3d.Matrix3D;
import tools3d.Vector3D;

class GraphControlPanel
extends JPanel
implements HierarchyListener,
ModelChangeListener {
    public static Logger log = Logger.getLogger("NanoTiler_debug");
    JSplitPane splitPane;
    GraphPanel graphPanel;
    RnaGuiParameters params;
    private boolean paintLinks = true;
    public GeometryPainterFactory geometryPainterFactory = new NanoTilerGeometryPainterFactory();
    YSliderPanel yslider;
    XSliderPanel xslider;
    JSlider phiSlider;
    JSlider thetaSlider;
    JSlider zoomSlider;
    JTextArea selected;
    double yValue = 0.0;
    double xValue = 0.0;
    double phiValue = 0.0;
    double thetaValue = 0.0;
    double oldYValue = 0.0;
    double oldXValue = 0.0;
    double oldPhiValue = 0.0;
    double oldThetaValue = 0.0;
    double zoomFactor = 2.0;
    double dist = 10.0;
    double xDiff = 0.0;
    double yDiff = 0.0;
    double phiDiff = 0.0;
    double thetaDiff = 0.0;
    double phi = 0.0;
    double theta = 0.0;
    double zoom = 0.0;
    double psi = 0.0;
    private JCheckBox atomCheckBox;
    private JCheckBox nucleotideCheckBox;
    private JCheckBox strandCheckBox;
    private ColorModel colorModel = ColorModel.Rainbow;
    private PaintMode paintMode = PaintMode.Solid;
    JCheckBox cBox;
    JCheckBox checkBox;

    public ColorModel getPainterColorModel() {
        return this.colorModel;
    }

    public PaintMode getPaintMode() {
        return this.paintMode;
    }

    public void updatePainter() {
        Object3DPainter painter = this.graphPanel.getPainter();
        CameraController projector = painter.getCameraController();
        GeometryPainter geometryPainter = null;
        switch (this.paintMode) {
            case Solid: {
                geometryPainter = this.geometryPainterFactory.createPainter(2, this.paintLinks);
                break;
            }
            case Wire: {
                geometryPainter = this.geometryPainterFactory.createPainter(3, this.paintLinks);
                break;
            }
            case Frame: {
                geometryPainter = this.geometryPainterFactory.createPainter(4, this.paintLinks);
            }
        }
        GeometryColorModel geometryColorModel = null;
        switch (this.colorModel) {
            case Rainbow: {
                geometryColorModel = new RainbowColorModel();
                break;
            }
            case Strand: {
                geometryColorModel = new RnaStrandColorModel();
                break;
            }
            case Atom: {
                geometryColorModel = new AtomColorModel();
                break;
            }
            case Nucleotide: {
                geometryColorModel = new NucleotideColorModel();
            }
        }
        geometryPainter.setGeometryColorModel(geometryColorModel);
        GeneralGeometryPainter newPainter = new GeneralGeometryPainter(this.params, geometryPainter, this.graphPanel.getGraphController());
        newPainter.setCameraController(projector);
        this.graphPanel.setPainter(newPainter);
        this.repaintThis();
    }

    @Override
    public void modelChanged(ModelChangeEvent e) {
        this.selected.setText(this.graphPanel.getGraphController().getGraph().getSelectedGraphText());
    }

    public void moveThetaSlider(double change) {
        this.setThetaSliderValue(this.getThetaSliderValue() + change);
    }

    public void movePhiSlider(double change) {
        this.setPhiSliderValue(this.getPhiSliderValue() + change);
    }

    private double getThetaSliderValue() {
        return this.thetaSlider.getValue();
    }

    private void setThetaSliderValue(double d) {
        if (d < (double)this.thetaSlider.getMinimum() || d > (double)this.thetaSlider.getMaximum()) {
            d = (double)(this.thetaSlider.getMaximum() + this.thetaSlider.getMinimum()) - d;
        }
        this.oldThetaValue = (double)((int)d) * (Math.PI / 180);
        this.thetaSlider.setValue((int)d);
    }

    private double getPhiSliderValue() {
        return this.phiSlider.getValue();
    }

    private void setPhiSliderValue(double d) {
        if (d < (double)this.phiSlider.getMinimum() || d > (double)this.phiSlider.getMaximum()) {
            d = (double)(this.phiSlider.getMaximum() + this.phiSlider.getMinimum()) - d;
        }
        this.oldPhiValue = (double)((int)d) * (Math.PI / 180);
        this.phiSlider.setValue((int)d);
    }

    private void setZoomSliderValue(double d) {
        this.zoomSlider.setValue((int)d);
    }

    private String[] getForbiddenNames() {
        ArrayList<String> list = new ArrayList<String>();
        if (!this.atomCheckBox.isSelected()) {
            list.add("Atom3D");
        }
        if (!this.nucleotideCheckBox.isSelected()) {
            list.add("Nucleotide3D");
        }
        if (!this.strandCheckBox.isSelected()) {
            list.add("RnaStrand");
        }
        String[] result = new String[list.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (String)list.get(i);
        }
        return result;
    }

    private void resetCamera() {
        for (int i = 0; i < 2; ++i) {
            this.graphPanel.getCameraController().getCamera().setPosition(new Vector3D(0.0, -10.0, 0.0));
            this.graphPanel.getCameraController().getCamera().setOrientation(new Matrix3D(-1.0, 0.0, 0.0, 0.0, 1.0, -0.0, 0.0, 0.0, 1.0));
            this.graphPanel.getCameraController().getCamera().setZoom(1.0);
            this.setZoomSliderValue(1.0);
            this.setXSliderValue(0);
            this.setYSliderValue(0);
            this.setThetaSliderValue(0.0);
            this.setPhiSliderValue(0.0);
            this.repaintThis();
        }
    }

    GraphControlPanel(RnaGuiParameters params, Object3DGraphController controller) {
        this.params = params;
        this.setBackground(Color.WHITE);
        BoxLayout layout = new BoxLayout(this, 1);
        this.setLayout(layout);
        this.setBorder(BorderFactory.createLineBorder(Color.black));
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BoxLayout(topPanel, 0));
        JButton button = new JButton("Solid");
        this.cBox = new JCheckBox("Links");
        this.cBox.setSelected(true);
        this.cBox.addActionListener(new NoLinkGeometryListener());
        JPanel painterPanel = new JPanel();
        painterPanel.setLayout(new BoxLayout(painterPanel, 0));
        painterPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), "Rendering Options"));
        JLabel boxLabel = new JLabel("Paint Mode");
        painterPanel.add(boxLabel);
        painterPanel.add(Box.createHorizontalStrut(5));
        JComboBox<Enum> comboBox = new JComboBox<PaintMode>(PaintMode.values());
        comboBox.setSelectedItem((Object)this.paintMode);
        comboBox.setEditable(false);
        comboBox.addItemListener(new PaintModeSelectedListener());
        painterPanel.add(comboBox);
        painterPanel.add(Box.createHorizontalStrut(20));
        boxLabel = new JLabel("Color Model");
        painterPanel.add(boxLabel);
        painterPanel.add(Box.createHorizontalStrut(5));
        comboBox = new JComboBox<ColorModel>(ColorModel.values());
        comboBox.setSelectedItem((Object)this.colorModel);
        comboBox.setEditable(false);
        comboBox.addItemListener(new ColorModelSelectedListener());
        painterPanel.add(comboBox);
        painterPanel.add(Box.createHorizontalStrut(20));
        painterPanel.add(this.cBox);
        topPanel.add(painterPanel);
        topPanel.setBorder(BorderFactory.createLineBorder(Color.black));
        topPanel.setMaximumSize(new Dimension(topPanel.getMaximumSize().width, topPanel.getPreferredSize().height));
        this.add(topPanel);
        JPanel temp = new JPanel(new BorderLayout());
        this.graphPanel = new GraphPanel(this, params, controller);
        this.graphPanel.setBackground(Color.WHITE);
        temp.add((Component)this.graphPanel, "Center");
        this.yslider = new YSliderPanel();
        temp.add((Component)this.yslider, "East");
        this.xslider = new XSliderPanel();
        temp.add((Component)this.xslider, "South");
        BottomPanel bottomPanel = new BottomPanel(this);
        bottomPanel.setMaximumSize(new Dimension(bottomPanel.getMaximumSize().width, bottomPanel.getPreferredSize().height));
        this.splitPane = new JSplitPane(0, temp, bottomPanel);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setResizeWeight(1.0);
        JPanel temp2 = new JPanel(new BorderLayout());
        temp2.add(this.splitPane);
        this.add(temp2);
        this.updatePainter();
    }

    @Override
    public void hierarchyChanged(HierarchyEvent e) {
        if (4L == (e.getChangeFlags() & 4L)) {
            this.removeHierarchyListener(this);
            this.splitPane.setDividerLocation(1.0);
        }
    }

    private double getYSliderValue() {
        return this.yslider.ySlider.getValue();
    }

    private void setYSliderValue(int i) {
        this.yslider.ySlider.setValue(i);
    }

    private double getXSliderValue() {
        return this.xslider.xSlider.getValue();
    }

    private void setXSliderValue(int i) {
        this.xslider.xSlider.setValue(i);
    }

    public Object3DPainter getPainter() {
        return this.graphPanel.getPainter();
    }

    public void repaintThis() {
        this.repaint();
    }

    public void setPainter(Object3DPainter p) {
        this.graphPanel.setPainter(p);
    }

    public void setCameraController(CameraController p) {
        this.graphPanel.setCameraController(p);
    }

    public void updateCamera(double theta, double phi, double psi, double dist) {
        this.graphPanel.getCameraController().updateCameraFromAngles(theta, phi, psi, dist);
    }

    private class ColorModelSelectedListener
    implements ItemListener {
        private ColorModelSelectedListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            GraphControlPanel.this.colorModel = (ColorModel)((Object)e.getItem());
            GraphControlPanel.this.updatePainter();
        }
    }

    private class PaintModeSelectedListener
    implements ItemListener {
        private PaintModeSelectedListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            GraphControlPanel.this.paintMode = (PaintMode)((Object)e.getItem());
            GraphControlPanel.this.updatePainter();
        }
    }

    private class ZoomOutListener
    implements ActionListener {
        private ZoomOutListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object3DPainter painter = GraphControlPanel.this.graphPanel.getPainter();
            CameraController projector = painter.getCameraController();
            GraphControlPanel.this.zoomFactor *= 0.5;
            projector.setZoom(GraphControlPanel.this.zoomFactor);
            GraphControlPanel.this.repaintThis();
        }
    }

    private class ZoomInListener
    implements ActionListener {
        private ZoomInListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object3DPainter painter = GraphControlPanel.this.graphPanel.getPainter();
            CameraController projector = painter.getCameraController();
            GraphControlPanel.this.zoomFactor *= 2.0;
            projector.setZoom(GraphControlPanel.this.zoomFactor);
            GraphControlPanel.this.repaintThis();
        }
    }

    private class ZoomChangedListener
    implements ChangeListener {
        private ZoomChangedListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            JSlider source = (JSlider)e.getSource();
            Object3DPainter painter = GraphControlPanel.this.graphPanel.getPainter();
            CameraController projector = painter.getCameraController();
            GraphControlPanel.this.zoom = 0.1 * (double)source.getValue();
            GraphControlPanel.this.zoom = Math.pow(2.0, GraphControlPanel.this.zoom);
            projector.setZoom(GraphControlPanel.this.zoom);
            GraphControlPanel.this.repaintThis();
        }
    }

    private class ResetButtonListener
    extends AbstractAction {
        private ResetButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GraphControlPanel.this.resetCamera();
        }
    }

    private class ThetaChangedListener
    implements ChangeListener {
        private ThetaChangedListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            GraphControlPanel.this.thetaValue = GraphControlPanel.this.getThetaSliderValue() * (Math.PI / 180);
            GraphControlPanel.this.thetaDiff = GraphControlPanel.this.thetaValue - GraphControlPanel.this.oldThetaValue;
            Object3DPainter painter = GraphControlPanel.this.graphPanel.getPainter();
            CameraController projector = painter.getCameraController();
            projector.rotateCameraNorth(-GraphControlPanel.this.thetaDiff);
            GraphControlPanel.this.repaintThis();
            GraphControlPanel.this.oldThetaValue = GraphControlPanel.this.thetaValue;
        }
    }

    private class PhiChangedListener
    implements ChangeListener {
        private PhiChangedListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            GraphControlPanel.this.phiValue = GraphControlPanel.this.getPhiSliderValue() * (Math.PI / 180);
            GraphControlPanel.this.phiDiff = GraphControlPanel.this.phiValue - GraphControlPanel.this.oldPhiValue;
            Object3DPainter painter = GraphControlPanel.this.graphPanel.getPainter();
            CameraController projector = painter.getCameraController();
            projector.rotateCameraWest(-GraphControlPanel.this.phiDiff);
            GraphControlPanel.this.repaintThis();
            GraphControlPanel.this.oldPhiValue = GraphControlPanel.this.phiValue;
        }
    }

    private class XChangedListener
    implements ChangeListener {
        private XChangedListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            Object3DPainter painter = GraphControlPanel.this.graphPanel.getPainter();
            CameraController projector = painter.getCameraController();
            GraphControlPanel.this.xValue = GraphControlPanel.this.getXSliderValue();
            GraphControlPanel.this.xDiff = GraphControlPanel.this.xValue - GraphControlPanel.this.oldXValue;
            projector.moveCamera(-GraphControlPanel.this.xDiff, 0.0);
            GraphControlPanel.this.repaintThis();
            GraphControlPanel.this.oldXValue = GraphControlPanel.this.xValue;
        }
    }

    private class YChangedListener
    implements ChangeListener {
        private YChangedListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            Object3DPainter painter = GraphControlPanel.this.graphPanel.getPainter();
            CameraController projector = painter.getCameraController();
            GraphControlPanel.this.yValue = GraphControlPanel.this.getYSliderValue();
            GraphControlPanel.this.yDiff = GraphControlPanel.this.yValue - GraphControlPanel.this.oldYValue;
            projector.moveCamera(0.0, GraphControlPanel.this.yDiff);
            GraphControlPanel.this.repaintThis();
            GraphControlPanel.this.oldYValue = GraphControlPanel.this.yValue;
        }
    }

    private class DefaultModeListener
    implements ActionListener {
        private DefaultModeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object3DPainter painter = GraphControlPanel.this.graphPanel.getPainter();
            CameraController projector = painter.getCameraController();
            SimplePainter newPainter = new SimplePainter(GraphControlPanel.this.params);
            newPainter.setCameraController(projector);
            GraphControlPanel.this.graphPanel.setPainter(newPainter);
            GraphControlPanel.this.repaintThis();
        }
    }

    private class PointModeListener
    implements ActionListener {
        private PointModeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object3DPainter painter = GraphControlPanel.this.graphPanel.getPainter();
            CameraController projector = painter.getCameraController();
            PointPainter pointPainter = new PointPainter(GraphControlPanel.this.params);
            pointPainter.setCameraController(projector);
            GraphControlPanel.this.graphPanel.setPainter(pointPainter);
            GraphControlPanel.this.repaintThis();
        }
    }

    private class RnaStrandModeListener
    implements ActionListener {
        private RnaStrandModeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            log.info("Switching to RnaStrandColorModel");
            GraphControlPanel.this.colorModel = ColorModel.Strand;
            GraphControlPanel.this.updatePainter();
            log.fine("End Switching to RnaStrandColorModel");
        }
    }

    private class RainbowModeListener
    implements ActionListener {
        private RainbowModeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            log.info("Switching to RainbowColormodel");
            GraphControlPanel.this.colorModel = ColorModel.Rainbow;
            GraphControlPanel.this.updatePainter();
            log.fine("End Switching to RainbowColorModel");
        }
    }

    private class WireFrameModeListener
    implements ActionListener {
        private WireFrameModeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GraphControlPanel.this.paintMode = PaintMode.Frame;
            log.info("Switching to WireFrameGeometryPainter");
            GraphControlPanel.this.updatePainter();
            log.fine("End Switching to WireFrameGeometryPainter");
        }
    }

    private class SolidModeListener
    implements ActionListener {
        private SolidModeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            log.info("Switching to SolidGeometryPainter!");
            GraphControlPanel.this.paintMode = PaintMode.Solid;
            GraphControlPanel.this.updatePainter();
            log.fine("End Switching to SolidGeometryPainter!");
        }
    }

    private class HideStrandListener
    implements ActionListener {
        private HideStrandListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            log.fine("called HideStrandListener.actionPerformed");
            Object3DPainter painter = GraphControlPanel.this.graphPanel.getPainter();
            if (GraphControlPanel.this.strandCheckBox.isSelected()) {
                painter.addForbidden("RnaStrand");
            } else {
                painter.removeForbidden("RnaStrand");
            }
            GraphControlPanel.this.repaintThis();
        }
    }

    private class HideNucleotideListener
    implements ActionListener {
        private HideNucleotideListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            log.fine("called HideNucleotideListener.actionPerformed");
            Object3DPainter painter = GraphControlPanel.this.graphPanel.getPainter();
            if (GraphControlPanel.this.nucleotideCheckBox.isSelected()) {
                painter.addForbidden("Nucleotide3D");
            } else {
                painter.removeForbidden("Nucleotide3D");
            }
            GraphControlPanel.this.repaintThis();
        }
    }

    private class HideAtomListener
    implements ActionListener {
        private HideAtomListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            log.fine("called HideAtomListener.actionPerformed");
            Object3DPainter painter = GraphControlPanel.this.graphPanel.getPainter();
            if (GraphControlPanel.this.atomCheckBox.isSelected()) {
                painter.addForbidden("Atom3D");
            } else {
                painter.removeForbidden("Atom3D");
            }
            GraphControlPanel.this.repaintThis();
        }
    }

    private class NoLinkGeometryListener
    implements ActionListener {
        private NoLinkGeometryListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            log.info("Switching to NoLinkGeometryPainter!");
            Object3DPainter painter = GraphControlPanel.this.graphPanel.getPainter();
            CameraController projector = painter.getCameraController();
            if (GraphControlPanel.this.cBox.isSelected()) {
                GraphControlPanel.this.paintLinks = true;
            } else {
                GraphControlPanel.this.paintLinks = false;
            }
            GraphControlPanel.this.updatePainter();
            log.fine("End Switching to NoLinkGeometryPainter!");
        }
    }

    private class ChangeForbiddenListener
    implements ActionListener {
        private ChangeForbiddenListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String[] forbiddenNames = GraphControlPanel.this.getForbiddenNames();
            Object3DPainter painter = GraphControlPanel.this.graphPanel.getPainter();
            painter.clearForbidden();
        }
    }

    private class WireModeListener
    implements ActionListener {
        private WireModeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            log.info("Switching to WirePainter!");
            GraphControlPanel.this.paintMode = PaintMode.Wire;
            GraphControlPanel.this.updatePainter();
            log.fine("End Switching to WirePainter!");
        }
    }

    private class XSliderPanel
    extends JPanel {
        JSlider xSlider;

        XSliderPanel() {
            this.setBorder(BorderFactory.createLineBorder(Color.black));
            this.setLayout(new BoxLayout(this, 3));
            this.setSize(new Dimension(GraphControlPanel.this.params.xSliderPanelWidth, GraphControlPanel.this.params.xSliderPanelHeight));
            this.xSlider = new JSlider(0, (int)GraphControlPanel.this.params.xMin, (int)GraphControlPanel.this.params.xMax, (int)GraphControlPanel.this.params.xInit);
            this.xSlider.setMajorTickSpacing(10);
            this.xSlider.setPaintTicks(false);
            this.xSlider.setPaintLabels(false);
            this.xSlider.addChangeListener(new XChangedListener());
            this.add(this.xSlider);
        }
    }

    private class YSliderPanel
    extends JPanel {
        JSlider ySlider;

        YSliderPanel() {
            this.setBorder(BorderFactory.createLineBorder(Color.black));
            this.setLayout(new BoxLayout(this, 3));
            this.ySlider = new JSlider(1, (int)GraphControlPanel.this.params.yMin, (int)GraphControlPanel.this.params.yMax, (int)GraphControlPanel.this.params.yInit);
            this.ySlider.setMajorTickSpacing(10);
            this.ySlider.setPaintTicks(false);
            this.ySlider.setPaintLabels(false);
            this.ySlider.addChangeListener(new YChangedListener());
            this.add(this.ySlider);
        }
    }

    private class BottomPanel
    extends JPanel {
        BottomPanel(GraphControlPanel app) {
            this.setBorder(BorderFactory.createLineBorder(Color.black));
            BoxLayout layout = new BoxLayout(this, 1);
            this.setLayout(layout);
            GraphControlPanel.this.selected = new JTextArea(30, 2);
            GraphControlPanel.this.selected.setEditable(false);
            GraphControlPanel.this.selected.setLineWrap(true);
            GraphControlPanel.this.selected.setText(GraphControlPanel.this.graphPanel.getGraphController().getGraph().getSelectedGraphText());
            GraphControlPanel.this.selected.setFont(new Font("roman", 0, 10));
            GraphControlPanel.this.graphPanel.getGraphController().addModelChangeListener(app);
            JScrollPane scrollPane = new JScrollPane(GraphControlPanel.this.selected, 20, 31);
            scrollPane.setPreferredSize(new Dimension(100, 50));
            this.add(scrollPane);
            JPanel sliderPanel = new JPanel();
            BoxLayout sliderPanelLayout = new BoxLayout(sliderPanel, 0);
            sliderPanel.setLayout(sliderPanelLayout);
            JButton resetButton = new JButton("Reset Position");
            resetButton.addActionListener(new ResetButtonListener());
            sliderPanel.add(resetButton);
            GraphControlPanel.this.zoomSlider = new JSlider(0, 10 * (int)GraphControlPanel.this.params.zoomMin, 10 * (int)GraphControlPanel.this.params.zoomMax, 10 * (int)GraphControlPanel.this.params.zoomInit);
            GraphControlPanel.this.zoomSlider.addChangeListener(new ZoomChangedListener());
            GraphControlPanel.this.zoomSlider.setMajorTickSpacing(10);
            GraphControlPanel.this.zoomSlider.setPaintTicks(false);
            GraphControlPanel.this.zoomSlider.setPaintLabels(false);
            GraphControlPanel.this.zoomSlider.setSnapToTicks(false);
            sliderPanel.add(new JLabel("Zoom"));
            sliderPanel.add(GraphControlPanel.this.zoomSlider);
            GraphControlPanel.this.thetaSlider = new JSlider(0, (int)GraphControlPanel.this.params.thetaMin, (int)GraphControlPanel.this.params.thetaMax, (int)GraphControlPanel.this.params.thetaInit);
            GraphControlPanel.this.thetaSlider.setMajorTickSpacing(30);
            GraphControlPanel.this.thetaSlider.setPaintTicks(false);
            GraphControlPanel.this.thetaSlider.setPaintLabels(false);
            GraphControlPanel.this.thetaSlider.addChangeListener(new ThetaChangedListener());
            sliderPanel.add(new JLabel("Rotate Up/Down"));
            sliderPanel.add(GraphControlPanel.this.thetaSlider);
            GraphControlPanel.this.phiSlider = new JSlider(0, (int)GraphControlPanel.this.params.phiMin, (int)GraphControlPanel.this.params.phiMax, (int)GraphControlPanel.this.params.phiInit);
            GraphControlPanel.this.phiSlider.addChangeListener(new PhiChangedListener());
            GraphControlPanel.this.phiSlider.setMajorTickSpacing(60);
            GraphControlPanel.this.phiSlider.setPaintTicks(false);
            GraphControlPanel.this.phiSlider.setPaintLabels(false);
            sliderPanel.add(new JLabel("Rotate Left/Right"));
            sliderPanel.add(GraphControlPanel.this.phiSlider);
            this.add(sliderPanel);
        }
    }

    public static enum ColorModel {
        Rainbow,
        Strand,
        Atom,
        Nucleotide;

    }

    public static enum PaintMode {
        Solid,
        Wire,
        Frame;

    }
}

