/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp.rnagui;

import commandtools.CommandApplication;
import commandtools.CommandException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import rnadesign.designapp.AbstractDesigner;
import rnadesign.designapp.rnagui.GeneralWizard;
import rnadesign.rnacontrol.Object3DController;
import rnadesign.rnacontrol.Object3DGraphController;
import rnadesign.rnamodel.RnaTools;
import rnadesign.rnamodel.StrandJunction3D;
import rnadesign.rnamodel.StrandJunctionDB;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.Object3DTools;

public class GrowGraphWizard
implements GeneralWizard {
    public static final String FRAME_TITLE = "Grow Graph";
    private CommandApplication application;
    private static int version = 1;
    private static final Dimension PANEL_DIM = new Dimension(225, 225);
    private static final Dimension TABLE_DIM = new Dimension(200, 200);
    private static final int COL_SIZE_NAME = 25;
    private JTable junctionTable;
    private JTable addedJunctionTable;
    private JTable constraintTable;
    private AbstractTableModel junctionTableModel;
    private AbstractTableModel addedJunctionTableModel;
    private BranchSelector branchSelector1;
    private BranchSelector branchSelector2;
    private JButton generate;
    private JButton close;
    private JButton addConstraint;
    private JButton removeConstraint;
    private JFormattedTextField basePairs;
    private JLabel label;
    private JTextField rootField;
    private Vector<String> tree;
    private String[] allowedNames = RnaTools.getRnaClassNames();
    private String[] forbiddenNames;
    private JPanel treePanel;
    private JButton treeButton;
    private JList treeList;
    private JScrollPane treeScroll;
    private boolean steric = true;
    private boolean helices = true;
    private int generations = 1;
    private int maxConnections = 1;
    private int maxBlocks = 1;
    private double x = 0.0;
    private double y = 0.0;
    private double z = 0.0;
    private String root = "root";
    private boolean useAdvanced = false;
    private ArrayList<Object3D> objects;
    private ArrayList<JunctionInfo> junctions;
    private ArrayList<JunctionInfo> addedJunctions;
    private ArrayList<JunctionInfo> availableJunctions;
    private ArrayList<ConstraintInfo> constraints;
    private ArrayList<ActionListener> actionListeners = new ArrayList();
    private boolean finished = false;
    private Object3DGraphController graphController;
    private JDialog frame;

    public GrowGraphWizard(CommandApplication application) {
        this.application = application;
    }

    @Override
    public void addActionListener(ActionListener listener) {
        this.actionListeners.add(listener);
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public void launchWizard(Object3DGraphController graphController, Component parentFrame) {
        this.graphController = graphController;
        this.frame = new JDialog(parentFrame instanceof Frame ? (Frame)parentFrame : null, FRAME_TITLE, true);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                GrowGraphWizard.this.finished = true;
            }
        });
        this.getJunctionInfo();
        this.constraints = new ArrayList();
        this.availableJunctions = new ArrayList();
        this.availableJunctions.addAll(this.junctions);
        this.frame.add(new RootChooser());
        this.frame.pack();
        this.frame.setVisible(true);
    }

    private void getJunctionInfo() {
        JunctionInfo info;
        int i;
        StrandJunction3D[] j;
        this.junctions = new ArrayList();
        StrandJunctionDB db = this.graphController.getJunctionController().getKissingLoopDB();
        int numberJunctions = db.getJunctionCount();
        int junctionCount = 0;
        int order = 1;
        while (junctionCount != numberJunctions) {
            j = db.getJunctions(order);
            junctionCount += j.length;
            for (i = 0; i < j.length; ++i) {
                info = new JunctionInfo();
                info.junction = j[i];
                info.order = order;
                info.index = i + 1;
                info.type = "k";
                this.junctions.add(info);
            }
            ++order;
        }
        db = this.graphController.getJunctionController().getJunctionDB();
        numberJunctions = db.getJunctionCount();
        junctionCount = 0;
        order = 1;
        while (junctionCount != numberJunctions) {
            j = db.getJunctions(order);
            junctionCount += j.length;
            for (i = 0; i < j.length; ++i) {
                info = new JunctionInfo();
                info.junction = j[i];
                info.order = order;
                info.index = i + 1;
                info.type = "j";
                this.junctions.add(info);
            }
            ++order;
        }
    }

    private String getSelectionText() {
        Object3DGraphController graphController = ((AbstractDesigner)this.application).getGraphController();
        Object3DController gControl = graphController.getGraph();
        Object3D selection = gControl.getSelectionRoot();
        if (selection == null) {
            return "";
        }
        String selectionName = selection.getName();
        Object3D curr = selection;
        while (curr.getParent() != null) {
            curr = curr.getParent();
            selectionName = curr.getName() + "." + selectionName;
        }
        return selectionName;
    }

    private class BranchSelector
    extends JPanel {
        JTable junctionTable;
        JList branchTable;
        ListSelectionListener listener;

        BranchSelector(ListSelectionListener l) {
            this.listener = l;
            this.setLayout(new BoxLayout(this, 0));
            this.junctionTable = new JTable(GrowGraphWizard.this.addedJunctionTableModel);
            this.junctionTable.getTableHeader().setReorderingAllowed(false);
            this.junctionTable.setColumnSelectionAllowed(false);
            ListSelectionModel lsm = this.junctionTable.getSelectionModel();
            lsm.setSelectionMode(0);
            lsm.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (e.getValueIsAdjusting()) {
                        return;
                    }
                    GrowGraphWizard.this.addConstraint.setEnabled(false);
                    if (BranchSelector.this.junctionTable.getSelectedRow() != -1) {
                        BranchSelector.this.junctionTable.setRowSelectionInterval(BranchSelector.this.junctionTable.getSelectedRow(), BranchSelector.this.junctionTable.getSelectedRow());
                        BranchSelector.this.branchTable.setEnabled(true);
                        GrowGraphWizard.this.basePairs.setEnabled(true);
                    } else {
                        BranchSelector.this.branchTable.setEnabled(false);
                        GrowGraphWizard.this.basePairs.setEnabled(false);
                    }
                    StrandJunction3D j = ((JunctionInfo)((GrowGraphWizard)GrowGraphWizard.this).addedJunctions.get((int)BranchSelector.this.junctionTable.getSelectedRow())).junction;
                    int size = j.getBranchCount();
                    Object[] branches = new Object[size];
                    for (int i = 0; i < size; ++i) {
                        branches[i] = new Integer(i + 1);
                    }
                    BranchSelector.this.branchTable.setModel(new DefaultComboBoxModel<Object>(branches));
                    BranchSelector.this.branchTable.revalidate();
                }
            });
            JScrollPane pane = new JScrollPane(this.junctionTable);
            pane.setPreferredSize(TABLE_DIM);
            this.add(pane);
            this.add(new JSeparator(1));
            this.branchTable = new JList();
            this.branchTable.setPreferredSize(TABLE_DIM);
            this.branchTable.setSelectionMode(0);
            this.branchTable.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (e.getValueIsAdjusting()) {
                        return;
                    }
                    BranchSelector.this.listener.valueChanged(e);
                }
            });
            this.branchTable.setEnabled(false);
            pane = new JScrollPane(this.branchTable);
            pane.setPreferredSize(TABLE_DIM);
            this.add(pane);
        }

        @Override
        public void setEnabled(boolean b) {
            super.setEnabled(b);
            if (!b) {
                this.junctionTable.removeRowSelectionInterval(0, GrowGraphWizard.this.addedJunctions.size());
            }
            this.branchTable.setEnabled(b);
            GrowGraphWizard.this.basePairs.setEnabled(b);
        }

        public int getBasePairs() {
            return (Integer)GrowGraphWizard.this.basePairs.getValue();
        }

        public int getJunction() {
            if (this.junctionTable.getSelectedRow() == -1) {
                return -1;
            }
            return this.junctionTable.getSelectedRow();
        }

        public int getBranch() {
            if (this.branchTable.getSelectedIndex() == -1) {
                return -1;
            }
            return this.branchTable.getSelectedIndex() + 1;
        }
    }

    private class JunctionTableModel
    extends AbstractTableModel {
        private String[] columns = new String[]{"Type", "Name", "Order", "ID"};
        private ArrayList<JunctionInfo> list;

        public JunctionTableModel(ArrayList<JunctionInfo> list) {
            this.list = list;
        }

        @Override
        public int getColumnCount() {
            return this.columns.length;
        }

        @Override
        public int getRowCount() {
            return this.list.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return this.list.get((int)rowIndex).type;
                }
                case 1: {
                    return Object3DTools.getFullName(this.list.get((int)rowIndex).junction);
                }
                case 2: {
                    return this.list.get((int)rowIndex).order;
                }
                case 3: {
                    return this.list.get((int)rowIndex).index;
                }
            }
            return null;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return this.columns[columnIndex];
        }
    }

    private class ConstraintTableModel
    extends AbstractTableModel {
        private String[] columns = new String[]{"Junction 1", "Branch 1", "Junction 2", "Branch 2", "Base Pairs"};

        private ConstraintTableModel() {
        }

        @Override
        public int getColumnCount() {
            return this.columns.length;
        }

        @Override
        public int getRowCount() {
            return GrowGraphWizard.this.constraints.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return Object3DTools.getFullName(((JunctionInfo)((GrowGraphWizard)GrowGraphWizard.this).addedJunctions.get((int)((ConstraintInfo)((GrowGraphWizard)GrowGraphWizard.this).constraints.get((int)rowIndex)).j1)).junction);
                }
                case 1: {
                    return ((ConstraintInfo)((GrowGraphWizard)GrowGraphWizard.this).constraints.get((int)rowIndex)).b1;
                }
                case 2: {
                    return Object3DTools.getFullName(((JunctionInfo)((GrowGraphWizard)GrowGraphWizard.this).addedJunctions.get((int)((ConstraintInfo)((GrowGraphWizard)GrowGraphWizard.this).constraints.get((int)rowIndex)).j2)).junction);
                }
                case 3: {
                    return ((ConstraintInfo)((GrowGraphWizard)GrowGraphWizard.this).constraints.get((int)rowIndex)).b2;
                }
                case 4: {
                    return ((ConstraintInfo)((GrowGraphWizard)GrowGraphWizard.this).constraints.get((int)rowIndex)).bases;
                }
            }
            return null;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return this.columns[columnIndex];
        }
    }

    private class AdvancedOptions
    extends JPanel {
        JRadioButton helicesTrue;
        JRadioButton helicesFalse;
        JRadioButton stericTrue;
        JRadioButton stericFalse;
        JTextField xLocation;
        JTextField yLocation;
        JTextField zLocation;
        JTextField blockMax;
        JTextField connMax;
        JTextField generations;

        AdvancedOptions() {
            this.setLayout(new BoxLayout(this, 1));
            JPanel temp = new JPanel();
            this.generations = new JTextField(10);
            this.generations.setText("1");
            temp.add(new JLabel("Generations:"));
            temp.add(this.generations);
            this.add(temp);
            this.add(new JSeparator(0));
            temp = new JPanel();
            this.helicesTrue = new JRadioButton("True");
            this.helicesFalse = new JRadioButton("False");
            ButtonGroup group = new ButtonGroup();
            group.add(this.helicesTrue);
            group.add(this.helicesFalse);
            this.helicesTrue.setSelected(true);
            this.helicesFalse.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GrowGraphWizard.this.helices = false;
                }
            });
            this.helicesTrue.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GrowGraphWizard.this.helices = true;
                }
            });
            temp.add(new JLabel("Helices:"));
            temp.add(this.helicesTrue);
            temp.add(this.helicesFalse);
            this.add(temp);
            this.add(new JSeparator(0));
            temp = new JPanel();
            temp.add(new JLabel("Connection Maximum: "));
            this.connMax = new JTextField(10);
            this.connMax.setText("1");
            temp.add(this.connMax);
            this.add(temp);
            temp = new JPanel();
            temp.add(new JLabel("Block Maximum: "));
            this.blockMax = new JTextField(10);
            this.blockMax.setText("1");
            temp.add(this.blockMax);
            this.add(temp);
            this.add(new JSeparator(0));
            temp = new JPanel();
            temp.add(new JLabel("X:"));
            this.xLocation = new JTextField(10);
            this.xLocation.setText("0.0");
            temp.add(this.xLocation);
            this.add(temp);
            temp = new JPanel();
            temp.add(new JLabel("Y:"));
            this.yLocation = new JTextField(10);
            this.yLocation.setText("0.0");
            temp.add(this.yLocation);
            this.add(temp);
            temp = new JPanel();
            temp.add(new JLabel("Z:"));
            this.zLocation = new JTextField(10);
            this.zLocation.setText("0.0");
            temp.add(this.zLocation);
            this.add(temp);
            this.add(new JSeparator(0));
            temp = new JPanel();
            this.stericTrue = new JRadioButton("True");
            this.stericFalse = new JRadioButton("False");
            group = new ButtonGroup();
            group.add(this.stericTrue);
            group.add(this.stericFalse);
            this.stericTrue.setSelected(true);
            this.stericFalse.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GrowGraphWizard.this.steric = false;
                }
            });
            this.stericTrue.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GrowGraphWizard.this.steric = true;
                }
            });
            temp.add(new JLabel("Steric:"));
            temp.add(this.stericTrue);
            temp.add(this.stericFalse);
            this.add(temp);
            JPanel bottomPanel = new JPanel();
            bottomPanel.setLayout(new BoxLayout(bottomPanel, 0));
            bottomPanel.add(Box.createHorizontalGlue());
            JButton close = new JButton("Close");
            close.addActionListener(new CloseWindowListener());
            bottomPanel.add(close);
            bottomPanel.add(Box.createHorizontalStrut(10));
            JButton generate = new JButton("Generate");
            generate.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GrowGraphWizard.this.useAdvanced = true;
                    try {
                        GrowGraphWizard.this.generations = Integer.parseInt(AdvancedOptions.this.generations.getText());
                        if (GrowGraphWizard.this.generations < 1) {
                            AdvancedOptions.this.generations.setText("1");
                            JOptionPane.showMessageDialog(GrowGraphWizard.this.frame, "Generations must be greater than or equal to 1");
                            return;
                        }
                        GrowGraphWizard.this.maxConnections = Integer.parseInt(AdvancedOptions.this.connMax.getText());
                        GrowGraphWizard.this.maxBlocks = Integer.parseInt(AdvancedOptions.this.blockMax.getText());
                        GrowGraphWizard.this.x = Double.parseDouble(AdvancedOptions.this.xLocation.getText());
                        GrowGraphWizard.this.y = Double.parseDouble(AdvancedOptions.this.yLocation.getText());
                        GrowGraphWizard.this.z = Double.parseDouble(AdvancedOptions.this.zLocation.getText());
                    }
                    catch (NumberFormatException ex) {
                        JOptionPane.showMessageDialog(GrowGraphWizard.this.frame, "Must enter a number");
                        return;
                    }
                    GenerateListener listener = new GenerateListener();
                    listener.actionPerformed(e);
                }
            });
            bottomPanel.add(generate);
            this.add(bottomPanel);
        }
    }

    private class GenerateListener
    implements ActionListener {
        private GenerateListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            StringBuffer command = new StringBuffer();
            command.append("growgraph blocks=");
            for (int i = 0; i < GrowGraphWizard.this.addedJunctions.size(); ++i) {
                JunctionInfo j = (JunctionInfo)GrowGraphWizard.this.addedJunctions.get(i);
                command.append(j.type + "," + j.order + "," + j.index);
                if (i >= GrowGraphWizard.this.addedJunctions.size() - 1) continue;
                command.append(";");
            }
            if (GrowGraphWizard.this.useAdvanced) {
                command.append(" root=" + GrowGraphWizard.this.root + " ");
                command.append("block-max=" + GrowGraphWizard.this.maxBlocks + " ");
                command.append("conn-max=" + GrowGraphWizard.this.maxConnections + " ");
                command.append("pos=" + GrowGraphWizard.this.x + "," + GrowGraphWizard.this.y + "," + GrowGraphWizard.this.z + " ");
                command.append("gen=" + GrowGraphWizard.this.generations + " ");
            }
            System.out.println(command);
            try {
                GrowGraphWizard.this.application.runScriptLine(command.toString());
            }
            catch (CommandException ex) {
                JOptionPane.showMessageDialog(GrowGraphWizard.this.frame, ex.getMessage());
                return;
            }
            GrowGraphWizard.this.frame.setVisible(false);
            GrowGraphWizard.this.frame.dispose();
        }
    }

    private class CloseWindowListener
    implements ActionListener {
        private CloseWindowListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GrowGraphWizard.this.frame.setVisible(false);
            GrowGraphWizard.this.frame.dispose();
        }
    }

    private class BlockAdder
    extends JPanel {
        BlockAdder() {
            final JButton add = new JButton("Add");
            final JButton remove = new JButton("Remove");
            final JButton next = new JButton("Next");
            JPanel leftRight = new JPanel();
            leftRight.setLayout(new BoxLayout(leftRight, 0));
            GrowGraphWizard.this.junctionTableModel = new JunctionTableModel(GrowGraphWizard.this.availableJunctions);
            GrowGraphWizard.this.junctionTable = new JTable(GrowGraphWizard.this.junctionTableModel);
            GrowGraphWizard.this.junctionTable.setColumnSelectionAllowed(false);
            GrowGraphWizard.this.junctionTable.getTableHeader().setReorderingAllowed(false);
            ListSelectionModel lsm = GrowGraphWizard.this.junctionTable.getSelectionModel();
            lsm.setSelectionMode(0);
            lsm.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (e.getValueIsAdjusting()) {
                        return;
                    }
                    if (GrowGraphWizard.this.junctionTable.getSelectedRow() != -1) {
                        GrowGraphWizard.this.junctionTable.setRowSelectionInterval(GrowGraphWizard.this.junctionTable.getSelectedRow(), GrowGraphWizard.this.junctionTable.getSelectedRow());
                        add.setEnabled(true);
                    } else {
                        add.setEnabled(false);
                    }
                }
            });
            GrowGraphWizard.this.addedJunctions = new ArrayList();
            GrowGraphWizard.this.addedJunctionTableModel = new JunctionTableModel(GrowGraphWizard.this.addedJunctions);
            GrowGraphWizard.this.addedJunctionTable = new JTable(GrowGraphWizard.this.addedJunctionTableModel);
            GrowGraphWizard.this.addedJunctionTable.setColumnSelectionAllowed(false);
            GrowGraphWizard.this.addedJunctionTable.getTableHeader().setReorderingAllowed(false);
            lsm = GrowGraphWizard.this.addedJunctionTable.getSelectionModel();
            lsm.setSelectionMode(0);
            lsm.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (e.getValueIsAdjusting()) {
                        return;
                    }
                    if (GrowGraphWizard.this.addedJunctionTable.getSelectedRow() != -1) {
                        GrowGraphWizard.this.addedJunctionTable.setRowSelectionInterval(GrowGraphWizard.this.addedJunctionTable.getSelectedRow(), GrowGraphWizard.this.addedJunctionTable.getSelectedRow());
                        remove.setEnabled(true);
                    } else {
                        remove.setEnabled(false);
                    }
                }
            });
            add.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = GrowGraphWizard.this.junctionTable.getSelectedRow();
                    if (row == -1) {
                        return;
                    }
                    JunctionInfo info = (JunctionInfo)GrowGraphWizard.this.availableJunctions.remove(row);
                    GrowGraphWizard.this.addedJunctions.add(info);
                    if (GrowGraphWizard.this.availableJunctions.size() == 0) {
                        add.setEnabled(false);
                    }
                    GrowGraphWizard.this.junctionTableModel.fireTableRowsDeleted(row, row);
                    GrowGraphWizard.this.addedJunctionTableModel.fireTableRowsInserted(GrowGraphWizard.this.addedJunctions.size() - 1, GrowGraphWizard.this.addedJunctions.size() - 1);
                    next.setEnabled(true);
                }
            });
            remove.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = GrowGraphWizard.this.addedJunctionTable.getSelectedRow();
                    if (row == -1) {
                        return;
                    }
                    JunctionInfo info = (JunctionInfo)GrowGraphWizard.this.addedJunctions.remove(row);
                    GrowGraphWizard.this.availableJunctions.add(info);
                    if (GrowGraphWizard.this.addedJunctions.size() == 0) {
                        remove.setEnabled(false);
                        next.setEnabled(false);
                    }
                    GrowGraphWizard.this.addedJunctionTableModel.fireTableRowsDeleted(row, row);
                    GrowGraphWizard.this.junctionTableModel.fireTableRowsInserted(GrowGraphWizard.this.addedJunctions.size() - 1, GrowGraphWizard.this.addedJunctions.size() - 1);
                }
            });
            remove.setEnabled(false);
            add.setEnabled(false);
            JPanel tempPanel = new JPanel(new BorderLayout());
            tempPanel.add((Component)new JLabel("Available"), "North");
            tempPanel.add((Component)new JScrollPane(GrowGraphWizard.this.junctionTable), "Center");
            tempPanel.add((Component)add, "South");
            tempPanel.setPreferredSize(PANEL_DIM);
            leftRight.add(tempPanel);
            leftRight.add(new JSeparator(1));
            tempPanel = new JPanel(new BorderLayout());
            tempPanel.add((Component)new JLabel("Added"), "North");
            tempPanel.add((Component)new JScrollPane(GrowGraphWizard.this.addedJunctionTable), "Center");
            tempPanel.add((Component)remove, "South");
            tempPanel.setPreferredSize(PANEL_DIM);
            leftRight.add(tempPanel);
            this.setLayout(new BorderLayout());
            this.add((Component)leftRight, "Center");
            JPanel temp = new JPanel();
            temp.setLayout(new BoxLayout(temp, 0));
            temp.add(Box.createHorizontalGlue());
            JButton close = new JButton("Close");
            close.addActionListener(new CloseWindowListener());
            temp.add(close);
            temp.add(Box.createHorizontalStrut(10));
            next.setEnabled(false);
            next.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GrowGraphWizard.this.frame.getContentPane().removeAll();
                    GrowGraphWizard.this.frame.add(new AdvancedOptions());
                    GrowGraphWizard.this.frame.pack();
                    GrowGraphWizard.this.frame.repaint();
                }
            });
            temp.add(next);
            this.add((Component)temp, "South");
            this.add((Component)new JLabel("<html><h2>Add Junctions / Kissing Loops"), "North");
        }
    }

    public class SelectionListener
    implements ListSelectionListener {
        JTextField field;

        public SelectionListener(JTextField field) {
            this.field = field;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                String text = (String)GrowGraphWizard.this.tree.get(e.getFirstIndex());
                if ((text = text.substring(0, text.indexOf(" "))).equals(this.field.getText())) {
                    text = (String)GrowGraphWizard.this.tree.get(e.getLastIndex());
                    text = text.substring(0, text.indexOf(" "));
                }
                this.field.setText(text);
            }
        }
    }

    private class TreePanel
    extends JPanel {
        public TreePanel(JTextField field) {
            Object3DGraphController controller = ((AbstractDesigner)GrowGraphWizard.this.application).getGraphController();
            GrowGraphWizard.this.tree = controller.getGraph().getTree(GrowGraphWizard.this.allowedNames, GrowGraphWizard.this.forbiddenNames);
            this.setLayout(new BorderLayout());
            JPanel labelPanel = new JPanel();
            labelPanel.setLayout(new BoxLayout(labelPanel, 1));
            labelPanel.add(new JLabel("Tree:"));
            this.add(labelPanel);
            GrowGraphWizard.this.treePanel = new JPanel();
            GrowGraphWizard.this.treeList = new JList(GrowGraphWizard.this.tree);
            GrowGraphWizard.this.treeList.addListSelectionListener(new SelectionListener(field));
            GrowGraphWizard.this.treeScroll = new JScrollPane(GrowGraphWizard.this.treeList);
            GrowGraphWizard.this.treeScroll.setVerticalScrollBarPolicy(20);
            GrowGraphWizard.this.treeScroll.setHorizontalScrollBarPolicy(30);
            GrowGraphWizard.this.treeScroll.setPreferredSize(new Dimension(300, 200));
            GrowGraphWizard.this.treePanel.add(GrowGraphWizard.this.treeScroll);
            this.add((Component)GrowGraphWizard.this.treePanel, "South");
        }
    }

    private class RootChooser
    extends JPanel {
        RootChooser() {
            JPanel centerPanel = new JPanel();
            centerPanel.setLayout(new BorderLayout());
            JPanel westCenterPanel = new JPanel();
            westCenterPanel.setLayout(new BorderLayout());
            GrowGraphWizard.this.label = new JLabel("Root: ");
            westCenterPanel.add((Component)GrowGraphWizard.this.label, "North");
            GrowGraphWizard.this.rootField = new JTextField(GrowGraphWizard.this.root, 25);
            westCenterPanel.add((Component)GrowGraphWizard.this.rootField, "Center");
            westCenterPanel.add((Component)new TreePanel(GrowGraphWizard.this.rootField), "South");
            centerPanel.add((Component)westCenterPanel, "West");
            JPanel buttonPanel = new JPanel();
            JButton close = new JButton("Close");
            close.addActionListener(new CloseWindowListener());
            JButton next = new JButton("Next");
            next.setEnabled(true);
            next.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GrowGraphWizard.this.root = GrowGraphWizard.this.rootField.getText().trim();
                    GrowGraphWizard.this.frame.getContentPane().removeAll();
                    GrowGraphWizard.this.frame.add(new BlockAdder());
                    GrowGraphWizard.this.frame.pack();
                    GrowGraphWizard.this.frame.repaint();
                }
            });
            buttonPanel.add(close);
            buttonPanel.add(next);
            centerPanel.add((Component)buttonPanel, "South");
            this.add(centerPanel);
        }
    }

    private class ConstraintInfo {
        int j1;
        int j2;
        int b1;
        int b2;
        int bases;

        private ConstraintInfo() {
        }
    }

    private class JunctionInfo {
        StrandJunction3D junction;
        int order;
        int index;
        String type;

        private JunctionInfo() {
        }
    }
}

