/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp.rnagui;

import commandtools.CommandApplication;
import commandtools.CommandException;
import controltools.ModelChangeEvent;
import controltools.ModelChangeListener;
import generaltools.StringTools;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.XMLEncoder;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import launchtools.SimpleQueueManager;
import rnadesign.designapp.NanoTilerScripter;
import rnadesign.designapp.rnagui.AddBasepairsWizard;
import rnadesign.designapp.rnagui.AddHelixWizard;
import rnadesign.designapp.rnagui.ApplyModeWizard;
import rnadesign.designapp.rnagui.Browser;
import rnadesign.designapp.rnagui.CharPanelBase;
import rnadesign.designapp.rnagui.ChosenWizard;
import rnadesign.designapp.rnagui.CloneWizard;
import rnadesign.designapp.rnagui.CubicGridWizard;
import rnadesign.designapp.rnagui.DistanceWizard;
import rnadesign.designapp.rnagui.ElasticNetworkWizard;
import rnadesign.designapp.rnagui.ElasticWizard;
import rnadesign.designapp.rnagui.EnvWizard;
import rnadesign.designapp.rnagui.FuseStrandsWizard;
import rnadesign.designapp.rnagui.GenLinkWizard;
import rnadesign.designapp.rnagui.GeneralGeometryPainter;
import rnadesign.designapp.rnagui.GeometryPainter;
import rnadesign.designapp.rnagui.GeometryPainterFactory;
import rnadesign.designapp.rnagui.GraphControlPanel;
import rnadesign.designapp.rnagui.GraphPanel;
import rnadesign.designapp.rnagui.GraphicsManualWizard;
import rnadesign.designapp.rnagui.GraphitGridWizard;
import rnadesign.designapp.rnagui.GrowGraphWizard;
import rnadesign.designapp.rnagui.GrowWizard;
import rnadesign.designapp.rnagui.HelixConstraintWizard;
import rnadesign.designapp.rnagui.HelpWizard;
import rnadesign.designapp.rnagui.ImportWizard;
import rnadesign.designapp.rnagui.InsertLinkWizard;
import rnadesign.designapp.rnagui.JobViewer;
import rnadesign.designapp.rnagui.JunctionParameterWizard;
import rnadesign.designapp.rnagui.LaunchMcSymWizard;
import rnadesign.designapp.rnagui.LaunchRnaInverseWizard;
import rnadesign.designapp.rnagui.ManualRotateWizard;
import rnadesign.designapp.rnagui.MinimizeWizard;
import rnadesign.designapp.rnagui.MoveWizard;
import rnadesign.designapp.rnagui.NanoTilerGeometryPainterFactory;
import rnadesign.designapp.rnagui.Object3DInputMask;
import rnadesign.designapp.rnagui.Object3DTreePanel;
import rnadesign.designapp.rnagui.OptbasepairsWizard;
import rnadesign.designapp.rnagui.OptimizationWizard;
import rnadesign.designapp.rnagui.PackageConstants;
import rnadesign.designapp.rnagui.PlaceJunctionWizard;
import rnadesign.designapp.rnagui.PlanarWizard;
import rnadesign.designapp.rnagui.PlatonicSolidWizard;
import rnadesign.designapp.rnagui.PointPainter;
import rnadesign.designapp.rnagui.QuaderWizard;
import rnadesign.designapp.rnagui.RemoveLinksWizard;
import rnadesign.designapp.rnagui.RenameWizard;
import rnadesign.designapp.rnagui.RnaControllerParameters;
import rnadesign.designapp.rnagui.RnaGuiParameters;
import rnadesign.designapp.rnagui.RnaModelParameters;
import rnadesign.designapp.rnagui.RnaStrandGuiWizard;
import rnadesign.designapp.rnagui.RunScriptWizard;
import rnadesign.designapp.rnagui.ScriptCommandDisplay;
import rnadesign.designapp.rnagui.SecondaryStructureEditorWizardNoThread;
import rnadesign.designapp.rnagui.SelectPanel;
import rnadesign.designapp.rnagui.SelectWizard;
import rnadesign.designapp.rnagui.SelectedPanel;
import rnadesign.designapp.rnagui.ShiftWizard;
import rnadesign.designapp.rnagui.SignatureWizard;
import rnadesign.designapp.rnagui.SimplePainter;
import rnadesign.designapp.rnagui.SynthWizard;
import rnadesign.designapp.rnagui.ViewLinksWizard;
import rnadesign.designapp.rnagui.ViewTreeWizard;
import rnadesign.designapp.rnagui.WelcomeWindowWizard;
import rnadesign.rnacontrol.BindingSiteController;
import rnadesign.rnacontrol.JunctionController;
import rnadesign.rnacontrol.LinkController;
import rnadesign.rnacontrol.Object3DController;
import rnadesign.rnacontrol.Object3DGraphController;
import rnadesign.rnacontrol.Object3DGraphControllerException;
import rnadesign.rnacontrol.PdbJunctionController;
import rnadesign.rnacontrol.SequenceController;
import rnadesign.rnacontrol.SimpleCameraController;
import rnadesign.rnamodel.JunctionCollector;
import rnadesign.rnamodel.Residue3D;
import rnadesign.rnamodel.RnaStrand;
import rnadesign.rnamodel.SequenceBindingSite;
import rnasecondary.InteractionSet;
import rnasecondary.MutableSecondaryStructure;
import rnasecondary.SecondaryStructureScriptFormatWriter;
import sequence.DnaTools;
import sequence.DuplicateNameException;
import sequence.Sequence;
import sequence.SequenceSubset;
import sequence.UnevenAlignment;
import sequence.UnknownSequenceException;
import sequence.UnknownSymbolException;
import tools3d.SimpleCamera;
import tools3d.Vector3D;
import tools3d.objects3d.Link;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.Object3DDefaultWriter;
import tools3d.objects3d.Object3DIOException;
import tools3d.objects3d.Object3DLinkSetBundle;
import tools3d.objects3d.Object3DTools;
import tools3d.objects3d.SimpleObject3DLinkSetBundle;
import viewer.rnadesign.GraphControllerDisplayManager;

public class NanoTiler
extends NanoTilerScripter
implements ModelChangeListener {
    private static ResourceBundle rb = ResourceBundle.getBundle("NanoTiler");
    public static final String WIKI_PAGE = rb.getString("wikihome");
    public static boolean developmentVersion = false;
    public static final String PDB_EXTENSION = ".pdb";
    public static final String NAMES_EXTENSION = ".names";
    public static final String POINTS_EXTENSION = ".points";
    public static String nanotilerHome = System.getenv("NANOTILER_HOME");
    public static final String TUTORIAL_HOME = "file://" + nanotilerHome + "/doc/nanotiler_tutorial.html";
    private static final String LOD_COARSE = "Coarse";
    private static final String LOD_MEDIUM = "Medium";
    private static final String LOD_FINE = "Fine";
    private JunctionController junctionController = new PdbJunctionController();
    public static String tilingStatisticsString = new String("");
    private RnaControllerParameters cparams = new RnaControllerParameters();
    private RnaModelParameters mparams = new RnaModelParameters();
    private RnaGuiParameters params = new RnaGuiParameters();
    private GraphControllerDisplayManager graphControllerDisplayManager;
    private JFrame rootFrame;
    private List<Component> frames = new ArrayList<Component>();
    private List<GraphControlPanel> graphControllPanels = new ArrayList<GraphControlPanel>();
    private static Logger log;
    public static boolean RIGHT_TO_LEFT;
    NanoTiler nanotilerApp;
    public GeometryPainterFactory geometryPainterFactory = new NanoTilerGeometryPainterFactory();
    public boolean openGLGraphics = false;
    JMenuItem menuItem;
    JCheckBox checkBox;

    @Override
    public void modelChanged(ModelChangeEvent e) {
        this.repaintApp();
    }

    NanoTiler(Object3DGraphController controller) {
        super(controller);
        if (log == null) {
            log = Logger.getAnonymousLogger();
        }
        if (nanotilerHome == null || nanotilerHome.length() == 0) {
            log.severe("NANOTILER_HOME variable is undefined!");
            System.exit(1);
        }
        this.nanotilerApp = this;
        this.graphController.addModelChangeListener(this);
        try {
            String nucdbName = rb.getString("nucleotides");
            if (nucdbName == null || nucdbName.length() == 0) {
                log.severe("Warning: undefined nucleotide database name! Use property nucleotides in property file");
            } else {
                char c = nucdbName.charAt(0);
                if (c != PackageConstants.SLASH.charAt(0)) {
                    nucdbName = nanotilerHome + PackageConstants.SLASH + nucdbName;
                }
                this.graphController.readNucleotideDB(nucdbName);
            }
        }
        catch (Object3DGraphControllerException e) {
            log.severe("Warning: could not read nucleotide database: " + e.getMessage());
        }
    }

    public void addComponentsToFrame(JFrame frame) {
        frame.setBackground(RnaGuiParameters.colorBackground);
        Container pane = frame.getContentPane();
        frame.setJMenuBar(new RnaMenuBar(this));
        if (!(pane.getLayout() instanceof BorderLayout)) {
            pane.add(new JLabel("Container doesn't use BorderLayout!"));
            return;
        }
        if (RIGHT_TO_LEFT) {
            pane.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        }
        JPanel centerPanel = new JPanel();
        if (this.openGLGraphics) {
            centerPanel.setLayout(new BoxLayout(centerPanel, 3));
            centerPanel.setBorder(BorderFactory.createLineBorder(Color.black));
            SimpleCameraController xyProjector = new SimpleCameraController(new SimpleCamera());
            xyProjector.setOrigin2D((int)(this.params.xScreenMax / 2.0), (int)(this.params.yScreenMax / 2.0));
            this.graphControllerDisplayManager = new GraphControllerDisplayManager(this.graphController, this.nanotilerApp);
            centerPanel.add(this.graphControllerDisplayManager);
        } else {
            RnaGuiParameters params = new RnaGuiParameters();
            GraphControlPanel graphPanel = new GraphControlPanel(params, this.graphController);
            SimpleCameraController xyProjector = new SimpleCameraController(new SimpleCamera());
            xyProjector.setOrigin2D((int)(params.xScreenMax / 2.0), (int)(params.yScreenMax / 2.0));
            graphPanel.setCameraController(xyProjector);
            NanoTilerGeometryPainterFactory geometryPainterFactory = new NanoTilerGeometryPainterFactory();
            GeometryPainter geometryPainter = geometryPainterFactory.createPainter(2);
            GeneralGeometryPainter newPainter = new GeneralGeometryPainter(params, geometryPainter, this.graphController);
            newPainter.setCameraController(xyProjector);
            graphPanel.setPainter(newPainter);
            this.graphController.addModelChangeListener(graphPanel.graphPanel);
            centerPanel.add(graphPanel);
        }
        pane.add((Component)centerPanel, "Center");
        pane.add((Component)new TopPanel(), "North");
        BottomPanel bottom = new BottomPanel(this);
        pane.add((Component)bottom, "South");
    }

    private void launchWelcomeWindow() {
        log.fine("Welcome window wizard started");
        WelcomeWindowWizard wizard = new WelcomeWindowWizard(this.nanotilerApp);
        wizard.launchWizard(this.graphController, this.rootFrame);
    }

    public void setGLGraphics(boolean choice) {
        this.openGLGraphics = choice;
    }

    private void chooseGLGraphics() {
        String msg = "Use Java based graphics? Ok confirms, cancel starts OpenGL graphics.";
        String title = "Choose Graphics Style";
        JFrame choiceFrame = new JFrame("Use Java graphics? Ok confirms, cancel starts OpenGL graphics.");
        int choice = JOptionPane.showConfirmDialog(null, msg, title, 2);
        if (choice == 0) {
            log.info("Java Foundation class graphics chosen!");
            this.openGLGraphics = false;
        } else {
            log.info("OpenGL graphics chosen!");
            this.openGLGraphics = true;
        }
    }

    private void registerComponent(Component c) {
        this.frames.add(c);
    }

    public void setLogger(Logger logger) {
        log = logger;
    }

    private void repaintApp() {
        this.rootFrame.repaint();
        for (int i = 0; i < this.frames.size(); ++i) {
            if (!(this.frames.get(i) instanceof Component)) continue;
            Component c = this.frames.get(i);
            c.repaint();
        }
        log.fine("called repaintApp!");
    }

    private void setRootFrame(JFrame frame) {
        this.rootFrame = frame;
    }

    private static void createAndShowGUI() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JFrame frame = new JFrame("NanoTiler");
        frame.setDefaultCloseOperation(3);
        Object3DGraphController controller = new Object3DGraphController();
        NanoTiler app = new NanoTiler(controller);
        Logger debugLog = Logger.getLogger("NanoTiler_debug");
        String debugFileName = "NanoTiler_debug.log";
        try {
            FileHandler debugLogFileHandler = new FileHandler(debugFileName);
            debugLogFileHandler.setLevel(Level.FINEST);
            debugLogFileHandler.setFormatter(new SimpleFormatter());
            debugLog.addHandler(debugLogFileHandler);
            debugLog.info("Writing debug info to file : " + debugFileName);
        }
        catch (IOException e) {
            debugLog.severe("Could not open debug output file name: " + debugFileName);
        }
        debugLog.setLevel(Level.FINE);
        app.setLogger(debugLog);
        app.chooseGLGraphics();
        app.addComponentsToFrame(frame);
        app.setRootFrame(frame);
        frame.pack();
        frame.setSize(1100, 700);
        frame.setVisible(true);
        try {
            app.runDefaultScript();
        }
        catch (CommandException ce) {
            System.out.println("Could not execute default script: " + ce.getMessage());
            System.exit(1);
        }
        catch (IOException ioe) {
            System.out.println("Could not execute default script: " + ioe.getMessage());
            System.exit(1);
        }
        app.launchWelcomeWindow();
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NanoTiler.createAndShowGUI();
            }
        });
    }

    static {
        RIGHT_TO_LEFT = false;
    }

    private class BottomPanel
    extends JPanel {
        private static final long serialVersionUID = -233359782949400973L;

        BottomPanel(CommandApplication commandApplication) {
            NanoTiler.this.params;
            this.setBackground(RnaGuiParameters.colorBackground);
            this.setBorder(BorderFactory.createLineBorder(Color.black));
            this.setLayout(new BorderLayout());
            this.setPreferredSize(new Dimension(((NanoTiler)NanoTiler.this).params.bottomPanelWidth, ((NanoTiler)NanoTiler.this).params.bottomPanelHeight));
            JTabbedPane tabbedPane = new JTabbedPane(1);
            JScrollPane scrollPane = new JScrollPane(new BottomPanelCenter());
            tabbedPane.addTab("Script commands", null, new ScriptCommandDisplay(commandApplication), "Script commands");
            tabbedPane.addTab("Secondary Structure", null, new RnaSecondaryStructureDisplay(), "Display Secondary Structure");
            this.add(tabbedPane);
            this.setVisible(true);
        }

        private class BottomPanelCenter
        extends JPanel
        implements Scrollable {
            private static final long serialVersionUID = -8705671670248050084L;
            private static final int COL_WIDTH = 10;
            private static final int ROW_HEIGHT = 14;

            BottomPanelCenter() {
                NanoTiler.this.params;
                this.setBackground(RnaGuiParameters.colorBackground);
                this.setBorder(BorderFactory.createLineBorder(Color.black));
                this.setPreferredSize(new Dimension(3 * ((NanoTiler)NanoTiler.this).params.bottomPanelCenterWidth, 3 * ((NanoTiler)NanoTiler.this).params.bottomPanelCenterHeight));
            }

            private int getCharPosX(int col) {
                return 10 + col * 10;
            }

            private int getCharPosY(int row) {
                return 20 + row * 14;
            }

            private void writeChar(Graphics g, char[] chars, int row, int col) {
                int xpos = this.getCharPosX(col);
                int ypos = this.getCharPosY(row);
                g.drawChars(chars, col, 1, xpos, ypos);
            }

            private void writeString(Graphics g, String s, int n) {
                char[] charArray = s.toCharArray();
                for (int i = 0; i < s.length(); ++i) {
                    this.writeChar(g, charArray, n + 1, i);
                }
            }

            private void drawBindingSite(Graphics g, int n) {
                BindingSiteController bindingSites = NanoTiler.this.graphController.getBindingSites();
                SequenceBindingSite site = bindingSites.getBindingSite(n);
                int seqId = 0;
                int len = site.getBindingSequence().size();
                int startId = site.getBindingSequence().getIndex(0);
                int stopId = site.getBindingSequence().getIndex(len - 1);
                int startX = this.getCharPosX(startId);
                int stopX = this.getCharPosX(stopId);
                int posY = this.getCharPosY(seqId + 1) + 3;
                g.drawLine(startX, posY, stopX, posY);
            }

            private void drawStem(Graphics g, int n) {
                LinkController links = NanoTiler.this.graphController.getLinks();
                Link link = links.get(n);
                if (link.getObj1() instanceof SequenceBindingSite && link.getObj2() instanceof SequenceBindingSite) {
                    SequenceBindingSite site1 = (SequenceBindingSite)link.getObj1();
                    SequenceBindingSite site2 = (SequenceBindingSite)link.getObj2();
                    SequenceController sequences = NanoTiler.this.graphController.getSequences();
                    int seqId1 = sequences.getSequenceId(site1.getBindingSequence().getSequence());
                    int seqId2 = sequences.getSequenceId(site2.getBindingSequence().getSequence());
                    log.info("Connectected sequences: " + seqId1 + " " + seqId2);
                    if (seqId1 >= 0 && seqId2 >= 0) {
                        SequenceSubset subset1 = site1.getBindingSequence();
                        SequenceSubset subset2 = site2.getBindingSequence();
                        int startId1 = subset1.getIndex(0);
                        int stopId1 = subset1.getIndex(subset1.size() - 1);
                        int startId2 = subset2.getIndex(0);
                        int stopId2 = subset2.getIndex(subset2.size() - 1);
                        int startX = this.getCharPosX((startId1 + stopId1) / 2);
                        int stopX = this.getCharPosX((startId2 + stopId2) / 2);
                        int startY = this.getCharPosY(seqId1) + 14 + 3;
                        int stopY = this.getCharPosY(seqId2) + 14 + 3;
                        g.drawLine(startX, startY, stopX, stopY);
                    } else {
                        log.info("Could not find sequence object in controller!");
                    }
                }
            }

            String generateSequenceInfoString(Sequence seq) {
                String result = "";
                if (seq.getParentObject() != null) {
                    Object3D parent = (Object3D)seq.getParentObject();
                    if (parent instanceof RnaStrand) {
                        result = "RNA; ";
                    }
                    result = StringTools.stringWithLength(result + seq.size() + " " + parent.getName(), 20, " ") + " : ";
                }
                result = result + seq.sequenceString();
                return result;
            }

            @Override
            public void paintComponent(Graphics g) {
                int i;
                super.paintComponent(g);
                int numObjects = NanoTiler.this.graphController.getGraph().getObjectCount();
                SequenceController sequences = NanoTiler.this.graphController.getSequences();
                int numSeq = sequences.getSequenceCount();
                BindingSiteController bindingSites = NanoTiler.this.graphController.getBindingSites();
                int numSites = bindingSites.getBindingSiteCount();
                LinkController links = NanoTiler.this.graphController.getLinks();
                int numLinks = links.size();
                String headerTxt = PackageConstants.NEWLINE + "Objects: " + numObjects + " Sequences: " + numSeq + " Links: " + numLinks + PackageConstants.NEWLINE;
                this.writeString(g, headerTxt, -1);
                for (i = 0; i < numSeq; ++i) {
                    String seqInfoString = this.generateSequenceInfoString(sequences.getSequence(i));
                    this.writeString(g, seqInfoString, i);
                }
                for (i = 0; i < numSites; ++i) {
                    this.drawBindingSite(g, i);
                }
                for (i = 0; i < numLinks; ++i) {
                    this.drawStem(g, i);
                }
            }

            @Override
            public Dimension getPreferredScrollableViewportSize() {
                return this.getPreferredSize();
            }

            @Override
            public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
                if (orientation == 0) {
                    return 10;
                }
                return 14;
            }

            @Override
            public boolean getScrollableTracksViewportHeight() {
                return false;
            }

            @Override
            public boolean getScrollableTracksViewportWidth() {
                return false;
            }

            @Override
            public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
                return this.getScrollableBlockIncrement(visibleRect, orientation, direction);
            }
        }

        private class RnaSecondaryStructureDisplay
        extends JPanel {
            private JTextArea textPane;

            public RnaSecondaryStructureDisplay() {
                this.setPreferredSize(new Dimension(((NanoTiler)NanoTiler.this).params.bottomPanelWidth, ((NanoTiler)NanoTiler.this).params.bottomPanelHeight));
                this.setLayout(new BorderLayout());
                this.textPane = new JTextArea();
                this.textPane.setEditable(false);
                this.textPane.setText("No Information Provided");
                this.textPane.setFont(new Font("Monospaced", 0, 14));
                NanoTiler.this.graphController.addModelChangeListener(new ModelChangeListener(){

                    @Override
                    public void modelChanged(ModelChangeEvent e) {
                        SecondaryStructureScriptFormatWriter writer = new SecondaryStructureScriptFormatWriter();
                        String secText = "undefined";
                        MutableSecondaryStructure sec = null;
                        try {
                            sec = NanoTiler.this.graphController.generateSecondaryStructure();
                            if (sec != null) {
                                secText = writer.writeString(sec);
                            }
                        }
                        catch (DuplicateNameException dne) {
                            log.warning("Duplicate sequence names detected! Cannot generate secondary structure.");
                        }
                        RnaSecondaryStructureDisplay.this.textPane.setText(secText);
                        RnaSecondaryStructureDisplay.this.repaint();
                    }
                });
                this.add(new JScrollPane(this.textPane));
            }
        }

        private class JunctionDisplay
        extends JPanel {
            private JTextArea textPane;

            public JunctionDisplay() {
                this.setPreferredSize(new Dimension(((NanoTiler)NanoTiler.this).params.bottomPanelWidth, ((NanoTiler)NanoTiler.this).params.bottomPanelHeight));
                this.setLayout(new BorderLayout());
                this.textPane = new JTextArea();
                this.textPane.setEditable(false);
                this.textPane.setText("No Information Provided");
                NanoTiler.this.graphController.addModelChangeListener(new ModelChangeListener(){

                    @Override
                    public void modelChanged(ModelChangeEvent e) {
                        JunctionCollector collector = NanoTiler.this.graphController.generateJunctions();
                        String text = "";
                        if (collector != null) {
                            for (int i = 0; i < collector.getJunctionCount(); ++i) {
                                int j;
                                text = text + collector.getJunction(i).toString() + PackageConstants.NEWLINE;
                                text = text + "Branches:" + PackageConstants.NEWLINE;
                                for (j = 0; j < collector.getJunction(i).getBranchCount(); ++j) {
                                    text = text + "\t" + collector.getJunction(i).getBranch(j).infoString();
                                }
                                text = text + PackageConstants.NEWLINE + "Strands:" + PackageConstants.NEWLINE;
                                for (j = 0; j < collector.getJunction(i).getStrandCount(); ++j) {
                                    text = text + "\t" + collector.getJunction(i).getStrand(j).sequenceString();
                                }
                                text = text + PackageConstants.NEWLINE + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
                            }
                        }
                        JunctionDisplay.this.textPane.setText(text);
                    }
                });
                this.add(new JScrollPane(this.textPane));
            }
        }
    }

    private class LeftPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;

        LeftPanel() {
            NanoTiler.this.params;
            this.setBackground(RnaGuiParameters.colorBackground);
            this.setPreferredSize(new Dimension(((NanoTiler)NanoTiler.this).params.leftPanelWidth, ((NanoTiler)NanoTiler.this).params.leftPanelHeight));
            this.setLayout(new BoxLayout(this, 3));
        }

        private class EditPanel
        extends JPanel {
            private static final long serialVersionUID = -2933863053809027476L;

            EditPanel() {
                NanoTiler.this.params;
                this.setBackground(RnaGuiParameters.colorBackground);
                this.setPreferredSize(new Dimension(((NanoTiler)NanoTiler.this).params.editPanelWidth, ((NanoTiler)NanoTiler.this).params.editPanelHeight));
                this.setBorder(BorderFactory.createLineBorder(Color.black));
            }
        }

        private class BlockPanel
        extends JPanel {
            private static final long serialVersionUID = 8221200532104481130L;

            BlockPanel() {
                NanoTiler.this.params;
                this.setBackground(RnaGuiParameters.colorBackground);
                this.setPreferredSize(new Dimension(((NanoTiler)NanoTiler.this).params.blockPanelWidth, ((NanoTiler)NanoTiler.this).params.blockPanelHeight));
                this.setBorder(BorderFactory.createLineBorder(Color.black));
                JButton button = new JButton("  Strand  ");
                button.setPreferredSize(new Dimension(((NanoTiler)NanoTiler.this).params.blockPanelButtonWidth, ((NanoTiler)NanoTiler.this).params.blockPanelButtonHeight));
                button.addActionListener(new NewStrandActionListener());
                button.setToolTipText("Create strand with n atoms");
                this.add(button);
                button = new JButton("  Grid    ");
                button.setPreferredSize(new Dimension(((NanoTiler)NanoTiler.this).params.blockPanelButtonWidth, ((NanoTiler)NanoTiler.this).params.blockPanelButtonHeight));
                button.addActionListener(new NewGridActionListener());
                button.setToolTipText("Insert Cubic Grid Wizard");
                this.add(button);
            }
        }
    }

    private class RightPanel
    extends JPanel {
        private static final long serialVersionUID = -5292034988486352842L;
        Object3DTreePanel selectionTree;

        RightPanel() {
            NanoTiler.this.params;
            this.setBackground(RnaGuiParameters.colorBackground);
            this.setPreferredSize(new Dimension(((NanoTiler)NanoTiler.this).params.rightPanelWidth, ((NanoTiler)NanoTiler.this).params.rightPanelHeight));
            this.setBorder(BorderFactory.createLineBorder(Color.black));
            this.setLayout(new BoxLayout(this, 0));
            JPanel rightHalf = new JPanel();
            rightHalf.setLayout(new BoxLayout(rightHalf, 1));
            rightHalf.setBorder(BorderFactory.createLineBorder(Color.black));
            JPanel leftHalf = new JPanel();
            JLabel treeLabel = new JLabel("Tree");
            treeLabel.setSize(new Dimension(50, 25));
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints gridbagc = new GridBagConstraints();
            int[] rowH = new int[]{18, ((NanoTiler)NanoTiler.this).params.rightPanelHeight - 18};
            gridbag.rowHeights = rowH;
            int[] columnW = new int[]{((NanoTiler)NanoTiler.this).params.rightPanelWidth / 2};
            gridbag.columnWidths = columnW;
            gridbagc.gridx = 0;
            gridbagc.gridy = 0;
            gridbagc.fill = 1;
            gridbag.setConstraints(treeLabel, gridbagc);
            leftHalf.setLayout(gridbag);
            leftHalf.setBorder(BorderFactory.createLineBorder(Color.black));
            JLabel label = new JLabel("Move:   ");
            rightHalf.add(label);
            rightHalf.add(new MovePanel());
            rightHalf.add(new JSeparator());
            rightHalf.add(new JLabel("Select:  "));
            rightHalf.add(new SelectPanel(((NanoTiler)NanoTiler.this).params.selectPanelParameters, NanoTiler.this.graphController.getGraph()));
            Object3DController object3DController = NanoTiler.this.graphController.getGraph();
            gridbagc.gridx = 0;
            gridbagc.gridy = 1;
            gridbagc.weighty = 1.0;
            gridbagc.weightx = 1.0;
            leftHalf.add(treeLabel);
            this.add(rightHalf);
        }

        private class MovePanel
        extends JPanel {
            private static final long serialVersionUID = 3781759864250812197L;

            MovePanel() {
                NanoTiler.this.params;
                this.setBackground(RnaGuiParameters.colorBackground);
                this.setBorder(BorderFactory.createLineBorder(Color.black));
                this.setPreferredSize(new Dimension(((NanoTiler)NanoTiler.this).params.movePanelWidth, ((NanoTiler)NanoTiler.this).params.movePanelHeight));
                this.setLayout(new GridLayout(6, 2));
                JButton button = new JButton("x+");
                button.setPreferredSize(new Dimension(((NanoTiler)NanoTiler.this).params.movePanelButtonWidth, ((NanoTiler)NanoTiler.this).params.movePanelButtonHeight));
                button.setToolTipText("translate x+ direction");
                button.addActionListener(new MoveNorthListener());
                this.add(button);
                button = new JButton("x-");
                button.setPreferredSize(new Dimension(((NanoTiler)NanoTiler.this).params.movePanelButtonWidth, ((NanoTiler)NanoTiler.this).params.movePanelButtonHeight));
                button.setToolTipText("translate x- direction");
                button.addActionListener(new MoveSouthListener());
                this.add(button);
                button = new JButton("y+");
                button.setPreferredSize(new Dimension(((NanoTiler)NanoTiler.this).params.movePanelButtonWidth, ((NanoTiler)NanoTiler.this).params.movePanelButtonHeight));
                button.setToolTipText("translate y+ direction");
                button.addActionListener(new MoveRightListener());
                this.add(button);
                button = new JButton("y-");
                button.setPreferredSize(new Dimension(((NanoTiler)NanoTiler.this).params.movePanelButtonWidth, ((NanoTiler)NanoTiler.this).params.movePanelButtonHeight));
                button.setToolTipText("translate y- direction");
                button.addActionListener(new MoveLeftListener());
                this.add(button);
                button = new JButton("z+");
                button.setPreferredSize(new Dimension(((NanoTiler)NanoTiler.this).params.movePanelButtonWidth, ((NanoTiler)NanoTiler.this).params.movePanelButtonHeight));
                button.setToolTipText("translate z+ direction");
                button.addActionListener(new MoveUpListener());
                this.add(button);
                button = new JButton("z-");
                button.setPreferredSize(new Dimension(((NanoTiler)NanoTiler.this).params.movePanelButtonWidth, ((NanoTiler)NanoTiler.this).params.movePanelButtonHeight));
                button.setToolTipText("translate z- direction");
                button.addActionListener(new MoveDownListener());
                this.add(button);
                button = new JButton("Rot");
                button.setPreferredSize(new Dimension(((NanoTiler)NanoTiler.this).params.movePanelButtonWidth, ((NanoTiler)NanoTiler.this).params.movePanelButtonHeight));
                button.setToolTipText("Rotate");
                button.addActionListener(new RotateListener());
                this.add(button);
                button = new JButton(" ");
                button.setPreferredSize(new Dimension(((NanoTiler)NanoTiler.this).params.movePanelButtonWidth, ((NanoTiler)NanoTiler.this).params.movePanelButtonHeight));
                this.add(button);
                button = new JButton("HU");
                button.setPreferredSize(new Dimension(((NanoTiler)NanoTiler.this).params.movePanelButtonWidth, ((NanoTiler)NanoTiler.this).params.movePanelButtonHeight));
                button.setToolTipText("move Hierarchy Up");
                button.addActionListener(new HierarchyUpListener());
                this.add(button);
                button = new JButton("HD");
                button.addActionListener(new HierarchyDownListener());
                button.setToolTipText("move Hierarchy Down");
                button.setPreferredSize(new Dimension(((NanoTiler)NanoTiler.this).params.selectPanelButtonWidth, ((NanoTiler)NanoTiler.this).params.movePanelButtonHeight));
                this.add(button);
            }
        }
    }

    private class TopPanel
    extends JPanel {
        private static final long serialVersionUID = 1394592164988290863L;

        TopPanel() {
            NanoTiler.this.params;
            this.setBackground(RnaGuiParameters.colorBackground);
            this.setBorder(BorderFactory.createLineBorder(Color.black));
            this.setLayout(new FlowLayout());
        }
    }

    private class MaxDepthPanel
    extends CharPanelBase {
        MaxDepthPanel() {
            this.setPreferredSize(new Dimension(50, 50));
        }

        @Override
        public void paint(Graphics g) {
            String s = "" + NanoTiler.this.graphController.getGraph().getDepthMax();
            this.writeString(g, s, 1);
        }
    }

    private class RnaMenuBar
    extends JMenuBar {
        private static final long serialVersionUID = -8919620750494034628L;
        private NanoTiler app;

        RnaMenuBar(NanoTiler app) {
            this.app = app;
            JMenu menu = new JMenu("File");
            JMenuItem item = new JMenuItem("Run Script");
            item.setToolTipText("Run a script");
            item.addActionListener(new RunScriptActionListener());
            menu.add(item);
            item = new JMenuItem("Import");
            item.setToolTipText("Import PDB file or PointSet");
            item.addActionListener(new ImportActionListener(app));
            menu.add(item);
            item = new JMenuItem("Export");
            JMenu subMenu = new JMenu("Export...");
            subMenu.setToolTipText("Export file");
            item = new JMenuItem("PDB (all)");
            item.addActionListener(new ExportPdbActionListener());
            subMenu.add(item);
            item = new JMenuItem("PDB (Junctions only)");
            item.addActionListener(new ExportJunctionsPdbActionListener());
            subMenu.add(item);
            item = new JMenuItem("Secondary Structure");
            item.addActionListener(new ExportSecondaryStructureListener());
            subMenu.add(item);
            item = new JMenuItem("PDB");
            menu.add(subMenu);
            subMenu = new JMenu("Demo...");
            item = new JMenuItem("Grow");
            item.addActionListener(new RunDemoListener("grow.script"));
            subMenu.add(item);
            item = new JMenuItem("Grow graph");
            item.addActionListener(new RunDemoListener("growgraph.script"));
            subMenu.add(item);
            item = new JMenuItem("Mutate");
            item.addActionListener(new RunDemoListener("mutate.script"));
            subMenu.add(item);
            item = new JMenuItem("Optimize base pairs");
            item.addActionListener(new RunDemoListener("optbasepairs.script"));
            subMenu.add(item);
            item = new JMenuItem("Ring fuse");
            item.addActionListener(new RunDemoListener("ringfuse.script"));
            subMenu.add(item);
            item = new JMenuItem("Place Junction");
            item.addActionListener(new RunDemoListener("place.script"));
            subMenu.add(item);
            item = new JMenuItem("Run all demos...");
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        NanoTiler.this.runScriptLine("demo all");
                    }
                    catch (CommandException ce) {
                        JOptionPane.showMessageDialog(null, ce.getMessage(), "Error", -1);
                    }
                }
            });
            subMenu.add(item);
            menu.add(subMenu);
            menu.add(new JSeparator());
            item = new JMenuItem("Quit");
            item.addActionListener(new ExitActionListener());
            item.setToolTipText("Quit program");
            menu.add(item);
            this.add(menu);
            menu = new JMenu("Edit");
            item = new JMenuItem("Clear all");
            item.addActionListener(new ClearActionListener());
            item.setToolTipText("Clear all structures in window");
            menu.add(item);
            item = new JMenuItem("Clone");
            item.setToolTipText("Clone an object to a new name and location");
            item.addActionListener(new CloneListener());
            menu.add(item);
            item = new JMenuItem("Fuse Strands");
            item.setToolTipText("Fuse two strands together");
            item.addActionListener(new AddFuseStrandsListener());
            menu.add(item);
            item = new JMenuItem("Move Object");
            item.setToolTipText("Move an object to a new location withing the tree");
            item.addActionListener(new MoveListener());
            menu.add(item);
            item = new JMenuItem("Select");
            item.addActionListener(new SelectListener(NanoTiler.this.nanotilerApp));
            item.setToolTipText("Select an object");
            menu.add(item);
            item = new JMenuItem("Shift");
            item.addActionListener(new ShiftListener(NanoTiler.this.nanotilerApp));
            item.setToolTipText("Shift an object");
            menu.add(item);
            item = new JMenuItem("Remove Link");
            item.setToolTipText("Remove an existing link between objects");
            item.addActionListener(new RemoveLinkListener());
            menu.add(item);
            item = new JMenuItem("Rename");
            item.addActionListener(new RenameListener(NanoTiler.this.nanotilerApp));
            item.setToolTipText("Rename an object");
            menu.add(item);
            item = new JMenuItem("Rotate");
            item.addActionListener(new ManualRotateListener(NanoTiler.this.nanotilerApp));
            menu.add(item);
            this.add(menu);
            menu = new JMenu("View");
            NanoTiler.this.menuItem = new JMenuItem("Selected Object");
            NanoTiler.this.menuItem.addActionListener(new ChosenListener(NanoTiler.this.nanotilerApp));
            menu.add(NanoTiler.this.menuItem);
            NanoTiler.this.menuItem = new JMenuItem("Tree");
            NanoTiler.this.menuItem.addActionListener(new ViewTreeListener());
            NanoTiler.this.menuItem.setToolTipText("View the tree");
            menu.add(NanoTiler.this.menuItem);
            NanoTiler.this.menuItem = new JMenuItem("Links");
            NanoTiler.this.menuItem.addActionListener(new ViewLinksListener());
            NanoTiler.this.menuItem.setToolTipText("View all links");
            menu.add(NanoTiler.this.menuItem);
            NanoTiler.this.menuItem = new JMenuItem("Atoms");
            NanoTiler.this.menuItem.addActionListener(new Atom3DActionListener());
            NanoTiler.this.menuItem.setToolTipText("Switch off atoms");
            NanoTiler.this.menuItem = new JMenuItem("Generate Signature");
            NanoTiler.this.menuItem.setToolTipText("Generate the signature of a given object");
            NanoTiler.this.menuItem.addActionListener(new GenerateSignatureListener());
            menu.add(NanoTiler.this.menuItem);
            NanoTiler.this.menuItem = new JMenuItem("Get Distance");
            NanoTiler.this.menuItem.setToolTipText("Get the distance between two given atoms");
            NanoTiler.this.menuItem.addActionListener(new DistanceListener());
            menu.add(NanoTiler.this.menuItem);
            NanoTiler.this.menuItem = new JMenuItem("View Variables");
            NanoTiler.this.menuItem.setToolTipText("View the existing set variables");
            NanoTiler.this.menuItem.addActionListener(new ViewVariablesListener());
            menu.add(NanoTiler.this.menuItem);
            this.add(menu);
            menu = new JMenu("Actions");
            item = new JMenuItem("Select Object");
            item.addActionListener(new SelectListener(NanoTiler.this.nanotilerApp));
            item.setToolTipText("Select an object");
            menu.add(item);
            item = new JMenuItem("Shift Object");
            item.addActionListener(new ShiftListener(NanoTiler.this.nanotilerApp));
            item.setToolTipText("Shift an Object");
            menu.add(item);
            item = new JMenuItem("Rename Object");
            item.addActionListener(new RenameListener(NanoTiler.this.nanotilerApp));
            item.setToolTipText("Rename an Object");
            menu.add(item);
            item = new JMenuItem("Rotate");
            item.addActionListener(new ManualRotateListener(NanoTiler.this.nanotilerApp));
            item.setToolTipText("Use Rotate command");
            menu.add(item);
            menu = new JMenu("Generate");
            item = new JMenuItem("Cubic grid");
            item.addActionListener(new NewGridActionListener());
            item.setToolTipText("Generate cube");
            menu.add(item);
            item = new JMenuItem("Platonic solid");
            item.addActionListener(new PlatonicSolidListener());
            item.setToolTipText("Generate Tetrahedron, Cube, Octahedron, Dodecahedron, or Icosahedron");
            menu.add(item);
            item = new JMenuItem("Planar shape");
            item.addActionListener(new PlanarListener());
            item.setToolTipText("Generate triangle, square, pentagon, hexagon etc.");
            menu.add(item);
            item = new JMenuItem("Helix");
            item.addActionListener(new AddHelixListener());
            item.setToolTipText("Insert Helix between two branch descriptors");
            menu.add(item);
            item = new JMenuItem("Link");
            item.addActionListener(new AddGenerateLinkListener());
            item.setToolTipText("Generate a link between two specified objects");
            menu.add(item);
            item = new JMenuItem("Covalent bonds");
            item.addActionListener(new GenerateAtomLinksListener());
            item.setToolTipText("Generate a link between any two atoms which are within a given distance of one another");
            item = new JMenuItem("Synthesize Object");
            item.setToolTipText("Synthesize an object of specified type and location");
            item.addActionListener(new AddSynthListener());
            menu.add(item);
            item = new JMenuItem("Basepair Constraint");
            item.addActionListener(new AddBasepairsListener());
            menu.add(item);
            item = new JMenuItem("Helix Constraint");
            item.addActionListener(new HelixConstraintListener());
            menu.add(item);
            this.add(menu);
            menu = new JMenu("Optimize");
            item = new JMenuItem("Base Pairs");
            item.setToolTipText("Launch base pair optimization wizard");
            item.addActionListener(new BasepairOptimizationWizardListener());
            menu.add(item);
            item = new JMenuItem("Helices");
            item.addActionListener(new OptimizeHelicesListener());
            menu.add(item);
            this.add(menu);
            menu = new JMenu("Building blocks");
            item = new JMenuItem("Load Database");
            item.addActionListener(new LoadJunctionListener());
            menu.add(item);
            item = new JMenuItem("Database Info");
            item.addActionListener(new TilingStatisticsListener());
            menu.add(item);
            item = new JMenuItem("Place");
            item.addActionListener(new PlaceJunctionListener());
            menu.add(item);
            item = new JMenuItem("Grow");
            item.addActionListener(new GrowListener());
            menu.add(item);
            item = new JMenuItem("Grow Graph");
            item.addActionListener(new GrowGraphListener());
            menu.add(item);
            this.add(menu);
            menu = new JMenu("Help");
            item = new JMenuItem("NanoTiler Tutorial");
            item.setToolTipText("Open a webpage containing a NanoTiler tutorial");
            item.addActionListener(new NanoTilerTutorialListener());
            menu.add(item);
            item = new JMenuItem("Command Help");
            item.setToolTipText("A list of all commands and help for each");
            item.addActionListener(new CommandHelpListener());
            menu.add(item);
            item = new JMenuItem("Graphics Help");
            item.setToolTipText("Provides all necessary information to effectively use the graphics display");
            item.addActionListener(new GraphicsHelpListener());
            menu.add(item);
            item = new JMenuItem("Welcome Window");
            item.setToolTipText("Launch the Welcome Window which is displayed when NanoTiler is initially opened.");
            item.addActionListener(new WelcomeWindowListener());
            menu.add(item);
            this.add(menu);
        }
    }

    private final class WelcomeWindowListener
    implements ActionListener {
        private WelcomeWindowListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            log.fine("Welcome window wizard started");
            WelcomeWindowWizard wizard = new WelcomeWindowWizard(NanoTiler.this.nanotilerApp);
            wizard.launchWizard(NanoTiler.this.graphController, NanoTiler.this.rootFrame);
        }
    }

    private final class WireFrameViewListener
    implements ActionListener {
        private WireFrameViewListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            log.fine("starting actionPerformed on WireFrameViewListener");
            GeometryPainter geometryPainter = NanoTiler.this.geometryPainterFactory.createPainter(4);
            for (int i = 0; i < NanoTiler.this.frames.size(); ++i) {
                if (!(NanoTiler.this.frames.get(i) instanceof GraphPanel)) continue;
                ((GraphPanel)NanoTiler.this.frames.get(i)).setPainter(new GeneralGeometryPainter(NanoTiler.this.params, geometryPainter, NanoTiler.this.graphController));
            }
            NanoTiler.this.repaintApp();
            log.fine("ending actionPerformed on WireFrameViewListener");
        }
    }

    private class CharacterDisplayListener
    implements ActionListener {
        private CharacterDisplayListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            log.fine("Switching to WireGeometryCharacterPainter!");
            GeometryPainter geometryPainter = NanoTiler.this.checkBox.isSelected() ? NanoTiler.this.geometryPainterFactory.createPainter(3) : NanoTiler.this.geometryPainterFactory.createPainter(5);
            for (int i = 0; i < NanoTiler.this.frames.size(); ++i) {
                if (!(NanoTiler.this.frames.get(i) instanceof GraphPanel)) continue;
                ((GraphPanel)NanoTiler.this.frames.get(i)).setPainter(new GeneralGeometryPainter(NanoTiler.this.params, geometryPainter, NanoTiler.this.graphController));
            }
            NanoTiler.this.repaintApp();
            log.fine("End Switching to WireGeometryCharactersPainter");
        }
    }

    private class NoLinkGeometryListener
    implements ActionListener {
        private NoLinkGeometryListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            log.fine("Switching to NoLinkGeometryPainter");
            GeometryPainter geometryPainter = NanoTiler.this.geometryPainterFactory.createPainter(2, false);
            for (int i = 0; i < NanoTiler.this.frames.size(); ++i) {
                if (!(NanoTiler.this.frames.get(i) instanceof GraphPanel)) continue;
                ((GraphPanel)NanoTiler.this.frames.get(i)).setPainter(new GeneralGeometryPainter(NanoTiler.this.params, geometryPainter, NanoTiler.this.graphController));
            }
            NanoTiler.this.repaintApp();
            log.fine("Ending NoLinkGeometryPainter");
        }
    }

    private final class WireViewListener
    implements ActionListener {
        private WireViewListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            log.fine("starting actionPerformed on WireViewListener");
            GeometryPainter geometryPainter = NanoTiler.this.geometryPainterFactory.createPainter(3);
            log.fine("mark 2 actionPerformed on WireViewListener");
            for (int i = 0; i < NanoTiler.this.frames.size(); ++i) {
                log.fine("mark 3 actionPerformed on WireViewListener");
                if (!(NanoTiler.this.frames.get(i) instanceof GraphPanel)) continue;
                log.fine("mark 3b actionPerformed on WireViewListener");
                ((GraphPanel)NanoTiler.this.frames.get(i)).setPainter(new GeneralGeometryPainter(NanoTiler.this.params, geometryPainter, NanoTiler.this.graphController));
            }
            NanoTiler.this.repaintApp();
            log.fine("ending actionPerformed on WireViewListener");
        }
    }

    private final class ApplyModeWizardListener
    implements ActionListener {
        private ApplyModeWizardListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            log.fine("Apply Mode wizard started");
            ApplyModeWizard wizard = new ApplyModeWizard(NanoTiler.this.nanotilerApp);
            wizard.launchWizard(NanoTiler.this.graphController, NanoTiler.this.rootFrame);
        }
    }

    private final class ElasticWizardListener
    implements ActionListener {
        private ElasticWizardListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            log.fine("Elastic wizard started");
            ElasticWizard wizard = new ElasticWizard(NanoTiler.this.nanotilerApp);
            wizard.launchWizard(NanoTiler.this.graphController, NanoTiler.this.rootFrame);
        }
    }

    private final class AddBasepairsListener
    implements ActionListener {
        private AddBasepairsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            log.fine("AddBasepair wizard started");
            AddBasepairsWizard wizard = new AddBasepairsWizard(NanoTiler.this.nanotilerApp);
            wizard.launchWizard(NanoTiler.this.rootFrame);
        }
    }

    private final class MoveListener
    implements ActionListener {
        private MoveListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            log.fine("Move Wizard Started");
            MoveWizard wizard = new MoveWizard(NanoTiler.this.nanotilerApp);
            wizard.launchWizard(NanoTiler.this.rootFrame);
        }
    }

    private final class CloneListener
    implements ActionListener {
        private CloneListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            log.fine("Clone wizard activated");
            CloneWizard wizard = new CloneWizard(NanoTiler.this.nanotilerApp);
            wizard.launchWizard(NanoTiler.this.rootFrame);
        }
    }

    private final class CommandHelpListener
    implements ActionListener {
        private CommandHelpListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            log.fine("Command Help activated");
            HelpWizard wizard = new HelpWizard(NanoTiler.this.nanotilerApp);
            wizard.launchWizard(NanoTiler.this.graphController, NanoTiler.this.rootFrame);
        }
    }

    private final class NanoTilerTutorialListener
    implements ActionListener {
        private NanoTilerTutorialListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            log.fine("NanoTiler tutorial launched");
            try {
                new Browser(TUTORIAL_HOME);
            }
            catch (Exception ex) {
                log.severe("Error displaying " + TUTORIAL_HOME);
            }
            log.fine("NanoTiler tutroial finished!");
        }
    }

    private final class NanoTilerWikiListener
    implements ActionListener {
        private NanoTilerWikiListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            log.fine("Wiki Help activated!");
            try {
                new Browser(WIKI_PAGE);
            }
            catch (Exception ex) {
                log.severe("Error displaying " + WIKI_PAGE);
            }
            log.fine("Wiki Help finished!");
        }
    }

    private final class TilingStatisticsListener
    implements ActionListener {
        private TilingStatisticsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            log.fine("TilingStatisticsListener activated!");
            JFrame.setDefaultLookAndFeelDecorated(true);
            JFrame frame = new JFrame("Tiling Statistics");
            frame.setDefaultCloseOperation(2);
            JTextArea textArea = new JTextArea(tilingStatisticsString);
            textArea.setEditable(false);
            textArea.setText(NanoTiler.this.graphController.getJunctionController().infoString());
            JScrollPane scrollPane = new JScrollPane(textArea);
            frame.getContentPane().setLayout(new BorderLayout());
            frame.getContentPane().add((Component)scrollPane, "Center");
            frame.pack();
            frame.setVisible(true);
        }
    }

    private final class JunctionInfoListener
    implements ActionListener {
        private JunctionInfoListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            log.fine("junctioninfolistener activated!");
            String junctionInfo = new String();
            junctionInfo = NanoTiler.this.junctionController.infoString();
            JFrame.setDefaultLookAndFeelDecorated(true);
            JFrame frame = new JFrame("Junction Database Info");
            frame.setDefaultCloseOperation(2);
            JTextArea textArea = new JTextArea(junctionInfo);
            JScrollPane scrollPane = new JScrollPane(textArea);
            frame.getContentPane().setLayout(new BorderLayout());
            frame.getContentPane().add((Component)scrollPane, "Center");
            frame.pack();
            frame.setVisible(true);
        }
    }

    private final class LoadJunctionListener
    implements ActionListener {
        private LoadJunctionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            log.fine("loadjunctionlistener activated!");
            JunctionParameterWizard wizard = new JunctionParameterWizard();
            wizard.launchWizard(NanoTiler.this.graphController, NanoTiler.this.rootFrame);
        }
    }

    private final class OptimizeHelicesListener
    implements ActionListener {
        private OptimizeHelicesListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            log.fine("optimizing helices");
            final JDialog dialog = new JDialog(NanoTiler.this.rootFrame, "Optimize Helices", true);
            final JRadioButton hTrue = new JRadioButton("True");
            JRadioButton hFalse = new JRadioButton("False");
            ButtonGroup group = new ButtonGroup();
            group.add(hTrue);
            group.add(hFalse);
            hTrue.setSelected(true);
            JPanel panel = new JPanel();
            panel.setLayout(new BoxLayout(panel, 1));
            JPanel temp = new JPanel();
            temp.add(new JLabel("Helices"));
            temp.add(hTrue);
            temp.add(hFalse);
            panel.add(temp);
            temp = new JPanel();
            final JTextField steps = new JTextField(10);
            steps.setText("1");
            temp.add(new JLabel("Steps"));
            temp.add(steps);
            panel.add(temp);
            panel.add(Box.createVerticalStrut(10));
            temp = new JPanel();
            JButton close = new JButton("Close");
            JButton optimize = new JButton("Optimize");
            close.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    dialog.setVisible(false);
                    dialog.dispose();
                }
            });
            optimize.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        Integer sts = Integer.parseInt(steps.getText());
                        if (sts < 0) {
                            return;
                        }
                        NanoTiler.this.nanotilerApp.runScriptLine("opthelices steps=" + sts + " helices=" + (hTrue.isSelected() ? "true" : Boolean.valueOf(false)));
                    }
                    catch (NumberFormatException en) {
                        JOptionPane.showMessageDialog(NanoTiler.this.rootFrame, en.getMessage());
                        return;
                    }
                    catch (CommandException ex) {
                        JOptionPane.showMessageDialog(NanoTiler.this.rootFrame, ex.getMessage());
                        return;
                    }
                    dialog.setVisible(false);
                    dialog.dispose();
                }
            });
            temp.add(close);
            temp.add(optimize);
            panel.add(temp);
            dialog.add(panel);
            dialog.pack();
            dialog.setVisible(true);
        }
    }

    private final class HelixConstraintListener
    implements ActionListener {
        private HelixConstraintListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            log.fine("helix constraint wizard launched");
            HelixConstraintWizard wizard = new HelixConstraintWizard(NanoTiler.this.nanotilerApp);
            wizard.launchWizard(NanoTiler.this.graphController, NanoTiler.this.rootFrame);
        }
    }

    private final class GrowGraphListener
    implements ActionListener {
        private GrowGraphListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            log.fine("grow graph wizard launched");
            GrowGraphWizard wizard = new GrowGraphWizard(NanoTiler.this.nanotilerApp);
            wizard.launchWizard(NanoTiler.this.graphController, NanoTiler.this.rootFrame);
        }
    }

    private final class GrowListener
    implements ActionListener {
        private GrowListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            log.fine("grow wizard launched");
            GrowWizard wizard = new GrowWizard(NanoTiler.this.nanotilerApp);
            wizard.launchWizard(NanoTiler.this.graphController, NanoTiler.this.rootFrame);
        }
    }

    private final class GraphicsHelpListener
    implements ActionListener {
        private GraphicsHelpListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            log.fine("Graphics manual wizard launched");
            GraphicsManualWizard wizard = new GraphicsManualWizard(NanoTiler.this.nanotilerApp);
            wizard.launchWizard(NanoTiler.this.graphController, NanoTiler.this.rootFrame);
        }
    }

    private final class PlaceJunctionListener
    implements ActionListener {
        private PlaceJunctionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            log.fine("place junction wizard launched");
            PlaceJunctionWizard wizard = new PlaceJunctionWizard(NanoTiler.this.nanotilerApp);
            wizard.launchWizard(NanoTiler.this.graphController, NanoTiler.this.rootFrame);
        }
    }

    private final class GenerateAtomLinksListener
    implements ActionListener {
        private GenerateAtomLinksListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NanoTiler.this.graphController.generateAtomLinks(NanoTiler.this.graphController.getGraph().getGraph(), NanoTiler.this.graphController.getAtomBondCutoff());
        }
    }

    private final class ViewVariablesListener
    implements ActionListener {
        private ViewVariablesListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            log.fine("Env wizard launched");
            EnvWizard wizard = new EnvWizard(NanoTiler.this.nanotilerApp);
            wizard.launchWizard(NanoTiler.this.graphController, NanoTiler.this.rootFrame);
        }
    }

    private final class ViewRunningListener
    implements ActionListener {
        private ViewRunningListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            log.fine("ViewRunningListener activated!");
            SimpleQueueManager queueManager = SimpleQueueManager.getInstance();
            JobViewer jobViewer = new JobViewer(queueManager);
            jobViewer.pack();
            jobViewer.setVisible(true);
        }
    }

    private final class PointsViewListener
    implements ActionListener {
        private PointsViewListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (int i = 0; i < NanoTiler.this.frames.size(); ++i) {
                if (!(NanoTiler.this.frames.get(i) instanceof GraphPanel)) continue;
                ((GraphPanel)NanoTiler.this.frames.get(i)).setPainter(new PointPainter(NanoTiler.this.params));
            }
            NanoTiler.this.repaintApp();
        }
    }

    private final class StandardViewListener
    implements ActionListener {
        private StandardViewListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (int i = 0; i < NanoTiler.this.frames.size(); ++i) {
                if (!(NanoTiler.this.frames.get(i) instanceof GraphPanel)) continue;
                ((GraphPanel)NanoTiler.this.frames.get(i)).setPainter(new SimplePainter(NanoTiler.this.params));
            }
            NanoTiler.this.repaintApp();
        }
    }

    private final class GlobalTreeSelectionListener
    implements TreeSelectionListener {
        private GlobalTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            NanoTiler.this.repaintApp();
        }
    }

    private final class AddFuseStrandsListener
    implements ActionListener {
        private AddFuseStrandsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FuseStrandsWizard wizard = new FuseStrandsWizard(NanoTiler.this.nanotilerApp);
            wizard.launchWizard(NanoTiler.this.graphController, NanoTiler.this.rootFrame);
        }
    }

    private final class RotateListener
    implements ActionListener {
        private RotateListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }

    private final class MoveSouthListener
    implements ActionListener {
        private MoveSouthListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NanoTiler.this.graphController.getGraph().translateSelected(new Vector3D(0.0, -((NanoTiler)NanoTiler.this).params.moveStep, 0.0));
            NanoTiler.this.repaintApp();
        }
    }

    private final class MoveNorthListener
    implements ActionListener {
        private MoveNorthListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NanoTiler.this.graphController.getGraph().translateSelected(new Vector3D(0.0, ((NanoTiler)NanoTiler.this).params.moveStep, 0.0));
            NanoTiler.this.repaintApp();
        }
    }

    private final class MoveDownListener
    implements ActionListener {
        private MoveDownListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NanoTiler.this.graphController.getGraph().translateSelected(new Vector3D(0.0, 0.0, -((NanoTiler)NanoTiler.this).params.moveStep));
            NanoTiler.this.repaintApp();
        }
    }

    private final class MoveUpListener
    implements ActionListener {
        private MoveUpListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NanoTiler.this.graphController.getGraph().translateSelected(new Vector3D(0.0, 0.0, ((NanoTiler)NanoTiler.this).params.moveStep));
            NanoTiler.this.repaintApp();
        }
    }

    private final class MoveLeftListener
    implements ActionListener {
        private MoveLeftListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NanoTiler.this.graphController.getGraph().translateSelected(new Vector3D(-((NanoTiler)NanoTiler.this).params.moveStep, 0.0, 0.0));
            NanoTiler.this.repaintApp();
        }
    }

    private final class MoveRightListener
    implements ActionListener {
        private MoveRightListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NanoTiler.this.graphController.getGraph().translateSelected(new Vector3D(((NanoTiler)NanoTiler.this).params.moveStep, 0.0, 0.0));
            NanoTiler.this.repaintApp();
        }
    }

    private final class DistanceListener
    implements ActionListener {
        private DistanceListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            log.fine("generate distance wizard started");
            DistanceWizard wizard = new DistanceWizard(NanoTiler.this.nanotilerApp);
            wizard.launchWizard(NanoTiler.this.graphController, NanoTiler.this.rootFrame);
        }
    }

    private final class GenerateSignatureListener
    implements ActionListener {
        private GenerateSignatureListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            log.fine("generate signature wizard started");
            SignatureWizard wizard = new SignatureWizard(NanoTiler.this.nanotilerApp);
            wizard.launchWizard(NanoTiler.this.graphController, NanoTiler.this.rootFrame);
        }
    }

    private final class Atom3DActionListener
    implements ActionListener {
        private Atom3DActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }

    private final class ChooseBackgroundColorListener
    implements ActionListener {
        private ChooseBackgroundColorListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFrame jFrame = NanoTiler.this.rootFrame;
            NanoTiler.this.params;
            Color newCol = JColorChooser.showDialog(jFrame, "Choose Background Color", RnaGuiParameters.colorBackground);
            for (int i = 0; i < NanoTiler.this.graphControllPanels.size(); ++i) {
                GraphControlPanel gcp = (GraphControlPanel)NanoTiler.this.graphControllPanels.get(i);
                gcp.graphPanel.setBackground(newCol);
            }
            NanoTiler.this.repaintApp();
        }
    }

    private final class ViewLinksListener
    implements ActionListener {
        private ViewLinksListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            log.fine("View links wizard launched");
            ViewLinksWizard wizard = new ViewLinksWizard(NanoTiler.this.nanotilerApp);
            wizard.launchWizard(NanoTiler.this.graphController, NanoTiler.this.rootFrame);
        }
    }

    private final class ViewTreeListener
    implements ActionListener {
        private ViewTreeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            log.fine("View Tree Wizard launched");
            ViewTreeWizard wizard = new ViewTreeWizard(NanoTiler.this.nanotilerApp);
            wizard.launchWizard(NanoTiler.this.graphController, NanoTiler.this.rootFrame);
        }
    }

    private final class SelectedPanelListener
    implements ActionListener {
        private SelectedPanelListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SelectedPanel selectedPanel = new SelectedPanel(new SelectedPanel.SelectedPanelParameters(), NanoTiler.this.graphController);
            JFrame selectedFrame = new JFrame("Selected Objects:");
            selectedFrame.add(selectedPanel);
            selectedFrame.pack();
            selectedFrame.setVisible(true);
            NanoTiler.this.registerComponent(selectedFrame);
        }
    }

    private final class DisplayOptionsListener
    implements ActionListener {
        private DisplayOptionsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GraphControllerDisplayManager graphControllerDisplayManager = NanoTiler.this.graphControllerDisplayManager;
            graphControllerDisplayManager.getClass();
            GraphControllerDisplayManager.GraphConfiguration dialog = new GraphControllerDisplayManager.GraphConfiguration(graphControllerDisplayManager, "Display Options");
            dialog.setVisible(true);
        }
    }

    private final class SaveGuiPropertiesActionListener
    implements ActionListener {
        private SaveGuiPropertiesActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            log.fine("Save Gui Parameters button pressed!");
            if (NanoTiler.this.graphController.getGraph().getObjectCount() <= 0) {
                return;
            }
            JFileChooser chooser = new JFileChooser();
            chooser.setApproveButtonText("Save");
            String cwdName = ((NanoTiler)NanoTiler.this).params.workDirectory;
            File cwd = new File(cwdName);
            chooser.setCurrentDirectory(cwd);
            int returnVal = chooser.showOpenDialog(NanoTiler.this.rootFrame.getContentPane());
            if (returnVal == 0) {
                String fileName = chooser.getCurrentDirectory() + PackageConstants.SLASH + chooser.getSelectedFile().getName();
                log.info("You chose this file: " + fileName);
                try {
                    XMLEncoder enc = new XMLEncoder(new BufferedOutputStream(new FileOutputStream(fileName)));
                    enc.writeObject(NanoTiler.this.params);
                }
                catch (IOException exc) {
                    log.severe("Could not open file: " + exc.getMessage());
                }
            }
            log.fine("Finished writing object3 native format!");
            log.fine("finished save button!");
        }
    }

    private final class SaveActionListener
    implements ActionListener {
        private SaveActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            log.fine("Save button pressed!");
            if (NanoTiler.this.graphController.getGraph().getObjectCount() <= 0) {
                return;
            }
            JFileChooser chooser = new JFileChooser();
            chooser.setApproveButtonText("Save");
            chooser.setFileSelectionMode(2);
            String cwdName = ((NanoTiler)NanoTiler.this).params.workDirectory;
            File cwd = new File(cwdName);
            chooser.setCurrentDirectory(cwd);
            int returnVal = chooser.showSaveDialog(NanoTiler.this.rootFrame.getContentPane());
            if (returnVal == 0) {
                String fileName = chooser.getCurrentDirectory() + PackageConstants.SLASH + chooser.getSelectedFile().getName();
                log.info("You chose this file: " + fileName);
                try {
                    FileOutputStream fis = new FileOutputStream(fileName);
                    Object3DDefaultWriter writer = new Object3DDefaultWriter();
                    NanoTiler.this.graphController.write(fis, writer);
                }
                catch (IOException exc) {
                    log.severe("Could not open file: " + exc.getMessage());
                }
            }
            log.fine("Finished writing object3 native format!");
            log.fine("finished save button!");
        }
    }

    private final class PrismListener
    implements ActionListener {
        private PrismListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            log.fine("New prism shape button pressed!");
            NanoTiler.this.repaintApp();
        }
    }

    private final class BasepairOptimizationWizardListener
    implements ActionListener {
        private BasepairOptimizationWizardListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            OptbasepairsWizard wizard = new OptbasepairsWizard(NanoTiler.this.nanotilerApp);
            wizard.launchWizard(NanoTiler.this.graphController, NanoTiler.this.rootFrame);
            NanoTiler.this.repaintApp();
        }
    }

    private final class OptimizationWizardListener
    implements ActionListener {
        private OptimizationWizardListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            OptimizationWizard wizard = new OptimizationWizard(NanoTiler.this.nanotilerApp);
            wizard.launchWizard(NanoTiler.this.graphController, NanoTiler.this.rootFrame);
            NanoTiler.this.repaintApp();
        }
    }

    private final class PlanarListener
    implements ActionListener {
        private PlanarListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            log.fine("New planar shape button pressed!");
            PlanarWizard wizard = new PlanarWizard();
            wizard.launchWizard(NanoTiler.this.graphController, NanoTiler.this.rootFrame);
            NanoTiler.this.repaintApp();
        }
    }

    private final class PlatonicSolidListener
    implements ActionListener {
        private PlatonicSolidListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            log.fine("New Platonic solid button pressed!");
            PlatonicSolidWizard wizard = new PlatonicSolidWizard();
            wizard.launchWizard(NanoTiler.this.graphController, NanoTiler.this.rootFrame);
            NanoTiler.this.repaintApp();
        }
    }

    private final class AddSynthListener
    implements ActionListener {
        private AddSynthListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            log.fine("synth wizard started");
            SynthWizard wizard = new SynthWizard(NanoTiler.this.nanotilerApp);
            wizard.launchWizard(NanoTiler.this.rootFrame);
        }
    }

    private final class AddGenerateLinkListener
    implements ActionListener {
        private AddGenerateLinkListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            log.fine("generate link wizard started");
            GenLinkWizard wizard = new GenLinkWizard(NanoTiler.this.nanotilerApp);
            wizard.launchWizard(NanoTiler.this.graphController, NanoTiler.this.rootFrame);
        }
    }

    private final class AddHelixListener
    implements ActionListener {
        private AddHelixListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            log.fine("add helix wizard started");
            AddHelixWizard wizard = new AddHelixWizard(NanoTiler.this.nanotilerApp);
            wizard.launchWizard(NanoTiler.this.graphController, NanoTiler.this.rootFrame);
        }
    }

    private final class StemTilerListener
    implements ActionListener {
        private StemTilerListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            log.fine("Starting StemTilerListener.actionPerformed!");
            Object3D obj = NanoTiler.this.graphController.getGraph().getSelectionRoot();
            LinkController links = NanoTiler.this.graphController.getLinks();
            SimpleObject3DLinkSetBundle bundle = new SimpleObject3DLinkSetBundle(obj, links);
            try {
                Object3DLinkSetBundle result = NanoTiler.this.graphController.generateCoveringStems(bundle, "tiling", false, 'N', 4);
                NanoTiler.this.graphController.getGraph().addGraph(result.getObject3D());
                NanoTiler.this.graphController.getLinks().addLinks(result.getLinks());
            }
            catch (Object3DGraphControllerException exc) {
                log.severe("StemTilerListener failed: " + exc.getMessage());
            }
        }
    }

    private final class GraphitGridActionListener
    implements ActionListener {
        private GraphitGridActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            log.fine("New Grid button pressed!");
            GraphitGridWizard wizard = new GraphitGridWizard();
            wizard.launchWizard(NanoTiler.this.graphController, NanoTiler.this.rootFrame);
            NanoTiler.this.repaintApp();
        }
    }

    private final class NewGridActionListener
    implements ActionListener {
        private NewGridActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            log.fine("New Grid button pressed!");
            CubicGridWizard wizard = new CubicGridWizard();
            wizard.launchWizard(NanoTiler.this.graphController, NanoTiler.this.rootFrame);
            NanoTiler.this.repaintApp();
        }
    }

    private final class NewStrandActionListener
    implements ActionListener {
        private NewStrandActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            log.fine("New Strand button pressed!");
            RnaStrandGuiWizard wizard = new RnaStrandGuiWizard();
            wizard.launchWizard(NanoTiler.this.graphController, NanoTiler.this.rootFrame);
            NanoTiler.this.repaintApp();
        }
    }

    private final class SecondaryStructureEditorListener
    implements ActionListener {
        private SecondaryStructureEditorListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            log.fine("New stem button pressed!");
            final SecondaryStructureEditorWizardNoThread wizard = new SecondaryStructureEditorWizardNoThread(NanoTiler.this.nanotilerApp);
            wizard.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean foundInteraction;
                    int i;
                    MutableSecondaryStructure struct;
                    MutableSecondaryStructure structure = wizard.getSecondaryStructure();
                    try {
                        struct = NanoTiler.this.graphController.generateSecondaryStructure();
                    }
                    catch (DuplicateNameException ex) {
                        System.out.println("Cannot update secondary structure");
                        return;
                    }
                    UnevenAlignment updatedSequences = structure.getSequences();
                    UnevenAlignment originalSequences = struct.getSequences();
                    System.out.println("Number of sequences from sse -- " + updatedSequences.getSequenceCount());
                    for (int i2 = 0; i2 < updatedSequences.getSequenceCount(); ++i2) {
                        System.out.println(updatedSequences.getSequence(i2));
                        int index = originalSequences.getIndex(updatedSequences.getSequence(i2).getName());
                        if (index != -1) continue;
                        try {
                            Sequence s = updatedSequences.getSequence(i2);
                            NanoTiler.this.graphController.addStrand(s.getName().trim(), s.sequenceString(), new Vector3D(0.0, 0.0, 0.0), new Vector3D(0.0, 0.0, 0.0), s.getAlphabet() == DnaTools.RNA_ALPHABET || s.getAlphabet() == DnaTools.AMBIGUOUS_RNA_ALPHABET ? 0 : 1);
                            continue;
                        }
                        catch (UnknownSymbolException ex) {
                            // empty catch block
                        }
                    }
                    InteractionSet oldInteractions = struct.getInteractions();
                    InteractionSet newInteractions = structure.getInteractions();
                    for (i = 0; i < oldInteractions.size(); ++i) {
                        System.out.println("Interaction: " + oldInteractions.get(i).getResidue1().getPos() + " - " + oldInteractions.get(i).getResidue2().getPos() + "\t" + oldInteractions.get(i).getInteractionType());
                        foundInteraction = false;
                        for (int j = 0; j < newInteractions.size(); ++j) {
                            if (newInteractions.get(j).compareTo(oldInteractions.get(i)) != 0) continue;
                            foundInteraction = true;
                            break;
                        }
                        if (!foundInteraction) {
                            Link l = NanoTiler.this.graphController.getLinks().find((Residue3D)oldInteractions.get(i).getResidue1(), (Residue3D)oldInteractions.get(i).getResidue2());
                            if (l != null) {
                                NanoTiler.this.graphController.getLinks().remove(l);
                                continue;
                            }
                            System.out.println("Could not remove link -- " + oldInteractions.get(i).getResidue1().getPos() + "  " + oldInteractions.get(i).getResidue2().getPos());
                            continue;
                        }
                        System.out.println("Interaction present in new structure");
                    }
                    try {
                        originalSequences = NanoTiler.this.graphController.generateSecondaryStructure().getSequences();
                    }
                    catch (DuplicateNameException ex) {
                        return;
                    }
                    for (i = 0; i < newInteractions.size(); ++i) {
                        foundInteraction = false;
                        for (int j = 0; j < oldInteractions.size(); ++j) {
                            if (newInteractions.get(i).compareTo(oldInteractions.get(j)) != 0) continue;
                            foundInteraction = true;
                            break;
                        }
                        if (foundInteraction) continue;
                        try {
                            String seq1Name = newInteractions.get(i).getSequence1().getName();
                            String seq2Name = newInteractions.get(i).getSequence2().getName();
                            int res1Pos = newInteractions.get(i).getResidue1().getPos();
                            int res2Pos = newInteractions.get(i).getResidue2().getPos();
                            Sequence sequence1 = originalSequences.getSequence(seq1Name);
                            Sequence sequence2 = originalSequences.getSequence(seq2Name);
                            NanoTiler.this.graphController.addBasePair(Object3DTools.getFullName((Residue3D)sequence1.getResidue(res1Pos)), Object3DTools.getFullName((Residue3D)sequence2.getResidue(res2Pos)), 1, 0);
                            continue;
                        }
                        catch (Object3DGraphControllerException ex) {
                            continue;
                        }
                        catch (UnknownSequenceException uex) {
                            // empty catch block
                        }
                    }
                }
            });
            wizard.launchWizard(NanoTiler.this.graphController, NanoTiler.this.rootFrame);
        }
    }

    private final class SelectListener
    implements ActionListener {
        private CommandApplication app;

        SelectListener(CommandApplication app) {
            this.app = app;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            log.fine("SelectListener activated!");
            SelectWizard wizard = new SelectWizard(this.app);
            wizard.launchWizard(NanoTiler.this.rootFrame);
        }
    }

    private final class ChosenListener
    implements ActionListener {
        private CommandApplication app;

        ChosenListener(CommandApplication app) {
            this.app = app;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            log.fine("ChosenListener activated!");
            ChosenWizard wizard = new ChosenWizard(this.app);
            wizard.launchWizard(NanoTiler.this.rootFrame);
        }
    }

    private final class ShiftListener
    implements ActionListener {
        private CommandApplication app;

        ShiftListener(CommandApplication app) {
            this.app = app;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            log.fine("ShiftListener activated!");
            ShiftWizard wizard = new ShiftWizard(this.app);
            wizard.launchWizard(NanoTiler.this.rootFrame);
        }
    }

    private final class RemoveLinkListener
    implements ActionListener {
        private RemoveLinkListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            log.fine("Remove link wizard activated");
            RemoveLinksWizard wizard = new RemoveLinksWizard(NanoTiler.this.nanotilerApp);
            wizard.launchWizard(NanoTiler.this.graphController, NanoTiler.this.rootFrame);
        }
    }

    private final class RenameListener
    implements ActionListener {
        private CommandApplication app;

        RenameListener(CommandApplication app) {
            this.app = app;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            log.fine("RenameListener activated!");
            RenameWizard wizard = new RenameWizard(this.app);
            wizard.launchWizard(NanoTiler.this.rootFrame);
        }
    }

    private final class ManualRotateListener
    implements ActionListener {
        private CommandApplication app;

        ManualRotateListener(CommandApplication app) {
            this.app = app;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            log.fine("ManualRotateListener activated");
            ManualRotateWizard wizard = new ManualRotateWizard(this.app);
            wizard.launchWizard(NanoTiler.this.rootFrame);
        }
    }

    private final class QuaderListener
    implements ActionListener {
        private CommandApplication app;

        QuaderListener(CommandApplication app) {
            this.app = app;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            log.fine("QuaderListener activated!");
            QuaderWizard wizard = new QuaderWizard(this.app);
            wizard.launchWizard(NanoTiler.this.rootFrame);
        }
    }

    private final class ElasticNetworkListener
    implements ActionListener {
        private ElasticNetworkListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            log.fine("ElasticNetworkListener activated!");
            ElasticNetworkWizard wizard = new ElasticNetworkWizard();
            wizard.launchWizard(NanoTiler.this.graphController, NanoTiler.this.rootFrame);
        }
    }

    private final class MinimizeListener
    implements ActionListener {
        private MinimizeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            log.fine("MinimizeListener activated!");
            MinimizeWizard wizard = new MinimizeWizard();
            wizard.launchWizard(NanoTiler.this.graphController, NanoTiler.this.rootFrame);
        }
    }

    private final class RunDemoListener
    implements ActionListener {
        String scriptFile;

        public RunDemoListener(String scriptFile) {
            this.scriptFile = scriptFile;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String file = nanotilerHome + "/demo/scripts/" + this.scriptFile;
            String command = "source " + file;
            try {
                NanoTiler.this.nanotilerApp.runScriptLine(command);
            }
            catch (CommandException ce) {
                JOptionPane.showMessageDialog(NanoTiler.this.rootFrame, ce.getMessage());
            }
        }
    }

    private final class ExportJunctionsPdbActionListener
    implements ActionListener {
        private ExportJunctionsPdbActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            log.fine("Export-PDB item activated!");
            if (NanoTiler.this.graphController.getGraph().getObjectCount() <= 0) {
                return;
            }
            JFileChooser chooser = new JFileChooser();
            chooser.setApproveButtonText("Save");
            String cwdName = ((NanoTiler)NanoTiler.this).params.workDirectory;
            File cwd = new File(cwdName);
            chooser.setCurrentDirectory(cwd);
            int returnVal = chooser.showSaveDialog(NanoTiler.this.rootFrame.getContentPane());
            if (returnVal == 0) {
                String fileName = chooser.getCurrentDirectory().toString() + PackageConstants.SLASH + chooser.getSelectedFile().getName().toString();
                log.info("You chose this file: " + fileName);
                boolean originalMode = true;
                NanoTiler.this.graphController.writeJunctionsToPdb(fileName, originalMode);
            }
            log.fine("Finished writing Junctions PDB button!");
        }
    }

    private final class ExportSecondaryStructureListener
    implements ActionListener {
        private ExportSecondaryStructureListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            log.fine("Export-Secondary structure item activated!");
            if (NanoTiler.this.graphController.getGraph().getObjectCount() <= 0) {
                return;
            }
            JFileChooser chooser = new JFileChooser();
            chooser.setApproveButtonText("Save");
            chooser.setFileSelectionMode(2);
            String cwdName = ((NanoTiler)NanoTiler.this).params.workDirectory;
            File cwd = new File(cwdName);
            chooser.setCurrentDirectory(cwd);
            int returnVal = chooser.showSaveDialog(NanoTiler.this.rootFrame.getContentPane());
            if (returnVal == 0) {
                String fileName = chooser.getCurrentDirectory() + PackageConstants.SLASH + chooser.getSelectedFile().getName();
                log.info("You chose this file: " + fileName);
                FileOutputStream fis = null;
                try {
                    fis = new FileOutputStream(fileName);
                    NanoTiler.this.graphController.writeSecondaryStructure(fis, 13);
                    fis.close();
                }
                catch (IOException exc) {
                    JOptionPane.showMessageDialog(null, "Could not open file: " + exc.getMessage());
                }
                catch (Object3DGraphControllerException ce) {
                    JOptionPane.showMessageDialog(null, "Controller exception: " + ce.getMessage());
                }
            }
            log.fine("Finished writing Secondary structure button!");
        }
    }

    private final class ExportPdbActionListener
    implements ActionListener {
        private ExportPdbActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            log.fine("Export-PDB item activated!");
            if (NanoTiler.this.graphController.getGraph().getObjectCount() <= 0) {
                return;
            }
            JFileChooser chooser = new JFileChooser();
            PdbFileFilter filter = new PdbFileFilter();
            chooser.setApproveButtonText("Save");
            chooser.setFileSelectionMode(2);
            chooser.setFileFilter(filter);
            String cwdName = ((NanoTiler)NanoTiler.this).params.workDirectory;
            File cwd = new File(cwdName);
            chooser.setCurrentDirectory(cwd);
            int returnVal = chooser.showSaveDialog(NanoTiler.this.rootFrame.getContentPane());
            if (returnVal == 0) {
                String fileName = chooser.getCurrentDirectory() + PackageConstants.SLASH + chooser.getSelectedFile().getName();
                if (!fileName.endsWith(NanoTiler.PDB_EXTENSION)) {
                    fileName = fileName + NanoTiler.PDB_EXTENSION;
                }
                log.info("You chose this file: " + fileName);
                Object fis = null;
                try {
                    NanoTiler.this.runScriptLine("exportpdb " + fileName);
                }
                catch (CommandException exc) {
                    log.severe("Could not open file: " + exc.getMessage());
                }
            }
            log.info("Finished writing PDB!");
        }
    }

    class PdbFileFilter
    extends FileFilter {
        PdbFileFilter() {
        }

        @Override
        public boolean accept(File f) {
            return f.isDirectory() || f.getName().toLowerCase().endsWith(NanoTiler.PDB_EXTENSION);
        }

        @Override
        public String getDescription() {
            return ".pdb files";
        }
    }

    private final class ExportMcsymActionListener
    implements ActionListener {
        private ExportMcsymActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            log.fine("Export-MCSYM item activated!");
            JOptionPane.showMessageDialog(null, "Sorry, the program's not done yet.", "Error", -1);
        }
    }

    private final class ExportBplActionListener
    implements ActionListener {
        private ExportBplActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            log.fine("Export-BPL item activated!");
            if (NanoTiler.this.graphController.getGraph().getObjectCount() <= 0) {
                return;
            }
            JFileChooser chooser = new JFileChooser();
            chooser.setApproveButtonText("Save");
            chooser.setFileSelectionMode(2);
            String cwdName = ((NanoTiler)NanoTiler.this).params.workDirectory;
            File cwd = new File(cwdName);
            chooser.setCurrentDirectory(cwd);
            int returnVal = chooser.showSaveDialog(NanoTiler.this.rootFrame.getContentPane());
            if (returnVal == 0) {
                String fileName = chooser.getCurrentDirectory() + PackageConstants.SLASH + chooser.getSelectedFile().getName();
                log.info("You chose this file: " + fileName);
                FileOutputStream fis = null;
                try {
                    fis = new FileOutputStream(fileName);
                    Object writer = null;
                    fis.close();
                }
                catch (IOException exc) {
                    log.severe("Could not open file: " + exc.getMessage());
                }
            }
            log.fine("Finished writing RNA2D3D bpl button!");
        }
    }

    private final class RunScriptActionListener
    implements ActionListener {
        private RunScriptActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            log.fine("Run script button pressed");
            RunScriptWizard wizard = new RunScriptWizard(NanoTiler.this.nanotilerApp);
            wizard.launchWizard(NanoTiler.this.graphController, NanoTiler.this.rootFrame);
        }
    }

    private final class ImportActionListener
    implements ActionListener {
        private NanoTiler app;

        ImportActionListener(NanoTiler app) {
            this.app = app;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            log.fine("ImportActionListener button pressed");
            ImportWizard wizard = new ImportWizard(this.app);
            wizard.launchWizard(NanoTiler.this.graphController, NanoTiler.this.rootFrame);
        }
    }

    private final class AddObject3DActionListener
    implements ActionListener {
        private AddObject3DActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            log.fine("Load button pressed!");
            JFileChooser chooser = new JFileChooser();
            String cwdName = ((NanoTiler)NanoTiler.this).params.workDirectory;
            File cwd = new File(cwdName);
            chooser.setCurrentDirectory(cwd);
            int returnVal = chooser.showOpenDialog(NanoTiler.this.rootFrame.getContentPane());
            if (returnVal == 0) {
                String fileName = chooser.getCurrentDirectory() + PackageConstants.SLASH + chooser.getSelectedFile().getName();
                log.info("You chose this file: " + fileName);
                try {
                    FileInputStream fis = new FileInputStream(fileName);
                    NanoTiler.this.graphController.readAndAdd(fis);
                }
                catch (Object3DIOException exc) {
                    log.severe("Could not reading graph file: " + exc.getMessage());
                }
                catch (IOException exc) {
                    log.severe("Could not open file: " + exc.getMessage());
                }
            }
        }
    }

    private final class InputObject3DActionListener
    implements ActionListener {
        private InputObject3DActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object3DInputMask inputMask = new Object3DInputMask(NanoTiler.this.rootFrame, NanoTiler.this.graphController.getGraph().getGraph(), NanoTiler.this.params);
            inputMask.pack();
        }
    }

    private final class LoadActionListener
    implements ActionListener {
        private LoadActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            log.fine("Load button pressed!");
            JFileChooser chooser = new JFileChooser();
            String cwdName = ((NanoTiler)NanoTiler.this).params.workDirectory;
            File cwd = new File(cwdName);
            chooser.setCurrentDirectory(cwd);
            int returnVal = chooser.showOpenDialog(NanoTiler.this.rootFrame.getContentPane());
            if (returnVal == 0) {
                String fileName = chooser.getCurrentDirectory().toString() + File.separatorChar + chooser.getSelectedFile().getName().toString();
                log.info("You chose this file: " + fileName);
                try {
                    FileInputStream fis = new FileInputStream(fileName);
                    NanoTiler.this.graphController.read(fis);
                }
                catch (Object3DIOException exc) {
                    log.severe("Could not reading graph file: " + exc.getMessage());
                }
                catch (IOException exc) {
                    log.severe("Could not open file: " + exc.getMessage());
                }
            }
            NanoTiler.this.repaintApp();
        }
    }

    private final class LaunchRnaInverseListener
    implements ActionListener {
        private CommandApplication app;

        LaunchRnaInverseListener(CommandApplication app) {
            this.app = app;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            log.fine("LaunchRnaInverseListener activated!");
            LaunchRnaInverseWizard wizard = new LaunchRnaInverseWizard(this.app);
            wizard.launchWizard(NanoTiler.this.rootFrame);
        }
    }

    private final class LaunchMcSymListener
    implements ActionListener {
        private LaunchMcSymListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            log.fine("LaunchMcSymListener activated!");
            LaunchMcSymWizard wizard = new LaunchMcSymWizard();
            wizard.launchWizard(NanoTiler.this.graphController, NanoTiler.this.rootFrame);
        }
    }

    private final class HierarchyDownListener
    implements ActionListener {
        private HierarchyDownListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            log.fine("HierarchyDown button pressed!");
            log.fine("HierarchyDown button: " + NanoTiler.this.graphController.getGraph().getDepthMax());
            NanoTiler.this.graphController.getGraph().setDepthMax(NanoTiler.this.graphController.getGraph().getDepthMax() + 1);
            log.fine("After: HierarchyDown button: " + NanoTiler.this.graphController.getGraph().getDepthMax());
            NanoTiler.this.repaintApp();
        }
    }

    private final class HierarchyUpListener
    implements ActionListener {
        private HierarchyUpListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            log.fine("HierarchyUp button pressed!");
            log.fine("HierarchyUp button: " + NanoTiler.this.graphController.getGraph().getDepthMax());
            if (NanoTiler.this.graphController.getGraph().getDepthMax() > 0) {
                NanoTiler.this.graphController.getGraph().setDepthMax(NanoTiler.this.graphController.getGraph().getDepthMax() - 1);
            }
            log.fine("After: HierarchyUp button: " + NanoTiler.this.graphController.getGraph().getDepthMax());
            NanoTiler.this.repaintApp();
        }
    }

    private static final class ExitActionListener
    implements ActionListener {
        private ExitActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            log.fine("Quit button pressed!");
            log.fine("quit button!");
            String msg = "Are you sure you want to quit the program?";
            String title = "Exit dialog";
            int choice = JOptionPane.showConfirmDialog(null, msg, title, 2);
            if (choice == 0) {
                System.exit(0);
            }
        }
    }

    private final class RemoveActionListener
    implements ActionListener {
        private RemoveActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (NanoTiler.this.graphController == null) {
                log.info("Graphcontroller is null before remove command!");
            } else {
                NanoTiler.this.graphController.getGraph().remove();
            }
        }
    }

    private final class ConnectActionListener
    implements ActionListener {
        private ConnectActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            InsertLinkWizard linkWizard = new InsertLinkWizard();
            if (NanoTiler.this.graphController == null) {
                log.info("Graphcontroller is null before starting linkWizard!");
            } else {
                log.fine("Graphcontroller is not null before starting linkWizard!");
            }
            linkWizard.launchWizard(NanoTiler.this.graphController, NanoTiler.this.rootFrame);
        }
    }

    private final class ClearActionListener
    implements ActionListener {
        private ClearActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            log.fine("Clear button pressed!");
            String msg = "Are you sure you want to discard all data?";
            String title = "Clear Button Dialog";
            int choice = JOptionPane.showConfirmDialog(null, msg, title, 2);
            if (choice == 0) {
                log.fine("clear button!");
                NanoTiler.this.graphController.clear();
                NanoTiler.this.repaintApp();
            }
        }
    }
}

