/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp.rnagui;

import commandtools.CommandApplication;
import commandtools.CommandException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import rnadesign.designapp.AbstractDesigner;
import rnadesign.designapp.rnagui.GeneralWizard;
import rnadesign.rnacontrol.Object3DController;
import rnadesign.rnacontrol.Object3DGraphController;
import rnadesign.rnamodel.RnaTools;
import tools3d.objects3d.Object3D;

public class OptbasepairsWizard
implements GeneralWizard {
    private static final int COL_SIZE_NAME = 30;
    private static final String FRAME_TITLE = "Optimize base pairs Wizard";
    public static Logger log = Logger.getLogger("NanoTiler_debug");
    private boolean finished = false;
    private JFrame frame = null;
    private List<ActionListener> actionListeners = new ArrayList<ActionListener>();
    private CommandApplication application;
    private Object3DGraphController graphController;
    private JTextArea blocksField;
    private JTextField errorField;
    private JTextField stepsField;
    private Vector<String> tree;
    private String[] allowedNames = RnaTools.getRnaClassNames();
    private String[] forbiddenNames = new String[]{"Atom3D", "Nucleotide3D"};
    private JPanel treePanel;
    private JButton treeButton;
    private JList treeList;
    private JLabel label;
    private JScrollPane treeScroll;

    public OptbasepairsWizard(CommandApplication application) {
        assert (application != null);
        this.application = application;
    }

    @Override
    public void addActionListener(ActionListener listener) {
        this.actionListeners.add(listener);
    }

    public void addComponents() {
        Container f = this.frame.getContentPane();
        f.setLayout(new BorderLayout());
        JPanel instructionsPanel = new JPanel();
        instructionsPanel.setLayout(new BoxLayout(instructionsPanel, 1));
        this.label = new JLabel("  Select the blocks that you would like to include in the optimization");
        instructionsPanel.add(this.label);
        JPanel labelPanel = new JPanel();
        this.label = new JLabel("Blocks: ");
        labelPanel.add(this.label);
        JPanel fieldPanel = new JPanel();
        fieldPanel.setLayout(new BoxLayout(fieldPanel, 1));
        this.blocksField = new JTextArea(20, 20);
        this.blocksField.setLineWrap(true);
        JScrollPane resultsScroller = new JScrollPane(this.blocksField);
        resultsScroller.setVerticalScrollBarPolicy(20);
        fieldPanel.add(resultsScroller);
        TreePanel treePanel = new TreePanel(this.blocksField);
        JPanel buttonPanel = new JPanel(new FlowLayout());
        this.label = new JLabel("Error:");
        buttonPanel.add(this.label);
        this.errorField = new JTextField(4);
        this.errorField.setText("0");
        buttonPanel.add(this.errorField);
        this.label = new JLabel("Steps:");
        buttonPanel.add(this.label);
        this.stepsField = new JTextField(6);
        this.stepsField.setText("100");
        buttonPanel.add(this.stepsField);
        JButton button = new JButton("Close");
        button.addActionListener(new CancelListener());
        buttonPanel.add(button);
        button = new JButton("Optimize Base Pairs");
        button.addActionListener(new OptbasepairsListener());
        buttonPanel.add(button);
        f.add((Component)instructionsPanel, "North");
        f.add((Component)labelPanel, "West");
        f.add((Component)fieldPanel, "Center");
        f.add((Component)treePanel, "East");
        f.add((Component)buttonPanel, "South");
    }

    private String getSelectionText() {
        Object3DGraphController graphController = ((AbstractDesigner)this.application).getGraphController();
        Object3DController gControl = graphController.getGraph();
        Object3D selection = gControl.getSelectionRoot();
        if (selection == null) {
            return "";
        }
        String selectionName = selection.getName();
        Object3D curr = selection;
        while (curr.getParent() != null) {
            curr = curr.getParent();
            selectionName = curr.getName() + "." + selectionName;
        }
        return selectionName;
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public void launchWizard(Object3DGraphController controller, Component parentFrame) {
        this.frame = new JFrame(FRAME_TITLE);
        if (controller == null) {
            log.info("GraphController received by lauchWizard is null!");
        }
        this.graphController = controller;
        this.addComponents();
        this.frame.pack();
        this.frame.setResizable(false);
        this.frame.setVisible(true);
    }

    private class TreePanel
    extends JPanel {
        public TreePanel(JTextArea field) {
            Object3DGraphController controller = ((AbstractDesigner)OptbasepairsWizard.this.application).getGraphController();
            OptbasepairsWizard.this.tree = controller.getGraph().getTree(OptbasepairsWizard.this.allowedNames, OptbasepairsWizard.this.forbiddenNames);
            this.setLayout(new BorderLayout());
            JPanel labelPanel = new JPanel();
            labelPanel.setLayout(new BoxLayout(labelPanel, 1));
            labelPanel.add(new JLabel("Tree:"));
            this.add(labelPanel);
            OptbasepairsWizard.this.treePanel = new JPanel();
            OptbasepairsWizard.this.treeList = new JList(OptbasepairsWizard.this.tree);
            OptbasepairsWizard.this.treeList.addListSelectionListener(new SelectionListener(field));
            OptbasepairsWizard.this.treeScroll = new JScrollPane(OptbasepairsWizard.this.treeList);
            OptbasepairsWizard.this.treeScroll.setVerticalScrollBarPolicy(20);
            OptbasepairsWizard.this.treeScroll.setHorizontalScrollBarPolicy(30);
            OptbasepairsWizard.this.treeScroll.setPreferredSize(new Dimension(300, 300));
            OptbasepairsWizard.this.treePanel.add(OptbasepairsWizard.this.treeScroll);
            this.add((Component)OptbasepairsWizard.this.treePanel, "South");
        }
    }

    public class SelectionListener
    implements ListSelectionListener {
        JTextArea field;

        public SelectionListener(JTextArea field) {
            this.field = field;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                String text = (String)OptbasepairsWizard.this.tree.get(e.getFirstIndex());
                if ((text = text.substring(0, text.indexOf(" "))).equals(this.field.getText())) {
                    text = (String)OptbasepairsWizard.this.tree.get(e.getLastIndex());
                    text = text.substring(0, text.indexOf(" "));
                }
                this.field.append(text + ";");
            }
        }
    }

    private class OptbasepairsListener
    implements ActionListener {
        private OptbasepairsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String blocks = OptbasepairsWizard.this.blocksField.getText();
            if (blocks.length() != 0 && blocks.charAt(blocks.length() - 1) == ';') {
                blocks = blocks.substring(0, blocks.length() - 1);
            }
            String command = "optbasepairs blocks=" + blocks + " error=" + OptbasepairsWizard.this.errorField.getText().trim() + " steps=" + OptbasepairsWizard.this.stepsField.getText().trim();
            System.out.println("Command: " + command);
            try {
                OptbasepairsWizard.this.application.runScriptLine(command);
            }
            catch (CommandException cex) {
                JOptionPane.showMessageDialog(OptbasepairsWizard.this.frame, cex + ": " + cex.getMessage());
            }
        }
    }

    private class CancelListener
    implements ActionListener {
        private CancelListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            OptbasepairsWizard.this.frame.setVisible(false);
            OptbasepairsWizard.this.frame = null;
            OptbasepairsWizard.this.finished = true;
        }
    }
}

