/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp.rnagui;

import java.awt.Color;
import java.util.Properties;
import tools3d.Ambiente;
import tools3d.Appearance;
import tools3d.Camera;
import tools3d.GeometryColorModel;
import tools3d.Vector3D;

public class RnaStrandColorModel
implements GeometryColorModel {
    public static final int COLOR_FULL = 1;
    public static final int COLOR_PASTELL = 2;
    private Color defaultColor = Color.GRAY;
    private Color junctionColor = Color.MAGENTA;
    private Color[] specialColors = new Color[4];
    private Color[] colors;
    private Color[] colorsBright;
    private Color[] colorsDark;
    private Color physicalColor = Color.RED;
    private Color chemicalColor = Color.CYAN;

    public RnaStrandColorModel(int colorMode) {
        this.specialColors[0] = new Color(162, 224, 72);
        this.specialColors[1] = new Color(213, 123, 224);
        this.specialColors[2] = new Color(255, 153, 0);
        this.specialColors[3] = new Color(161, 28, 233);
        switch (colorMode) {
            case 1: {
                this.colors = new Color[12];
                this.colors[0] = new Color(0, 0, 255);
                this.colors[1] = new Color(255, 102, 102);
                this.colors[2] = new Color(102, 255, 102);
                this.colors[3] = new Color(255, 255, 102);
                this.colors[4] = new Color(102, 255, 255);
                this.colors[5] = new Color(255, 102, 255);
                this.colors[6] = new Color(102, 102, 153);
                this.colors[7] = new Color(153, 102, 102);
                this.colors[8] = new Color(102, 153, 102);
                this.colors[9] = new Color(153, 153, 102);
                this.colors[10] = new Color(102, 153, 153);
                this.colors[11] = new Color(153, 102, 153);
                this.colorsBright = new Color[this.colors.length];
                this.colorsDark = new Color[this.colors.length];
                for (int i = 0; i < this.colors.length; ++i) {
                    this.colorsBright[i] = this.colors[i];
                    this.colorsDark[i] = this.colors[i];
                }
                break;
            }
            case 2: {
                this.colors = new Color[12];
                this.colors[0] = new Color(102, 102, 255);
                this.colors[1] = new Color(255, 102, 102);
                this.colors[2] = new Color(102, 255, 102);
                this.colors[3] = new Color(255, 255, 102);
                this.colors[4] = new Color(102, 255, 255);
                this.colors[5] = new Color(255, 102, 255);
                this.colors[6] = new Color(102, 102, 153);
                this.colors[7] = new Color(153, 102, 102);
                this.colors[8] = new Color(102, 153, 102);
                this.colors[9] = new Color(153, 153, 102);
                this.colors[10] = new Color(102, 153, 153);
                this.colors[11] = new Color(153, 102, 153);
                this.colorsBright = new Color[this.colors.length];
                this.colorsDark = new Color[this.colors.length];
                for (int i = 0; i < this.colors.length; ++i) {
                    this.colorsBright[i] = this.colors[i].brighter().brighter();
                    this.colorsDark[i] = this.colors[i].darker().darker();
                }
                break;
            }
        }
    }

    public RnaStrandColorModel() {
        this(1);
    }

    private int colorCap(int n) {
        if (n < 0) {
            return 0;
        }
        if (n > 255) {
            return 255;
        }
        return n;
    }

    private double interpolateCol(double frac, int val1, int val2) {
        return (1.0 - frac) * (double)val1 + frac * (double)val2;
    }

    private Color interpolateCol(double frac, Color col1, Color col2) {
        return new Color((int)this.interpolateCol(frac, col1.getRed(), col2.getRed()), (int)this.interpolateCol(frac, col1.getGreen(), col2.getGreen()), (int)this.interpolateCol(frac, col1.getBlue(), col2.getBlue()));
    }

    @Override
    public Color computeColor(Ambiente ambiente, Appearance appearance, Properties properties, Vector3D faceNormal, Camera camera) {
        if (properties != null) {
            String strandIdString = properties.getProperty("strand_id");
            String physicalString = properties.getProperty("interaction_type");
            String className = properties.getProperty("class_name");
            if (physicalString != null && physicalString.equals("watson_crick")) {
                return this.physicalColor;
            }
            if (physicalString != null && physicalString.equals("backbone")) {
                return this.chemicalColor;
            }
            if (strandIdString != null) {
                int strand = Integer.parseInt(strandIdString);
                if ((strand %= this.colors.length) >= 0 && strand < this.colors.length) {
                    Color col = this.colors[strand];
                    String siblingIdString = properties.getProperty("sibling_id");
                    String siblingMaxString = properties.getProperty("sibling_max");
                    if (siblingIdString != null && siblingMaxString != null) {
                        int siblingId = Integer.parseInt(siblingIdString);
                        int siblingMax = Integer.parseInt(siblingMaxString);
                        double frac = 0.5;
                        if (siblingMax > 0) {
                            frac = (double)siblingId / (double)siblingMax;
                        }
                        return this.interpolateCol(frac, this.colorsBright[strand], this.colorsDark[strand]);
                    }
                    return col;
                }
            } else if (className != null) {
                return this.specialColors[Math.abs(className.hashCode()) % this.specialColors.length];
            }
        }
        if (appearance != null) {
            return appearance.getColor();
        }
        return this.defaultColor;
    }

    public void setDefaultColor(Color c) {
        this.defaultColor = c;
    }
}

