/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp.rnagui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import rnadesign.designapp.rnagui.GeneralWizard;
import rnadesign.rnacontrol.Object3DGraphController;
import sequence.UnknownSymbolException;
import tools3d.Vector3D;

public class RnaStrandGuiWizard
implements GeneralWizard {
    public static Logger log = Logger.getLogger("NanoTiler_debug");
    private boolean finished = false;
    private JFrame frame = null;
    private JComboBox typeComboBox;
    private JTextField sequenceField;
    private JTextField nameField;
    private JTextField xField;
    private JTextField yField;
    private JTextField zField;
    private JTextField xDirField;
    private JTextField yDirField;
    private JTextField zDirField;
    private List<ActionListener> actionListeners = new ArrayList<ActionListener>();
    private Object3DGraphController graphController;
    public static final String FRAME_TITLE = "RNA Strand Wizard";

    @Override
    public void addActionListener(ActionListener listener) {
        this.actionListeners.add(listener);
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public void launchWizard(Object3DGraphController graphController, Component parentFrame) {
        if (graphController == null) {
            log.info("GraphController received by launchWizard is null!");
        }
        this.graphController = graphController;
        this.frame = new JFrame(FRAME_TITLE);
        this.addComponents(this.frame);
        this.frame.pack();
        this.frame.setVisible(true);
    }

    private String getInitName() {
        char c = (char)(65 + this.graphController.getSequences().getSequenceCount());
        char[] chars = new char[]{c};
        return new String(chars);
    }

    public void addComponents(JFrame _frame) {
        Container f = _frame.getContentPane();
        f.setLayout(new BorderLayout());
        JPanel top = new JPanel();
        JPanel center = new JPanel();
        this.nameField = new JTextField(this.getInitName());
        this.sequenceField = new JTextField("NNNNNNNNNN", 50);
        this.xField = new JTextField("0.0", 6);
        this.yField = new JTextField("0.0", 6);
        this.zField = new JTextField("0.0", 6);
        this.xDirField = new JTextField("0.0", 6);
        this.yDirField = new JTextField("0.0", 6);
        this.zDirField = new JTextField("1.0", 6);
        JPanel xyzPanel = new JPanel();
        xyzPanel.setLayout(new FlowLayout());
        xyzPanel.add(new JLabel("Position:"));
        xyzPanel.add(this.xField);
        xyzPanel.add(this.yField);
        xyzPanel.add(this.zField);
        JPanel xyzDirPanel = new JPanel();
        xyzDirPanel.setLayout(new FlowLayout());
        xyzDirPanel.add(new JLabel("Direction:"));
        xyzDirPanel.add(this.xDirField);
        xyzDirPanel.add(this.yDirField);
        xyzDirPanel.add(this.zDirField);
        top.add(new JLabel("Name:"));
        top.add(this.nameField);
        top.add(xyzPanel);
        top.add(xyzDirPanel);
        center.add(new JLabel("Sequence:"));
        center.add(this.sequenceField);
        f.add((Component)top, "North");
        f.add((Component)center, "Center");
        String[] typeStrings = new String[]{"RNA", "DNA", "Protein"};
        this.typeComboBox = new JComboBox<String>(typeStrings);
        JPanel bottomPanel = new JPanel();
        JButton button = new JButton("Cancel");
        button.addActionListener(new CancelListener());
        bottomPanel.add(this.typeComboBox);
        bottomPanel.add(button);
        button = new JButton("Done");
        button.addActionListener(new DoneListener());
        bottomPanel.add(button);
        f.add((Component)bottomPanel, "South");
    }

    Vector3D generatePosition() {
        Vector3D result = null;
        double x = Double.parseDouble(this.xField.getText().trim());
        double y = Double.parseDouble(this.yField.getText().trim());
        double z = Double.parseDouble(this.zField.getText().trim());
        result = new Vector3D(x, y, z);
        return result;
    }

    Vector3D generateDirection() {
        double z;
        double y;
        Vector3D result = null;
        double x = Double.parseDouble(this.xDirField.getText().trim());
        result = new Vector3D(x, y = Double.parseDouble(this.yDirField.getText().trim()), z = Double.parseDouble(this.zDirField.getText().trim()));
        if (result.length() > 0.0) {
            result.normalize();
        }
        return result;
    }

    private class CancelListener
    implements ActionListener {
        private CancelListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RnaStrandGuiWizard.this.frame.setVisible(false);
            RnaStrandGuiWizard.this.frame = null;
            RnaStrandGuiWizard.this.finished = true;
        }
    }

    private class DoneListener
    implements ActionListener {
        private DoneListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Vector3D direction = RnaStrandGuiWizard.this.generateDirection();
            if (direction.length() == 0.0) {
                JOptionPane.showMessageDialog(RnaStrandGuiWizard.this.frame, "Direction vector has to be non-zero!");
                return;
            }
            try {
                int typeNumber = RnaStrandGuiWizard.this.typeComboBox.getSelectedIndex();
                int typeId = 0;
                switch (typeNumber) {
                    case 0: {
                        typeId = 0;
                        break;
                    }
                    case 1: {
                        typeId = 1;
                        break;
                    }
                    case 2: {
                        typeId = 2;
                    }
                }
                RnaStrandGuiWizard.this.graphController.addStrand(RnaStrandGuiWizard.this.nameField.getText().trim(), RnaStrandGuiWizard.this.sequenceField.getText().trim(), RnaStrandGuiWizard.this.generatePosition(), direction, typeId);
                RnaStrandGuiWizard.this.frame.setVisible(false);
                RnaStrandGuiWizard.this.frame = null;
                RnaStrandGuiWizard.this.finished = true;
            }
            catch (UnknownSymbolException exception) {
                JOptionPane.showMessageDialog(RnaStrandGuiWizard.this.frame, "Unknown sequence character found! Use only ACGU");
            }
        }
    }
}

