/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp.rnagui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import rnadesign.designapp.rnagui.RnaGuiParameters;
import rnadesign.rnacontrol.Object3DController;
import tools3d.objects3d.Object3D;

public class SelectPanel
extends JPanel {
    public static Logger log = Logger.getLogger("NanoTiler_debug");
    private Object3DController graphController;
    private static final long serialVersionUID = 1L;

    private void debugOutput() {
        Object3D selectObject = this.graphController.getSelectionCursor();
        if (selectObject != null) {
            log.fine("Selection cursor: " + selectObject.isSelected() + " " + selectObject.infoString());
        } else {
            log.fine("Selection Cursor is null!");
        }
        selectObject = this.graphController.getSelectionRoot();
        if (selectObject != null) {
            log.fine("Selection root: " + selectObject.isSelected() + " " + selectObject.infoString());
        } else {
            log.fine("Selection root is null!");
        }
    }

    public SelectPanel(SelectPanelParameters params, Object3DController graphController) {
        this.graphController = graphController;
        this.setBackground(RnaGuiParameters.colorBackground);
        this.setPreferredSize(new Dimension(params.width, params.height));
        this.setBorder(BorderFactory.createLineBorder(Color.black));
        this.setLayout(new GridLayout(3, 2));
        JButton button = new JButton("Up");
        button.setPreferredSize(new Dimension(params.buttonWidth, params.buttonHeight));
        button.addActionListener(new MoveUpSelectionListener());
        this.add(button);
        button = new JButton("Down");
        button.addActionListener(new MoveDownSelectionListener());
        button.setPreferredSize(new Dimension(params.buttonWidth, params.buttonHeight));
        this.add(button);
        button = new JButton("Next");
        button.setPreferredSize(new Dimension(params.buttonWidth, params.buttonHeight));
        button.addActionListener(new IncSelectionListener());
        this.add(button);
        button = new JButton("Prev");
        button.addActionListener(new DecSelectionListener());
        button.setPreferredSize(new Dimension(params.buttonWidth, params.buttonHeight));
        this.add(button);
        button = new JButton("Sel");
        button.setPreferredSize(new Dimension(params.buttonWidth, params.buttonHeight));
        button.addActionListener(new SelectCurrentListener());
        this.add(button);
        button = new JButton("Des");
        button.addActionListener(new DeselectCurrentListener());
        button.setPreferredSize(new Dimension(params.buttonWidth, params.buttonHeight));
        this.add(button);
    }

    private class SelectAllListener
    implements ActionListener {
        private SelectAllListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SelectPanel.this.graphController.selectAll();
            SelectPanel.this.debugOutput();
        }
    }

    private class SelectCurrentListener
    implements ActionListener {
        private SelectCurrentListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SelectPanel.this.graphController.selectCurrent();
            SelectPanel.this.debugOutput();
        }
    }

    private class ResetSelectionListener
    implements ActionListener {
        private ResetSelectionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SelectPanel.this.graphController.resetSelectionCursor();
            SelectPanel.this.debugOutput();
        }
    }

    private class MoveDownSelectionListener
    implements ActionListener {
        private MoveDownSelectionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SelectPanel.this.graphController.moveDownSelectionCursor();
            SelectPanel.this.debugOutput();
        }
    }

    private class MoveUpSelectionListener
    implements ActionListener {
        private MoveUpSelectionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SelectPanel.this.graphController.moveUpSelectionCursor();
            SelectPanel.this.debugOutput();
        }
    }

    private class IncSelectionListener
    implements ActionListener {
        private IncSelectionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SelectPanel.this.graphController.incSelectionCursor();
            SelectPanel.this.debugOutput();
        }
    }

    private class DeselectCurrentListener
    implements ActionListener {
        private DeselectCurrentListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SelectPanel.this.graphController.deselectCurrent();
            SelectPanel.this.debugOutput();
        }
    }

    private class DeselectAllListener
    implements ActionListener {
        private DeselectAllListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SelectPanel.this.graphController.deselectAll();
            SelectPanel.this.debugOutput();
        }
    }

    private class DecSelectionListener
    implements ActionListener {
        private DecSelectionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SelectPanel.this.graphController.decSelectionCursor();
            SelectPanel.this.debugOutput();
        }
    }

    public static class SelectPanelParameters {
        int height = 100;
        int width = 120;
        int buttonWidth = 60;
        int buttonHeight = 40;
    }
}

