/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp.rnagui;

import commandtools.CommandApplication;
import controltools.ModelChangeEvent;
import controltools.ModelChangeListener;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.AbstractListModel;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import rnadesign.designapp.rnagui.GeneralWizard;
import rnadesign.rnacontrol.Object3DGraphController;

public class ViewLinksWizard
implements GeneralWizard,
ModelChangeListener {
    public static final String FRAME_TITLE = "Links";
    private CommandApplication application;
    private JList list = new JList();
    private static int junction_suffix = 1;
    private ArrayList<ActionListener> actionListeners = new ArrayList();
    private boolean finished = false;
    private Object3DGraphController graphController;
    private JFrame frame;

    public ViewLinksWizard(CommandApplication application) {
        this.application = application;
    }

    @Override
    public void addActionListener(ActionListener listener) {
        this.actionListeners.add(listener);
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public void launchWizard(Object3DGraphController graphController, Component parentFrame) {
        this.graphController = graphController;
        this.frame = new JFrame(FRAME_TITLE);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                ViewLinksWizard.this.finished = true;
            }
        });
        this.graphController.getLinks().addModelChangeListener(this);
        JPanel panel = new JPanel();
        this.list.setListData(this.getLinks());
        this.list.setAlignmentX(0.5f);
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setPreferredSize(new Dimension(300, 300));
        panel.add(new JScrollPane(this.list));
        panel.add(Box.createVerticalStrut(10));
        JButton close = new JButton("Close");
        close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ViewLinksWizard.this.frame.setVisible(false);
                ViewLinksWizard.this.frame.dispose();
            }
        });
        close.setAlignmentX(0.5f);
        panel.add(close);
        this.frame.add(panel);
        this.frame.pack();
        this.frame.setVisible(true);
    }

    public String[] getLinks() {
        String s = this.graphController.getLinks().toPrettyString();
        StringTokenizer tokenizer = new StringTokenizer(s, "\n");
        String[] array = new String[tokenizer.countTokens()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = tokenizer.nextToken();
        }
        return array;
    }

    @Override
    public void modelChanged(ModelChangeEvent e) {
        String s = this.graphController.getLinks().toPrettyString();
        StringTokenizer tokenizer = new StringTokenizer(s, "\n");
        final String[] array = new String[tokenizer.countTokens()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = tokenizer.nextToken();
        }
        this.list.setModel(new AbstractListModel(){

            @Override
            public int getSize() {
                return array.length;
            }

            @Override
            public Object getElementAt(int index) {
                return array[index];
            }
        });
        this.list.revalidate();
        this.frame.repaint();
    }
}

