/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp.rnagui;

import commandtools.CommandApplication;
import commandtools.CommandException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import rnadesign.designapp.rnagui.Browser;
import rnadesign.designapp.rnagui.GeneralWizard;
import rnadesign.designapp.rnagui.GraphicsManualWizard;
import rnadesign.designapp.rnagui.HelpWizard;
import rnadesign.rnacontrol.Object3DGraphController;

public class WelcomeWindowWizard
implements GeneralWizard {
    private static final int COL_SIZE_NAME = 20;
    private static final String FRAME_TITLE = "NanoTiler Welcome and Basic Navigation Screen";
    private boolean finished = false;
    private JFrame frame = null;
    private List<ActionListener> actionListeners = new ArrayList<ActionListener>();
    private CommandApplication application;
    private Object3DGraphController controller;
    private String nanotilerHome = System.getenv("NANOTILER_HOME");
    public final String TUTORIAL_HOME = "file://" + this.nanotilerHome + "/doc/NanoTilerUserManual.html";
    private final String NEWLINE = "\n";
    private String[] demoScripts = new String[]{"grow.script", "optbasepairs.script", "mutate.script", "all"};
    private String[] demoButtonNames = new String[]{"Grow", "Optimize Basepair Constraints", "Mutate", "Run all demos"};
    private final Dimension buttonSize = new Dimension(250, 25);
    private final int ROWS = 13;
    private final int COLS = 40;
    private String descriptionText = "Demo Scripts:\n  Each script demonstrates a functionality in NanoTiler. More demos are available using File->Demos and the script command \"demo\".\n\nUser Manual:\n  The user manual provides users with information about how to install, run and use the NanoTiler program.\n";

    public WelcomeWindowWizard(CommandApplication application) {
        assert (application != null);
        this.application = application;
    }

    @Override
    public void addActionListener(ActionListener listener) {
        this.actionListeners.add(listener);
    }

    public void addComponents() {
        Container f = this.frame.getContentPane();
        f.setLayout(new BorderLayout());
        JPanel demoPanel = new JPanel();
        demoPanel.setLayout(new BoxLayout(demoPanel, 1));
        JLabel label = new JLabel("Demos:");
        demoPanel.add(label);
        for (int i = 0; i < this.demoScripts.length; ++i) {
            JButton demoTempButton = new JButton(this.demoButtonNames[i]);
            demoTempButton.addActionListener(new ScriptListener(this.demoScripts[i]));
            demoTempButton.setPreferredSize(this.buttonSize);
            demoTempButton.setMinimumSize(this.buttonSize);
            demoTempButton.setMaximumSize(this.buttonSize);
            demoPanel.add(demoTempButton);
        }
        JPanel helpPanel = new JPanel();
        helpPanel.setLayout(new BoxLayout(helpPanel, 1));
        label = new JLabel("Help:");
        helpPanel.add(label);
        JButton tutorialButton = new JButton("User Manual");
        tutorialButton.addActionListener(new TutorialListener());
        tutorialButton.setPreferredSize(this.buttonSize);
        tutorialButton.setMinimumSize(this.buttonSize);
        tutorialButton.setMaximumSize(this.buttonSize);
        helpPanel.add(tutorialButton);
        JButton commandHelpButton = new JButton("Command Help");
        commandHelpButton.addActionListener(new CommandHelpListener());
        commandHelpButton.setPreferredSize(this.buttonSize);
        commandHelpButton.setMinimumSize(this.buttonSize);
        commandHelpButton.setMaximumSize(this.buttonSize);
        helpPanel.add(commandHelpButton);
        JButton graphicsHelpButton = new JButton("Graphics Help (OpenGL mode)");
        graphicsHelpButton.addActionListener(new GraphicsHelpListener());
        graphicsHelpButton.setPreferredSize(this.buttonSize);
        graphicsHelpButton.setMinimumSize(this.buttonSize);
        graphicsHelpButton.setMaximumSize(this.buttonSize);
        helpPanel.add(graphicsHelpButton);
        JPanel bottomPanel = new JPanel();
        JButton nanotilerButton = new JButton("Close");
        nanotilerButton.addActionListener(new CancelListener());
        bottomPanel.add(Box.createHorizontalGlue());
        bottomPanel.add(nanotilerButton);
        JPanel descriptionPanel = new JPanel();
        JTextArea descriptionArea = new JTextArea(this.descriptionText, 13, 40);
        descriptionArea.setLineWrap(true);
        descriptionArea.setEditable(false);
        descriptionPanel.add(descriptionArea);
        f.add((Component)helpPanel, "West");
        f.add((Component)demoPanel, "Center");
        f.add((Component)descriptionPanel, "East");
        f.add((Component)bottomPanel, "South");
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public void launchWizard(Object3DGraphController controller, Component parentFrame) {
        this.frame = new JFrame(FRAME_TITLE);
        this.controller = controller;
        this.addComponents();
        this.frame.pack();
        this.frame.setVisible(true);
    }

    private final class LaunchListener
    implements ActionListener {
        private LaunchListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WelcomeWindowWizard wizard = new WelcomeWindowWizard(WelcomeWindowWizard.this.application);
            wizard.launchWizard(WelcomeWindowWizard.this.controller, WelcomeWindowWizard.this.frame);
        }
    }

    private final class GraphicsHelpListener
    implements ActionListener {
        private GraphicsHelpListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GraphicsManualWizard wizard = new GraphicsManualWizard(WelcomeWindowWizard.this.application);
            wizard.launchWizard(WelcomeWindowWizard.this.controller, WelcomeWindowWizard.this.frame);
        }
    }

    private final class CommandHelpListener
    implements ActionListener {
        private CommandHelpListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            HelpWizard wizard = new HelpWizard(WelcomeWindowWizard.this.application);
            wizard.launchWizard(WelcomeWindowWizard.this.controller, WelcomeWindowWizard.this.frame);
        }
    }

    private class TutorialListener
    implements ActionListener {
        private TutorialListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                new Browser(WelcomeWindowWizard.this.TUTORIAL_HOME);
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(WelcomeWindowWizard.this.frame, ex.getMessage());
            }
        }
    }

    private class ScriptListener
    implements ActionListener {
        String fileName;

        public ScriptListener(String fileName) {
            this.fileName = fileName;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WelcomeWindowWizard.this.frame.setVisible(false);
            boolean ok = true;
            if (!WelcomeWindowWizard.this.controller.getGraph().isEmpty()) {
                String msg = "Are you sure you want to start a demo and discard all current data?";
                String title = "Clear Button Dialog";
                int choice = JOptionPane.showConfirmDialog(null, msg, title, 2);
                ok = choice == 0;
            }
            if (ok) {
                try {
                    WelcomeWindowWizard.this.application.runScriptLine("clear all");
                    String command = "";
                    if ("all".equals(this.fileName)) {
                        command = "demo all";
                    } else {
                        String path = WelcomeWindowWizard.this.nanotilerHome + "/demo/scripts/" + this.fileName;
                        command = "source " + path;
                    }
                    WelcomeWindowWizard.this.application.runScriptLine(command);
                }
                catch (CommandException ce) {
                    JOptionPane.showMessageDialog(WelcomeWindowWizard.this.frame, ce.getMessage());
                }
            }
            WelcomeWindowWizard.this.frame.setVisible(true);
        }
    }

    private class CancelListener
    implements ActionListener {
        private CancelListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (WelcomeWindowWizard.this.frame != null) {
                WelcomeWindowWizard.this.frame.setVisible(false);
                WelcomeWindowWizard.this.frame = null;
            }
            WelcomeWindowWizard.this.finished = true;
        }
    }
}

