/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp.rnagui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import rnadesign.designapp.rnagui.AbstractShape3DPainter;
import tools3d.Appearance;
import tools3d.Cube;
import tools3d.Cylinder;
import tools3d.Shape3D;
import tools3d.Sphere;
import tools3d.Vector3D;

public class WireShape3DPainter
extends AbstractShape3DPainter {
    String[] handledShapeNames = new String[]{"Sphere", "Cube", "Cylinder"};
    Vector3D radVec = new Vector3D(0.0, 0.0, 0.0);

    @Override
    public String[] getHandledShapeNames() {
        return this.handledShapeNames;
    }

    private Color getPaintColor(Shape3D shape) {
        Appearance appearance = shape.getAppearance();
        Color color = null;
        Color paintColor = null;
        if (appearance != null) {
            color = appearance.getColor();
        }
        paintColor = color != null ? color : this.getDefaultPaintColor();
        return paintColor;
    }

    private void paintSphere(Graphics g, Sphere obj) {
        Graphics2D g2 = (Graphics2D)g;
        double radius3D = obj.getBoundingRadius();
        Vector3D pos = obj.getPosition();
        double radius2D = radius3D * this.cameraController.getZoom();
        Point2D point2D = this.cameraController.project(pos);
        Color paintColor = this.getPaintColor(obj);
        g2.setXORMode(paintColor);
        g2.fill(new Ellipse2D.Double(point2D.getX(), point2D.getY(), radius2D, radius2D));
    }

    private void paintCylinder(Graphics g, Cylinder obj) {
        Graphics2D g2 = (Graphics2D)g;
        double radius3D = obj.getBoundingRadius();
        Vector3D pos = obj.getPosition();
        double radius2D = radius3D * this.cameraController.getZoom();
        Point2D point2D = this.cameraController.project(pos);
        Color paintColor = this.getPaintColor(obj);
        g2.setXORMode(paintColor);
        g2.fill(new Ellipse2D.Double(point2D.getX(), point2D.getY(), radius2D, radius2D));
    }

    private void paintCube(Graphics g, Cube obj) {
        Graphics2D g2 = (Graphics2D)g;
        double radius3D = obj.getBoundingRadius();
        Vector3D pos = obj.getPosition();
        double radius2D = radius3D * this.cameraController.getZoom();
        Point2D point2D = this.cameraController.project(pos);
        Color paintColor = this.getPaintColor(obj);
        g2.setXORMode(paintColor);
        g2.fill(new Ellipse2D.Double(point2D.getX(), point2D.getY(), radius2D, radius2D));
    }

    @Override
    public void paint(Graphics g, Shape3D obj) {
        if (obj instanceof Sphere) {
            this.paintSphere(g, (Sphere)obj);
        } else if (obj instanceof Cylinder) {
            this.paintCylinder(g, (Cylinder)obj);
        } else if (obj instanceof Cube) {
            this.paintCube(g, (Cube)obj);
        }
    }
}

