/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnacontrol;

import generaltools.StringTools;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.logging.Logger;
import rnadesign.rnacontrol.PdbJunctionController;
import rnadesign.rnamodel.BranchDescriptor3D;
import rnadesign.rnamodel.BridgeFinder;
import rnadesign.rnamodel.DBElementDescriptor;
import rnadesign.rnamodel.DoubleHelixBridgeFinder;
import rnadesign.rnamodel.HelixBridgeFinder;
import rnadesign.rnamodel.JunctionMultiConstraintLink;
import rnadesign.rnamodel.Nucleotide3D;
import rnadesign.rnamodel.RnaModelException;
import rnadesign.rnamodel.RnaPdbRnaviewReader;
import rnadesign.rnamodel.SingleStrandBridgeFinder;
import rnadesign.rnamodel.SingleStrandsBridgeFinder;
import rnadesign.rnamodel.StrandJunction3D;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.Object3DLinkSetBundle;

public class BridgeItController {
    public static final int SIMPLE_HELIX = 1;
    public static final int DOUBLE_HELIX = 2;
    public static final double DEFAULT_ANGLE_WEIGHT = 10.0;
    private static Logger log = Logger.getLogger("NanoTiler_debug");
    private List<Object3DLinkSetBundle> bundleList;
    private Object3D nucleotideDB;
    private double angleWeight;
    private double rms;
    private int lenMin;
    private int lenMax;
    private int solutionMax;
    private PdbJunctionController junctionController;
    private int helixAlgorithm;

    public BridgeItController() {
        this.angleWeight = 10.0;
        this.rms = 2.0;
        this.lenMin = 1;
        this.lenMax = 3;
        this.solutionMax = 10;
        this.helixAlgorithm = 1;
        this.bundleList = new ArrayList<Object3DLinkSetBundle>();
    }

    public BridgeItController(List<String> fileNames, PdbJunctionController junctionController, Object3D nucleotideDB) {
        this();
        this.junctionController = junctionController;
        this.nucleotideDB = nucleotideDB;
        for (String s : fileNames) {
            try {
                this.readAndAdd(s);
            }
            catch (IOException ioe) {
                System.out.println("Could not read from file: " + s + " : ignoring: " + ioe.getMessage());
            }
        }
    }

    public BridgeItController(String fileNameFile, PdbJunctionController junctionController) {
        block3: {
            this.angleWeight = 10.0;
            this.rms = 2.0;
            this.lenMin = 1;
            this.lenMax = 3;
            this.solutionMax = 10;
            this.helixAlgorithm = 1;
            this.junctionController = junctionController;
            try {
                String[] lines;
                FileInputStream fis = new FileInputStream(fileNameFile);
                for (String s : lines = StringTools.readAllLines(fis)) {
                    s = s.trim();
                    this.readAndAdd(s);
                }
            }
            catch (IOException ioe) {
                System.out.println(ioe.getMessage());
                if ($assertionsDisabled) break block3;
                throw new AssertionError();
            }
        }
    }

    public List<Object3DLinkSetBundle> findBridges(JunctionMultiConstraintLink jLink) throws RnaModelException {
        int[] bestPerm = jLink.findBestPermutation();
        List result = null;
        for (int i = 0; i < jLink.size(); ++i) {
            int id1 = bestPerm[bestPerm.length - 1];
            if (i > 0) {
                id1 = bestPerm[i - 1];
            }
            int id2 = bestPerm[i];
            List<Object3DLinkSetBundle> newBridgeBundle = this.findBridge(jLink.getThreePrimeObject(id1), jLink.getFivePrimeObject(id2));
            if (newBridgeBundle == null || newBridgeBundle.size() <= 0) {
                throw new RnaModelException("Could not find all bridges for junction link " + jLink.getName());
            }
            result.add(newBridgeBundle.get(0));
        }
        return result;
    }

    public List<Object3DLinkSetBundle> findBridge(Object3D obj1, Object3D obj2) throws RnaModelException {
        assert (obj1 != null || obj2 != null);
        if (obj1 instanceof Nucleotide3D && obj2 instanceof Nucleotide3D) {
            return this.findSingleStrandBridge((Nucleotide3D)obj1, (Nucleotide3D)obj2);
        }
        if (obj1 != null && obj1 instanceof Nucleotide3D && obj2 == null) {
            return this.findSingleStrandBridge((Nucleotide3D)obj1, null);
        }
        if (obj2 != null && obj2 instanceof Nucleotide3D && obj1 == null) {
            return this.findSingleStrandBridge(null, (Nucleotide3D)obj2);
        }
        if (obj1 instanceof BranchDescriptor3D && obj2 instanceof BranchDescriptor3D) {
            List<StrandJunction3D> allowedJunctions = this.junctionController.retrieveAllJunctions();
            return this.findHelixBridge((BranchDescriptor3D)obj1, (BranchDescriptor3D)obj2, allowedJunctions);
        }
        Random random = new Random();
        if (random.nextDouble() >= 0.0) {
            throw new RnaModelException("Bridge between classes " + obj1.getClassName() + " and " + obj2.getClassName() + " is not supported.");
        }
        return null;
    }

    private List<StrandJunction3D> retrieveAllowedJunctions(List<DBElementDescriptor> dbElements) {
        ArrayList<StrandJunction3D> result = new ArrayList<StrandJunction3D>();
        for (DBElementDescriptor dbElement : dbElements) {
            result.addAll(this.junctionController.retrieveJunctions(dbElement));
        }
        return result;
    }

    public List<Object3DLinkSetBundle> findBridge(Object3D obj1, Object3D obj2, List<DBElementDescriptor> dbElements) throws RnaModelException {
        if (obj1 instanceof Nucleotide3D && obj2 instanceof Nucleotide3D) {
            return this.findSingleStrandBridge((Nucleotide3D)obj1, (Nucleotide3D)obj2);
        }
        if (obj1 instanceof BranchDescriptor3D && obj2 instanceof BranchDescriptor3D) {
            List<StrandJunction3D> allowedJunctions = this.retrieveAllowedJunctions(dbElements);
            return this.findHelixBridge((BranchDescriptor3D)obj1, (BranchDescriptor3D)obj2, allowedJunctions);
        }
        Random random = new Random();
        if (random.nextDouble() >= 0.0) {
            throw new RnaModelException("Bridge between classes " + obj1.getClassName() + " and " + obj2.getClassName() + " is not supported.");
        }
        return null;
    }

    public List<Object3DLinkSetBundle> findBridgeWithHelix(Object3D obj1, Object3D obj2, int numBP) throws RnaModelException {
        if (obj1 instanceof Nucleotide3D && obj2 instanceof Nucleotide3D) {
            return this.findSingleStrandBridgeWithHelix((Nucleotide3D)obj1, (Nucleotide3D)obj2, numBP);
        }
        Random random = new Random();
        if (random.nextDouble() >= 0.0) {
            throw new RnaModelException("Bridge between classes " + obj1.getClassName() + " and " + obj2.getClassName() + " is not supported.");
        }
        return null;
    }

    public List<Object3DLinkSetBundle> findSingleStrandBridgeWithHelix(Nucleotide3D obj1, Nucleotide3D obj2, int numBP) throws RnaModelException {
        assert (false);
        return null;
    }

    private List<Object3DLinkSetBundle> findSingleStrandBridge(Nucleotide3D obj1, Nucleotide3D obj2) {
        assert (obj1 != null || obj2 != null);
        ArrayList result = new ArrayList();
        SingleStrandBridgeFinder finder = new SingleStrandBridgeFinder(this.bundleList);
        finder.setRms(this.rms);
        finder.setLenMin(this.lenMin);
        finder.setLenMax(this.lenMax);
        finder.setSolutionMax(this.solutionMax);
        finder.setAngleWeight(this.angleWeight);
        return finder.findBridge(obj1, obj2);
    }

    SingleStrandBridgeFinder generateSingleStrandBridgeFinder() {
        return new SingleStrandBridgeFinder(this.bundleList);
    }

    SingleStrandsBridgeFinder generateSingleStrandBridgesFinder() {
        return new SingleStrandsBridgeFinder(this.bundleList);
    }

    public List<Object3DLinkSetBundle> getBundleList() {
        return this.bundleList;
    }

    public List<Object3DLinkSetBundle> findHelixBridge(BranchDescriptor3D obj1, BranchDescriptor3D obj2, List<StrandJunction3D> junctions) {
        ArrayList result = new ArrayList();
        BridgeFinder finder = null;
        switch (this.helixAlgorithm) {
            case 1: {
                finder = new HelixBridgeFinder(junctions, this.nucleotideDB);
                break;
            }
            case 2: {
                finder = new DoubleHelixBridgeFinder(junctions, this.nucleotideDB);
                break;
            }
            default: {
                System.out.println("Unknown helix algorithm: " + this.helixAlgorithm);
                assert (false);
                break;
            }
        }
        finder.setAngleWeight(this.angleWeight);
        finder.setLenMax(this.lenMin);
        finder.setLenMax(this.lenMax);
        finder.setRms(this.rms);
        finder.setSolutionMax(this.solutionMax);
        return finder.findBridge(obj1, obj2);
    }

    public void readAndAdd(String fileName) throws IOException {
        log.info("Starting BridgeItController.readAndAdd " + fileName);
        assert (this.bundleList != null);
        RnaPdbRnaviewReader reader = new RnaPdbRnaviewReader();
        FileInputStream fis = new FileInputStream(fileName);
        log.info("Starting to read bundle...");
        Object3DLinkSetBundle bundle = reader.readBundle(fis);
        if (bundle == null) {
            throw new IOException("Error reading from file: " + fileName);
        }
        log.info("Adding bundle");
        this.bundleList.add(bundle);
        log.info("Finished BridgeItController.readAndAdd " + fileName);
    }

    public void setAngleWeight(double weight) {
        this.angleWeight = weight;
    }

    public void setHelixAlgorithm(int helixAlgorithm) {
        this.helixAlgorithm = helixAlgorithm;
    }

    public void setLenMin(int n) {
        this.lenMin = n;
    }

    public void setLenMax(int n) {
        this.lenMax = n;
    }

    public void setRms(double rms) {
        this.rms = rms;
    }

    public void setSolutionMax(int n) {
        this.solutionMax = n;
    }

    public static boolean validateHelixAlgorithm(int n) {
        switch (n) {
            case 1: {
                return true;
            }
            case 2: {
                return true;
            }
        }
        return false;
    }
}

