/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnacontrol;

import controltools.ModelChangeEvent;
import java.io.IOException;
import java.io.InputStream;
import rnadesign.rnacontrol.BasePairController;
import rnadesign.rnacontrol.PackageConstants;
import rnadesign.rnacontrol.SimpleLinkController;
import rnadesign.rnamodel.InteractionLink;
import rnadesign.rnamodel.InteractionLinkImp;
import rnadesign.rnamodel.Nucleotide3D;
import rnadesign.rnamodel.NucleotideDBTools;
import rnadesign.rnamodel.RnaPdbRnaviewReader;
import rnadesign.rnamodel.RnaStem3D;
import rnadesign.rnamodel.StemTools;
import rnasecondary.Interaction;
import rnasecondary.InteractionType;
import rnasecondary.Stem;
import tools3d.objects3d.Link;
import tools3d.objects3d.LinkSet;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.Object3DLinkSetBundle;
import tools3d.objects3d.Object3DTools;

public class SimpleBasePairController
extends SimpleLinkController
implements BasePairController {
    private int minStemLength = 3;

    private void addNoChange(Link link) {
        if (link instanceof InteractionLink) {
            Object3D obj1 = link.getObj1();
            Object3D obj2 = link.getObj2();
            if (!(obj1 instanceof Nucleotide3D)) {
                log.warning("Link has to connect nucleotides: " + obj1.getName());
                return;
            }
            if (!(obj2 instanceof Nucleotide3D)) {
                log.warning("Link has to connect nucleotides: " + obj2.getName());
                return;
            }
        } else {
            log.warning("Ignoring link that is not interaction link: " + link.getObj1().getName() + " " + link.getObj2().getName());
            return;
        }
        this.residueInteractions.add(((InteractionLink)link).getInteraction());
        log.finest("Added link is interaction link: " + link.getObj1().getName() + " " + link.getObj2().getName());
        this.links.add(link);
    }

    @Override
    public void add(Link link) {
        this.addNoChange(link);
        this.fireModelChanged(new ModelChangeEvent(this));
    }

    @Override
    public void read(InputStream is) throws IOException {
        RnaPdbRnaviewReader reader = new RnaPdbRnaviewReader();
        Object3DLinkSetBundle bundle = reader.readBundle(is);
        Object3D root = bundle.getObject3D();
        LinkSet tmpLinks = bundle.getLinks();
        Object3DLinkSetBundle stemBundle = StemTools.generateStemsFromLinks(root, tmpLinks, this.minStemLength);
        Object3D stemRoot = stemBundle.getObject3D();
        for (int i = 0; i < stemRoot.size(); ++i) {
            RnaStem3D stem = (RnaStem3D)stemRoot.getChild(i);
            Stem stemInfo = stem.getStemInfo();
            for (int j = 0; j < stem.getLength(); ++j) {
                Interaction interaction = stemInfo.get(j);
                Object3D res1 = (Object3D)((Object)interaction.getResidue1());
                Object3D res2 = (Object3D)((Object)interaction.getResidue2());
                if (NucleotideDBTools.hasTripodAtoms(res1) && NucleotideDBTools.hasTripodAtoms(res2)) {
                    InteractionLinkImp interactionLink = new InteractionLinkImp(res1, res2, interaction);
                    log.fine("Added base pair to SimpleBasePairController " + interactionLink);
                    this.add(interactionLink);
                    continue;
                }
                log.info("Required atoms missing for residues: " + Object3DTools.getFullName(res1) + " " + Object3DTools.getFullName(res2));
            }
        }
    }

    public String toInfoString(int n) {
        InteractionLink link = (InteractionLink)this.get(n);
        Interaction interaction = link.getInteraction();
        InteractionType interactionType = interaction.getInteractionType();
        Nucleotide3D nuc1 = (Nucleotide3D)link.getObj1();
        Nucleotide3D nuc2 = (Nucleotide3D)link.getObj2();
        String result = interactionType.toString() + " " + nuc1.getName() + " " + nuc1.getSymbol().getCharacter() + " " + nuc2.getName() + " " + nuc2.getSymbol().getCharacter();
        return result;
    }

    @Override
    public String toInfoString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Number of defined base pairs: " + this.size() + PackageConstants.NEWLINE);
        for (int i = 0; i < this.size(); ++i) {
            buf.append("" + (i + 1) + " " + this.toInfoString(i) + PackageConstants.NEWLINE);
        }
        return buf.toString();
    }
}

